/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security;

import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlListData
implements Cloneable {
    protected SecurityConstants.PrincipalType type = SecurityConstants.PrincipalType.USER;
    protected String name;
    protected List<Role> roles;

    public AccessControlListData(String name, List<Role> roles, SecurityConstants.PrincipalType type) {
        this.name = name;
        this.roles = roles;
        this.type = type;
    }

    public SecurityConstants.PrincipalType getType() {
        return this.type;
    }

    public void setType(SecurityConstants.PrincipalType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public boolean hasRole(String roleName) {
        if (this.roles != null) {
            for (Role role : this.roles) {
                if (!role.getId().equals(roleName) && !role.getName().equals(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getMaxPrivileges() {
        ArrayList<String> maxPrivs = new ArrayList<String>();
        if (this.roles != null) {
            for (Role role : this.roles) {
                List<String> privs = role.getPrivileges();
                for (String priv : privs) {
                    if (maxPrivs.contains(priv)) continue;
                    maxPrivs.add(priv);
                }
            }
        }
        return maxPrivs;
    }

    public AccessControlListData clone() throws CloneNotSupportedException {
        AccessControlListData clone = (AccessControlListData)super.clone();
        ArrayList<Role> clonedRoles = new ArrayList<Role>();
        for (Role role : this.roles) {
            clonedRoles.add(role.clone());
        }
        clone.roles = clonedRoles;
        return clone;
    }

    public JSONObject toJSON() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("name", this.name);
        jsonObj.put("type", (Object)this.type.getValue());
        JSONArray jsonArray = new JSONArray();
        jsonObj.put("roles", jsonArray);
        for (Role role : this.roles) {
            jsonArray.add(role.toJSON());
        }
        return jsonObj;
    }
}

