/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security;

import com.ibm.ecm.security.AccessControlListData;
import com.ibm.ecm.security.SecurityConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlList
implements Cloneable {
    private String description;
    private String name;
    private List<AccessControlListData> aclData;

    public AccessControlList(String name, List<AccessControlListData> aclData) {
        this.name = name;
        this.aclData = aclData;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<AccessControlListData> getAclData() {
        return this.aclData;
    }

    public void setAclData(List<AccessControlListData> aclData) {
        this.aclData = aclData;
    }

    public List<String> getUserList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.aclData != null && this.aclData.size() > 0) {
            for (AccessControlListData aclDataObj : this.aclData) {
                if (list.contains(aclDataObj.getName()) || aclDataObj.getType() != SecurityConstants.PrincipalType.USER) continue;
                list.add(aclDataObj.getName());
            }
            Collections.sort(list);
        }
        return list;
    }

    public List<String> getGroupList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.aclData != null && this.aclData.size() > 0) {
            for (AccessControlListData aclDataObj : this.aclData) {
                if (list.contains(aclDataObj.getName()) || aclDataObj.getType() != SecurityConstants.PrincipalType.GROUP) continue;
                list.add(aclDataObj.getName());
            }
            Collections.sort(list);
        }
        return list;
    }

    public void remove(String entry) {
        if (this.aclData != null && this.aclData.size() > 0) {
            for (int i = 0; i < this.aclData.size(); ++i) {
                AccessControlListData aclDataObj = this.aclData.get(i);
                if (!aclDataObj.getName().equalsIgnoreCase(entry)) continue;
                this.aclData.remove(i);
            }
        }
    }

    public boolean contains(String entry) {
        if (this.aclData != null && this.aclData.size() > 0) {
            for (AccessControlListData aclDataObj : this.aclData) {
                if (!aclDataObj.getName().equalsIgnoreCase(entry)) continue;
                return true;
            }
        }
        return false;
    }

    public AccessControlListData get(String entry) {
        if (this.aclData != null && this.aclData.size() > 0) {
            for (AccessControlListData aclDataObj : this.aclData) {
                if (!aclDataObj.getName().equalsIgnoreCase(entry)) continue;
                return aclDataObj;
            }
        }
        return null;
    }

    public AccessControlList clone() throws CloneNotSupportedException {
        AccessControlList clone = (AccessControlList)super.clone();
        ArrayList<AccessControlListData> list = new ArrayList<AccessControlListData>();
        for (AccessControlListData dataEntry : this.aclData) {
            list.add(dataEntry.clone());
        }
        return clone;
    }
}

