/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.nls;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class GenerateDitaFromRuntimeMessages {
    public static void main(String[] args) throws IOException {
        String outDir = args[0];
        System.out.println("Generating message dita files to directory " + outDir);
        ResourceBundle servicesBundle = ResourceBundle.getBundle("com.ibm.ecm.nls.ServicesMessages", Locale.ENGLISH);
        ResourceBundle appletsBundle = ResourceBundle.getBundle("com.ibm.ecm.nls.ServicesMessages", Locale.ENGLISH);
        GenerateDitaFromRuntimeMessages.processJavaBundle(servicesBundle, outDir);
        GenerateDitaFromRuntimeMessages.processJavaBundle(appletsBundle, outDir);
        GenerateDitaFromRuntimeMessages.processJavascriptBundle("./WebContent/ecm/nls/messages.js", outDir);
        System.out.println("Message dita file generation completed");
    }

    private static final void processJavaBundle(ResourceBundle bundle, String outDir) throws IOException {
        for (String key : bundle.keySet()) {
            if (!key.endsWith(".id")) continue;
            String keyRoot = key.substring(0, key.length() - ".id".length());
            System.out.println("Processing message " + keyRoot);
            String num = bundle.getString(keyRoot + ".id");
            String id = "CIWEB" + num;
            String text = "";
            try {
                text = bundle.getString(keyRoot);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            String explanation = "";
            try {
                explanation = bundle.getString(keyRoot + ".explanation");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            String userResponse = "";
            try {
                userResponse = bundle.getString(keyRoot + ".userResponse");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            String adminResponse = "";
            try {
                adminResponse = bundle.getString(keyRoot + ".adminResponse");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            String parm0 = "parameter_0";
            try {
                parm0 = bundle.getString(keyRoot + ".0");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            String parm1 = "parameter_1";
            try {
                parm1 = bundle.getString(keyRoot + ".1");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            String parm2 = "parameter_2";
            try {
                parm2 = bundle.getString(keyRoot + ".2");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(outDir + "/" + id + ".dita"));
            String s = GenerateDitaFromRuntimeMessages.getMessage(num, text, explanation, userResponse, adminResponse, parm0, parm1, parm2) + "\n";
            writer.write(s);
            writer.close();
        }
    }

    private static final void processJavascriptBundle(String filename, String outDir) throws IOException {
        Hashtable<String, String> javascriptBundle = new Hashtable<String, String>();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        String line = reader.readLine().trim();
        while (line != null) {
            if ((line = line.trim()).contains(":")) {
                String key = line.substring(0, line.indexOf(":"));
                String value = line.substring(line.indexOf(":") + 1);
                if ((value = value.trim()).startsWith("\"")) {
                    value = value.substring(1);
                }
                if (value.endsWith(",")) {
                    value = value.substring(0, value.length() - 1);
                }
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                javascriptBundle.put(key, value);
            }
            line = reader.readLine();
        }
        for (String key : javascriptBundle.keySet()) {
            if (!key.endsWith("_number")) continue;
            String keyRoot = key.substring(0, key.length() - "_number".length());
            System.out.println("Processing message " + keyRoot);
            String num = (String)javascriptBundle.get(keyRoot + "_number");
            String id = "CIWEB" + num;
            String text = "";
            try {
                text = (String)javascriptBundle.get(keyRoot);
            }
            catch (Exception e) {
                // empty catch block
            }
            String explanation = "";
            try {
                explanation = (String)javascriptBundle.get(keyRoot + "_explanation");
            }
            catch (Exception e) {
                // empty catch block
            }
            String userResponse = "";
            try {
                userResponse = (String)javascriptBundle.get(keyRoot + "_userResponse");
            }
            catch (Exception e) {
                // empty catch block
            }
            String adminResponse = "";
            try {
                adminResponse = (String)javascriptBundle.get(keyRoot + "_adminResponse");
            }
            catch (Exception e) {
                // empty catch block
            }
            String parm0 = "parameter_0";
            try {
                parm0 = (String)javascriptBundle.get(keyRoot + "_0");
            }
            catch (Exception e) {
                // empty catch block
            }
            String parm1 = "parameter_1";
            try {
                parm1 = (String)javascriptBundle.get(keyRoot + "_1");
            }
            catch (Exception e) {
                // empty catch block
            }
            String parm2 = "parameter_2";
            try {
                parm2 = (String)javascriptBundle.get(keyRoot + "_2");
            }
            catch (Exception e) {
                // empty catch block
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(outDir + "/" + id + ".dita"));
            String s = GenerateDitaFromRuntimeMessages.getMessage(num, text, explanation, userResponse, adminResponse, parm0, parm1, parm2) + "\n";
            writer.write(s);
            writer.close();
        }
    }

    private static final String addAttr(String name, String value) {
        return ' ' + name + "=\"" + value + "\"";
    }

    private static final String getMessage(String num, String msg, String explanation, String userResponse, String adminResponse, String parm0, String parm1, String parm2) {
        StringBuffer buf = new StringBuffer();
        msg = GenerateDitaFromRuntimeMessages.closetags(msg);
        explanation = GenerateDitaFromRuntimeMessages.closetags(explanation);
        userResponse = GenerateDitaFromRuntimeMessages.closetags(userResponse);
        adminResponse = GenerateDitaFromRuntimeMessages.closetags(adminResponse);
        msg = GenerateDitaFromRuntimeMessages.substituteParms(msg, parm0, parm1, parm2);
        explanation = GenerateDitaFromRuntimeMessages.substituteParms(explanation, parm0, parm1, parm2);
        userResponse = GenerateDitaFromRuntimeMessages.substituteParms(userResponse, parm0, parm1, parm2);
        adminResponse = GenerateDitaFromRuntimeMessages.substituteParms(adminResponse, parm0, parm1, parm2);
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buf.append("\n<!--Arbortext, Inc., 1988-2009, v.4002-->");
        buf.append("\n<!DOCTYPE msg PUBLIC \"-//IBM//DTD DITA Message Reference//EN\" \"msgRef.dtd\">");
        buf.append("\n<?Pub Inc?>");
        buf.append("\n<msg");
        buf.append(GenerateDitaFromRuntimeMessages.addAttr("audience", "all"));
        buf.append(GenerateDitaFromRuntimeMessages.addAttr("id", "CIWEB" + num));
        buf.append(GenerateDitaFromRuntimeMessages.addAttr("otherprops", "all"));
        buf.append(GenerateDitaFromRuntimeMessages.addAttr("platform", "all"));
        buf.append(GenerateDitaFromRuntimeMessages.addAttr("product", "ciweb"));
        buf.append(GenerateDitaFromRuntimeMessages.addAttr("xml:lang", "en-us"));
        buf.append(">");
        buf.append("\n<msgId><msgPrefix>CIWEB</msgPrefix><msgNumber>").append(num).append("</msgNumber><msgSuffix></msgSuffix>\n</msgId>");
        buf.append("<?Pub Caret -2?>");
        buf.append("\n<msgText>").append(msg).append("</msgText>");
        buf.append("\n<msgBody>");
        buf.append("\n<msgExplanation>").append(explanation).append("</msgExplanation>");
        buf.append("\n<msgUserResponse>").append(userResponse).append("</msgUserResponse>");
        if (adminResponse != null) {
            buf.append("\n<msgAdministratorResponse>").append(adminResponse).append("</msgAdministratorResponse>");
        }
        buf.append("\n</msgBody>");
        buf.append("\n</msg>");
        buf.append("\n<?Pub *0000001261?>");
        return buf.toString();
    }

    private static final String substituteParms(String msg, String parm0, String parm1, String parm2) {
        if (msg == null) {
            return null;
        }
        msg = msg.replaceAll("\\$\\{0\\}", "<varname>" + parm0 + "</varname>");
        msg = msg.replaceAll("\\{0\\}", "<varname>" + parm0 + "</varname>");
        msg = msg.replaceAll("\\$\\{1\\}", "<varname>" + parm1 + "</varname>");
        msg = msg.replaceAll("\\$\\{2\\}", "<varname>" + parm2 + "</varname>");
        msg = msg.replaceAll("\\{1\\}", "<varname>" + parm1 + "</varname>");
        msg = msg.replaceAll("\\{2\\}", "<varname>" + parm2 + "</varname>");
        return msg;
    }

    private static final String closetags(String msg) {
        if (msg == null) {
            return null;
        }
        String msgout = "";
        StringTokenizer tokenizer = new StringTokenizer(msg, "<", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.startsWith("p>")) {
                msgout = msgout + token + "</p>";
                continue;
            }
            if (token.startsWith("li>")) {
                msgout = msgout + token + "</li>";
                continue;
            }
            if (token.startsWith("/p>")) {
                msgout = msgout.substring(0, msgout.length() - 1);
                msgout = msgout + token.substring(3);
                continue;
            }
            if (token.startsWith("/li>")) {
                msgout = msgout.substring(0, msgout.length() - 1);
                msgout = msgout + token.substring(4);
                continue;
            }
            msgout = msgout + token;
        }
        return msgout;
    }
}

