/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.viewer;

import com.ibm.ecm.beans.viewer.ViewServicesInfo;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class ViewServicesInfoMediator
extends BaseMediator {
    private String docUrl = null;
    private String contentType = null;
    private String serverType = null;
    private ViewServicesInfo viewServicesInfo;

    public ViewServicesInfoMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public String getDocUrl() {
        return this.docUrl;
    }

    public void setDocUrl(String docUrl) {
        this.docUrl = docUrl;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ViewServicesInfo getViewServicesInfo() {
        return this.viewServicesInfo;
    }

    public void setViewServicesInfo(ViewServicesInfo viewServicesInfo) {
        this.viewServicesInfo = viewServicesInfo;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        jsonObject.put("docUrl", this.getDocUrl());
        jsonObject.put("contentType", this.getContentType());
        jsonObject.put("serverType", this.getServerType());
        if (this.viewServicesInfo != null) {
            JSONUtils.put(jsonObject, "pageCount", this.viewServicesInfo.getPageCount());
            JSONUtils.put(jsonObject, "canRotate", this.viewServicesInfo.canRotate());
            JSONUtils.put(jsonObject, "canEnhance", this.viewServicesInfo.canEnhance());
            JSONUtils.put(jsonObject, "canInvert", this.viewServicesInfo.canInvert());
            JSONUtils.put(jsonObject, "canShowAnnotations", this.viewServicesInfo.canShowAnnotations());
            JSONUtils.put(jsonObject, "canBalance", this.viewServicesInfo.canBalance());
            JSONUtils.put(jsonObject, "canPrint", this.viewServicesInfo.canPrint());
            JSONUtils.put(jsonObject, "canManipulatePages", this.viewServicesInfo.canManipulatePages());
            JSONUtils.put(jsonObject, "minScale", this.viewServicesInfo.getMinScale());
            JSONUtils.put(jsonObject, "maxScale", this.viewServicesInfo.getMaxScale());
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, new StringBuffer("Returning JSON: ").append(jsonObject.toString()).toString());
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        int pageCount = new Integer(jsonObject.get("pageCount").toString());
        boolean canRotate = new Boolean(jsonObject.get("canRotate").toString());
        boolean canEnhance = new Boolean(jsonObject.get("canEnhance").toString());
        boolean canInvert = new Boolean(jsonObject.get("canInvert").toString());
        boolean canShowAnnotations = new Boolean(jsonObject.get("canShowAnnotations").toString());
        boolean canBalance = new Boolean(jsonObject.get("canBalance").toString());
        boolean canPrint = new Boolean(jsonObject.get("canPrint").toString());
        boolean canManipulatePages = new Boolean(jsonObject.get("canManipulatePages").toString());
        double minScale = new Double(jsonObject.get("minScale").toString());
        double maxScale = new Double(jsonObject.get("maxScale").toString());
        ViewServicesInfo viewServicesInfo = new ViewServicesInfo(pageCount, canRotate, canEnhance, canInvert, canShowAnnotations, canBalance, canPrint, canManipulatePages, minScale, maxScale);
        this.setViewServicesInfo(viewServicesInfo);
    }
}

