/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8.workflow;

import com.filenet.api.collection.StringList;
import com.filenet.api.core.Containable;
import com.filenet.api.core.Document;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.RepositoryObject;
import com.filenet.api.core.VersionSeries;
import com.filenet.api.core.Versionable;
import com.filenet.api.core.WorkflowDefinition;
import com.filenet.api.events.ClassWorkflowSubscription;
import com.filenet.api.util.Id;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8WorkflowSubscriptionsMediator
extends BaseMediator {
    private IndependentlyPersistableObject item = null;
    private ArrayList validSubscriptions;

    public P8WorkflowSubscriptionsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setValidSubscriptions(ArrayList validSubscriptions) {
        this.validSubscriptions = validSubscriptions;
    }

    public void setItem(IndependentlyPersistableObject item) {
        this.item = item;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            JSONObject jsonDataStore = new JSONObject();
            JSONArray jsonItems = new JSONArray();
            int count = 0;
            if (this.validSubscriptions != null) {
                for (ClassWorkflowSubscription subscription : this.validSubscriptions) {
                    Boolean isEnabled = subscription.get_IsEnabled();
                    Boolean manualLaunch = subscription.get_EnableManualLaunch();
                    if (!isEnabled.booleanValue() || !manualLaunch.booleanValue()) continue;
                    ++count;
                    JSONObject jsonItem = new JSONObject();
                    String displayName = subscription.get_DisplayName();
                    String description = subscription.get_DescriptiveText();
                    jsonItem.put("displayName", displayName);
                    jsonItem.put("description", description);
                    WorkflowDefinition workflow = subscription.get_WorkflowDefinition();
                    Id workflowId = workflow.get_Id();
                    ObjectStore workflowObjectStore = workflow.getObjectStore();
                    workflowObjectStore.refresh();
                    jsonItem.put("workflowId", workflowId.toString());
                    jsonItem.put("workflowObjectStore", workflowObjectStore.get_ObjectStoreId().toString());
                    String propertyMap = null;
                    StringList propertyMapList = subscription.get_PropertyMap();
                    for (String propMap : propertyMapList) {
                        if (propertyMap == null) {
                            propertyMap = propMap;
                            continue;
                        }
                        propertyMap = propertyMap + "," + propMap;
                    }
                    jsonItem.put("subject", subscription.get_Subject());
                    jsonItem.put("vwversion", URLEncoder.encode(subscription.get_VWVersion(), "UTF-8"));
                    if (propertyMap != null) {
                        jsonItem.put("propertyMap", URLEncoder.encode(propertyMap, "UTF-8"));
                    }
                    jsonItems.add(jsonItem);
                }
                ObjectStore itemObjectStore = ((RepositoryObject)this.item).getObjectStore();
                itemObjectStore.refresh();
                String attachmentId = "";
                if (this.item instanceof Document) {
                    VersionSeries vs = ((Versionable)this.item).get_VersionSeries();
                    Id vsId = vs.get_Id();
                    String name = ((Document)this.item).get_Name();
                    attachmentId = name + "||3|3|" + itemObjectStore.get_DisplayName() + "|" + vsId;
                } else if (this.item instanceof Folder) {
                    Id itemId = ((Containable)this.item).get_Id();
                    String name = ((Folder)this.item).get_Name();
                    attachmentId = name + "||2|3|" + itemObjectStore.get_DisplayName() + "|" + itemId;
                }
                jsonObject.put("attachmentId", URLEncoder.encode(attachmentId, "UTF-8"));
                jsonObject.put("subscriptions_name", "WorkflowSubscriptions");
                jsonObject.put("num_subscriptions", (Object)count);
                jsonDataStore.put("items", jsonItems);
                jsonDataStore.put("label", "description");
                jsonDataStore.put("identifier", "displayName");
                jsonObject.put("datastore", jsonDataStore);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }
}

