/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8.workflow;

import com.ibm.ecm.json.TableView;
import com.ibm.ecm.mediator.ResultSetMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.ColumnUtil;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.p8.P8Workflow;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWDataField;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWWorkBasket;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.util.MessageResources;

public class P8WorkItemsMediator
extends ResultSetMediator {
    private VWQueueElement[] queueElements = null;
    private VWWorkBasket.Column[] columns = null;
    private String repositoryId = null;
    private int fetchCount = 0;
    public int pageSize = 200;
    public static Long NO_DATE = new Long("-2000000000000");
    public static Long FUTURE_DATE = new Long("2147483647000");

    public P8WorkItemsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setQueueElements(VWQueueElement[] queueElements) {
        this.queueElements = queueElements;
    }

    public void setColumns(VWWorkBasket.Column[] columns) {
        this.columns = columns;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setFetchCount(int fetchCount) {
        this.fetchCount = fetchCount;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        jsonObject.put("pageSize", (Object)this.pageSize);
        jsonObject.put("sortDirection", "0");
        jsonObject.put("sortIndex", "-1");
        jsonObject.put("showLocation", "false");
        jsonObject.put("repositoryId", this.repositoryId);
        jsonObject.put("template_name", (Object)null);
        jsonObject.put("template_label", (Object)null);
        jsonObject.put("templates", (Object)null);
        jsonObject.put("num_results", (Object)(this.queueElements != null ? this.queueElements.length : 0));
        jsonObject.put("fetchCount", (Object)this.fetchCount);
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    protected JSONArray buildMagazineViewColumns() {
        return new JSONArray();
    }

    protected JSONObject buildTableColumns() throws Exception {
        String methodName = "buildTableColums";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONObject jsonCells = null;
        TableView tableView = new TableView();
        TableView.ColumnSet columnSet = tableView.createColumnSet();
        if (this.columns != null) {
            columnSet.addColumnProperty(ColumnUtil.buildStateColumnProperty(this.request, "&nbsp;", "multiStateIcon", true, true, false), true);
            columnSet.addColumnProperty(ColumnUtil.buildColumnProperty("&nbsp;", "17px", "mimeTypeIcon", null, true), true);
            String symbolicName = this.columns[0].getName();
            String criteriaName = this.columns[0].getPrompt();
            Boolean nosort = !this.columns[0].isSortable();
            columnSet.addColumnProperty(ColumnUtil.buildColumnProperty(criteriaName, "20em", symbolicName, null, nosort));
            for (int i = 1; i < this.columns.length; ++i) {
                VWWorkBasket.Column column = this.columns[i];
                symbolicName = column.getName();
                criteriaName = column.getPrompt();
                criteriaName = StringEscapeUtils.escapeHtml((String)criteriaName).trim();
                nosort = !column.isSortable();
                double size = 16.0;
                size = Math.max((double)criteriaName.length(), size) * 0.6;
                String width = P8WorkItemsMediator.formatSize(size) + "em";
                columnSet.addColumnProperty(ColumnUtil.buildColumnProperty(criteriaName, width, symbolicName, null, nosort));
            }
            jsonCells = tableView.toJson();
        } else {
            columnSet.addColumnProperty(ColumnUtil.buildStateColumnProperty(this.request, "&nbsp;", "multiStateIcon", true, true, false), true);
            columnSet.addColumnProperty(ColumnUtil.buildColumnProperty("&nbsp;", "17px", "mimeTypeIcon", null, true), true);
            columnSet.addColumnProperty(ColumnUtil.buildColumnProperty("Subject", "25em", "F_Subject", null, false));
            jsonCells = tableView.toJson();
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonCells;
    }

    private static String formatSize(double val) {
        int ix = (int)(val * 100.0);
        double rounded = (double)ix / 100.0;
        return Double.toString(rounded);
    }

    protected JSONArray buildTableRows() throws Exception {
        JSONArray jsonRows = new JSONArray();
        if (this.queueElements != null) {
            for (int i = 0; i < this.queueElements.length; ++i) {
                VWQueueElement queueElement = this.queueElements[i];
                JSONObject jsonRow = new JSONObject();
                jsonRow.put("id", queueElement.getWorkObjectNumber());
                jsonRow.put("name", queueElement.getSubject());
                JSONObject jsonAttributes = new JSONObject();
                JSONArray jsonAttributeInfo = new JSONArray();
                jsonAttributeInfo.add(queueElement.getSubject());
                jsonAttributes.put("Name", jsonAttributeInfo);
                jsonAttributeInfo = new JSONArray();
                jsonAttributeInfo.add(queueElement.getStepName());
                jsonAttributeInfo.add("xs:string");
                jsonAttributes.put("F_StepName", jsonAttributeInfo);
                jsonAttributeInfo = new JSONArray();
                jsonAttributeInfo.add(queueElement.getSubject());
                jsonAttributeInfo.add("xs:string");
                jsonAttributes.put("F_Subject", jsonAttributeInfo);
                jsonAttributeInfo = new JSONArray();
                int status = queueElement.getStepDeadlineStatus();
                if (status == 0) {
                    jsonAttributeInfo.add(this.messageResources.getMessage(this.locale, "process.overdue.inprocess"));
                } else if (status == 1) {
                    jsonAttributeInfo.add(this.messageResources.getMessage(this.locale, "process.overdue.remindersent"));
                } else {
                    jsonAttributeInfo.add(this.messageResources.getMessage(this.locale, "process.overdue.overdue"));
                }
                jsonAttributeInfo.add("xs:string");
                jsonAttributes.put("F_Overdue", jsonAttributeInfo);
                jsonAttributeInfo = new JSONArray();
                VWDataField dataField = queueElement.getDataField("F_EnqueueTime");
                if (dataField != null) {
                    Date enqueueTime = (Date)dataField.getValue();
                    jsonAttributeInfo.add(DateUtil.getISODateString(enqueueTime, true));
                } else {
                    jsonAttributeInfo.add("");
                }
                jsonAttributeInfo.add("xs:timestamp");
                jsonAttributes.put("F_EnqueueTime", jsonAttributeInfo);
                jsonAttributeInfo = new JSONArray();
                String queueName = queueElement.getQueueName();
                jsonAttributeInfo.add(queueName);
                jsonAttributeInfo.add("xs:string");
                jsonAttributes.put("queueName", jsonAttributeInfo);
                jsonAttributeInfo = new JSONArray();
                jsonAttributeInfo.add(queueElement.getWorkObjectNumber());
                jsonAttributeInfo.add("xs:string");
                jsonAttributes.put("wobNum", jsonAttributeInfo);
                jsonAttributeInfo = new JSONArray();
                int locked = queueElement.getLockedStatus();
                jsonAttributeInfo.add(locked > 0 ? "true" : "false");
                jsonAttributeInfo.add("xs:boolean");
                jsonAttributes.put("IsReserved", jsonAttributeInfo);
                jsonAttributeInfo = new JSONArray();
                jsonAttributeInfo.add(locked > 0 ? "true" : "false");
                jsonAttributeInfo.add("xs:boolean");
                jsonAttributes.put("F_Locked", jsonAttributeInfo);
                jsonRow.put("locked", locked > 0 ? "true" : "false");
                jsonAttributeInfo = new JSONArray();
                jsonAttributeInfo.add(queueElement.getLockedUser());
                jsonAttributeInfo.add("xs:string");
                jsonAttributes.put("F_LockedUser", jsonAttributeInfo);
                jsonRow.put("lockedUser", queueElement.getLockedUser());
                jsonRow.put("name", queueElement.getSubject());
                jsonRow.put("template", "");
                jsonRow.put("queueName", queueElement.getQueueName());
                jsonRow.put("wobNum", queueElement.getWorkObjectNumber());
                jsonRow.put("F_StepProcId", (Object)queueElement.getProcessorId());
                jsonRow.put("isSelected", "false");
                if (!queueName.equals("Tracker")) {
                    jsonRow.put("mimetype", "application/x-workitem");
                } else {
                    jsonRow.put("mimetype", "application/x-tracker");
                }
                boolean canReassign = queueElement.getCanReassign();
                jsonRow.put("privCanReassign", canReassign ? "true" : "false");
                if (this.columns != null) {
                    for (int j = 0; j < this.columns.length; ++j) {
                        String name = this.columns[j].getAuthoredName();
                        if (jsonAttributes.containsKey(name)) continue;
                        jsonAttributeInfo = new JSONArray();
                        Object fieldValue = queueElement.getFieldValue(name);
                        if (fieldValue instanceof Date) {
                            Date dateValue = (Date)fieldValue;
                            if (dateValue == null || dateValue.getTime() == NO_DATE.longValue()) {
                                jsonAttributeInfo.add("");
                            } else if (dateValue.getTime() == FUTURE_DATE.longValue()) {
                                jsonAttributeInfo.add("");
                            } else {
                                jsonAttributeInfo.add(DateUtil.getISODateString(dateValue, true));
                            }
                        } else if (fieldValue instanceof Boolean) {
                            jsonAttributeInfo.add((Boolean)fieldValue == true ? "true" : "false");
                        } else if (name.equals("StepName")) {
                            jsonAttributeInfo.add(queueElement.getStepName());
                        } else {
                            jsonAttributeInfo.add(fieldValue);
                        }
                        String type = P8Workflow.getDataType(this.columns[j].getType());
                        jsonAttributeInfo.add(type);
                        jsonAttributes.put(name, jsonAttributeInfo);
                    }
                }
                jsonRow.put("attributes", jsonAttributes);
                jsonRows.add(jsonRow);
            }
        }
        return jsonRows;
    }
}

