/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.SecurityTokenManager;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWUserInfo;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8UserPreferencesMediator
extends BaseMediator {
    private VWSession vwSession = null;
    private VWUserInfo userInfo = null;
    private String mode = null;

    public P8UserPreferencesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setVWSession(VWSession vwSession) {
        this.vwSession = vwSession;
    }

    public void setUserInfo(VWUserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            String token;
            if (this.userInfo != null && this.mode == null) {
                JSONObject jsonPreferences = new JSONObject();
                jsonPreferences.put("name", this.userInfo.getName());
                jsonPreferences.put("emailAddress", this.userInfo.getEMailAddress());
                Locale preferredLocale = this.userInfo.getPreferredLocale();
                Locale[] supportedLocales = this.vwSession.fetchAvailableLocales();
                if (supportedLocales != null && supportedLocales.length > 0) {
                    JSONArray jsonLocales = new JSONArray();
                    String useServerDefault = this.messageResources.getMessage(this.locale, "process.user.info.server.locale");
                    jsonLocales.add(useServerDefault);
                    boolean found = false;
                    for (int i = 0; i < supportedLocales.length; ++i) {
                        Locale supportedLocale = supportedLocales[i];
                        jsonLocales.add(supportedLocale.getDisplayName());
                        if (found || preferredLocale == null || !preferredLocale.equals(supportedLocale)) continue;
                        jsonPreferences.put("selectedLocale", preferredLocale.getDisplayName());
                        found = true;
                    }
                    jsonPreferences.put("preferredLocales", jsonLocales);
                } else {
                    Locale serverLocale = this.vwSession.fetchServerLocale();
                    if (serverLocale == null) {
                        jsonPreferences.put("renderPreferredLocale", "false");
                    } else {
                        JSONArray jsonLocales = new JSONArray();
                        jsonLocales.add(serverLocale.getDisplayName());
                        jsonPreferences.put("selectedLocale", serverLocale.getDisplayName());
                        jsonPreferences.put("preferredLocales", jsonLocales);
                    }
                }
                VWParticipant participant = this.userInfo.getProxyUserNamePx();
                if (participant != null) {
                    jsonPreferences.put("proxyUserDisplayName", participant.getDisplayName());
                    jsonPreferences.put("proxyUserShortName", participant.getParticipantName());
                }
                int flags = this.userInfo.getNotificationFlags();
                jsonPreferences.put("stepNewAssignment", Boolean.toString(this.getNotificationFlag(flags, 1)));
                jsonPreferences.put("stepExpiredDeadline", Boolean.toString(this.getNotificationFlag(flags, 2)));
                jsonPreferences.put("stepReminders", Boolean.toString(this.getNotificationFlag(flags, 4)));
                jsonPreferences.put("stepMilestoneReached", Boolean.toString(this.getNotificationFlag(flags, 512)));
                jsonPreferences.put("trackerNewAssignment", Boolean.toString(this.getNotificationFlag(flags, 32)));
                jsonPreferences.put("trackerDeadlineReminders", Boolean.toString(this.getNotificationFlag(flags, 64)));
                jsonPreferences.put("trackerDeadlineExpired", Boolean.toString(this.getNotificationFlag(flags, 16)));
                jsonPreferences.put("trackerException", Boolean.toString(this.getNotificationFlag(flags, 8)));
                jsonPreferences.put("trackerExpiredDeadline", Boolean.toString(this.getNotificationFlag(flags, 128)));
                jsonPreferences.put("trackerMilestoneReached", Boolean.toString(this.getNotificationFlag(flags, 256)));
                jsonObject.put("preferences", jsonPreferences);
            }
            if (P8UserPreferencesMediator.isSecureServiceEnabled(this.request) && (token = new SecurityTokenManager().generateToken(this.request, false)) != null) {
                jsonObject.put("security_token", token);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    public boolean getNotificationFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }
}

