/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.SecurityTokenManager;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWMilestoneElement;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8TrackerMilestonesMediator
extends BaseMediator {
    private VWMilestoneElement[] workflowMilestones = null;
    private String name = null;

    public P8TrackerMilestonesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setWorkflowMilestones(VWMilestoneElement[] workflowMilestones) {
        this.workflowMilestones = workflowMilestones;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            String token;
            JSONObject jsonDataStore = new JSONObject();
            JSONArray jsonItems = new JSONArray();
            if (this.workflowMilestones != null) {
                for (int i = 0; i < this.workflowMilestones.length; ++i) {
                    JSONObject jsonItem = new JSONObject();
                    VWMilestoneElement workflowMilestone = this.workflowMilestones[i];
                    jsonItem.put("milestone", workflowMilestone.getName());
                    jsonItem.put("message", workflowMilestone.getMessage());
                    jsonItem.put("level", (Object)workflowMilestone.getLevel());
                    Date date = workflowMilestone.getTimestamp();
                    if (date != null) {
                        jsonItem.put("reached", DateUtil.getISODateString(date, true));
                    }
                    jsonItems.add(jsonItem);
                }
            }
            jsonDataStore.put("milestones", jsonItems);
            jsonObject.put("datastore", jsonDataStore);
            if (this.name != null) {
                jsonObject.put("name", this.name);
            }
            if (P8TrackerMilestonesMediator.isSecureServiceEnabled(this.request) && (token = new SecurityTokenManager().generateToken(this.request, false)) != null) {
                jsonObject.put("security_token", token);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }
}

