/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DateUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWParticipantHistory;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWStepHistory;
import filenet.vw.api.VWStepOccurrenceHistory;
import filenet.vw.api.VWStepWorkObjectHistory;
import filenet.vw.api.VWWorkflowHistory;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8TrackerHistoryMediator
extends BaseMediator {
    private VWProcess vwProcess = null;
    private VWMapDefinition[] maps = null;

    public P8TrackerHistoryMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setMaps(VWMapDefinition[] maps) {
        this.maps = maps;
    }

    public void setVWProcess(VWProcess vwProcess) {
        this.vwProcess = vwProcess;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            JSONObject jsonDataStore = new JSONObject();
            JSONArray jsonItems = new JSONArray();
            JSONArray jsonMaps = new JSONArray();
            for (int i = 0; i < this.maps.length; ++i) {
                VWMapDefinition vmMap = this.maps[i];
                String mapName = this.maps[i].getName();
                jsonMaps.add(mapName);
                VWWorkflowHistory vwWorkflowHistory = this.vwProcess.fetchWorkflowHistory(vmMap.getMapId());
                if (vwWorkflowHistory == null) continue;
                P8TrackerHistoryMediator.getParticipantHistoryInfo(vwWorkflowHistory, jsonItems, mapName);
            }
            jsonDataStore.put("workflowMaps", jsonMaps);
            jsonDataStore.put("historyItems", jsonItems);
            jsonObject.put("datastore", jsonDataStore);
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    private static void getParticipantHistoryInfo(VWWorkflowHistory vwWorkflowHistory, JSONArray jsonItems, String mapName) {
        String methodName = "getParticipantHistory";
        VWStepHistory vwStepHistory = null;
        VWStepOccurrenceHistory vwStepOccuranceHistory = null;
        VWStepWorkObjectHistory vwStepWorkObjectHistory = null;
        VWParticipantHistory vwParticipantHistory = null;
        try {
            while (vwWorkflowHistory.hasNext()) {
                vwStepHistory = vwWorkflowHistory.next();
                if (vwStepHistory == null || vwStepHistory.isCompoundStep()) continue;
                int occurrence = 0;
                vwStepHistory.resetFetch();
                while (vwStepHistory.hasNext()) {
                    String stepName = vwStepHistory.getStepName();
                    vwStepOccuranceHistory = vwStepHistory.next();
                    if (vwStepOccuranceHistory == null) continue;
                    ++occurrence;
                    vwStepOccuranceHistory.resetFetch();
                    while (vwStepOccuranceHistory.hasNext()) {
                        vwStepWorkObjectHistory = vwStepOccuranceHistory.next();
                        if (vwStepWorkObjectHistory == null) continue;
                        vwStepWorkObjectHistory.resetFetch();
                        while (vwStepWorkObjectHistory.hasNext()) {
                            vwParticipantHistory = vwStepWorkObjectHistory.next();
                            if (vwParticipantHistory == null) continue;
                            JSONObject jsonItem = new JSONObject();
                            jsonItem.put("participant", vwParticipantHistory.getParticipantName());
                            jsonItem.put("stepName", stepName);
                            Date completionDate = vwParticipantHistory.getCompletionDate();
                            if (completionDate != null) {
                                jsonItem.put("completed", DateUtil.getISODateString(completionDate, true));
                            } else {
                                jsonItem.put("status", (Object)vwParticipantHistory.getStepStatus());
                            }
                            jsonItem.put("response", vwParticipantHistory.getResponse());
                            jsonItem.put("comments", vwParticipantHistory.getComments());
                            jsonItem.put("cycle", (Object)occurrence);
                            jsonItem.put("map", mapName);
                            jsonItems.add(jsonItem);
                        }
                    }
                }
            }
        }
        catch (VWException e) {
            // empty catch block
        }
    }
}

