/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8.workflow;

import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.SecurityTokenManager;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWStepElement;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8TrackerElementMediator
extends BaseMediator {
    private VWStepElement trackerElement = null;
    private int queueType = -1;
    private DesktopConfig desktopConfig = null;

    public P8TrackerElementMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setTrackerElement(VWStepElement trackerElement) {
        this.trackerElement = trackerElement;
    }

    public void setQueueType(int type) {
        this.queueType = type;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            String token;
            jsonObject.put("Name", this.trackerElement.getSubject());
            jsonObject.put("queueName", this.trackerElement.getQueueName());
            if (this.queueType > 0) {
                String type = "";
                if (this.queueType == 1) {
                    type = "processQueue";
                } else if (this.queueType == 2) {
                    type = "userQueue";
                } else if (this.queueType == 3) {
                    type = "systemQueue";
                }
                jsonObject.put("queue_type", type);
            }
            jsonObject.put("wobNum", this.trackerElement.getWorkObjectNumber());
            jsonObject.put("workclass_name", this.trackerElement.getWorkClassName());
            jsonObject.put("sheet_name", this.trackerElement.getCurrentMapName());
            jsonObject.put("step_name", this.trackerElement.getStepName());
            VWParameter[] parameters = this.trackerElement.getParameters(767, 3);
            if (parameters != null) {
                Date deadline = this.trackerElement.getDeadline();
                int overdue = this.trackerElement.getOverdue();
                String overdueStatus = null;
                overdueStatus = overdue == 0 ? this.messageResources.getMessage(this.locale, "process.overdue.inprocess") : (overdue == 1 ? this.messageResources.getMessage(this.locale, "process.overdue.remindersent") : this.messageResources.getMessage(this.locale, "process.overdue.overdue"));
                if (deadline != null) {
                    JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Deadline", DateUtil.getISODateString(deadline, true), "xs:timestamp"));
                } else if (overdue == 2) {
                    JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Deadline", overdueStatus, "xs:string"));
                } else {
                    String noneSet = this.messageResources.getMessage(this.locale, "process.overdue.noneset");
                    JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Deadline", noneSet, "xs:string"));
                }
                JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Overdue", overdueStatus, "xs:string"));
                JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Subject", this.trackerElement.getSubject(), "xs:string"));
                Date dateReceived = this.trackerElement.getDateReceived();
                if (dateReceived != null) {
                    JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_StepReceived", DateUtil.getISODateString(dateReceived, true), "xs:timestamp"));
                }
                JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Originator", this.trackerElement.getOriginator(), "xs:string"));
                JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_StepName", this.trackerElement.getStepName(), "xs:string"));
                JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Instructions", this.trackerElement.getStepDescription(), "xs:string"));
            }
            if (P8TrackerElementMediator.isSecureServiceEnabled(this.request) && (token = new SecurityTokenManager().generateToken(this.request, false)) != null) {
                jsonObject.put("security_token", token);
            }
        }
        catch (Exception e) {
            Logger.logError(P8TrackerElementMediator.class, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    private JSONObject getSystemFieldJSON(String name, String value, String dataType) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("readOnly", new Boolean(true));
        jsonObject.put("cardinality", "SINGLE");
        jsonObject.put("system", new Boolean(true));
        jsonObject.put("name", name);
        jsonObject.put("dataType", dataType);
        jsonObject.put("required", new Boolean(false));
        jsonObject.put("hidden", new Boolean(false));
        jsonObject.put("label", name);
        if (value == null) {
            value = "";
        }
        jsonObject.put("values", value);
        return jsonObject;
    }
}

