/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8.workflow;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.SecurityTokenManager;
import com.ibm.ecm.util.p8.P8Workflow;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWWorkflowDefinition;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8StepElementMediator
extends BaseMediator {
    private VWStepElement stepElement = null;
    private int queueType = -1;
    private String entryTemplateMode = null;
    private DesktopConfig desktopConfig = null;
    private VWWorkflowDefinition workflowDefinition = null;
    private String defaultRepositoryId = null;

    public P8StepElementMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setStepElement(VWStepElement stepElement) {
        this.stepElement = stepElement;
    }

    public void setQueueType(int type) {
        this.queueType = type;
    }

    public void setMode(String entryTemplateMode) {
        this.entryTemplateMode = entryTemplateMode;
    }

    public void setWorkflowDefinition(VWWorkflowDefinition workflowDefinition) {
        this.workflowDefinition = workflowDefinition;
    }

    public void setRepositoryId(String repositoryId) {
        this.defaultRepositoryId = repositoryId;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            String token;
            jsonObject.put("Name", this.stepElement.getSubject());
            jsonObject.put("queueName", this.stepElement.getQueueName());
            if (this.queueType > 0) {
                String type = "";
                if (this.queueType == 1) {
                    type = "processQueue";
                } else if (this.queueType == 2) {
                    type = "userQueue";
                } else if (this.queueType == 3) {
                    type = "systemQueue";
                }
                jsonObject.put("queue_type", type);
            }
            jsonObject.put("wobNum", this.stepElement.getWorkObjectNumber());
            jsonObject.put("workclass_name", this.stepElement.getWorkClassName());
            jsonObject.put("sheet_name", this.stepElement.getCurrentMapName());
            jsonObject.put("step_name", this.stepElement.getStepName());
            jsonObject.put("showFieldHoverHelp", new Boolean(false));
            jsonObject.put("can_return", new Boolean(this.stepElement.getCanReturnToSource()));
            jsonObject.put("can_reassign", new Boolean(this.stepElement.getCanReassign()));
            jsonObject.put("can_view_history", new Boolean(this.stepElement.getCanViewHistory()));
            jsonObject.put("can_view_status", new Boolean(this.stepElement.getCanViewStatus()));
            String mainAttachmentParameterName = null;
            try {
                mainAttachmentParameterName = (String)this.stepElement.getParameterValue("F_MAINATTACHMENT");
            }
            catch (Exception e) {
                // empty catch block
            }
            Hashtable<String, JSONObject> criteriaSortTable = new Hashtable<String, JSONObject>();
            Hashtable<String, JSONObject> participantSortTable = new Hashtable<String, JSONObject>();
            Hashtable<String, JSONObject> attachmentSortTable = new Hashtable<String, JSONObject>();
            JSONObject jsonComment = null;
            VWParameter[] parameters = this.stepElement.getParameters(767, 3);
            if (parameters != null) {
                VWMapNode[] steps = null;
                if (this.entryTemplateMode != null && this.entryTemplateMode.equals("et")) {
                    VWMapDefinition mapDefinition = this.workflowDefinition.getMainMap();
                    steps = mapDefinition.getSteps();
                }
                for (int i = 0; i < parameters.length; ++i) {
                    JSONObject jsonCriteria = new JSONObject();
                    VWParameter parameter = parameters[i];
                    String name = parameter.getName();
                    if (parameter.getName().equals("EDS_Service")) {
                        jsonObject.put("EDS_Service", parameter.getValue());
                        continue;
                    }
                    Integer mode = parameter.getMode();
                    if (mode.equals(1)) {
                        jsonCriteria.put("readOnly", new Boolean(true));
                    } else if (mode.equals(3)) {
                        jsonCriteria.put("readOnly", new Boolean(false));
                    } else {
                        jsonCriteria.put("readOnly", new Boolean(false));
                    }
                    if (parameter.isArray()) {
                        jsonCriteria.put("cardinality", "LIST");
                    } else {
                        jsonCriteria.put("cardinality", "SINGLE");
                    }
                    if (parameter.isSystemParameter()) {
                        if (name.equals("F_Comment") || name.equals("F_Trackers")) {
                            jsonCriteria.put("system", new Boolean(false));
                        } else {
                            jsonCriteria.put("system", new Boolean(true));
                        }
                    } else {
                        jsonCriteria.put("system", new Boolean(false));
                    }
                    jsonCriteria.put("name", name);
                    String prompt = parameter.getDescription();
                    if (name.equals("F_Comment")) {
                        prompt = this.messageResources.getMessage(this.locale, "process.comment");
                    }
                    if (prompt == null || prompt.length() == 0) {
                        prompt = parameter.getAuthoredName();
                    }
                    int dataType = parameter.getFieldType();
                    if (name.equals("F_Responses")) {
                        dataType = 2;
                    }
                    jsonCriteria.put("dataType", P8Workflow.getDataType(dataType));
                    String minValue = "";
                    String maxValue = "";
                    String maxEntry = "";
                    if (dataType == 1) {
                        minValue = "-2147483648";
                        maxValue = "2147483647";
                    } else if (dataType == 8) {
                        minValue = "-1.7976931348623157E308";
                        maxValue = "1.7976931348623157E308";
                    } else if (dataType != 16 && dataType == 2) {
                        maxEntry = "2147483647";
                    }
                    jsonCriteria.put("minValue", minValue);
                    jsonCriteria.put("maxValue", maxValue);
                    jsonCriteria.put("maxEntry", maxEntry);
                    Boolean required = false;
                    if (dataType == 64 && !name.equals("F_Trackers")) {
                        required = true;
                    }
                    jsonCriteria.put("required", required);
                    Boolean hidden = false;
                    if (dataType == 32) {
                        hidden = true;
                    } else if (dataType == 1 && this.entryTemplateMode != null && this.entryTemplateMode.equals("et") && name.startsWith("VotingTotal")) {
                        hidden = true;
                    }
                    jsonCriteria.put("hidden", hidden);
                    if (dataType == 32 && mainAttachmentParameterName != null && name.equals(mainAttachmentParameterName)) {
                        jsonCriteria.put("initiatingAttachment", mainAttachmentParameterName);
                    }
                    if (name.equals("F_Responses")) {
                        String[] responses = this.stepElement.getStepResponses();
                        if (responses == null || responses.length < 1) {
                            jsonCriteria.put("validValues", "");
                        } else {
                            P8StepElementMediator.addStringArrayToJSON(jsonCriteria, "validValues", responses);
                        }
                        jsonCriteria.put("values", "");
                        criteriaSortTable.put(prompt, jsonCriteria);
                    } else {
                        Object values = P8Workflow.getValue(parameter);
                        if (values instanceof String[]) {
                            P8StepElementMediator.addStringArrayToJSON(jsonCriteria, "values", (String[])values);
                            criteriaSortTable.put(prompt, jsonCriteria);
                        } else if (values instanceof VWParticipant[]) {
                            if (this.entryTemplateMode != null && this.entryTemplateMode.equals("et")) {
                                VWParameter votingParameter;
                                String index = name.substring(13);
                                String votingParameterName = "VotingTotal" + index;
                                VWStepDefinition stepDefinition = (VWStepDefinition)steps[Integer.parseInt(index) + 1];
                                if (stepDefinition != null) {
                                    prompt = stepDefinition.getName();
                                }
                                if ((votingParameter = this.stepElement.getParameter(votingParameterName)) != null) {
                                    jsonCriteria.put("votingParameter", votingParameterName);
                                    Integer value = (Integer)votingParameter.getValue();
                                    jsonCriteria.put("votingNumber", value.toString());
                                }
                            }
                            this.addParticipantArrayToJSON(jsonCriteria, "values", (VWParticipant[])values);
                            participantSortTable.put(prompt, jsonCriteria);
                        } else if (values instanceof VWAttachment[]) {
                            this.addAttachmentArrayToJSON(jsonCriteria, "values", (VWAttachment[])values);
                            attachmentSortTable.put(prompt, jsonCriteria);
                        } else {
                            jsonCriteria.put("values", values);
                            if (name.equals("F_Comment")) {
                                jsonComment = jsonCriteria;
                            } else {
                                criteriaSortTable.put(prompt, jsonCriteria);
                            }
                        }
                    }
                    jsonCriteria.put("label", prompt);
                    jsonCriteria = null;
                }
                this.sortCriteriaTable(criteriaSortTable, jsonObject);
                this.sortCriteriaTable(participantSortTable, jsonObject);
                JSONUtils.accumulate(jsonObject, "criterias", jsonComment);
                this.sortCriteriaTable(attachmentSortTable, jsonObject);
                Date deadline = this.stepElement.getDeadline();
                int overdue = this.stepElement.getOverdue();
                String overdueStatus = null;
                overdueStatus = overdue == 0 ? this.messageResources.getMessage(this.locale, "process.overdue.inprocess") : (overdue == 1 ? this.messageResources.getMessage(this.locale, "process.overdue.remindersent") : this.messageResources.getMessage(this.locale, "process.overdue.overdue"));
                if (deadline != null) {
                    JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Deadline", DateUtil.getISODateString(deadline, true), "xs:timestamp"));
                } else if (overdue == 2) {
                    JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Deadline", overdueStatus, "xs:string"));
                } else {
                    String noneSet = this.messageResources.getMessage(this.locale, "process.overdue.noneset");
                    JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Deadline", noneSet, "xs:string"));
                }
                JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Overdue", overdueStatus, "xs:string"));
                Date dateReceived = this.stepElement.getDateReceived();
                if (dateReceived != null) {
                    JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_StepReceived", DateUtil.getISODateString(dateReceived, true), "xs:timestamp"));
                }
                JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Originator", this.stepElement.getOriginator(), "xs:string"));
                JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_StepName", this.stepElement.getStepName(), "xs:string"));
                JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_Instructions", this.stepElement.getStepDescription(), "xs:string"));
                try {
                    VWGuid caseFolderId = (VWGuid)this.stepElement.getProperty("F_CaseFolder");
                    if (caseFolderId != null) {
                        JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_CaseFolderId", caseFolderId.toString(), "xs:string"));
                    }
                }
                catch (VWException vwe) {
                    // empty catch block
                }
                try {
                    VWGuid caseTaskId = (VWGuid)this.stepElement.getProperty("F_CaseTask");
                    if (caseTaskId != null) {
                        JSONUtils.accumulate(jsonObject, "criterias", this.getSystemFieldJSON("F_CaseTaskId", caseTaskId.toString(), "xs:string"));
                    }
                }
                catch (VWException vwe) {
                    // empty catch block
                }
            }
            if (P8StepElementMediator.isSecureServiceEnabled(this.request) && (token = new SecurityTokenManager().generateToken(this.request, false)) != null) {
                jsonObject.put("security_token", token);
            }
        }
        catch (Exception e) {
            Logger.logError(P8StepElementMediator.class, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    private JSONObject getSystemFieldJSON(String name, String value, String dataType) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("readOnly", new Boolean(true));
        jsonObject.put("cardinality", "SINGLE");
        jsonObject.put("system", new Boolean(true));
        jsonObject.put("name", name);
        jsonObject.put("dataType", dataType);
        jsonObject.put("required", new Boolean(false));
        jsonObject.put("hidden", new Boolean(false));
        jsonObject.put("label", name);
        if (value == null) {
            value = "";
        }
        jsonObject.put("values", value);
        return jsonObject;
    }

    private void addParticipantArrayToJSON(JSONObject jsonObject, String label, VWParticipant[] participants) {
        try {
            JSONArray jsonArray = new JSONArray();
            for (int j = 0; j < participants.length; ++j) {
                VWParticipant participant = participants[j];
                if (participant.getGUID() == null) continue;
                JSONObject jsonItem = new JSONObject();
                jsonItem.put("displayName", participant.getDisplayName());
                jsonItem.put("name", participant.getDistinguishedName());
                jsonItem.put("domain", participant.getDomainName());
                jsonItem.put("shortName", participant.getParticipantName());
                jsonItem.put("id", participant.getGUID());
                jsonItem.put("isGroup", new Boolean(participant.isGroup()));
                jsonArray.add(jsonItem);
            }
            jsonObject.put(label, jsonArray);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void addAttachmentArrayToJSON(JSONObject jsonObject, String label, VWAttachment[] attachments) {
        try {
            JSONArray jsonArray = new JSONArray();
            for (int j = 0; j < attachments.length; ++j) {
                VWAttachment attachment = attachments[j];
                if (attachment == null || attachment.getAttachmentName() == null) continue;
                JSONObject jsonItem = new JSONObject();
                jsonItem.put("attachment_name", attachment.getAttachmentName());
                jsonItem.put("attachment_id", attachment.getId());
                String version = attachment.getVersion();
                jsonItem.put("attachment_version", version);
                if (version == null || version.equals("-1")) {
                    jsonItem.put("attachment_vsid", attachment.getId());
                }
                jsonItem.put("attachment_type", (Object)attachment.getType());
                String objectStoreName = attachment.getLibraryName();
                jsonItem.put("attachment_library_name", objectStoreName);
                jsonItem.put("attachment_library_type", (Object)attachment.getLibraryType());
                if (this.desktopConfig == null) {
                    this.desktopConfig = Config.getDesktopConfig(this.request);
                }
                String repositoryId = P8Workflow.getRepositoryId(this.desktopConfig, this.defaultRepositoryId, objectStoreName);
                jsonItem.put("attachment_repository_id", repositoryId);
                jsonArray.add(jsonItem);
            }
            jsonObject.put(label, jsonArray);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void sortCriteriaTable(Hashtable sortTable, JSONObject jsonObject) {
        Vector v = new Vector(sortTable.keySet());
        Collections.sort(v, String.CASE_INSENSITIVE_ORDER);
        for (String key : v) {
            JSONObject jsonCriteria = (JSONObject)sortTable.get(key);
            JSONUtils.accumulate(jsonObject, "criterias", jsonCriteria);
        }
    }
}

