/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8.workflow;

import com.ibm.ecm.json.TableView;
import com.ibm.ecm.mediator.ResultSetMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWWorkBasket;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.util.MessageResources;

public class P8StepAttachmentsMediator
extends ResultSetMediator {
    private VWStepElement stepElement = null;
    private VWWorkBasket.Column[] columns = null;
    private String repositoryId = null;
    private String parentWobNum = null;

    public P8StepAttachmentsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setStepElement(VWStepElement stepElement) {
        this.stepElement = stepElement;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setParentWobNum(String parentWobNum) {
        this.parentWobNum = parentWobNum;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        jsonObject.put("repositoryId", this.repositoryId);
        jsonObject.put("template_name", (Object)null);
        jsonObject.put("template_label", (Object)null);
        jsonObject.put("templates", (Object)null);
        try {
            VWParameter[] parameters = this.stepElement.getParameters(32, 3);
            jsonObject.put("num_results", (Object)parameters.length);
        }
        catch (Exception e) {
            Logger.logError(P8StepAttachmentsMediator.class, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        if (this.parentWobNum != null) {
            jsonObject.put("docid", this.parentWobNum);
        }
        jsonObject.put("pageSize", "200");
        jsonObject.put("sortDirection", "0");
        jsonObject.put("sortIndex", "-1");
        jsonObject.put("showLocation", "false");
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    protected JSONArray buildMagazineViewColumns() {
        JSONArray columns = new JSONArray();
        JSONObject thumbnail = new JSONObject();
        thumbnail.put("field", "thumbnail");
        thumbnail.put("name", "");
        thumbnail.put("width", "60px");
        thumbnail.put("decorator", "MagazineViewDecorator.thumbnailDecorator");
        columns.add(thumbnail);
        JSONObject content = new JSONObject();
        content.put("field", "content");
        content.put("name", "");
        content.put("decorator", "MagazineViewDecorator.contentCellDecoratorP8");
        columns.add(content);
        return columns;
    }

    protected JSONObject buildTableColumns() throws Exception {
        String methodName = "buildTableColums";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONObject jsonCells = null;
        TableView tableView = new TableView();
        TableView.ColumnSet columnSet = tableView.createColumnSet();
        if (this.columns != null) {
            columnSet.addColumnProperty(new String[][]{{"name", "&nbsp"}, {"width", "17px"}, {"field", "icon"}});
            columnSet.addColumnProperty(new String[][]{{"name", "&nbsp;"}, {"width", "17px"}, {"field", "mimeTypeIcon"}});
            String symbolicName = this.columns[0].getName();
            String criteriaName = this.columns[0].getPrompt();
            Boolean nosort = !this.columns[0].isSortable();
            columnSet.addColumnProperty(this.buildColumnProperty(criteriaName, "20em", symbolicName, nosort));
            for (int i = 1; i < this.columns.length; ++i) {
                VWWorkBasket.Column column = this.columns[i];
                symbolicName = column.getName();
                criteriaName = column.getPrompt();
                criteriaName = StringEscapeUtils.escapeHtml((String)criteriaName).trim();
                nosort = !column.isSortable();
                double size = 16.0;
                size = Math.max((double)criteriaName.length(), size) * 0.6;
                String width = P8StepAttachmentsMediator.formatSize(size) + "em";
                columnSet.addColumnProperty(this.buildColumnProperty(criteriaName, width, symbolicName, nosort));
            }
            jsonCells = tableView.toJson();
        } else {
            String cells = null;
            cells = "{\"cells\":[[{\"width\":\"17px\",\"field\":\"icon\",\"name\":\"&nbsp\"},";
            cells = cells + "{\"width\":\"17px\",\"field\":\"mimeTypeIcon\",\"name\":\"&nbsp;\"},";
            cells = cells + "{\"width\":\"25em\",\"field\":\"Name\",\"name\":\"Name\"}]]}";
            jsonCells = new JSONObject();
            jsonCells = JSONObject.parse(cells);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonCells;
    }

    protected JSONArray buildTableRows() throws Exception {
        String methodName = "buildTableRows";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONArray jsonRows = new JSONArray();
        try {
            Hashtable attachmentSortTable = new Hashtable();
            VWParameter[] parameters = this.stepElement.getParameters(32, 3);
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    VWParameter parameter = parameters[i];
                    JSONObject jsonRow = new JSONObject();
                    String prompt = parameter.getDescription();
                    String authoredName = parameter.getAuthoredName();
                    if (prompt == null || prompt.length() == 0) {
                        prompt = authoredName;
                    }
                    jsonRow.put("Name", prompt);
                    jsonRow.put("authoredName", authoredName);
                    String wobNum = "Attachment," + this.stepElement.getWorkObjectNumber() + "," + authoredName;
                    jsonRow.put("wobNum", wobNum);
                    jsonRow.put("id", wobNum);
                    String attachment = this.messageResources.getMessage(this.locale, "process.attachment");
                    jsonRow.put("mimetype", attachment);
                    jsonRow.put("queueName", this.stepElement.getQueueName());
                    jsonRow.put("name", prompt);
                    jsonRow.put("template", "");
                    if (parameter.isArray()) {
                        jsonRow.put("cardinality", "LIST");
                    } else {
                        jsonRow.put("cardinality", "SINGLE");
                    }
                    Integer mode = parameter.getMode();
                    if (mode.equals(1)) {
                        jsonRow.put("readOnly", "true");
                    } else if (mode.equals(3)) {
                        jsonRow.put("readOnly", "false");
                    } else {
                        jsonRow.put("readOnly", "false");
                    }
                    jsonRows.add(jsonRow);
                }
                Collections.sort(jsonRows, new AttachmentComparator());
            }
        }
        catch (Exception e) {
            Logger.logError(P8StepAttachmentsMediator.class, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonRows;
    }

    private JSONArray sortItemsTable(Hashtable sortTable) {
        JSONArray jsonArray = new JSONArray();
        Vector v = new Vector(sortTable.keySet());
        Collections.sort(v, String.CASE_INSENSITIVE_ORDER);
        for (String key : v) {
            JSONObject jsonItem = (JSONObject)sortTable.get(key);
            jsonArray.add(jsonItem);
        }
        return jsonArray;
    }

    private Map buildColumnProperty(String name, String width, String symbolicName, Boolean nosort) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("name", name);
        propertyMap.put("width", width);
        propertyMap.put("field", symbolicName);
        propertyMap.put("nosort", nosort);
        propertyMap.put("sortable", nosort == false);
        return propertyMap;
    }

    private static String formatSize(double val) {
        int ix = (int)(val * 100.0);
        double rounded = (double)ix / 100.0;
        return Double.toString(rounded);
    }

    private class AttachmentComparator
    implements Comparator {
        private AttachmentComparator() {
        }

        public int compare(Object object1, Object object2) {
            JSONObject row1 = (JSONObject)object1;
            JSONObject row2 = (JSONObject)object2;
            String name1 = (String)row1.get("name");
            String name2 = (String)row2.get("name");
            return name1.compareToIgnoreCase(name2);
        }
    }
}

