/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.p8.P8Workflow;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWRole;
import java.util.Arrays;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8ProcessRolesMediator
extends BaseMediator {
    private VWRole[] roles = null;
    private String applicationSpaceName = null;

    public P8ProcessRolesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setRoles(VWRole[] roles) {
        this.roles = roles;
    }

    public void setApplicationSpaceName(String applicationSpaceName) {
        this.applicationSpaceName = applicationSpaceName;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            jsonObject.put("num_processroles", (Object)this.roles.length);
            jsonObject.put("appspace_name", this.applicationSpaceName);
            jsonObject.put("appspace_auth_name", this.applicationSpaceName);
            JSONObject jsonDataStore = new JSONObject();
            JSONArray jsonItems = new JSONArray();
            for (int i = 0; i < this.roles.length; ++i) {
                VWRole role = this.roles[i];
                JSONObject jsonItem = new JSONObject();
                jsonItem.put("processrole_desc", role.getDescription());
                jsonItem.put("processrole_name", role.getName());
                jsonItem.put("processrole_auth_name", role.getAuthoredName());
                VWAttributeInfo attributeInfo = role.getAttributeInfo();
                String[] attributeNames = attributeInfo.getAttributeNames();
                if (attributeNames != null && attributeNames.length > 0) {
                    JSONObject jsonAttributes = new JSONObject();
                    for (int j = 0; j < attributeNames.length; ++j) {
                        int fieldType = attributeInfo.getFieldType(attributeNames[j]);
                        String dataType = P8Workflow.getDataType(fieldType);
                        boolean isArray = attributeInfo.isFieldArray(attributeNames[j]);
                        Object value = attributeInfo.getFieldValue(attributeNames[j]);
                        Object stringValue = P8Workflow.getValue(fieldType, isArray, value);
                        JSONArray jsonAttributeInfo = new JSONArray();
                        if (isArray) {
                            JSONArray jsonValues = new JSONArray();
                            String[] stringValues = (String[])stringValue;
                            jsonValues.addAll(Arrays.asList(stringValues));
                            jsonAttributeInfo.add(jsonValues);
                        } else {
                            jsonAttributeInfo.add((String)stringValue);
                        }
                        jsonAttributeInfo.add(dataType);
                        jsonAttributes.put(attributeNames[j], jsonAttributeInfo);
                    }
                    jsonItem.put("attributes", jsonAttributes);
                }
                jsonItems.add(jsonItem);
            }
            jsonDataStore.put("items", jsonItems);
            jsonDataStore.put("label", "processrole_desc");
            jsonDataStore.put("identifier", "processrole_name");
            jsonObject.put("datastore", jsonDataStore);
        }
        catch (Exception e) {
            Logger.logError(P8ProcessRolesMediator.class, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }
}

