/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWRole;
import filenet.vw.api.VWWorkBasket;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8ProcessInbasketsMediator
extends BaseMediator {
    private VWWorkBasket[] inBaskets = null;
    private VWRole role = null;

    public P8ProcessInbasketsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setInbaskets(VWWorkBasket[] inBaskets) {
        this.inBaskets = inBaskets;
    }

    public void setRole(VWRole role) {
        this.role = role;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            jsonObject.put("num_inbaskets", (Object)this.inBaskets.length);
            jsonObject.put("processrole_name", this.role.getName());
            jsonObject.put("processrole_auth_name", this.role.getAuthoredName());
            JSONObject jsonDataStore = new JSONObject();
            JSONArray jsonItems = new JSONArray();
            for (int i = 0; i < this.inBaskets.length; ++i) {
                VWWorkBasket inBasket = this.inBaskets[i];
                JSONObject jsonItem = new JSONObject();
                jsonItem.put("inbasket_desc", inBasket.getDescription());
                jsonItem.put("inbasket_name", inBasket.getName());
                jsonItem.put("inbasket_auth_name", inBasket.getAuthoredName());
                int type = inBasket.getQueue().getQueueType();
                String queueType = "";
                if (type == 1) {
                    queueType = "processQueue";
                } else if (type == 2) {
                    queueType = "userQueue";
                } else if (type == 3) {
                    queueType = "systemQueue";
                }
                jsonItem.put("queueType", queueType);
                jsonItem.put("queueName", inBasket.getQueueName());
                jsonItems.add(jsonItem);
            }
            jsonDataStore.put("items", jsonItems);
            jsonDataStore.put("label", "inbasket_desc");
            jsonDataStore.put("identifier", "inbasket_name");
            jsonObject.put("datastore", jsonDataStore);
        }
        catch (Exception e) {
            Logger.logError(P8ProcessInbasketsMediator.class, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }
}

