/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8.workflow;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.InterfaceTextConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8ProcessApplicationSpacesMediator
extends BaseMediator {
    String[] names = null;
    String mode = null;
    String repositoryId = null;

    public P8ProcessApplicationSpacesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setApplicationSpaceNames(String[] names) {
        this.names = names;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            jsonObject.put("num_appspaces", (Object)this.names.length);
            JSONObject jsonDataStore = new JSONObject();
            JSONArray jsonItems = new JSONArray();
            if (this.mode == null || !this.mode.equalsIgnoreCase("admin")) {
                DesktopConfig desktopConfig = Config.getDesktopConfig(this.request);
                Collection<InterfaceTextConfig> appSpaceList = desktopConfig.getApplicationSpaceLabelsList("navigator");
                if (appSpaceList.size() > 0) {
                    Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Configuring process application spaces from Admin settings.");
                    block2: for (InterfaceTextConfig configLabel : appSpaceList) {
                        String labelKey = configLabel.getLabelKey();
                        String labelRepositoryId = configLabel.getRepositoryId();
                        for (int i = 0; i < this.names.length; ++i) {
                            if (!labelKey.equals(this.names[i]) || !labelRepositoryId.equals(this.repositoryId)) continue;
                            String locLabel = DesktopConfig.getLocalizedAppSpaceLabel(appSpaceList, labelRepositoryId, this.names[i], this.locale);
                            if (locLabel == null || locLabel.length() == 0) {
                                locLabel = this.names[i];
                            }
                            JSONObject jsonItem = this.createApplicationSpaceObject(locLabel, this.names[i], this.names[i]);
                            jsonItems.add(jsonItem);
                            continue block2;
                        }
                    }
                } else {
                    Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "No application spaces configured for the desktop, displaying all.");
                    for (int i = 0; i < this.names.length; ++i) {
                        JSONObject jsonItem = this.createApplicationSpaceObject(this.names[i], this.names[i], this.names[i]);
                        jsonItems.add(jsonItem);
                    }
                }
            } else {
                for (int i = 0; i < this.names.length; ++i) {
                    JSONObject jsonItem = this.createApplicationSpaceObject(this.names[i], this.names[i], this.names[i]);
                    jsonItems.add(jsonItem);
                }
            }
            jsonDataStore.put("items", jsonItems);
            jsonDataStore.put("label", "appspace_desc");
            jsonDataStore.put("identifier", "appspace_name");
            jsonObject.put("datastore", jsonDataStore);
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    private JSONObject createApplicationSpaceObject(String name, String authoredName, String description) {
        JSONObject jsonItem = new JSONObject();
        jsonItem.put("appspace_name", name);
        jsonItem.put("appspace_auth_name", authoredName);
        jsonItem.put("appspace_desc", description);
        return jsonItem;
    }
}

