/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8.workflow;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.p8.P8Workflow;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWWorkBasket;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8InbasketFiltersMediator
extends BaseMediator {
    private VWWorkBasket.Filter[] filters = null;
    private String applicationSpaceName;
    private String processRoleName;
    private String inbasketName;

    public P8InbasketFiltersMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setFilters(VWWorkBasket.Filter[] filters) {
        this.filters = filters;
    }

    public void setApplicationSpaceName(String applicationSpaceName) {
        this.applicationSpaceName = applicationSpaceName;
    }

    public void setProcessRoleName(String processRoleName) {
        this.processRoleName = processRoleName;
    }

    public void setInbasketName(String inbasketName) {
        this.inbasketName = inbasketName;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            jsonObject.put("appspace_name", this.applicationSpaceName);
            jsonObject.put("processrole_name", this.processRoleName);
            jsonObject.put("inbasket_name", this.inbasketName);
            for (int i = 0; i < this.filters.length; ++i) {
                JSONObject jsonFilter = new JSONObject();
                VWWorkBasket.Filter filter = this.filters[i];
                jsonFilter.put("label", filter.getPrompt());
                jsonFilter.put("name", filter.getName());
                jsonFilter.put("operator", this.getFilterOperator(filter.getOperator()));
                jsonFilter.put("cardinality", "SINGLE");
                jsonFilter.put("readOnly", (Object)false);
                jsonFilter.put("required", (Object)false);
                jsonFilter.put("system", (Object)false);
                jsonFilter.put("hidden", (Object)false);
                int dataType = this.filters[i].getType();
                jsonFilter.put("dataType", P8Workflow.getDataType(dataType));
                String minValue = "";
                String maxValue = "";
                String maxEntry = "";
                if (dataType == 1) {
                    minValue = "-2147483648";
                    maxValue = "2147483647";
                } else if (dataType == 8) {
                    minValue = "-1.7976931348623157E308";
                    maxValue = "1.7976931348623157E308";
                } else if (dataType != 16 && dataType == 2) {
                    maxEntry = "2147483647";
                }
                jsonFilter.put("minValue", minValue);
                jsonFilter.put("maxValue", maxValue);
                jsonFilter.put("maxEntry", maxEntry);
                jsonFilter.put("values", "");
                JSONUtils.accumulate(jsonObject, "criterias", jsonFilter);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    private String getFilterOperator(int filterType) {
        String filterLabel = "equals";
        if (filterType == 1) {
            filterLabel = "does not equal";
        } else if (filterType == 2) {
            filterLabel = "is greater than";
        } else if (filterType == 3) {
            filterLabel = "is greater than or equal to";
        } else if (filterType == 4) {
            filterLabel = "is less than";
        } else if (filterType == 5) {
            filterLabel = "is less than or equal to";
        } else if (filterType == 6) {
            filterLabel = "is like";
        } else if (filterType == 7) {
            filterLabel = "is not like";
        }
        return filterLabel;
    }
}

