/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8;

import com.filenet.api.collection.PropertyDescriptionList;
import com.filenet.api.constants.TypeID;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.json.TableView;
import com.ibm.ecm.mediator.ResultSetMediator;
import com.ibm.ecm.mediator.p8.P8HitMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.ColumnUtil;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8SearchResultsMediator
extends ResultSetMediator {
    private static List<String> DEFAULT_DISPLAY_COLUMNS = Collections.unmodifiableList(Arrays.asList("MajorVersionNumber", "ContentSize", "DateLastModified", "LastModifier"));
    private static List<String> VERSION_DISPLAY_COLUMNS = Collections.unmodifiableList(Arrays.asList("{NAME}", "VersionStatus", "MajorVersionNumber", "MinorVersionNumber", "LastModifier", "DateLastModified"));
    private static List<String> VERSION_DISPLAY_COLUMN_WIDTHS = Collections.unmodifiableList(Arrays.asList("15%", "15%", "15%", "15%", "15%", "15%"));
    private String[] displayColumns = null;
    private Set<String> additionalProperties = null;
    public P8SearchResultsBean searchResultsBean;
    public P8Connection connection;
    public Collection<ClassDescription> classDescriptions;
    public String folderDescription;
    private JSONObject sortJsonObject = new JSONObject();
    public String serverName;
    public String searchMessage;
    public boolean showDocLocation;
    public int pageSize = 200;
    public int sortIndex = -1;
    private Hashtable<String, Integer> columnSizes = new Hashtable();
    private Hashtable<String, String> versionListColumnWidths = new Hashtable();
    private HashMap uniqueDates = new HashMap();
    private HashMap containmentNames = null;
    public int sortDirection = 1;
    public boolean showNotesIcon = true;
    public String parentDocID;
    public boolean listDocumentVersions = false;
    private boolean searchResultsAllVersions = false;
    private boolean annotationsByDefault;
    private HashMap updatedDocIds;
    private boolean maxResultsReached;
    private boolean addColumnSorting = true;
    private String nameColumnWidth = "20em";
    private boolean includeSubclasses;
    private boolean showCheckoutIfReservation = true;
    private String sortByProperty = null;
    private String docNameProperty = null;
    private String folderNameProperty = null;
    private JSONObject aclJSON = null;
    private Map<String, PropertyDescription> propertyDescriptions;

    public P8SearchResultsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public P8SearchResultsBean getSearchResultsBean() {
        return this.searchResultsBean;
    }

    public void setSearchResultsBean(P8SearchResultsBean searchResultsBean) {
        this.searchResultsBean = searchResultsBean;
    }

    public String getParentDocID() {
        return this.parentDocID;
    }

    public void setParentDocID(String parentDocID) {
        this.parentDocID = parentDocID;
    }

    public boolean getListDocumentVersions() {
        return this.listDocumentVersions;
    }

    public void setListDocumentVersions(boolean listDocumentVersions) {
        this.listDocumentVersions = listDocumentVersions;
    }

    public boolean getSearchResultsAllVersions() {
        return this.searchResultsAllVersions;
    }

    public void setSearchResultsAllVersions(boolean searchResultsAllVersions) {
        this.searchResultsAllVersions = searchResultsAllVersions;
    }

    public String getSearchMessage() {
        return this.searchMessage;
    }

    public void setSearchMessage(String searchMessage) {
        this.searchMessage = searchMessage;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setAddColumnSorting(boolean addColumnSorting) {
        this.addColumnSorting = addColumnSorting;
    }

    public void setNameColumnWidth(String width) {
        this.nameColumnWidth = width;
    }

    public boolean hasAnnotationsByDefault() {
        return this.annotationsByDefault;
    }

    public void setAnnotationsByDefault(boolean annotationsByDefault) {
        this.annotationsByDefault = annotationsByDefault;
    }

    public void setShowDocLocation(boolean showDocLocation) {
        this.showDocLocation = showDocLocation;
    }

    public boolean getShowDocLocation() {
        return this.showDocLocation;
    }

    public boolean getShowNotesIcon() {
        return this.showNotesIcon;
    }

    public void setShowNotesIcon(boolean showNotesIcon) {
        this.showNotesIcon = showNotesIcon;
    }

    public void setClassDescriptions(Collection<ClassDescription> classDescriptions) {
        this.classDescriptions = classDescriptions;
    }

    public ClassDescription getClassDescription() {
        if (this.classDescriptions == null || this.classDescriptions.size() == 0) {
            return null;
        }
        return this.classDescriptions.iterator().next();
    }

    public void addClassDescription(ClassDescription classDescription) {
        if (this.classDescriptions == null) {
            this.classDescriptions = new Vector<ClassDescription>();
        }
        this.classDescriptions.add(classDescription);
    }

    public void setIncludeSubClasses(boolean includeSubclasses) {
        this.includeSubclasses = includeSubclasses;
    }

    public boolean getIncludeSubClasses() {
        return this.includeSubclasses;
    }

    public void setShowCheckoutIfReservation(boolean showCheckoutIfReservation) {
        this.showCheckoutIfReservation = showCheckoutIfReservation;
    }

    public boolean getShowCheckoutIfReservation() {
        return this.showCheckoutIfReservation;
    }

    public void setContainmentNames(HashMap containmentNames) {
        this.containmentNames = containmentNames;
    }

    protected void toJSONFromVectorForClassDescriptions(JSONObject jsonObject, String category) throws IOException {
        String methodName = "toJSONFromVectorForClassDescriptions";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (this.classDescriptions != null && jsonObject != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "classDescriptions().size(): " + this.classDescriptions.size());
            for (ClassDescription cd : this.classDescriptions) {
                String cdDisplayName = cd.get_DisplayName();
                JSONObject jsonCD = new JSONObject();
                jsonCD.put("template_name", cd.get_SymbolicName());
                jsonCD.put("template_label", cdDisplayName);
                jsonCD.put("template_desc", cdDisplayName);
                JSONUtils.accumulate(jsonObject, category, jsonCD);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            jsonObject.put("printersConfigured", (Object)false);
            if (this.getClassDescription() != null) {
                jsonObject.put("template_name", this.getClassDescription().get_SymbolicName());
            }
            jsonObject.put("repositoryId", this.getServerName());
            jsonObject.put("template_label", this.getFolderDescription());
            jsonObject.put("sortformats", this.sortJsonObject);
            this.toJSONFromVectorForClassDescriptions(jsonObject, "templates");
            if (this.getParentDocID() != null) {
                jsonObject.put("docid", this.getParentDocID());
            }
            if (this.getSearchResultsBean() != null) {
                jsonObject.put("num_results", (Object)this.getSearchResultsBean().size());
                jsonObject.put("showLocation", (Object)false);
                jsonObject.put("showNotesIcon", (Object)false);
                jsonObject.put("pageSize", (Object)this.pageSize);
                jsonObject.put("sortIndex", (Object)this.getSortIndex());
                jsonObject.put("sortDirection", (Object)this.getSortDirection());
                JSONObject jsonDates = new JSONObject();
                jsonDates.putAll(this.uniqueDates);
                jsonObject.put("dates", jsonDates);
                jsonObject.put("repositoryRecordType", this.connection.getObjectStoreRecordType());
            }
            if (this.aclJSON != null) {
                jsonObject.putAll(this.aclJSON);
            }
            if (this.maxResultsReached) {
                jsonObject.put("maxResultsReached", (Object)true);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            this.addError("error.exception.general", e.getLocalizedMessage());
        }
        return jsonObject;
    }

    private void putColumnSize(String index, int size) {
        Integer tempValue = this.columnSizes.get(index);
        if (tempValue != null) {
            int value = tempValue;
            if (value < size) {
                this.columnSizes.put(index, size);
            }
        } else {
            this.columnSizes.put(index, size);
        }
    }

    public JSONObject toJSONObject(String origDocid, String newDocid) throws IOException {
        String methodName = "toJSONObject";
        JSONObject jsonObject = this.toJSONObject();
        if (this.getClassDescription() != null) {
            jsonObject.put("template_name", this.getClassDescription().get_SymbolicName());
        }
        jsonObject.put("repositoryId", this.getServerName());
        jsonObject.put("template_label", this.getFolderDescription());
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, new StringBuffer("search results size: ").append(this.getSearchResultsBean() != null ? String.valueOf(this.getSearchResultsBean().size()) : "0").toString());
        jsonObject.put("origdocid", origDocid);
        jsonObject.put("docid", newDocid);
        return jsonObject;
    }

    @Override
    public void fromJSONObject(JSONObject jsonObject) {
        throw new RuntimeException("This method is not implemented.");
    }

    public JSONObject getResultRow(int hitIndex) throws Exception {
        String methodName = "getResultRow";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONObject jsonRow = null;
        P8SearchResultsBean searchResults = this.getSearchResultsBean();
        if (searchResults != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Starting to build json row from hit");
            List hits = searchResults.getHits();
            if (hits != null && hitIndex >= 0 && hitIndex < hits.size()) {
                P8HitMediator hitMediator = new P8HitMediator(this.request, this.messageResources, this.locale, this.searchResultsAllVersions, this.additionalProperties, this.docNameProperty, this.folderNameProperty, this.showCheckoutIfReservation, this.containmentNames, this.getPropertyDescriptions(), this.updatedDocIds);
                hitMediator.setConnection(this.connection);
                hitMediator.setHit(hits.get(hitIndex));
                jsonRow = hitMediator.toJSONObject();
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonRow;
    }

    @Override
    protected JSONArray buildTableRows() throws Exception {
        String methodName = "buildTableRows";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONArray jsonRows = new JSONArray();
        if (this.searchResultsBean != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Starting to build json rows from hits");
            this.searchResultsBean.reset();
            P8HitMediator hitMediator = new P8HitMediator(this.request, this.messageResources, this.locale, this.searchResultsAllVersions, this.additionalProperties, this.docNameProperty, this.folderNameProperty, this.showCheckoutIfReservation, this.containmentNames, this.getPropertyDescriptions(), this.updatedDocIds);
            hitMediator.setConnection(this.connection);
            if (this.displayColumns != null) {
                HashSet<String> requiredProperties = new HashSet<String>();
                for (int i = 0; i < this.displayColumns.length; ++i) {
                    requiredProperties.add(this.displayColumns[i]);
                }
                hitMediator.setRequiredProperties(requiredProperties);
            }
            P8SearchResultsBean searchResults = this.getSearchResultsBean();
            List hits = searchResults.getHits();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "hit size: " + hits.size());
            for (Object hit : hits) {
                hitMediator.setHit(hit);
                JSONObject jsonHit = hitMediator.toJSONObject();
                jsonRows.add(jsonHit);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonRows;
    }

    @Override
    protected JSONArray buildMagazineViewColumns() {
        JSONArray columns = new JSONArray();
        JSONObject thumbnail = new JSONObject();
        thumbnail.put("field", "thumbnail");
        thumbnail.put("name", "");
        thumbnail.put("width", "60px");
        thumbnail.put("decorator", "MagazineViewDecorator.thumbnailDecorator");
        columns.add(thumbnail);
        JSONObject content = new JSONObject();
        content.put("field", "content");
        content.put("name", "");
        content.put("decorator", "MagazineViewDecorator.contentCellDecoratorP8");
        columns.add(content);
        return columns;
    }

    @Override
    protected JSONObject buildTableColumns() throws Exception {
        String methodName = "buildTableColums";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        String dateFormat = "%m/%d/%Y";
        String timeFormat = "hh:mm:ss";
        TableView tableView = new TableView();
        TableView.ColumnSet columnSet = tableView.createColumnSet();
        columnSet.addColumnProperty(ColumnUtil.buildStateColumnProperty(this.request, "&nbsp;", "multiStateIcon", true, false, this.connection.isRecordObjectStore()), true);
        columnSet.addColumnProperty(ColumnUtil.buildColumnProperty("&nbsp;", "17px", "mimeTypeIcon", null, true), true);
        if (this.classDescriptions != null) {
            if (this.displayColumns != null && this.displayColumns.length > 0) {
                for (int i = 0; i < this.displayColumns.length; ++i) {
                    if (i == 0) {
                        columnSet.addColumnProperty(ColumnUtil.buildColumnProperty(this.messageResources.getMessage(this.getLocale(), "name"), this.nameColumnWidth, this.displayColumns[i], null, !this.addColumnSorting));
                    } else {
                        PropertyDescription pd = this.propertyDescriptions.get(this.displayColumns[i]);
                        if (pd != null) {
                            this.addToColumnSet(pd, columnSet, this.displayColumns[i]);
                        }
                    }
                    if (this.sortByProperty == null || !this.sortByProperty.equals(this.displayColumns[i])) continue;
                    this.setSortIndex(i + 3);
                }
            } else if (this.listDocumentVersions) {
                for (int index = 0; index < VERSION_DISPLAY_COLUMNS.size(); ++index) {
                    String name = VERSION_DISPLAY_COLUMNS.get(index);
                    if (name.equals("{NAME}")) {
                        columnSet.addColumnProperty(ColumnUtil.buildColumnProperty(this.messageResources.getMessage(this.getLocale(), "name"), VERSION_DISPLAY_COLUMN_WIDTHS.get(index), name, null, !this.addColumnSorting));
                        continue;
                    }
                    this.versionListColumnWidths.put(name, VERSION_DISPLAY_COLUMN_WIDTHS.get(index));
                    PropertyDescription pd = this.propertyDescriptions.get(name);
                    if (pd == null) continue;
                    this.addToColumnSet(pd, columnSet, name);
                }
            } else {
                columnSet.addColumnProperty(ColumnUtil.buildColumnProperty(this.messageResources.getMessage(this.getLocale(), "name"), this.nameColumnWidth, "{NAME}", null, !this.addColumnSorting));
                for (String name : DEFAULT_DISPLAY_COLUMNS) {
                    PropertyDescription pd;
                    if (name.equals("{NAME}") || (pd = this.propertyDescriptions.get(name)) == null) continue;
                    this.addToColumnSet(pd, columnSet, name);
                }
            }
        }
        this.sortJsonObject.put("dataFormat", dateFormat);
        this.sortJsonObject.put("timeFormat", timeFormat);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return tableView.toJson();
    }

    private Map<String, PropertyDescription> getPropertyDescriptions() {
        if (this.propertyDescriptions == null) {
            if (this.classDescriptions == null) {
                return null;
            }
            this.propertyDescriptions = new HashMap<String, PropertyDescription>();
            for (ClassDescription classDescription : this.classDescriptions) {
                if (this.includeSubclasses) {
                    ArrayList<PropertyDescription> pdl = P8Util.getPropertyDescriptions(classDescription, this.includeSubclasses, false, false, false, true);
                    for (PropertyDescription pd : pdl) {
                        this.propertyDescriptions.put(pd.get_SymbolicName(), pd);
                    }
                    continue;
                }
                PropertyDescriptionList pds = classDescription.get_PropertyDescriptions();
                PropertyDescription pd = null;
                for (int i = 0; i < pds.size(); ++i) {
                    pd = (PropertyDescription)pds.get(i);
                    this.propertyDescriptions.put(pd.get_SymbolicName(), pd);
                }
            }
        }
        return this.propertyDescriptions;
    }

    private void addToColumnSet(PropertyDescription pd, TableView.ColumnSet columnSet, String symbolicName) {
        String displayName = pd.get_DisplayName();
        if (pd.get_IsSystemOwned().booleanValue()) {
            String customLabel;
            if (P8Util.isDefaultLabel(pd.get_SymbolicName())) {
                String messageKey = "systemp8." + pd.get_SymbolicName() + ".defaultLabel";
                displayName = MessageUtil.getMessage(this.getLocale(), messageKey);
            }
            if ((customLabel = BaseUtil.getCustomLabelValue(this.request, "sys_" + pd.get_SymbolicName())) != null) {
                displayName = customLabel;
            }
        }
        String criteriaName = displayName.trim();
        boolean isNumeric = P8Util.isNumericDataType(pd);
        String width = null;
        if (this.listDocumentVersions) {
            width = this.versionListColumnWidths.get(symbolicName);
        }
        if (width == null) {
            Integer columnSize = this.columnSizes.get(symbolicName);
            width = ColumnUtil.getColumnWidth(displayName.length(), columnSize != null ? columnSize : -1, pd.get_DataType() == TypeID.DATE, isNumeric);
        }
        boolean orderable = pd.get_IsOrderable();
        if (isNumeric) {
            columnSet.addColumnProperty(ColumnUtil.buildColumnProperty(criteriaName, width, symbolicName, "text-align:right;", !this.addColumnSorting || !orderable));
        } else {
            columnSet.addColumnProperty(ColumnUtil.buildColumnProperty(criteriaName, width, symbolicName, null, !this.addColumnSorting || !orderable));
        }
    }

    private static String formatSize(double val) {
        int ix = (int)(val * 100.0);
        double rounded = (double)ix / 100.0;
        return Double.toString(rounded);
    }

    public String getFolderDescription() {
        return this.folderDescription;
    }

    public void setFolderDescription(String folderDescription) {
        this.folderDescription = folderDescription;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public P8Connection getServer() {
        return this.connection;
    }

    public void setServer(P8Connection server) {
        this.connection = server;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(int sortDirection) {
        this.sortDirection = sortDirection;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public void setUpdatedDocIds(HashMap updatedDocIds) {
        this.updatedDocIds = updatedDocIds;
    }

    public boolean isMaxResultsReached() {
        return this.maxResultsReached;
    }

    public void setMaxResultsReached(boolean maxResultsReached) {
        this.maxResultsReached = maxResultsReached;
    }

    public void setDisplayColumns(String[] displayColumns) {
        this.displayColumns = displayColumns;
    }

    public String[] getDisplayColumns() {
        return this.displayColumns;
    }

    public void setAdditionalProperties(Set<String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public void setSortByProperty(String sortByProperty) {
        this.sortByProperty = sortByProperty;
    }

    public String getSortByProperty() {
        return this.sortByProperty;
    }

    public String getDocNameProperty() {
        return this.docNameProperty;
    }

    public void setDocNameProperty(String docNameProperty) {
        this.docNameProperty = docNameProperty;
    }

    public String getFolderNameProperty() {
        return this.folderNameProperty;
    }

    public void setFolderNameProperty(String folderNameProperty) {
        this.folderNameProperty = folderNameProperty;
    }

    public void setACLJson(JSONObject aclJSON) {
        this.aclJSON = aclJSON;
    }
}

