/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8;

import com.filenet.api.meta.PropertyDescription;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8PropertyDescsMediator
extends BaseMediator {
    private Map<String, List<PropertyDescription>> propDescs = new LinkedHashMap<String, List<PropertyDescription>>();

    public void setPropDescs(String objectType, List<PropertyDescription> propDescs) {
        this.propDescs.put(objectType, propDescs);
    }

    public P8PropertyDescsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        JSONArray jsonObjectTypes = new JSONArray();
        if (this.propDescs != null) {
            Set<Map.Entry<String, List<PropertyDescription>>> keys = this.propDescs.entrySet();
            for (Map.Entry<String, List<PropertyDescription>> entry : keys) {
                JSONArray jsonPropertyDescriptions = new JSONArray();
                List<PropertyDescription> list = entry.getValue();
                String key = entry.getKey();
                String propertyLabel = null;
                String cePropertyLabel = null;
                String customLabel = null;
                Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, key + " property description size: " + list.size());
                for (PropertyDescription propDesc : list) {
                    String customLabelID;
                    cePropertyLabel = propDesc.get_DisplayName();
                    String defaultLabel = null;
                    String messageKey = "systemp8." + propDesc.get_SymbolicName() + ".label";
                    if (P8Util.isDefaultLabel(propDesc.get_SymbolicName())) {
                        defaultLabel = MessageUtil.getMessage(this.getLocale(), messageKey);
                    }
                    propertyLabel = (customLabel = BaseUtil.getCustomLabelValue(this.request, customLabelID = "sys_" + propDesc.get_SymbolicName())) != null && !customLabel.equalsIgnoreCase(messageKey) ? cePropertyLabel + " (" + customLabel + ")" : (defaultLabel != null && !defaultLabel.equalsIgnoreCase(messageKey) ? defaultLabel : cePropertyLabel);
                    if (propDesc.get_IsSystemGenerated().booleanValue()) {
                        propertyLabel = propertyLabel + "*";
                    }
                    JSONObject json = new JSONObject();
                    json.put("label", propertyLabel);
                    json.put("value", propDesc.get_SymbolicName());
                    json.put("type", propDesc.get_DataType().toString());
                    jsonPropertyDescriptions.add(json);
                }
                JSONObject jsonObjectType = new JSONObject();
                jsonObjectType.put("items", jsonPropertyDescriptions);
                jsonObjectType.put("type", key);
                jsonObjectTypes.add(jsonObjectType);
            }
        }
        jsonObject.put("objectTypes", jsonObjectTypes);
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON:" + jsonObject.toString());
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }
}

