/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8;

import com.filenet.api.collection.BinaryList;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.collection.DateTimeList;
import com.filenet.api.collection.Float64List;
import com.filenet.api.collection.IdList;
import com.filenet.api.collection.Integer32List;
import com.filenet.api.collection.PropertyDescriptionList;
import com.filenet.api.collection.StringList;
import com.filenet.api.constants.TypeID;
import com.filenet.api.core.ContentElement;
import com.filenet.api.core.ContentReference;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.CustomObject;
import com.filenet.api.core.Document;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.meta.PropertyDescriptionBinary;
import com.filenet.api.meta.PropertyDescriptionBoolean;
import com.filenet.api.meta.PropertyDescriptionDateTime;
import com.filenet.api.meta.PropertyDescriptionFloat64;
import com.filenet.api.meta.PropertyDescriptionId;
import com.filenet.api.meta.PropertyDescriptionInteger32;
import com.filenet.api.meta.PropertyDescriptionString;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.DocumentInfoMediator;
import com.ibm.ecm.security.AccessControlList;
import com.ibm.ecm.security.AccessControlListData;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.p8.Attachment;
import com.ibm.ecm.util.p8.P8ChoiceListUtil;
import com.ibm.ecm.util.p8.P8SecurityPolicy;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8ItemMediator
extends DocumentInfoMediator {
    public String serverDisplayName = null;
    public String docID = null;
    IndependentlyPersistableObject hit = null;
    private WCDateFormat wcDateFormat = WCDateFormat.getDefaultDateFormats(this.request);
    private AccessControlList acl = null;
    private P8SecurityPolicy sp = null;
    public String formType = null;
    public boolean showFieldHoverHelp = false;
    protected Enumeration criterias = null;
    private RepositoryConfig repositoryConfig = null;
    private List<Property> nonSystemProperties = null;
    private List<Property> systemProperties = null;
    private ObjectStore objectStore;

    public P8ItemMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
        this.formType = "edit";
    }

    protected P8ItemMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public IndependentlyPersistableObject getHit() {
        return this.hit;
    }

    public String getDocID() {
        return this.docID;
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }

    public void setHit(IndependentlyPersistableObject hit) {
        this.hit = hit;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public P8SecurityPolicy getSecurityPolicy() {
        return this.sp;
    }

    public void setSecurityPolicy(P8SecurityPolicy sp) {
        this.sp = sp;
    }

    public String getFormType() {
        if (this.formType == null) {
            this.formType = "search";
        }
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public Enumeration getCriterias() {
        return this.criterias;
    }

    public void setCriterias(Enumeration criterias) {
        this.criterias = criterias;
    }

    public RepositoryConfig getRepositoryConfig() {
        return this.repositoryConfig;
    }

    public void setRepositoryConfig(RepositoryConfig repositoryConfig) {
        this.repositoryConfig = repositoryConfig;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    private boolean isConfiguredSystemProperty(PropertyDescription propertyDescription, String[] configuredSystemProperties) {
        for (int i = 0; i < configuredSystemProperties.length; ++i) {
            if (!propertyDescription.get_IsSystemOwned().booleanValue() || !propertyDescription.get_SymbolicName().equalsIgnoreCase(configuredSystemProperties[i])) continue;
            return true;
        }
        return false;
    }

    private void setSystemPropertiesOrder(ClassDescription classDescription, String[] configuredSystemProperties) {
        ArrayList<Property> systemProperties = new ArrayList<Property>();
        for (int i = 0; i < configuredSystemProperties.length; ++i) {
            for (Property property : this.systemProperties) {
                PropertyDescription propertyDescription = P8Util.getPropertyDescription(classDescription, property);
                if (!propertyDescription.get_SymbolicName().equalsIgnoreCase(configuredSystemProperties[i])) continue;
                systemProperties.add(property);
            }
        }
        this.systemProperties = systemProperties;
    }

    private void createPropertyLists(ClassDescription classDescription, Properties properties, String[] configuredSystemProperties) throws Exception {
        String methodName = "createPropertyLists";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        ArrayList<Property> nonSystemProperties = new ArrayList<Property>();
        ArrayList<Property> systemProperties = new ArrayList<Property>();
        for (Property property : properties) {
            PropertyDescription propertyDescription = P8Util.getPropertyDescription(classDescription, property);
            if (this.isConfiguredSystemProperty(propertyDescription, configuredSystemProperties)) {
                systemProperties.add(property);
                continue;
            }
            nonSystemProperties.add(property);
        }
        this.systemProperties = systemProperties;
        this.setSystemPropertiesOrder(classDescription, configuredSystemProperties);
        this.nonSystemProperties = nonSystemProperties;
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        String mimeType = "";
        String[] configuredSystemProperties = null;
        IndependentlyPersistableObject item = this.getHit();
        if (item != null) {
            jsonObject.put("template_name", item.getClassName());
            jsonObject.put("template_label", item.get_ClassDescription().get_DisplayName());
            jsonObject.put("template_desc", item.get_ClassDescription().get_DescriptiveText());
            jsonObject.put("template_hidden", item.get_ClassDescription().get_IsHidden());
            if (item instanceof Document) {
                configuredSystemProperties = this.repositoryConfig.getDocumentSystemProperties();
                if (configuredSystemProperties != null) {
                    for (int i = 0; i < configuredSystemProperties.length; ++i) {
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, i + 1 + ":" + configuredSystemProperties[i]);
                    }
                }
                Document document = (Document)item;
                jsonObject.put("docid", document.get_Id().toString());
                mimeType = document.get_MimeType();
                jsonObject.put("file_ext", document.get_Name());
                if (this.sp != null) {
                    jsonObject.put("parm_securitypolicy", this.sp.toJSONObject());
                }
            } else if (item instanceof Folder) {
                configuredSystemProperties = this.repositoryConfig.getFolderSystemProperties();
                if (configuredSystemProperties != null) {
                    for (int i = 0; i < configuredSystemProperties.length; ++i) {
                        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, i + 1 + ":" + configuredSystemProperties[i]);
                    }
                }
                Folder folder = (Folder)item;
                jsonObject.put("docid", folder.get_Id().toString());
                mimeType = "folder";
                jsonObject.put("file_ext", folder.get_FolderName());
            } else if (this.hit instanceof Attachment) {
                Attachment a = (Attachment)this.hit;
                if (a.getType().equals("folder")) {
                    mimeType = "folder";
                    configuredSystemProperties = this.repositoryConfig.getFolderSystemProperties();
                } else {
                    mimeType = "application/binary";
                    configuredSystemProperties = this.repositoryConfig.getDocumentSystemProperties();
                }
            } else if (item instanceof CustomObject) {
                ArrayList<String> systemProps = new ArrayList<String>();
                ClassDescription classDescription = item.get_ClassDescription();
                PropertyDescriptionList pdl = classDescription.get_PropertyDescriptions();
                if (pdl != null) {
                    for (PropertyDescription propDesc : pdl) {
                        if (propDesc.get_IsHidden().booleanValue() || !propDesc.get_IsSystemOwned().booleanValue()) continue;
                        systemProps.add(propDesc.get_SymbolicName());
                    }
                }
                configuredSystemProperties = new String[systemProps.size()];
                systemProps.toArray(configuredSystemProperties);
                CustomObject object = (CustomObject)item;
                jsonObject.put("docid", object.get_Id().toString());
                mimeType = "application/binary";
                jsonObject.put("file_ext", object.get_Name());
            }
        }
        jsonObject.put("showFieldHoverHelp", new Boolean(this.getShowFieldHoverHelp()));
        if (item != null) {
            ClassDescription classDescription = item.get_ClassDescription();
            PropertyDescription namePropDesc = null;
            if (classDescription.get_NamePropertyIndex() != null) {
                int namePropertyIndex = classDescription.get_NamePropertyIndex();
                namePropDesc = (PropertyDescription)classDescription.get_PropertyDescriptions().get(namePropertyIndex);
            }
            Properties properties = item.getProperties();
            try {
                this.createPropertyLists(classDescription, properties, configuredSystemProperties);
                this.createJSONForProperties(jsonObject, this.nonSystemProperties, namePropDesc, "criterias");
                this.createJSONForProperties(jsonObject, this.systemProperties, namePropDesc, "systemProperties");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        jsonObject.put("mimetype", mimeType);
        JSONArray jsonAccessControlArray = new JSONArray();
        jsonObject.put("acl", jsonAccessControlArray);
        if (this.acl != null) {
            for (AccessControlListData aclDataEntry : this.acl.getAclData()) {
                jsonAccessControlArray.add(aclDataEntry.toJSON());
            }
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    private void createJSONForProperties(JSONObject jsonObject, List<Property> properties, PropertyDescription namePropDesc, String jsonKey) {
        String methodName = "createJSONForProperties";
        boolean editMode = true;
        Object criteriaFormat = null;
        String maxEntry = "";
        String minValue = "";
        String maxValue = "";
        String[] validValues = new String[]{};
        IndependentlyPersistableObject item = this.getHit();
        ClassDescription classDescription = item.get_ClassDescription();
        ArrayList<PropertyDescription> pds = new ArrayList<PropertyDescription>(properties.size());
        for (Property property : properties) {
            pds.add(P8Util.getPropertyDescription(classDescription, property));
        }
        P8ChoiceListUtil.loadChoiceLists(this.request, pds, this.objectStore);
        for (Property property : properties) {
            BinaryList bList;
            PropertyDescription propertyDescription = P8Util.getPropertyDescription(classDescription, property);
            JSONObject jsonCriteria = new JSONObject();
            if (propertyDescription.get_DataType() == TypeID.BINARY) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "name: " + propertyDescription.get_Name() + "  is Binary");
                continue;
            }
            if (item instanceof Document && (propertyDescription.get_SymbolicName().equals("SourceDocument") || propertyDescription.get_SymbolicName().equals("DestinationDocuments") || propertyDescription.get_SymbolicName().equals("CompoundDocumentState") || propertyDescription.get_SymbolicName().equals("RecordInformation"))) continue;
            maxEntry = "";
            minValue = "";
            maxValue = "";
            validValues = new String[]{};
            if (propertyDescription instanceof PropertyDescriptionDateTime) {
                DateTimeList dtList;
                PropertyDescriptionDateTime pdDateTime = (PropertyDescriptionDateTime)propertyDescription;
                Date date = pdDateTime.get_PropertyMinimumDateTime();
                if (date != null) {
                    minValue = this.wcDateFormat.getDateFormat().format(date);
                }
                if ((date = pdDateTime.get_PropertyMaximumDateTime()) != null) {
                    maxValue = this.wcDateFormat.getDateFormat().format(date);
                }
                if ((date = pdDateTime.get_PropertyDefaultDateTime()) != null) {
                    // empty if block
                }
                if ((dtList = pdDateTime.get_PropertySelectionsDateTime()).size() > 0) {
                    validValues = new String[dtList.size()];
                    for (int i = 0; i < dtList.size(); ++i) {
                        validValues[i] = dtList.get(i).toString();
                    }
                }
            } else if (propertyDescription instanceof PropertyDescriptionFloat64) {
                Float64List fList;
                PropertyDescriptionFloat64 pdFloat64 = (PropertyDescriptionFloat64)propertyDescription;
                minValue = pdFloat64.get_PropertyMinimumFloat64() != null ? pdFloat64.get_PropertyMinimumFloat64().toString() : "4.9E-324";
                maxValue = pdFloat64.get_PropertyMaximumFloat64() != null ? pdFloat64.get_PropertyMaximumFloat64().toString() : "1.7976931348623157E308";
                if (pdFloat64.get_PropertyDefaultFloat64() != null) {
                    // empty if block
                }
                if ((fList = pdFloat64.get_PropertySelectionsFloat64()).size() > 0) {
                    validValues = new String[fList.size()];
                    for (int i = 0; i < fList.size(); ++i) {
                        validValues[i] = fList.get(i).toString();
                    }
                }
            } else if (propertyDescription instanceof PropertyDescriptionInteger32) {
                Integer32List iList;
                PropertyDescriptionInteger32 pdInteger32 = (PropertyDescriptionInteger32)propertyDescription;
                minValue = pdInteger32.get_PropertyMinimumInteger32() != null ? pdInteger32.get_PropertyMinimumInteger32().toString() : "-2147483648";
                maxValue = pdInteger32.get_PropertyMaximumInteger32() != null ? pdInteger32.get_PropertyMaximumInteger32().toString() : "2147483647";
                if (pdInteger32.get_PropertyDefaultInteger32() != null) {
                    // empty if block
                }
                if ((iList = pdInteger32.get_PropertySelectionsInteger32()).size() > 0) {
                    validValues = new String[iList.size()];
                    for (int i = 0; i < iList.size(); ++i) {
                        validValues[i] = iList.get(i).toString();
                    }
                }
            } else if (propertyDescription instanceof PropertyDescriptionString) {
                StringList sList;
                PropertyDescriptionString pdString = (PropertyDescriptionString)propertyDescription;
                if (pdString.get_MaximumLengthString() != null) {
                    maxEntry = pdString.get_MaximumLengthString().toString();
                }
                if (pdString.get_PropertyDefaultString() != null) {
                    // empty if block
                }
                if ((sList = pdString.get_PropertySelectionsString()).size() > 0) {
                    validValues = new String[sList.size()];
                    for (int i = 0; i < sList.size(); ++i) {
                        validValues[i] = sList.get(i).toString();
                    }
                }
            } else if (propertyDescription instanceof PropertyDescriptionBinary) {
                PropertyDescriptionBinary pdBinary = (PropertyDescriptionBinary)propertyDescription;
                if (pdBinary.get_MaximumLengthBinary() != null) {
                    maxEntry = pdBinary.get_MaximumLengthBinary().toString();
                }
                if (pdBinary.get_PropertyDefaultBinary() != null) {
                    // empty if block
                }
                if ((bList = pdBinary.get_PropertySelectionBinary()).size() > 0) {
                    validValues = new String[bList.size()];
                    for (int i = 0; i < bList.size(); ++i) {
                        validValues[i] = bList.get(i).toString();
                    }
                }
            } else if (propertyDescription instanceof PropertyDescriptionId) {
                IdList idList;
                PropertyDescriptionId pdId = (PropertyDescriptionId)propertyDescription;
                if (pdId.get_PropertyDefaultId() != null) {
                    // empty if block
                }
                if ((idList = pdId.get_PropertySelectionsId()).size() > 0) {
                    validValues = new String[idList.size()];
                    for (int i = 0; i < idList.size(); ++i) {
                        validValues[i] = idList.get(i).toString();
                    }
                }
            } else if (propertyDescription instanceof PropertyDescriptionBoolean) {
                PropertyDescriptionBoolean pdBoolean = (PropertyDescriptionBoolean)propertyDescription;
                if (pdBoolean.get_PropertyDefaultBoolean() != null) {
                    // empty if block
                }
                if ((bList = pdBoolean.get_PropertySelectionsBoolean()).size() > 0) {
                    validValues = new String[bList.size()];
                    for (int i = 0; i < bList.size(); ++i) {
                        validValues[i] = bList.get(i).toString();
                    }
                }
            }
            P8ChoiceListUtil.addChoiceList(this.request, propertyDescription, this.objectStore, jsonCriteria);
            jsonCriteria.put("cardinality", propertyDescription.get_Cardinality().toString());
            jsonCriteria.put("name", propertyDescription.get_SymbolicName());
            jsonCriteria.put("dataType", P8Util.getDataType(propertyDescription));
            boolean readOnly = propertyDescription.get_IsReadOnly();
            if (this.getFormType().equals("edit") && !readOnly && (propertyDescription.get_Settability().getValue() == 1 || propertyDescription.get_Settability().getValue() == 2)) {
                readOnly = true;
            }
            jsonCriteria.put("readOnly", (Object)readOnly);
            jsonCriteria.put("required", propertyDescription.get_IsValueRequired());
            String propertyLabel = propertyDescription.get_DisplayName();
            if (jsonKey.equalsIgnoreCase("systemProperties")) {
                String customLabelID = "sys_" + propertyDescription.get_SymbolicName();
                String customLabel = BaseUtil.getCustomLabelValue(this.request, customLabelID);
                if (customLabel != null) {
                    propertyLabel = customLabel;
                } else if (P8Util.isDefaultLabel(propertyDescription.get_SymbolicName())) {
                    String messageKey = "systemp8." + propertyDescription.get_SymbolicName() + ".defaultLabel";
                    propertyLabel = MessageUtil.getMessage(this.getLocale(), messageKey);
                }
            }
            jsonCriteria.put("label", propertyLabel);
            jsonCriteria.put("minValue", minValue);
            jsonCriteria.put("maxValue", maxValue);
            jsonCriteria.put("maxEntry", maxEntry);
            P8ItemMediator.addStringArrayToJSON(jsonCriteria, "validValues", validValues);
            Object values = P8Util.getValue(property);
            if (values instanceof String[]) {
                P8ItemMediator.addStringArrayToJSON(jsonCriteria, "values", (String[])values);
            } else {
                if (propertyDescription.get_SymbolicName().equals("ContentSize")) {
                    String contentSizeString;
                    if (item instanceof Document) {
                        Document document = (Document)item;
                        String filename = null;
                        ContentElementList cel = document.get_ContentElements();
                        if (cel != null && !cel.isEmpty()) {
                            ContentElement ce = (ContentElement)cel.get(0);
                            if (ce instanceof ContentTransfer) {
                                ContentTransfer ct = (ContentTransfer)ce;
                                this.mimeType = ct.get_ContentType();
                                String retrievalName = ct.get_RetrievalName();
                                if (retrievalName != null && retrievalName.length() > 0) {
                                    filename = Util.getFileNameFromPath(this.request, retrievalName);
                                }
                                values = ct.get_ContentSize().toString();
                            } else if (ce instanceof ContentReference) {
                                ContentReference cr = (ContentReference)ce;
                                this.mimeType = cr.get_ContentType();
                                filename = cr.get_ContentLocation();
                            }
                        }
                        if (filename != null && filename.length() > 0) {
                            jsonObject.put("filename", filename);
                        }
                    }
                    if ((contentSizeString = values.toString()).length() > 0) {
                        double contentSize = Double.valueOf(contentSizeString);
                        if (contentSize < 0.0) {
                            values = "";
                        } else if (this.mimeType.length() == 0) {
                            this.mimeType = "application/binary";
                        }
                    }
                }
                jsonCriteria.put("values", values);
            }
            JSONUtils.accumulate(jsonObject, jsonKey, jsonCriteria);
            if (namePropDesc != null && propertyDescription.get_SymbolicName().equals(namePropDesc.get_SymbolicName())) {
                try {
                    JSONObject jsonCriteriaName = JSONObject.parse(jsonCriteria.toString());
                    jsonCriteriaName.put("name", "Name");
                    String nameDisplayName = this.messageResources.getMessage(this.getLocale(), "name");
                    jsonCriteriaName.put("label", nameDisplayName);
                    JSONUtils.accumulate(jsonObject, jsonKey, jsonCriteriaName);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            jsonCriteria = null;
        }
    }

    @Override
    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        this.setDocID(jsonObject.get("docid").toString());
        JSONArray criteriasJsonArray = (JSONArray)jsonObject.get("criterias");
        JSONObject criteria = null;
        SearchCriterion criteriaHolder = null;
        Vector<SearchCriterion> criterias = new Vector<SearchCriterion>(criteriasJsonArray.size());
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
            criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
            criteriaHolder = new SearchCriterion();
            String criteriaName = criteria.get("name").toString();
            criteriaHolder.setName(criteriaName);
            String currentOperator = criteria.get("operator").toString();
            criteriaHolder.setOperator(currentOperator);
            JSONArray valuesJsonArray = (JSONArray)criteria.get("values");
            String[] tempValuesArray = new String[valuesJsonArray.size()];
            for (int iValuesCounter = 0; iValuesCounter < valuesJsonArray.size(); ++iValuesCounter) {
                tempValuesArray[iValuesCounter] = (String)valuesJsonArray.get(iValuesCounter);
            }
            criteriaHolder.setValues(tempValuesArray);
            criterias.add(criteriaHolder);
        }
        this.setCriterias(criterias.elements());
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }
}

