/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8;

import com.filenet.api.admin.ChoiceList;
import com.filenet.api.constants.ReservationType;
import com.filenet.api.core.Document;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.VersionSeries;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyInteger32;
import com.filenet.api.property.PropertyInteger32List;
import com.filenet.api.query.RepositoryRow;
import com.filenet.api.replication.ReplicationGroup;
import com.filenet.api.util.Id;
import com.ibm.ecm.mediator.HitMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.p8.Attachment;
import com.ibm.ecm.util.p8.P8ChoiceListUtil;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8HitMediator
extends HitMediator {
    private static Set<String> ADDITIONAL_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("IcnAutoRun", "IcnShowInTree")));
    private P8Connection connection;
    private Object hit;
    private Set<String> requiredProperties;
    private boolean showingAllVersions;
    private Set<String> additionalProperties;
    private String docNameProperty;
    private String folderNameProperty;
    private boolean showCheckoutIfReservation;
    private HashMap containmentNames;
    private Map<String, PropertyDescription> propertyDescriptions;
    private HashMap updatedDocIds;
    private ClassDescription cd;
    private boolean isDocument;
    private boolean isFolder;
    private Properties properties;
    private String itemId;
    private String objectStoreId;
    private ObjectStore objectStore;
    private String nameProp;
    private String mimeType;
    private boolean isCheckedOut;
    private boolean isCurrentVersion;
    private boolean showCheckoutForReservation;
    private String checkedOutBy;
    private Document reservation;
    private Integer versionStatus;
    private ReservationType reservationType;
    private boolean isDeclaredAsRecord;
    private boolean privAddItem;
    private boolean privCheckInDoc;
    private boolean privCheckInOutDoc;
    private boolean privEditDoc;
    private boolean privCheckOutDoc;
    private boolean privCanCancelCheckout;
    private boolean privMoveToFolder;
    private boolean privAddToFolder;
    private boolean privNone;
    private boolean privAddDoc;
    private boolean privViewDoc;
    private boolean privViewAnno;
    private boolean privEditAnno;
    private boolean privEditProp;
    private boolean privChangeClass;
    private boolean privRemoveFromFolder;
    private boolean privAddLink;
    private boolean privModifyPermissions;
    private boolean privMajorVersion;
    private boolean privMinorVersion;
    private boolean privDelete;
    private boolean privViewNotes;
    private boolean privAddNotes;
    private boolean privPrintNotes;
    private String hitName;
    private boolean rootFolder;
    private String contentSize;

    public P8HitMediator(HttpServletRequest request, MessageResources resources, Locale locale, boolean isShowingAllVersions, Set<String> additionalProperties, String docNameProperty, String folderNameProperty, boolean showCheckoutIfReservation, HashMap containmentNames, Map<String, PropertyDescription> propertyDescriptions, HashMap updatedDocIds) {
        super(request, resources, locale);
        this.showingAllVersions = isShowingAllVersions;
        this.additionalProperties = additionalProperties;
        this.docNameProperty = docNameProperty;
        this.folderNameProperty = folderNameProperty;
        this.showCheckoutIfReservation = showCheckoutIfReservation;
        this.containmentNames = containmentNames;
        this.propertyDescriptions = propertyDescriptions;
        this.updatedDocIds = updatedDocIds;
    }

    public void setConnection(P8Connection connection) {
        this.connection = connection;
    }

    public void setRequiredProperties(Set<String> requiredProperties) {
        this.requiredProperties = requiredProperties;
    }

    public void setHit(Object hit) {
        double size;
        int objectStoreAccessAllowed;
        this.hit = hit;
        this.cd = null;
        this.isDocument = false;
        this.isFolder = false;
        this.properties = null;
        this.itemId = null;
        this.objectStoreId = null;
        this.objectStore = null;
        this.nameProp = null;
        this.mimeType = "";
        this.isCheckedOut = false;
        this.isCurrentVersion = true;
        this.showCheckoutForReservation = false;
        this.checkedOutBy = null;
        this.reservation = null;
        this.versionStatus = null;
        this.reservationType = null;
        this.isDeclaredAsRecord = false;
        this.privAddItem = false;
        this.privCheckInDoc = false;
        this.privCheckInOutDoc = false;
        this.privEditDoc = false;
        this.privCheckOutDoc = false;
        this.privCanCancelCheckout = false;
        this.privMoveToFolder = false;
        this.privAddToFolder = false;
        this.privNone = false;
        this.privAddDoc = false;
        this.privViewDoc = false;
        this.privViewAnno = false;
        this.privEditAnno = false;
        this.privEditProp = false;
        this.privChangeClass = false;
        this.privRemoveFromFolder = false;
        this.privAddLink = false;
        this.privModifyPermissions = false;
        this.privMajorVersion = false;
        this.privMinorVersion = false;
        this.privDelete = false;
        this.privViewNotes = false;
        this.privAddNotes = false;
        this.privPrintNotes = false;
        if (hit instanceof IndependentObject) {
            this.cd = ((IndependentObject)hit).get_ClassDescription();
        } else if (hit instanceof RepositoryRow) {
            Properties props = ((RepositoryRow)hit).getProperties();
            this.cd = (ClassDescription)props.getEngineObjectValue("ClassDescription");
        }
        this.isDocument = hit instanceof Document;
        this.isFolder = hit instanceof Folder;
        if (this.cd != null) {
            if (!this.isFolder) {
                boolean bl = this.isDocument = this.isDocument || P8Util.isDocumentClass(this.cd);
            }
            if (!this.isDocument) {
                boolean bl = this.isFolder = this.isFolder || P8Util.isFolderClass(this.cd);
            }
        }
        if (hit instanceof IndependentObject) {
            this.properties = ((IndependentObject)hit).getProperties();
        } else if (hit instanceof RepositoryRow) {
            this.properties = ((RepositoryRow)hit).getProperties();
        }
        if (hit instanceof Attachment) {
            Attachment a = (Attachment)hit;
            this.itemId = a.getObjectReferenceId();
            this.objectStoreId = a.getObjectStoreName();
        } else if (hit instanceof IndependentObject) {
            ObjectReference objRef = ((IndependentObject)hit).getObjectReference();
            this.itemId = P8Util.getDocId(objRef);
            this.objectStoreId = objRef.getObjectStoreIdentity();
        } else if (hit instanceof RepositoryRow) {
            ObjectReference cdRef = this.cd.getObjectReference();
            String id = ((RepositoryRow)hit).getProperties().getIdValue("Id").toString();
            this.itemId = P8Util.getDocId(this.cd.get_SymbolicName(), cdRef.getObjectStoreIdentity(), id);
            this.objectStoreId = cdRef.getObjectStoreIdentity();
        }
        this.objectStore = P8Util.getObjectStore(this.connection, this.objectStoreId);
        if (this.isDocument) {
            this.nameProp = this.docNameProperty;
        } else if (this.isFolder) {
            this.nameProp = this.folderNameProperty;
        }
        if (this.nameProp == null && this.cd != null && this.cd.get_NamePropertyIndex() != null) {
            int namePropertyIndex = this.cd.get_NamePropertyIndex();
            PropertyDescription namePropDesc = (PropertyDescription)this.cd.get_PropertyDescriptions().get(namePropertyIndex);
            if (namePropDesc != null) {
                this.nameProp = namePropDesc.get_SymbolicName();
            }
        }
        this.isCheckedOut = false;
        this.isCurrentVersion = true;
        this.showCheckoutForReservation = false;
        this.reservation = null;
        this.versionStatus = null;
        this.reservationType = null;
        if (this.isDocument) {
            Boolean currentVersion = (Boolean)this.getPropertyValue(hit, "IsCurrentVersion");
            if (!currentVersion.booleanValue()) {
                this.isCurrentVersion = false;
            }
            Boolean reserved = (Boolean)this.getPropertyValue(hit, "IsReserved");
            this.versionStatus = (Integer)this.getPropertyValue(hit, "VersionStatus");
            if (reserved.booleanValue() || this.versionStatus == 3) {
                this.isCheckedOut = true;
            }
            if (this.isCheckedOut || this.showCheckoutIfReservation) {
                this.reservation = (Document)this.getPropertyValue(hit, "Reservation");
                if (this.reservation != null) {
                    this.reservationType = this.reservation.get_ReservationType();
                    this.checkedOutBy = this.reservation.get_Creator();
                    if (this.showCheckoutIfReservation) {
                        this.showCheckoutForReservation = true;
                    }
                }
            }
        }
        this.privAddItem = ((objectStoreAccessAllowed = ((Integer)this.getPropertyValue(this.objectStore, "AccessMask")).intValue()) & 0x200000) > 0;
        String classSymbolicName = null;
        if (this.cd != null) {
            classSymbolicName = this.cd.get_SymbolicName();
        }
        if (this.isFolder) {
            this.mimeType = "folder";
        } else if (hit instanceof Attachment) {
            Attachment a = (Attachment)hit;
            this.mimeType = a.getType().equals("folder") ? "folder" : "application/binary";
        } else if (this.contentSize != null && this.contentSize.length() > 0 && !((size = Double.valueOf(this.contentSize).doubleValue()) < 0.0) && this.mimeType.length() == 0) {
            this.mimeType = "application/binary";
        }
        int accessAllowed = 0;
        this.isDeclaredAsRecord = false;
        if (this.isDocument) {
            Property recordInformationProperty;
            accessAllowed = (Integer)this.getPropertyValue(hit, "AccessMask");
            Boolean isVersioningEnabled = (Boolean)this.getPropertyValue(hit, "IsVersioningEnabled");
            if (isVersioningEnabled.booleanValue() && ((accessAllowed & 4) > 0 || (accessAllowed & 0x40) > 0)) {
                if (this.isCheckedOut || this.showCheckoutForReservation) {
                    if (this.reservation != null && (this.reservationType != ReservationType.EXCLUSIVE || this.checkedOutBy != null && this.checkedOutBy.equals(this.connection.getUserId()))) {
                        this.privCheckInDoc = true;
                        this.privCheckInOutDoc = true;
                        this.privEditDoc = true;
                    }
                } else {
                    this.privCheckOutDoc = true;
                }
            }
            if ((this.isCheckedOut || this.showCheckoutForReservation) && this.reservation != null) {
                int reservationAccessAllowed = (Integer)this.getPropertyValue(this.reservation, "AccessMask");
                if (this.reservationType == ReservationType.EXCLUSIVE) {
                    if (this.checkedOutBy != null && this.checkedOutBy.equals(this.connection.getUserId())) {
                        this.privCanCancelCheckout = true;
                    } else if ((reservationAccessAllowed & 0x80000) > 0 && (reservationAccessAllowed & 0x10000) > 0 && (objectStoreAccessAllowed & 0x800000) > 0) {
                        this.privCanCancelCheckout = true;
                    }
                } else if (((reservationAccessAllowed & 4) > 0 || (reservationAccessAllowed & 0x40) > 0 || (reservationAccessAllowed & 0x10000) > 0) && (objectStoreAccessAllowed & 0x800000) > 0) {
                    this.privCanCancelCheckout = true;
                }
            }
            this.privAddToFolder = true;
            this.privMoveToFolder = true;
            this.privRemoveFromFolder = true;
            if (this.properties != null && this.properties.isPropertyPresent("RecordInformation") && (recordInformationProperty = this.properties.get("RecordInformation")).getObjectValue() != null) {
                this.isDeclaredAsRecord = true;
            }
        } else if (this.isFolder) {
            accessAllowed = (Integer)this.getPropertyValue(hit, "AccessMask");
            if ((accessAllowed & 2) > 0) {
                boolean locked;
                this.privMoveToFolder = true;
                if ((objectStoreAccessAllowed & 0x400000) > 0) {
                    this.privEditDoc = true;
                }
                boolean bl = locked = hit instanceof Folder && ((Folder)hit).isLocked() != false;
                if (locked && this.checkedOutBy != null && this.checkedOutBy.equals(this.connection.getUserId())) {
                    this.privCheckInDoc = true;
                    this.privCheckInOutDoc = true;
                } else if (!locked) {
                    this.privCheckOutDoc = true;
                }
            }
            this.privAddToFolder = (accessAllowed & 0x10) > 0;
            this.privRemoveFromFolder = (accessAllowed & 0x20) > 0;
        } else if (hit instanceof Attachment) {
            Attachment a = (Attachment)hit;
            accessAllowed = a.getAccessAllowed();
            this.privNone = true;
            this.privAddDoc = false;
            this.privAddItem = false;
        }
        this.privViewDoc = (accessAllowed & 0x80) > 0;
        this.privViewAnno = (accessAllowed & 0x8000000) > 0;
        this.privEditAnno = (accessAllowed & 0x2000000) > 0;
        this.privEditProp = (accessAllowed & 2) > 0;
        this.privChangeClass = classSymbolicName != null && classSymbolicName.equalsIgnoreCase("StoredSearch") ? false : this.privEditProp;
        this.privAddLink = (accessAllowed & 0x200) > 0;
        this.privModifyPermissions = (accessAllowed & 0x40000) > 0;
        this.privMajorVersion = (accessAllowed & 4) > 0;
        boolean bl = this.privMinorVersion = (accessAllowed & 0x40) > 0;
        if (this.versionStatus != null && this.versionStatus == 3) {
            this.privDelete = this.privCanCancelCheckout;
        } else if ((accessAllowed & 0x10000) > 0 && (objectStoreAccessAllowed & 0x800000) > 0) {
            this.privDelete = true;
        }
        if (this.isDocument && this.showingAllVersions && !this.isCurrentVersion) {
            this.privAddToFolder = false;
            this.privMoveToFolder = false;
            this.privRemoveFromFolder = false;
        }
    }

    @Override
    public JSONObject toJSONObject() {
        String entryTemplateOS;
        double size;
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONObject jsonHit = super.toJSONObject();
        jsonHit.put("objectStoreId", this.objectStoreId);
        jsonHit.put("objectStoreName", this.objectStore.get_SymbolicName());
        jsonHit.put("objectStoreDisplayName", this.objectStore.get_DisplayName());
        this.putColumnSize("icon", 12);
        this.putColumnSize("mimeTypeIcon", 12);
        jsonHit.put("rootfolder", (Object)this.rootFolder);
        if (this.updatedDocIds != null && this.updatedDocIds.containsKey(this.itemId)) {
            String origdocid = (String)this.updatedDocIds.get(this.itemId);
            jsonHit.put("origdocid", origdocid);
        }
        String classSymbolicName = null;
        if (this.cd != null) {
            classSymbolicName = this.cd.get_SymbolicName();
            jsonHit.put("template", classSymbolicName);
            jsonHit.put("template_label", this.cd.get_DisplayName());
        }
        if (!this.isFolder && !(this.hit instanceof Attachment) && this.contentSize != null && this.contentSize.length() > 0 && (size = Double.valueOf(this.contentSize).doubleValue()) < 0.0) {
            jsonHit.put("ContentSize", "");
        }
        jsonHit.put("mimetype", this.mimeType.trim());
        if (this.isDocument) {
            ReplicationGroup replicationGroup;
            VersionSeries vs = (VersionSeries)this.getPropertyValue(this.hit, "VersionSeries");
            if (vs != null) {
                String vsId = vs.get_Id().toString();
                jsonHit.put("vsId", vsId);
            }
            if ((replicationGroup = (ReplicationGroup)this.getPropertyValue(this.hit, "ReplicationGroup")) != null) {
                String name = replicationGroup.get_DisplayName();
                jsonHit.put("replicationGroup", name);
            }
            if (this.properties != null && this.properties.isPropertyPresent("RecordInformation")) {
                jsonHit.put("privIERRecordDeclare", (Object)(!this.isDeclaredAsRecord ? 1 : 0));
            }
        } else if (this.isFolder) {
            String folderId = this.getPropertyValue(this.hit, "Id").toString();
            if (this.containmentNames != null && !this.containmentNames.isEmpty() && this.containmentNames.containsKey(folderId)) {
                jsonHit.put("containmentName", (String)this.containmentNames.get(folderId));
            }
        } else if (this.hit instanceof Attachment) {
            jsonHit.put("privNone", (Object)true);
        }
        if (this.properties != null && this.properties.isPropertyPresent("EntryTemplateObjectStoreName") && this.properties.isPropertyPresent("EntryTemplateId") && (entryTemplateOS = this.properties.getStringValue("EntryTemplateObjectStoreName")) != null && !entryTemplateOS.isEmpty()) {
            Id entryTemplateId;
            if (!Id.isId((String)entryTemplateOS)) {
                try {
                    entryTemplateOS = P8Util.getObjectStoreIdentityFromName(this.connection, entryTemplateOS);
                }
                catch (Exception e) {
                    entryTemplateOS = null;
                }
            }
            if (entryTemplateOS != null && !entryTemplateOS.isEmpty() && (entryTemplateId = this.properties.getIdValue("EntryTemplateId")) != null) {
                jsonHit.put("entryTemplateId", P8Util.getDocId("EntryTemplate", entryTemplateOS, entryTemplateId.toString()));
            }
        }
        if (this.isCheckedOut) {
            jsonHit.put("locked", (Object)this.isCheckedOut);
        }
        if (this.isCurrentVersion) {
            jsonHit.put("currentVersion", (Object)this.isCurrentVersion);
        }
        if (this.showCheckoutForReservation) {
            jsonHit.put("showCheckoutForReservation", (Object)this.showCheckoutForReservation);
        }
        if (this.checkedOutBy != null) {
            jsonHit.put("lockedUser", this.checkedOutBy);
        }
        if (this.isDeclaredAsRecord) {
            jsonHit.put("declaredAsRecord", (Object)this.isDeclaredAsRecord);
        }
        if (this.privModifyPermissions) {
            jsonHit.put("modifyPermissions", (Object)this.privModifyPermissions);
        }
        String versionStatusInt = this.versionStatus == null ? "" : this.versionStatus.toString();
        jsonHit.put("versionStatusInt", versionStatusInt);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonHit;
    }

    @Override
    public String getItemId() throws Exception {
        return this.itemId;
    }

    @Override
    public String getItemName() throws Exception {
        return this.hitName;
    }

    @Override
    public JSONObject buildAttributes() throws Exception {
        String methodName = "buildAttributes";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        this.hitName = null;
        this.rootFolder = false;
        this.contentSize = null;
        JSONObject jsonAttributes = new JSONObject();
        Properties properties = null;
        if (this.hit instanceof IndependentObject) {
            properties = ((IndependentObject)this.hit).getProperties();
        } else if (this.hit instanceof RepositoryRow) {
            properties = ((RepositoryRow)this.hit).getProperties();
        }
        if (properties != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "properties count: " + properties.size());
            try {
                Property[] propertiesArray = properties.toArray();
                if (this.cd != null) {
                    ArrayList<PropertyDescription> pds = new ArrayList<PropertyDescription>(properties.size());
                    for (Property property : propertiesArray) {
                        PropertyDescription pd = P8Util.getPropertyDescription(this.cd, property);
                        if (pd == null) continue;
                        pds.add(pd);
                    }
                    P8ChoiceListUtil.loadChoiceLists(this.request, pds, this.objectStore);
                }
                for (Property property : propertiesArray) {
                    String dispValue;
                    Object value;
                    PropertyDescription pd;
                    boolean isAdditionalProperty;
                    String symbolicName = property.getPropertyName();
                    boolean bl = isAdditionalProperty = ADDITIONAL_PROPERTIES.contains(symbolicName) || this.additionalProperties != null && this.additionalProperties.contains(symbolicName);
                    if ((this.requiredProperties == null || this.requiredProperties.contains(symbolicName) || symbolicName.equals(this.nameProp) || isAdditionalProperty) && (pd = this.getPropertyDescription(this.cd, symbolicName)) != null && (!pd.get_IsHidden().booleanValue() || isAdditionalProperty)) {
                        JSONArray jsonAttributeInfo = new JSONArray();
                        Object value2 = P8Util.getValue(property);
                        Object displayValue = null;
                        if (value2 instanceof String[]) {
                            JSONArray jsonArray = new JSONArray();
                            String[] array = (String[])value2;
                            jsonArray.addAll(Arrays.asList(array));
                            jsonAttributeInfo.add(jsonArray);
                            String[] displayValues = (String[])this.getChoiceListDisplayValue(value2, property, this.objectStore, this.cd);
                            if (displayValues != null) {
                                JSONArray jsonDisplayArray = new JSONArray();
                                jsonDisplayArray.addAll(Arrays.asList(displayValues));
                                displayValue = jsonDisplayArray;
                            }
                        } else {
                            jsonAttributeInfo.add(value2);
                            if (symbolicName.equals("VersionStatus")) {
                                int versionStatus = (Integer)this.getPropertyValue(this.hit, "VersionStatus");
                                List<String> versionStatusLookup = P8Util.getVersionStatusLookups(this.request, this.objectStore);
                                displayValue = versionStatusLookup.get(versionStatus - 1);
                            } else {
                                displayValue = (String)this.getChoiceListDisplayValue(value2, property, this.objectStore, this.cd);
                            }
                        }
                        jsonAttributeInfo.add(P8Util.getDataType(pd));
                        boolean formattingInfoAdded = false;
                        if (symbolicName.equals("PathName")) {
                            jsonAttributeInfo.add("path");
                            formattingInfoAdded = true;
                        } else if (symbolicName.equals("ContentSize")) {
                            jsonAttributeInfo.add("fileSize");
                            formattingInfoAdded = true;
                        }
                        if (displayValue != null) {
                            if (!formattingInfoAdded) {
                                jsonAttributeInfo.add((Object)null);
                            }
                            jsonAttributeInfo.add(displayValue);
                        }
                        String dispValue2 = value2.toString();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "row.put(" + symbolicName + ',' + value2 + ")");
                        if (this.nameProp != null && symbolicName.equals(this.nameProp)) {
                            this.hitName = dispValue2;
                            if (this.requiredProperties == null || this.requiredProperties.contains("{NAME}")) {
                                String nameDisplayName = this.messageResources.getMessage(this.getLocale(), "name");
                                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "found name prop, row.put of " + nameDisplayName + ',' + dispValue2);
                                jsonAttributes.put("{NAME}", jsonAttributeInfo);
                            }
                            if (this.requiredProperties == null || this.requiredProperties.contains(symbolicName)) {
                                jsonAttributes.put(symbolicName, jsonAttributeInfo);
                            }
                        } else {
                            jsonAttributes.put(symbolicName, jsonAttributeInfo);
                        }
                        this.putColumnSize(symbolicName, dispValue2.length());
                    }
                    if (symbolicName.equals("MimeType")) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "found MIME_TYPE for property: " + symbolicName);
                        value = P8Util.getValue(property);
                        dispValue = value.toString();
                        if (dispValue == null) continue;
                        this.mimeType = dispValue;
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "mimeType=" + this.mimeType);
                        continue;
                    }
                    if (!symbolicName.equals("ContentSize")) continue;
                    value = P8Util.getValue(property);
                    this.contentSize = dispValue = value.toString();
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
            if (this.hitName != null && this.hitName.equals("") && properties.isPropertyPresent("Parent") && properties.getStringValue("Parent") == null) {
                this.hitName = this.messageResources.getMessage(this.getLocale(), "folder.root.name");
                this.rootFolder = true;
            }
        } else if (this.hit instanceof Attachment) {
            String dispValue = ((Attachment)this.hit).getDisplayName();
            String nameDisplayName = this.messageResources.getMessage(this.getLocale(), "name");
            JSONArray jsonAttributeInfo = new JSONArray();
            jsonAttributeInfo.add(dispValue);
            jsonAttributes.put(nameDisplayName, jsonAttributeInfo);
            jsonAttributeInfo = new JSONArray();
            jsonAttributeInfo.add(dispValue);
            jsonAttributes.put("Name", jsonAttributeInfo);
            jsonAttributeInfo = new JSONArray();
            jsonAttributeInfo.add(dispValue);
            jsonAttributes.put("{NAME}", jsonAttributeInfo);
            this.putColumnSize(nameDisplayName, dispValue.length());
            this.hitName = dispValue;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonAttributes;
    }

    @Override
    public boolean canEditProperties() throws Exception {
        return this.privEditProp;
    }

    @Override
    public boolean canEditDoc() throws Exception {
        return this.privEditDoc;
    }

    @Override
    public boolean canViewNotes() throws Exception {
        return this.privViewNotes;
    }

    @Override
    public boolean canAddDoc() throws Exception {
        return this.privAddDoc;
    }

    @Override
    public boolean canAddItem() throws Exception {
        return this.privAddItem;
    }

    @Override
    public boolean canEmailDoc() throws Exception {
        return this.privViewDoc;
    }

    @Override
    public boolean canExport() throws Exception {
        return this.privViewDoc;
    }

    @Override
    public boolean canAddToFolder() throws Exception {
        return this.privAddToFolder;
    }

    @Override
    public boolean canRemoveFromFolder() throws Exception {
        return this.privRemoveFromFolder;
    }

    @Override
    public boolean canAddLink() throws Exception {
        return this.privAddLink;
    }

    @Override
    public boolean canRemoveLink() throws Exception {
        return false;
    }

    @Override
    public boolean canAddNotes() throws Exception {
        return false;
    }

    @Override
    public boolean canPrintNotes() throws Exception {
        return false;
    }

    @Override
    public boolean canPrintDoc() throws Exception {
        return this.privViewDoc;
    }

    @Override
    public boolean canCheckInOutDoc() throws Exception {
        return this.privCheckInOutDoc;
    }

    @Override
    public boolean canCheckInDoc() throws Exception {
        return this.privCheckInDoc;
    }

    @Override
    public boolean canCheckOutDoc() throws Exception {
        return this.privCheckOutDoc;
    }

    @Override
    public boolean canCancelCheckOutDoc() throws Exception {
        return this.privCanCancelCheckout;
    }

    @Override
    public boolean canViewAnnotations() throws Exception {
        return this.privViewAnno;
    }

    @Override
    public boolean canEditAnnotations() throws Exception {
        return this.privEditAnno;
    }

    @Override
    public boolean canViewDoc() throws Exception {
        return this.privViewDoc;
    }

    @Override
    public boolean canDelete() throws Exception {
        return this.privDelete;
    }

    @Override
    public boolean canStartWorkflow() throws Exception {
        return false;
    }

    @Override
    public boolean canHold() throws Exception {
        return false;
    }

    @Override
    public boolean canMoveToFolder() throws Exception {
        return this.privMoveToFolder;
    }

    @Override
    public boolean canChangeClass() throws Exception {
        return this.privChangeClass;
    }

    @Override
    public boolean canMajorVersion() throws Exception {
        return this.privMajorVersion;
    }

    @Override
    public boolean canMinorVersion() throws Exception {
        return this.privMinorVersion;
    }

    @Override
    public boolean canDeclare() throws Exception {
        return this.privEditProp && !this.isDeclaredAsRecord;
    }

    private Object getPropertyValue(Object hit, String propName) {
        Object value;
        block13: {
            value = null;
            if (hit instanceof IndependentlyPersistableObject) {
                IndependentlyPersistableObject object = (IndependentlyPersistableObject)hit;
                if (propName == "AccessMask") {
                    value = object.getAccessAllowed();
                } else if (propName.equals("Id")) {
                    value = object.getObjectReference().getObjectIdentity();
                } else {
                    Properties props = object.getProperties();
                    try {
                        if (props.isPropertyPresent(propName)) {
                            value = props.getObjectValue(propName);
                            break block13;
                        }
                        object.fetchProperties(new String[]{propName});
                        value = object.getProperties().getObjectValue(propName);
                    }
                    catch (EngineRuntimeException e) {
                        Logger.logError((Object)this, "getPropertyValue", (ServletRequest)this.request, (Throwable)e);
                    }
                }
            } else if (hit instanceof RepositoryRow) {
                Properties props = ((RepositoryRow)hit).getProperties();
                if (propName == "AccessMask") {
                    value = 999415;
                } else if (props.isPropertyPresent(propName)) {
                    value = props.getObjectValue(propName);
                }
            }
        }
        return value;
    }

    private String wrapperText(String text) {
        return text.replaceAll("&", "&amp;");
    }

    private PropertyDescription getPropertyDescription(ClassDescription classDescription, String symbolicName) {
        PropertyDescription propertyDescription = null;
        if (this.propertyDescriptions != null) {
            propertyDescription = this.propertyDescriptions.get(symbolicName);
        } else if (classDescription != null) {
            propertyDescription = P8Util.getPropertyDescription(classDescription, symbolicName);
        }
        return propertyDescription;
    }

    private Object getChoiceListDisplayValue(Object value, Property property, ObjectStore objectStore, ClassDescription classDescription) {
        String[] choiceListDisplayValue;
        boolean intValue;
        if (value == null || value.toString().isEmpty() || classDescription == null) {
            return null;
        }
        ChoiceList choiceList = P8ChoiceListUtil.getChoiceList(this.request, property.getPropertyName(), objectStore, classDescription);
        if (choiceList == null) {
            return null;
        }
        boolean bl = intValue = property instanceof PropertyInteger32List || property instanceof PropertyInteger32;
        if (value instanceof String[]) {
            String[] values = (String[])value;
            String[] displayValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                String v = values[i];
                displayValues[i] = P8ChoiceListUtil.lookupDisplayNameInChoiceList((EngineObject)choiceList, intValue ? Integer.valueOf(v) : v);
            }
            choiceListDisplayValue = displayValues;
        } else {
            choiceListDisplayValue = P8ChoiceListUtil.lookupDisplayNameInChoiceList((EngineObject)choiceList, intValue ? Integer.valueOf(value.toString()) : value);
        }
        return choiceListDisplayValue;
    }

    public void putColumnSize(String index, int size) {
    }
}

