/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8;

import com.filenet.api.collection.RealmSet;
import com.filenet.api.security.Realm;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8GetDirectoriesMediator
extends BaseMediator {
    RealmSet directories;

    public RealmSet getDirectories() {
        return this.directories;
    }

    public void setDirectories(RealmSet directories) {
        this.directories = directories;
    }

    public P8GetDirectoriesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        int count = 0;
        JSONObject jsonObject = super.toJSONObject();
        JSONArray jsonRealms = new JSONArray();
        for (Realm realm : this.directories) {
            JSONObject jsonRealm = new JSONObject();
            String id = realm.get_Name();
            jsonRealm.put("id", id);
            jsonRealm.put("name", this.getDirectoryName(id));
            jsonRealms.add(jsonRealm);
            ++count;
        }
        jsonObject.put("directories", jsonRealms);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Returning JSON:" + jsonObject.toString());
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonObject;
    }

    private String getDirectoryName(String realmId) {
        String domainName = null;
        if (realmId.length() != 0) {
            StringTokenizer st = new StringTokenizer(realmId, "=,", true);
            StringBuilder domainBuffer = new StringBuilder(st.countTokens());
            boolean start = false;
            while (st.hasMoreTokens()) {
                String value = st.nextToken();
                if (start) {
                    if (value.equalsIgnoreCase(",")) {
                        domainBuffer.append(".");
                        start = false;
                    } else {
                        domainBuffer.append(value);
                    }
                }
                if (start || !value.equalsIgnoreCase("=")) continue;
                start = true;
            }
            domainName = domainBuffer.toString();
        }
        return domainName;
    }
}

