/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8;

import com.ibm.ecm.json.JSONItem;
import com.ibm.ecm.json.JSONStore;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8EntryTemplatesMediator
extends BaseMediator {
    private String repositoryId = null;
    ArrayList<EntryTemplate> entryTemplates = new ArrayList();
    private int maxTemplates;

    public P8EntryTemplatesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void addEntryTemplate(String templateId, String templateName, String templateDescription, String objectStoreName) {
        EntryTemplate entryTemplate = new EntryTemplate();
        entryTemplate.id = templateId;
        entryTemplate.name = templateName;
        entryTemplate.description = templateDescription;
        entryTemplate.objectStoreName = objectStoreName;
        this.entryTemplates.add(entryTemplate);
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        jsonObject.put("repositoryId", this.getRepositoryId());
        jsonObject.put("num_templates", new Integer(this.entryTemplates.size()));
        JSONStore DataStore = new JSONStore("template_name", "template_label", this.locale);
        for (EntryTemplate entryTemplate : this.entryTemplates) {
            String description = entryTemplate.description;
            if (description == null) {
                description = "";
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("template_desc", description);
            properties.put("objectStore", entryTemplate.objectStoreName);
            JSONItem DataItem = DataStore.createDataItem(entryTemplate.id, entryTemplate.name, properties);
            DataStore.addItem(DataItem);
        }
        jsonObject.put("datastore", DataStore.toJson());
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    private class EntryTemplate {
        String id;
        String name;
        String description;
        String objectStoreName;

        private EntryTemplate() {
        }
    }
}

