/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8;

import com.filenet.api.constants.Cardinality;
import com.filenet.api.constants.TypeID;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.security.SecurityPolicy;
import com.filenet.api.security.User;
import com.filenet.api.util.Id;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8GetItemPermissionMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8EntryTemplate;
import com.ibm.ecm.util.p8.P8Permission;
import com.ibm.ecm.util.p8.P8SecurityPolicy;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8EntryTemplateMediator
extends BaseMediator {
    private P8EntryTemplate entryTemplate = null;
    private P8Connection connection = null;
    private JSONObject entryTemplateFolder = null;
    public boolean showFieldHoverHelp = false;

    public P8EntryTemplateMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected P8EntryTemplateMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public P8EntryTemplate getEntryTemplate() {
        return this.entryTemplate;
    }

    public void setEntryTemplate(P8EntryTemplate entryTemplate) {
        this.entryTemplate = entryTemplate;
    }

    public P8Connection getConnection() {
        return this.connection;
    }

    public void setConnection(P8Connection connection) {
        this.connection = connection;
    }

    public void setEntryTemplateFolder(JSONObject entryTemplateFolder) {
        this.entryTemplateFolder = entryTemplateFolder;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        String objectStoreId = this.entryTemplate.getObjectStore().getId();
        ObjectStore objectStore = P8Util.getObjectStore(this.connection, objectStoreId);
        JSONObject jsonObject = super.toJSONObject();
        OrderedJSONObject jsonEntryTemplate = new OrderedJSONObject();
        jsonEntryTemplate.putAll(jsonObject);
        jsonEntryTemplate.put("showFieldHoverHelp", new Boolean(this.getShowFieldHoverHelp()));
        if (this.entryTemplate == null) {
            Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
            return jsonEntryTemplate;
        }
        jsonEntryTemplate.put("id", P8Util.getDocId(this.entryTemplate.getTemplateReference()));
        jsonEntryTemplate.put("displayName", this.entryTemplate.getDisplayName());
        jsonEntryTemplate.put("description", this.entryTemplate.getDescription());
        jsonEntryTemplate.put("entrytemplate_type", this.entryTemplate.getTypeName());
        OrderedJSONObject jsonObjectStore = new OrderedJSONObject();
        jsonObjectStore.put("id", objectStoreId);
        jsonObjectStore.put("symbolicName", objectStore.get_SymbolicName());
        jsonObjectStore.put("displayName", objectStore.get_DisplayName());
        jsonEntryTemplate.put("objectStore", jsonObjectStore);
        jsonEntryTemplate.put("useForCheckin", (Object)this.entryTemplate.isUseForCheckin());
        OrderedJSONObject jsonFile = new OrderedJSONObject();
        jsonFile.put("allowUserSelect", (Object)this.entryTemplate.isSelectFile());
        jsonFile.put("allowDuplicateFileNames", (Object)this.entryTemplate.isAllowDuplicateFileNames());
        jsonEntryTemplate.put("file", jsonFile);
        OrderedJSONObject jsonFolder = new OrderedJSONObject();
        jsonFolder.put("selected", this.entryTemplateFolder);
        jsonFolder.put("allowUserSelect", (Object)this.entryTemplate.isSelectFolder());
        jsonFolder.put("restrictToSelectedFolderOrDescendant", (Object)this.entryTemplate.isConstrainFolder());
        jsonEntryTemplate.put("folder", jsonFolder);
        OrderedJSONObject jsonClass = new OrderedJSONObject();
        ClassDescription classDescription = P8Util.getCachedCD(objectStore, this.entryTemplate.getAddClassId());
        jsonClass.put("template_id", classDescription.get_Id().toString());
        jsonClass.put("template_name", classDescription.getProperties().getStringValue("SymbolicName"));
        jsonClass.put("template_label", classDescription.getProperties().getStringValue("DisplayName"));
        jsonClass.put("template_desc", classDescription.getProperties().getStringValue("DescriptiveText"));
        jsonClass.put("allowUserSetPropertyValues", (Object)this.entryTemplate.isSetProperties());
        JSONArray jsonProperties = new JSONArray();
        Collection<P8EntryTemplate.PropertyOptions> propsOptions = this.entryTemplate.getPropertiesOptions().values();
        for (P8EntryTemplate.PropertyOptions propOptions : propsOptions) {
            OrderedJSONObject jsonPropertyOpts = new OrderedJSONObject();
            ((JSONObject)jsonPropertyOpts).put("name", propOptions.getName());
            ((JSONObject)jsonPropertyOpts).put("required", (Object)propOptions.isRequired());
            ((JSONObject)jsonPropertyOpts).put("readOnly", (Object)propOptions.isReadOnly());
            ((JSONObject)jsonPropertyOpts).put("hidden", (Object)propOptions.isHidden());
            ((JSONObject)jsonPropertyOpts).put("cardinality", propOptions.getCardinalityName());
            ((JSONObject)jsonPropertyOpts).put("dataType", propOptions.getDataTypeName());
            TypeID dataType = propOptions.getDataType();
            if (dataType == TypeID.OBJECT) {
                String defObjId;
                OrderedJSONObject jsonRequiredClass = new OrderedJSONObject();
                String requiredClassName = propOptions.getRequiredClassName();
                if (!requiredClassName.isEmpty()) {
                    classDescription = P8Util.getCachedCD(objectStore, requiredClassName);
                    jsonRequiredClass.put("template_id", classDescription.get_Id().toString());
                    jsonRequiredClass.put("template_name", classDescription.getProperties().getStringValue("SymbolicName"));
                    jsonRequiredClass.put("template_label", classDescription.getProperties().getStringValue("DisplayName"));
                    jsonRequiredClass.put("template_desc", classDescription.getProperties().getStringValue("DescriptiveText"));
                }
                ((JSONObject)jsonPropertyOpts).put("required_template", jsonRequiredClass);
                P8EntryTemplate.Reference defObjValue = propOptions.getDefaultObjectValue();
                if (defObjValue != null && !(defObjId = defObjValue.getId()).isEmpty()) {
                    OrderedJSONObject jsonDefObjValue = new OrderedJSONObject();
                    PropertyFilter defObjPropFilter = new PropertyFilter();
                    defObjPropFilter.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Name", null));
                    Document defObj = Factory.Document.fetchInstance((ObjectStore)objectStore, (Id)new Id(defObjId), (PropertyFilter)defObjPropFilter);
                    jsonDefObjValue.put("id", P8Util.getDocId(defObj.getObjectReference()));
                    jsonDefObjValue.put("name", defObj.get_Name());
                    P8EntryTemplate.Reference defObjObjectStore = propOptions.getDefaultObjectValueObjectStore();
                    if (defObjObjectStore != null) {
                        jsonDefObjValue.put("objectStore", defObjObjectStore.getId());
                    }
                    ((JSONObject)jsonPropertyOpts).put("defaultObjectValue", jsonDefObjValue);
                }
            } else {
                Object defValue = propOptions.getDefaultValue();
                JSONArray jsonValues = new JSONArray();
                if (defValue != null) {
                    if (propOptions.getCardinality() == Cardinality.LIST) {
                        List values = (List)defValue;
                        for (Object value : values) {
                            if (value == null) continue;
                            if (dataType == TypeID.DATE) {
                                jsonValues.add(DateUtil.getISODateString((Date)value, true));
                                continue;
                            }
                            jsonValues.add(value.toString());
                        }
                    } else if (dataType == TypeID.DATE) {
                        jsonValues.add(DateUtil.getISODateString((Date)defValue, true));
                    } else {
                        jsonValues.add(defValue.toString());
                    }
                }
                ((JSONObject)jsonPropertyOpts).put("defaultValue", jsonValues);
            }
            jsonProperties.add(jsonPropertyOpts);
        }
        jsonClass.put("propertiesOptions", jsonProperties);
        jsonEntryTemplate.put("template", jsonClass);
        P8EntryTemplate.Option addAsMinor = this.entryTemplate.getAddAsMinorVersion();
        OrderedJSONObject jsonAddAsMinor = new OrderedJSONObject();
        jsonAddAsMinor.put("on", (Object)addAsMinor.isOn());
        jsonAddAsMinor.put("readOnly", (Object)addAsMinor.isReadOnly());
        jsonAddAsMinor.put("hidden", (Object)addAsMinor.isHidden());
        jsonEntryTemplate.put("asMinorVersion", jsonAddAsMinor);
        P8EntryTemplate.Option autoClassify = this.entryTemplate.getAutoClassify();
        OrderedJSONObject jsonAutoClassify = new OrderedJSONObject();
        jsonAutoClassify.put("on", (Object)autoClassify.isOn());
        jsonAutoClassify.put("readOnly", (Object)autoClassify.isReadOnly());
        jsonAutoClassify.put("hidden", (Object)autoClassify.isHidden());
        jsonEntryTemplate.put("autoClassify", jsonAutoClassify);
        OrderedJSONObject jsonSecurity = new OrderedJSONObject();
        jsonSecurity.put("allowUserSelect", (Object)this.entryTemplate.isSetSecurity());
        String secPolicyId = this.entryTemplate.getSecurityPolicy().getId();
        if (secPolicyId != null && !secPolicyId.isEmpty()) {
            P8SecurityPolicy sp = null;
            try {
                SecurityPolicy secPolicy = Factory.SecurityPolicy.fetchInstance((ObjectStore)objectStore, (Id)new Id(secPolicyId), null);
                sp = new P8SecurityPolicy(this.connection, secPolicy);
            }
            catch (Exception e) {
                P8EntryTemplate.Reference secPolicyReference = this.entryTemplate.getSecurityPolicy();
                sp = new P8SecurityPolicy(secPolicyReference.getId(), secPolicyReference.getName(), secPolicyReference.getName());
            }
            jsonSecurity.put("policy", sp.toJSONObject());
        }
        User currentUser = Factory.User.fetchCurrent((Connection)this.connection.getCEConnection(), null);
        jsonSecurity.put("user_acctinfo", P8GetItemPermissionMediator.userAcctInfoToJSONObject(currentUser));
        jsonSecurity.put("acl", P8Permission.permissionsToJSONObject(this.entryTemplate.getPermissions()));
        jsonEntryTemplate.put("security", jsonSecurity);
        P8EntryTemplate.Workflow workflow = this.entryTemplate.getWorkflow();
        if (workflow != null) {
            OrderedJSONObject jsonWorkflow = new OrderedJSONObject();
            jsonWorkflow.put("id", workflow.getId());
            jsonWorkflow.put("vsId", workflow.getVersionSeriesId());
            jsonWorkflow.put("name", workflow.getName());
            jsonWorkflow.put("objectStoreName", workflow.getObjectStoreName());
            jsonWorkflow.put("styleName", workflow.getStyleName());
            jsonWorkflow.put("promptToLaunchWorkflow", (Object)this.entryTemplate.isPromptToLaunchWorkflow());
            jsonWorkflow.put("runWorkflow", (Object)this.entryTemplate.isRunWorkflow());
            jsonWorkflow.put("selectParticipant", (Object)this.entryTemplate.isSelectParticipant());
            jsonEntryTemplate.put("workflow", jsonWorkflow);
        }
        OrderedJSONObject jsonRecord = new OrderedJSONObject();
        jsonRecord.put("declare", this.entryTemplate.getDeclareRecord().toString());
        jsonEntryTemplate.put("record", jsonRecord);
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonEntryTemplate;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }
}

