/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8;

import com.filenet.api.constants.TypeID;
import com.filenet.api.core.Document;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.DocumentInfoMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8DocumentMediator
extends DocumentInfoMediator {
    public String serverDisplayName = null;
    public Document document = null;
    public String docID = null;
    Document hit = null;
    public String formType = null;
    public boolean showFieldHoverHelp = false;
    protected Enumeration criterias = null;

    public P8DocumentMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
        this.formType = "edit";
    }

    protected P8DocumentMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public Document getHit() {
        return this.hit;
    }

    public String getDocID() {
        return this.docID;
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }

    public void setHit(Document hit) {
        this.hit = hit;
    }

    public String getFormType() {
        if (this.formType == null) {
            this.formType = "search";
        }
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public Enumeration getCriterias() {
        return this.criterias;
    }

    public void setCriterias(Enumeration criterias) {
        this.criterias = criterias;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        if (this.getHit() != null) {
            jsonObject.put("template_name", this.getHit().getClassName());
            jsonObject.put("template_label", this.getHit().getClassName());
            jsonObject.put("template_desc", this.getHit().get_ClassDescription().get_DescriptiveText());
            jsonObject.put("docid", this.getHit().get_Id().toString());
            jsonObject.put("mimetype", this.getHit().get_MimeType());
            jsonObject.put("file_ext", this.getHit().get_Name());
        }
        jsonObject.put("showFieldHoverHelp", new Boolean(this.getShowFieldHoverHelp()));
        Object dataType = null;
        boolean editMode = true;
        Object criteriaFormat = null;
        Document document = this.getHit();
        ClassDescription classDescription = document.get_ClassDescription();
        Properties properties = document.getProperties();
        for (Property property : properties) {
            PropertyDescription propertyDescription = P8Util.getPropertyDescription(classDescription, property);
            JSONObject jsonCriteria = new JSONObject();
            if (editMode) {
                if (propertyDescription.get_Settability().getValue() == 3) {
                    Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "name: " + propertyDescription.get_Name() + "  propertyDescription.get_Settability(): " + propertyDescription.get_Settability());
                    continue;
                }
                if (propertyDescription.get_IsSystemOwned().booleanValue() || propertyDescription.get_IsSystemGenerated().booleanValue()) {
                    Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "name: " + propertyDescription.get_Name() + "  propertyDescription.get_IsSystemOwned(): " + propertyDescription.get_IsSystemOwned());
                    continue;
                }
                if (propertyDescription.get_IsHidden().booleanValue() || propertyDescription.get_DataType() == TypeID.GUID) {
                    Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "name: " + propertyDescription.get_Name() + " is hidden or a GUID");
                }
            }
            jsonCriteria.put("name", propertyDescription.get_Name());
            jsonCriteria.put("dataType", P8Util.getDataType(propertyDescription));
            jsonCriteria.put("dataType", "xs:string");
            jsonCriteria.put("required", propertyDescription.get_IsValueRequired());
            jsonCriteria.put("label", propertyDescription.get_DisplayName());
            P8DocumentMediator.addStringArrayToJSON(jsonCriteria, "validValues", new String[0]);
            jsonCriteria.put("values", P8Util.getValue(property));
            JSONUtils.accumulate(jsonObject, "criterias", jsonCriteria);
            jsonCriteria = null;
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        this.setDocID(jsonObject.get("docid").toString());
        JSONArray criteriasJsonArray = (JSONArray)jsonObject.get("criterias");
        JSONObject criteria = null;
        SearchCriterion criteriaHolder = null;
        Vector<SearchCriterion> criterias = new Vector<SearchCriterion>(criteriasJsonArray.size());
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
            criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
            criteriaHolder = new SearchCriterion();
            String criteriaName = criteria.get("name").toString();
            criteriaHolder.setName(criteriaName);
            String currentOperator = criteria.get("operator").toString();
            criteriaHolder.setOperator(currentOperator);
            JSONArray valuesJsonArray = (JSONArray)criteria.get("values");
            String[] tempValuesArray = new String[valuesJsonArray.size()];
            for (int iValuesCounter = 0; iValuesCounter < valuesJsonArray.size(); ++iValuesCounter) {
                tempValuesArray[iValuesCounter] = (String)valuesJsonArray.get(iValuesCounter);
            }
            criteriaHolder.setValues(tempValuesArray);
            criterias.add(criteriaHolder);
        }
        this.setCriterias(criterias.elements());
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }
}

