/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8;

import com.filenet.api.collection.BinaryList;
import com.filenet.api.collection.DateTimeList;
import com.filenet.api.collection.Float64List;
import com.filenet.api.collection.IdList;
import com.filenet.api.collection.Integer32List;
import com.filenet.api.collection.StringList;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.meta.PropertyDescriptionBinary;
import com.filenet.api.meta.PropertyDescriptionBoolean;
import com.filenet.api.meta.PropertyDescriptionDateTime;
import com.filenet.api.meta.PropertyDescriptionFloat64;
import com.filenet.api.meta.PropertyDescriptionId;
import com.filenet.api.meta.PropertyDescriptionInteger32;
import com.filenet.api.meta.PropertyDescriptionString;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.p8.P8ChoiceListUtil;
import com.ibm.ecm.util.p8.P8SearchDefinition;
import com.ibm.ecm.util.p8.P8SearchTemplate;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8CriteriasMediator
extends BaseMediator {
    private String productName;
    private List<P8SearchDefinition.SearchInObjectStore> objectStores;
    private SearchTemplate.ObjectType objectType;
    private List<SearchTemplate.SearchFolder> folders;
    private List<SearchTemplate.SearchClass> classes;
    private SearchTemplate.VersionOption versionOption;
    private List<SearchTemplate.TextSearchCriterion> textSearchCriteria;
    private SearchTemplate.TextSearchType textSearchType;
    private SearchTemplate.ResultsDisplay resultsDisplay;
    private Boolean autoRun;
    private Boolean showInTree;
    private P8SearchTemplate.CriteriaLayout textSearchCriteriaLayout;
    private boolean operatorHidden;
    private boolean criteriaRelationshipHidden;
    private boolean autoResolved;
    private boolean propertyTextAnded;
    private ObjectStore objectStore;
    private SearchTemplate.Macros macros;
    private List criteria;
    private List<PropertyDescription> propertyDescriptionList = null;
    private WCDateFormat wcDateFormat = WCDateFormat.getDefaultDateFormats(this.request);
    public String serverName = null;
    public String formType = null;
    public boolean hasSavedSearches = false;
    public boolean showFieldHoverHelp = false;
    public boolean isAndSearch = true;

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setObjectStores(List<P8SearchDefinition.SearchInObjectStore> objectStores) {
        this.objectStores = objectStores;
    }

    public List<P8SearchDefinition.SearchInObjectStore> getObjectStores() {
        return this.objectStores;
    }

    public List<PropertyDescription> getPropertyDescriptionList() {
        return this.propertyDescriptionList;
    }

    public void setPropertyDescriptionList(ArrayList<PropertyDescription> propertyDescriptionList) {
        this.propertyDescriptionList = propertyDescriptionList;
    }

    public boolean isAndSearch() {
        return this.isAndSearch;
    }

    public void setAndSearch(boolean isAndSearch) {
        this.isAndSearch = isAndSearch;
    }

    public P8CriteriasMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected P8CriteriasMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public List<SearchTemplate.SearchFolder> getFolders() {
        return this.folders;
    }

    public void setFolders(List<SearchTemplate.SearchFolder> folders) {
        this.folders = folders;
    }

    public List<SearchTemplate.SearchClass> getClasses() {
        return this.classes;
    }

    public void setClasses(List<SearchTemplate.SearchClass> classes) {
        this.classes = classes;
    }

    public SearchTemplate.ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(SearchTemplate.ObjectType objectType) {
        this.objectType = objectType;
    }

    public List getCriteria() {
        return this.criteria;
    }

    public boolean getHasSavedSearches() {
        return this.hasSavedSearches;
    }

    public void setHasSavedSearches(boolean hasSavedSearches) {
        this.hasSavedSearches = hasSavedSearches;
    }

    public void setCriteria(List criteria) {
        this.criteria = criteria;
    }

    public SearchTemplate.VersionOption getVersionOption() {
        return this.versionOption;
    }

    public void setVersionOption(SearchTemplate.VersionOption versionOption) {
        this.versionOption = versionOption;
    }

    public List<SearchTemplate.TextSearchCriterion> getTextSearchCriteria() {
        return this.textSearchCriteria;
    }

    public void setTextSearchCriteria(List<SearchTemplate.TextSearchCriterion> textSearchCriteria) {
        this.textSearchCriteria = textSearchCriteria;
    }

    public SearchTemplate.TextSearchType getTextSearchType() {
        return this.textSearchType;
    }

    public void setTextSearchType(SearchTemplate.TextSearchType textSearchType) {
        this.textSearchType = textSearchType;
    }

    public SearchTemplate.ResultsDisplay getResultsDisplay() {
        return this.resultsDisplay;
    }

    public void setResultsDisplay(SearchTemplate.ResultsDisplay resultsDisplay) {
        this.resultsDisplay = resultsDisplay;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getFormType() {
        if (this.formType == null) {
            this.formType = "search";
        }
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public void setAutoRun(Boolean autoRun) {
        this.autoRun = autoRun;
    }

    public boolean getAutoRun() {
        return this.autoRun;
    }

    public void setShowInTree(Boolean showInTree) {
        this.showInTree = showInTree;
    }

    public boolean getShowInTree() {
        return this.showInTree;
    }

    public P8SearchTemplate.CriteriaLayout getTextSearchCriteriaLayout() {
        return this.textSearchCriteriaLayout;
    }

    public void setTextSearchCriteriaLayout(P8SearchTemplate.CriteriaLayout textSearchCriteriaLayout) {
        this.textSearchCriteriaLayout = textSearchCriteriaLayout;
    }

    public boolean isOperatorHidden() {
        return this.operatorHidden;
    }

    public void setOperatorHidden(boolean operatorHidden) {
        this.operatorHidden = operatorHidden;
    }

    public boolean isCriteriaRelationshipHidden() {
        return this.criteriaRelationshipHidden;
    }

    public void setCriteriaRelationshipHidden(boolean criteriaRelationshipHidden) {
        this.criteriaRelationshipHidden = criteriaRelationshipHidden;
    }

    public boolean isAutoResolved() {
        return this.autoResolved;
    }

    public void setAutoResolved(boolean autoResolved) {
        this.autoResolved = autoResolved;
    }

    public boolean isPropertyTextAnded() {
        return this.propertyTextAnded;
    }

    public void setPropertyTextAnded(boolean propertyTextAnded) {
        this.propertyTextAnded = propertyTextAnded;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    public SearchTemplate.Macros getMacros() {
        return this.macros;
    }

    public void setMacros(SearchTemplate.Macros macros) {
        this.macros = macros;
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        if (this.getObjectType() == null) {
            Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
            return jsonObject;
        }
        jsonObject.put("productName", this.getProductName());
        if (this.objectStores != null) {
            for (P8SearchDefinition.SearchInObjectStore os : this.objectStores) {
                JSONObject osJSON = new JSONObject();
                osJSON.put("id", os.getId());
                osJSON.put("name", os.getSymbolicName());
                osJSON.put("displayName", os.getName());
                JSONUtils.accumulate(jsonObject, "search_objectstores", osJSON);
            }
        }
        jsonObject.put("objectType", this.getObjectType().toString());
        jsonObject.put("andSearch", (Object)this.isAndSearch());
        jsonObject.put("query_view", new Boolean(this.getHasSavedSearches()));
        jsonObject.put("showFieldHoverHelp", new Boolean(this.getShowFieldHoverHelp()));
        if (this.folders != null) {
            for (SearchTemplate.SearchFolder folder : this.folders) {
                JSONObject folderJSON = new JSONObject();
                folderJSON.put("id", folder.getId());
                folderJSON.put("pathName", folder.getPathName());
                folderJSON.put("searchSubfolders", (Object)folder.isSearchSubfolders());
                folderJSON.put("view", folder.getView().toString());
                folderJSON.put("objectStoreId", folder.getObjectStoreId());
                folderJSON.put("objectStoreName", folder.getObjectStoreName());
                folderJSON.put("itemId", folder.getItemId());
                JSONUtils.accumulate(jsonObject, "search_folders", folderJSON);
            }
        }
        if (this.classes != null) {
            for (SearchTemplate.SearchClass subclass : this.classes) {
                JSONObject classJSON = new JSONObject();
                if (jsonObject.get("template_name") == null) {
                    jsonObject.put("template_name", subclass.getName());
                    jsonObject.put("template_label", subclass.getDisplayName());
                    jsonObject.put("searchSubclasses", (Object)subclass.isSearchSubclasses());
                }
                classJSON.put("name", subclass.getName());
                classJSON.put("displayName", subclass.getDisplayName());
                classJSON.put("objectType", subclass.getObjectType().toString());
                classJSON.put("searchSubclasses", (Object)subclass.isSearchSubclasses());
                classJSON.put("editProperty", subclass.getEditProperty().toString());
                classJSON.put("itemId", subclass.getItemId());
                JSONUtils.accumulate(jsonObject, "search_classes", classJSON);
            }
        }
        String dataType = null;
        String criteriaFormat = null;
        Iterator criteriaIterator = null;
        if (this.criteria != null) {
            criteriaIterator = this.criteria.iterator();
        }
        boolean cascade = this.textSearchType == null || this.textSearchType == SearchTemplate.TextSearchType.cascade;
        P8ChoiceListUtil.loadChoiceLists(this.request, this.propertyDescriptionList, this.objectStore);
        while (criteriaIterator != null && criteriaIterator.hasNext()) {
            SearchCriterion loopCriteria = (SearchCriterion)criteriaIterator.next();
            JSONObject jsonCriteria = new JSONObject();
            PropertyDescription propertyDescription = null;
            for (int i = 0; i < this.propertyDescriptionList.size() && propertyDescription == null; ++i) {
                PropertyDescription tpropertyDescription = this.propertyDescriptionList.get(i);
                if (!tpropertyDescription.get_SymbolicName().equals(loopCriteria.getName())) continue;
                propertyDescription = tpropertyDescription;
                break;
            }
            jsonCriteria.put("name", loopCriteria.getName());
            criteriaFormat = this.getFormat(loopCriteria.getDataType());
            if (criteriaFormat != null) {
                jsonCriteria.put("format", criteriaFormat);
            }
            dataType = loopCriteria.getDataType();
            if (propertyDescription != null) {
                loopCriteria.setDataType(P8Util.getDataType(propertyDescription));
                String displayName = P8Util.getPropertyDisplayName(this.request, propertyDescription);
                loopCriteria.setDisplayName(displayName);
                loopCriteria.setCardinality(propertyDescription.get_Cardinality().toString());
                jsonCriteria.put("cardinality", loopCriteria.getCardinality());
            }
            jsonCriteria.put("dataType", loopCriteria.getDataType());
            jsonCriteria.put("label", loopCriteria.getDisplayName());
            jsonCriteria.put("readOnly", (Object)loopCriteria.isReadOnly());
            jsonCriteria.put("hidden", (Object)loopCriteria.isHidden());
            jsonCriteria.put("required", (Object)loopCriteria.isRequired());
            jsonCriteria.put("minValue", "");
            jsonCriteria.put("maxValue", "");
            jsonCriteria.put("maxEntry", "");
            jsonCriteria.put("itemId", loopCriteria.getItemId());
            jsonCriteria.put("defaultOperator", loopCriteria.getOperator());
            P8CriteriasMediator.addStringArrayToJSON(jsonCriteria, "values", loopCriteria.getValues());
            P8CriteriasMediator.addStringArrayToJSON(jsonCriteria, "displayValues", loopCriteria.getDisplayValues());
            if (propertyDescription != null) {
                P8ChoiceListUtil.addChoiceList(this.request, propertyDescription, this.objectStore, jsonCriteria);
                String maxEntry = "";
                String minValue = "";
                String maxValue = "";
                String[] validValues = new String[]{};
                try {
                    PropertyDescriptionBoolean pdBoolean;
                    BinaryList bList;
                    if (propertyDescription instanceof PropertyDescriptionDateTime) {
                        PropertyDescriptionDateTime pdDateTime = (PropertyDescriptionDateTime)propertyDescription;
                        Date date = pdDateTime.get_PropertyMinimumDateTime();
                        if (date != null) {
                            minValue = this.wcDateFormat.getDateFormat().format(date);
                        }
                        if ((date = pdDateTime.get_PropertyMaximumDateTime()) != null) {
                            maxValue = this.wcDateFormat.getDateFormat().format(date);
                        }
                        DateTimeList dtList = pdDateTime.get_PropertySelectionsDateTime();
                        ArrayList<Object> l1 = new ArrayList<Object>();
                        if (dtList.size() > 0) {
                            int i;
                            validValues = new String[dtList.size()];
                            for (i = 0; i < dtList.size(); ++i) {
                                l1.add(dtList.get(i));
                            }
                            Collections.sort(l1);
                            for (i = 0; i < l1.size(); ++i) {
                                validValues[i] = l1.get(i).toString();
                            }
                        }
                    } else if (propertyDescription instanceof PropertyDescriptionFloat64) {
                        PropertyDescriptionFloat64 pdFloat64 = (PropertyDescriptionFloat64)propertyDescription;
                        if (pdFloat64.get_PropertyMinimumFloat64() != null) {
                            minValue = pdFloat64.get_PropertyMinimumFloat64().toString();
                        }
                        if (pdFloat64.get_PropertyMaximumFloat64() != null) {
                            maxValue = pdFloat64.get_PropertyMaximumFloat64().toString();
                        }
                        Float64List fList = pdFloat64.get_PropertySelectionsFloat64();
                        ArrayList<Object> l1 = new ArrayList<Object>();
                        if (fList.size() > 0) {
                            int i;
                            validValues = new String[fList.size()];
                            for (i = 0; i < fList.size(); ++i) {
                                l1.add(fList.get(i));
                            }
                            Collections.sort(l1);
                            for (i = 0; i < l1.size(); ++i) {
                                validValues[i] = l1.get(i).toString();
                            }
                        }
                    } else if (propertyDescription instanceof PropertyDescriptionInteger32) {
                        PropertyDescriptionInteger32 pdInteger32 = (PropertyDescriptionInteger32)propertyDescription;
                        if (pdInteger32.get_PropertyMinimumInteger32() != null) {
                            minValue = pdInteger32.get_PropertyMinimumInteger32().toString();
                        }
                        if (pdInteger32.get_PropertyMaximumInteger32() != null) {
                            maxValue = pdInteger32.get_PropertyMaximumInteger32().toString();
                        }
                        Integer32List iList = pdInteger32.get_PropertySelectionsInteger32();
                        ArrayList<Object> l1 = new ArrayList<Object>();
                        if (iList.size() > 0) {
                            int i;
                            validValues = new String[iList.size()];
                            for (i = 0; i < iList.size(); ++i) {
                                l1.add(iList.get(i));
                            }
                            Collections.sort(l1);
                            for (i = 0; i < l1.size(); ++i) {
                                validValues[i] = l1.get(i).toString();
                            }
                        }
                    } else if (propertyDescription instanceof PropertyDescriptionString) {
                        PropertyDescriptionString pdString = (PropertyDescriptionString)propertyDescription;
                        if (pdString.get_MaximumLengthString() != null) {
                            maxEntry = pdString.get_MaximumLengthString().toString();
                        }
                        StringList sList = pdString.get_PropertySelectionsString();
                        ArrayList<String> l1 = new ArrayList<String>();
                        if (sList.size() > 0) {
                            int i;
                            validValues = new String[sList.size()];
                            for (i = 0; i < sList.size(); ++i) {
                                l1.add(sList.get(i).toString());
                            }
                            Collections.sort(l1, String.CASE_INSENSITIVE_ORDER);
                            for (i = 0; i < l1.size(); ++i) {
                                validValues[i] = l1.get(i).toString();
                            }
                        }
                        jsonCriteria.put("usesLongColumn", pdString.get_UsesLongColumn());
                        if (cascade) {
                            jsonCriteria.put("textSearchable", pdString.get_IsCBREnabled());
                        }
                    } else if (propertyDescription instanceof PropertyDescriptionBinary) {
                        PropertyDescriptionBinary pdBinary = (PropertyDescriptionBinary)propertyDescription;
                        if (pdBinary.get_MaximumLengthBinary() != null) {
                            maxEntry = pdBinary.get_MaximumLengthBinary().toString();
                        }
                        if ((bList = pdBinary.get_PropertySelectionBinary()).size() > 0) {
                            validValues = new String[bList.size()];
                            for (int i = 0; i < bList.size(); ++i) {
                                validValues[i] = bList.get(i).toString();
                            }
                        }
                    } else if (propertyDescription instanceof PropertyDescriptionId) {
                        PropertyDescriptionId pdId = (PropertyDescriptionId)propertyDescription;
                        IdList idList = pdId.get_PropertySelectionsId();
                        if (idList.size() > 0) {
                            validValues = new String[idList.size()];
                            for (int i = 0; i < idList.size(); ++i) {
                                validValues[i] = idList.get(i).toString();
                            }
                        }
                    } else if (propertyDescription instanceof PropertyDescriptionBoolean && (bList = (pdBoolean = (PropertyDescriptionBoolean)propertyDescription).get_PropertySelectionsBoolean()).size() > 0) {
                        validValues = new String[bList.size()];
                        for (int i = 0; i < bList.size(); ++i) {
                            validValues[i] = bList.get(i).toString();
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
                }
                jsonCriteria.put("minValue", minValue);
                jsonCriteria.put("maxValue", maxValue);
                jsonCriteria.put("maxEntry", maxEntry);
                P8CriteriasMediator.addStringArrayToJSON(jsonCriteria, "validValues", validValues);
            }
            JSONUtils.accumulate(jsonObject, "criterias", jsonCriteria);
            loopCriteria = null;
            jsonCriteria = null;
        }
        JSONObject optionCriteria = new JSONObject();
        SearchTemplate.VersionOption versionOption = this.getVersionOption();
        if (versionOption != null) {
            optionCriteria.put("versionOption", this.getVersionOption().toString());
        }
        optionCriteria.put("propertyTextAnded", (Object)this.isPropertyTextAnded());
        if (this.macros != null) {
            optionCriteria.put("macros", this.macros.toJSON());
        }
        jsonObject.put("moreOptions", optionCriteria);
        if (this.textSearchCriteria != null && this.textSearchCriteria.size() > 0) {
            jsonObject.put("textSearchCriteria", this.textSearchCriteria.get(0).toJSON());
            if (this.textSearchCriteria.size() > 1) {
                for (SearchTemplate.TextSearchCriterion criterion : this.textSearchCriteria) {
                    JSONUtils.accumulate(jsonObject, "search_text_criteria", criterion.toJSON());
                }
            }
        }
        if (this.textSearchCriteriaLayout != null) {
            jsonObject.put("textCriteriaLayout", this.textSearchCriteriaLayout.toJSON());
        }
        if (this.textSearchType != null) {
            jsonObject.put("textSearchType", this.textSearchType.toString());
        }
        if (this.resultsDisplay != null) {
            jsonObject.put("resultsDisplay", this.resultsDisplay.toJSON());
        }
        if (this.autoRun != null) {
            jsonObject.put("autoRun", this.autoRun);
        }
        if (this.showInTree != null) {
            jsonObject.put("showInTree", this.showInTree);
        }
        jsonObject.put("operatorHidden", (Object)this.operatorHidden);
        jsonObject.put("criteriaRelationshipHidden", (Object)this.criteriaRelationshipHidden);
        jsonObject.put("autoResolved", (Object)this.autoResolved);
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    public String getFormat(String type) {
        String methodName = "getFormat";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        String returnFormat = null;
        if (!type.equals("xs:timestamp") && !type.equals("xs:date") && !type.equals("xs:time") && type.equals("xs:decimal")) {
            returnFormat = "";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "returned Format [" + type + "]: " + returnFormat);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return returnFormat;
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }
}

