/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8;

import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.core.EngineObject;
import com.filenet.api.meta.ClassDescription;
import com.ibm.ecm.json.JSONItem;
import com.ibm.ecm.json.JSONStore;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class P8ClassesMediator
extends BaseMediator {
    private String serverDisplayName = null;
    private HashMap classes = null;
    private int maxClasses;
    P8ClassDescription parentClass = null;

    public P8ClassesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void addClass(ClassDescription classDescription) {
        P8ClassDescription cd = this.makeP8ClassDescription((EngineObject)classDescription);
        if (cd != null) {
            this.getClasses().put(cd.name, cd);
        }
    }

    public void addClass(ClassDefinition classDefinition) {
        P8ClassDescription cd = this.makeP8ClassDescription((EngineObject)classDefinition);
        if (cd != null) {
            if (cd.allowsInstances == Boolean.TRUE) {
                cd.allowsInstances = this.canCreateInstance(classDefinition);
            }
            this.getClasses().put(cd.name, cd);
        }
    }

    private P8ClassDescription makeP8ClassDescription(EngineObject classDescription) {
        String className = classDescription.getProperties().getStringValue("SymbolicName");
        String dispName = classDescription.getProperties().getStringValue("DisplayName");
        String id = classDescription.getProperties().getIdValue("Id").toString();
        if (className != null) {
            P8ClassDescription cd = new P8ClassDescription();
            cd.id = id;
            cd.name = className;
            cd.displayName = dispName;
            cd.description = classDescription.getProperties().getStringValue("DescriptiveText");
            cd.allowsInstances = (boolean)classDescription.getProperties().getBooleanValue("AllowsInstances");
            return cd;
        }
        return null;
    }

    private boolean canCreateInstance(ClassDefinition classDef) {
        return (classDef.getAccessAllowed() & 0x100) == 256;
    }

    public void setParentClass(ClassDefinition classDefinition) {
        P8ClassDescription cd = this.makeP8ClassDescription((EngineObject)classDefinition);
        if (cd != null) {
            if (cd.allowsInstances == Boolean.TRUE) {
                cd.allowsInstances = this.canCreateInstance(classDefinition);
            }
            this.parentClass = cd;
        }
    }

    public String getServerDisplayName() {
        return this.serverDisplayName;
    }

    public void setServerDisplayName(String serverDisplayName) {
        this.serverDisplayName = serverDisplayName;
    }

    public HashMap getClasses() {
        if (this.classes == null) {
            this.classes = new HashMap(0);
        }
        return this.classes;
    }

    public void setClasses(HashMap classes) {
        this.classes = classes;
    }

    protected List sortClasses() {
        ArrayList sortedList = new ArrayList(this.getClasses().values());
        Collections.sort(sortedList, new Comparator<P8ClassDescription>(){

            @Override
            public int compare(P8ClassDescription w1, P8ClassDescription w2) {
                return w1.displayName.compareToIgnoreCase(w2.displayName);
            }
        });
        return sortedList;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        jsonObject.put("repositoryId", this.getServerDisplayName());
        jsonObject.put("num_templates", new Integer(this.getClasses().size()));
        JSONStore DataStore = new JSONStore("template_name", "template_label", this.locale);
        List sortedClasses = this.sortClasses();
        Iterator iterator = sortedClasses.iterator();
        for (int currentFolder = 0; iterator.hasNext() && currentFolder < this.getMaxClasses(); ++currentFolder) {
            P8ClassDescription classDescription = (P8ClassDescription)iterator.next();
            String classId = classDescription.name;
            String dispName = classDescription.displayName;
            JSONItem DataItem = DataStore.createDataItem(classId, dispName);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("template_desc", classDescription.description);
            properties.put("allowsInstances", classDescription.allowsInstances.toString());
            DataItem.setProperties(properties);
            DataStore.addItem(DataItem);
        }
        if (this.parentClass != null) {
            JSONObject jsonParentClass = new JSONObject();
            jsonParentClass.put("id", this.parentClass.name);
            jsonParentClass.put("name", this.parentClass.displayName);
            jsonParentClass.put("allowsInstances", this.parentClass.allowsInstances.toString());
            jsonObject.put("parentclass", jsonParentClass);
        }
        jsonObject.put("datastore", DataStore.toJson());
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        this.setServerDisplayName(jsonObject.get("repositoryId").toString());
        this.setClasses(new HashMap(P8ClassesMediator.toMapFromJSONForClasses((JSONArray)jsonObject.get("templates"))));
    }

    protected static Map toMapFromJSONForClasses(JSONArray jsonArray) {
        TreeMap<String, String> newHashMap = new TreeMap<String, String>();
        String myString = new String();
        JSONObject jsonObject = null;
        for (int iArrayItemCounter = 0; iArrayItemCounter < jsonArray.size(); ++iArrayItemCounter) {
            jsonObject = (JSONObject)jsonArray.get(iArrayItemCounter);
            for (String keyName : jsonObject.keySet()) {
                String value = jsonObject.get(keyName).toString();
                newHashMap.put(keyName, value);
            }
        }
        return newHashMap;
    }

    public int getMaxClasses() {
        return this.maxClasses;
    }

    public void setMaxClasses(int maxClasses) {
        this.maxClasses = maxClasses;
    }

    private class P8ClassDescription {
        String name;
        String id;
        String displayName;
        String description;
        Boolean allowsInstances;

        private P8ClassDescription() {
        }
    }
}

