/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8;

import com.filenet.api.collection.BinaryList;
import com.filenet.api.collection.DateTimeList;
import com.filenet.api.collection.Float64List;
import com.filenet.api.collection.IdList;
import com.filenet.api.collection.Integer32List;
import com.filenet.api.collection.PropertyDescriptionList;
import com.filenet.api.collection.StringList;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.meta.PropertyDescriptionBinary;
import com.filenet.api.meta.PropertyDescriptionBoolean;
import com.filenet.api.meta.PropertyDescriptionDateTime;
import com.filenet.api.meta.PropertyDescriptionFloat64;
import com.filenet.api.meta.PropertyDescriptionId;
import com.filenet.api.meta.PropertyDescriptionInteger32;
import com.filenet.api.meta.PropertyDescriptionObject;
import com.filenet.api.meta.PropertyDescriptionString;
import com.filenet.api.security.AccessPermissionDescription;
import com.filenet.api.security.Marking;
import com.filenet.api.security.MarkingSet;
import com.filenet.api.util.UserContext;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.p8.P8ChoiceListUtil;
import com.ibm.ecm.util.p8.P8SecurityPolicy;
import com.ibm.ecm.util.p8.P8TextSearchUtil;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8AttributesMediator
extends BaseMediator {
    private List<PropertyDescription> propertyDescriptionList = null;
    private List<AccessPermissionDescription> permissionDescList = null;
    private P8SecurityPolicy securityPolicy = null;
    private Map<String, Object> currentValues = null;
    private boolean includeAuthoringAttributes = true;
    private List<ClassDescription> classDescList = null;
    private Map<String, P8SecurityPolicy> securityPolicies = null;
    private Map<String, String> alternateChoiceLists = null;
    private Set<String> textSearchableProps = null;
    Set baseClassPropertyDescriptionNameSet = null;
    public String classId = null;
    public String classSymbolicName = null;
    public String classDisplayName = null;
    public String classDescription = null;
    public String serverName = null;
    public boolean showFieldHoverHelp = false;
    public boolean isPseudoClass = false;
    public Boolean allowsInstances = null;
    private WCDateFormat wcDateFormat = WCDateFormat.getDefaultDateFormats(this.request);
    private ObjectStore objectStore;

    public void setBaseClassPropertyDescriptionNameSet(Set propertyDescriptionNameSet) {
        this.baseClassPropertyDescriptionNameSet = propertyDescriptionNameSet;
    }

    public List<PropertyDescription> getPropertyDescriptionList() {
        return this.propertyDescriptionList;
    }

    public void setPropertyDescriptionList(List<PropertyDescription> propertyDescriptionList) {
        this.propertyDescriptionList = propertyDescriptionList;
    }

    public List<AccessPermissionDescription> getPermissionDescList() {
        return this.permissionDescList;
    }

    public void setPermissionDescList(List<AccessPermissionDescription> permissionDescList) {
        this.permissionDescList = permissionDescList;
    }

    public P8SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public void setSecurityPolicy(P8SecurityPolicy securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public void setIncludeAuthoringAttributes(boolean yes) {
        this.includeAuthoringAttributes = yes;
    }

    public boolean getIncludeAuthoringAttributes() {
        return this.includeAuthoringAttributes;
    }

    public void addCurrentValue(String attributeName, Object value) {
        if (this.currentValues == null) {
            this.currentValues = new Hashtable<String, Object>();
        }
        this.currentValues.put(attributeName, value);
    }

    public P8AttributesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
        UserContext.get().setLocale(locale);
    }

    protected P8AttributesMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
        UserContext.get().setLocale(baseMediator.getLocale());
    }

    public String getClassId() {
        return this.classId;
    }

    public void setClassId(String classId) {
        this.classId = classId;
    }

    public String getClassSymbolicName() {
        return this.classSymbolicName;
    }

    public void setClassSymbolicName(String name) {
        this.classSymbolicName = name;
    }

    public String getClassDisplayName() {
        return this.classDisplayName;
    }

    public void setClassDisplayName(String name) {
        this.classDisplayName = name;
    }

    public String getFolderDescription() {
        return this.classDescription;
    }

    public void setFolderDescription(String folderDescription) {
        this.classDescription = folderDescription;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public boolean isPseudoClass() {
        return this.isPseudoClass;
    }

    public void setPseudoClass(boolean isPseudoClass) {
        this.isPseudoClass = isPseudoClass;
    }

    public boolean getAllowsInstances() {
        return this.allowsInstances;
    }

    public void setAllowsInstances(boolean allowsInstances) {
        this.allowsInstances = allowsInstances;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        this.addClassJSONInfo(jsonObject);
        jsonObject.put("showFieldHoverHelp", new Boolean(this.getShowFieldHoverHelp()));
        String textSearchType = P8TextSearchUtil.getTextSearchType(this.request);
        boolean cascade = textSearchType != null && textSearchType.length() > 0 && SearchTemplate.TextSearchType.valueOf(textSearchType) == SearchTemplate.TextSearchType.cascade;
        JSONArray jsonAttributeDefsArray = new JSONArray();
        P8ChoiceListUtil.loadChoiceLists(this.request, this.propertyDescriptionList, this.objectStore);
        for (int p = 0; p < this.propertyDescriptionList.size(); ++p) {
            JSONArray jsonMarkingArray;
            String[] validValues;
            String defaultValue;
            String maxValue;
            String minValue;
            String maxEntry;
            JSONObject jsonAttributeDef;
            String symbolicName;
            PropertyDescription propertyDescription;
            block57: {
                propertyDescription = this.propertyDescriptionList.get(p);
                symbolicName = propertyDescription.get_SymbolicName();
                Logger.logDebug(P8AttributesMediator.class, "toJSONObject", (ServletRequest)this.request, "Attribute symbolic name is \"" + symbolicName + "\"");
                if (propertyDescription.get_SymbolicName().equals("SourceDocument") || propertyDescription.get_SymbolicName().equals("DestinationDocuments") || propertyDescription.get_SymbolicName().equals("CompoundDocumentState") || propertyDescription.get_SymbolicName().equals("RecordInformation")) continue;
                jsonAttributeDef = new JSONObject();
                if (this.baseClassPropertyDescriptionNameSet != null && !this.baseClassPropertyDescriptionNameSet.contains(propertyDescription.get_SymbolicName())) {
                    jsonAttributeDef.put("subClassAttribute", new Boolean(true));
                }
                jsonAttributeDef.put("name", symbolicName);
                jsonAttributeDef.put("hidden", new Boolean(propertyDescription.get_IsHidden()));
                if (symbolicName.equals("FolderName")) {
                    jsonAttributeDef.put("system", new Boolean(false));
                } else {
                    jsonAttributeDef.put("system", new Boolean(propertyDescription.get_IsSystemOwned()));
                }
                jsonAttributeDef.put("dataType", P8Util.getDataType(propertyDescription));
                String pdDisplayName = propertyDescription.get_DisplayName();
                if (propertyDescription.get_IsSystemOwned().booleanValue()) {
                    String customLabel;
                    if (P8Util.isDefaultLabel(propertyDescription.get_SymbolicName())) {
                        String messageKey = "systemp8." + propertyDescription.get_SymbolicName() + ".defaultLabel";
                        pdDisplayName = MessageUtil.getMessage(this.getLocale(), messageKey);
                    }
                    if ((customLabel = BaseUtil.getCustomLabelValue(this.request, "sys_" + propertyDescription.get_SymbolicName())) != null) {
                        pdDisplayName = customLabel;
                    }
                }
                jsonAttributeDef.put("label", pdDisplayName);
                jsonAttributeDef.put("description", propertyDescription.get_DescriptiveText());
                jsonAttributeDef.put("searchable", new Boolean(propertyDescription.get_IsSearchable()));
                if (cascade && propertyDescription instanceof PropertyDescriptionString) {
                    boolean textSearchable = this.isPropertyTextSearchable(propertyDescription);
                    jsonAttributeDef.put("textSearchable", (Object)textSearchable);
                }
                maxEntry = "";
                minValue = "";
                maxValue = "";
                defaultValue = "";
                validValues = new String[]{};
                jsonMarkingArray = new JSONArray();
                try {
                    BinaryList bList;
                    if (propertyDescription instanceof PropertyDescriptionDateTime) {
                        PropertyDescriptionDateTime pdDateTime = (PropertyDescriptionDateTime)propertyDescription;
                        Date date = pdDateTime.get_PropertyMinimumDateTime();
                        if (date != null && !this.isMultipleClassesMode()) {
                            minValue = this.wcDateFormat.getDateFormat().format(date);
                        }
                        if ((date = pdDateTime.get_PropertyMaximumDateTime()) != null && !this.isMultipleClassesMode()) {
                            maxValue = this.wcDateFormat.getDateFormat().format(date);
                        }
                        if ((date = pdDateTime.get_PropertyDefaultDateTime()) != null) {
                            defaultValue = this.wcDateFormat.getDateFormat().format(pdDateTime.get_PropertyDefaultDateTime());
                        }
                        DateTimeList dtList = pdDateTime.get_PropertySelectionsDateTime();
                        ArrayList<Object> l1 = new ArrayList<Object>();
                        if (dtList.size() > 0) {
                            int i;
                            validValues = new String[dtList.size()];
                            for (i = 0; i < dtList.size(); ++i) {
                                l1.add(dtList.get(i));
                            }
                            Collections.sort(l1);
                            for (i = 0; i < l1.size(); ++i) {
                                validValues[i] = l1.get(i).toString();
                            }
                        }
                        break block57;
                    }
                    if (propertyDescription instanceof PropertyDescriptionFloat64) {
                        PropertyDescriptionFloat64 pdFloat64 = (PropertyDescriptionFloat64)propertyDescription;
                        if (pdFloat64.get_PropertyMinimumFloat64() != null && !this.isMultipleClassesMode()) {
                            minValue = pdFloat64.get_PropertyMinimumFloat64().toString();
                        }
                        if (pdFloat64.get_PropertyMaximumFloat64() != null && !this.isMultipleClassesMode()) {
                            maxValue = pdFloat64.get_PropertyMaximumFloat64().toString();
                        }
                        if (pdFloat64.get_PropertyDefaultFloat64() != null) {
                            defaultValue = pdFloat64.get_PropertyDefaultFloat64().toString();
                        }
                        Float64List fList = pdFloat64.get_PropertySelectionsFloat64();
                        ArrayList<Object> l1 = new ArrayList<Object>();
                        if (fList.size() > 0) {
                            int i;
                            validValues = new String[fList.size()];
                            for (i = 0; i < fList.size(); ++i) {
                                l1.add(fList.get(i));
                            }
                            Collections.sort(l1);
                            for (i = 0; i < l1.size(); ++i) {
                                validValues[i] = l1.get(i).toString();
                            }
                        }
                        break block57;
                    }
                    if (propertyDescription instanceof PropertyDescriptionInteger32) {
                        PropertyDescriptionInteger32 pdInteger32 = (PropertyDescriptionInteger32)propertyDescription;
                        minValue = pdInteger32.get_PropertyMinimumInteger32() != null && !this.isMultipleClassesMode() ? pdInteger32.get_PropertyMinimumInteger32().toString() : "-2147483648";
                        maxValue = pdInteger32.get_PropertyMaximumInteger32() != null && !this.isMultipleClassesMode() ? pdInteger32.get_PropertyMaximumInteger32().toString() : "2147483647";
                        if (pdInteger32.get_PropertyDefaultInteger32() != null) {
                            defaultValue = pdInteger32.get_PropertyDefaultInteger32().toString();
                        }
                        Integer32List iList = pdInteger32.get_PropertySelectionsInteger32();
                        ArrayList<Object> l1 = new ArrayList<Object>();
                        if (iList.size() > 0) {
                            int i;
                            validValues = new String[iList.size()];
                            for (i = 0; i < iList.size(); ++i) {
                                l1.add(iList.get(i));
                            }
                            Collections.sort(l1);
                            for (i = 0; i < l1.size(); ++i) {
                                validValues[i] = l1.get(i).toString();
                            }
                        }
                        break block57;
                    }
                    if (propertyDescription instanceof PropertyDescriptionString) {
                        PropertyDescriptionString pdString = (PropertyDescriptionString)propertyDescription;
                        if (pdString.get_MaximumLengthString() != null) {
                            maxEntry = pdString.get_MaximumLengthString().toString();
                        }
                        if (pdString.get_PropertyDefaultString() != null) {
                            defaultValue = pdString.get_PropertyDefaultString().toString();
                        }
                        StringList sList = pdString.get_PropertySelectionsString();
                        ArrayList<String> l1 = new ArrayList<String>();
                        if (sList.size() > 0) {
                            int i;
                            validValues = new String[sList.size()];
                            for (i = 0; i < sList.size(); ++i) {
                                l1.add(sList.get(i).toString());
                            }
                            Collections.sort(l1, String.CASE_INSENSITIVE_ORDER);
                            for (i = 0; i < l1.size(); ++i) {
                                validValues[i] = l1.get(i).toString();
                            }
                        }
                        jsonAttributeDef.put("usesLongColumn", pdString.get_UsesLongColumn());
                        MarkingSet markingSet = pdString.get_MarkingSet();
                        if (markingSet != null) {
                            for (Marking marking : markingSet.get_Markings()) {
                                JSONObject markingJson = new JSONObject();
                                markingJson.put("id", marking.get_Id().toString());
                                markingJson.put("value", marking.get_MarkingValue());
                                markingJson.put("mask", marking.get_ConstraintMask());
                                jsonMarkingArray.add(markingJson);
                            }
                        }
                        break block57;
                    }
                    if (propertyDescription instanceof PropertyDescriptionBinary) {
                        PropertyDescriptionBinary pdBinary = (PropertyDescriptionBinary)propertyDescription;
                        if (pdBinary.get_MaximumLengthBinary() != null) {
                            maxEntry = pdBinary.get_MaximumLengthBinary().toString();
                        }
                        if (pdBinary.get_PropertyDefaultBinary() != null) {
                            defaultValue = pdBinary.get_PropertyDefaultBinary().toString();
                        }
                        if ((bList = pdBinary.get_PropertySelectionBinary()).size() <= 0) continue;
                        validValues = new String[bList.size()];
                        for (int i = 0; i < bList.size(); ++i) {
                            validValues[i] = bList.get(i).toString();
                        }
                        continue;
                    }
                    if (propertyDescription instanceof PropertyDescriptionId) {
                        IdList idList;
                        PropertyDescriptionId pdId = (PropertyDescriptionId)propertyDescription;
                        if (pdId.get_PropertyDefaultId() != null) {
                            defaultValue = pdId.get_PropertyDefaultId().toString();
                        }
                        if ((idList = pdId.get_PropertySelectionsId()).size() > 0) {
                            validValues = new String[idList.size()];
                            for (int i = 0; i < idList.size(); ++i) {
                                validValues[i] = idList.get(i).toString();
                            }
                        }
                    } else if (propertyDescription instanceof PropertyDescriptionBoolean) {
                        PropertyDescriptionBoolean pdBoolean = (PropertyDescriptionBoolean)propertyDescription;
                        if (pdBoolean.get_PropertyDefaultBoolean() != null) {
                            defaultValue = pdBoolean.get_PropertyDefaultBoolean().toString();
                        }
                        if ((bList = pdBoolean.get_PropertySelectionsBoolean()).size() > 0) {
                            validValues = new String[bList.size()];
                            for (int i = 0; i < bList.size(); ++i) {
                                validValues[i] = bList.get(i).toString();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logError(P8AttributesMediator.class, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
                }
            }
            jsonAttributeDef.put("cardinality", propertyDescription.get_Cardinality().toString());
            jsonAttributeDef.put("uniqueValues", propertyDescription.get_RequiresUniqueElements());
            if (this.hasAlternateChoiceList(symbolicName)) {
                String clId = this.getAlternateChoiceList(symbolicName);
                if (clId != null && clId.length() > 0) {
                    P8ChoiceListUtil.addChoiceList(this.request, propertyDescription, clId, this.objectStore, jsonAttributeDef);
                }
            } else {
                P8ChoiceListUtil.addChoiceList(this.request, propertyDescription, this.objectStore, jsonAttributeDef);
            }
            jsonAttributeDef.put("minValue", minValue);
            jsonAttributeDef.put("maxValue", maxValue);
            String criteriaFormat = this.getFormat(propertyDescription);
            if (criteriaFormat != null) {
                jsonAttributeDef.put("format", criteriaFormat);
            }
            if (!this.isMultipleClassesMode() || !this.hasAlternateChoiceList(symbolicName)) {
                P8AttributesMediator.addStringArrayToJSON(jsonAttributeDef, "validValues", validValues);
            }
            if (jsonMarkingArray.size() > 0) {
                jsonAttributeDef.put("markingList", jsonMarkingArray);
            }
            jsonAttributeDef.put("maxEntry", maxEntry);
            jsonAttributeDef.put("defaultOperator", "EQUAL");
            String[] operators = this.getOperatorSymbols(propertyDescription, this.getMessageResources(), this.getLocale());
            P8AttributesMediator.addStringArrayToJSON(jsonAttributeDef, "availableOperators", operators);
            jsonAttributeDef.put("orderable", propertyDescription.get_IsOrderable());
            if (this.includeAuthoringAttributes) {
                this.addAuthoringAttributesToJSON(jsonAttributeDef, propertyDescription, defaultValue);
            }
            jsonAttributeDefsArray.add(jsonAttributeDef);
        }
        jsonObject.put("criterias", jsonAttributeDefsArray);
        return jsonObject;
    }

    private JSONArray accesPermissionsToJSONArray(List<AccessPermissionDescription> permDescList) {
        JSONArray jsonArrayPermissions = new JSONArray();
        for (AccessPermissionDescription apd : permDescList) {
            JSONObject jsonObjAPD = new JSONObject();
            jsonObjAPD.put("permission_name", apd.get_DisplayName());
            jsonObjAPD.put("permission_type", apd.get_PermissionType().toString());
            jsonArrayPermissions.add(jsonObjAPD);
        }
        return jsonArrayPermissions;
    }

    private void addAuthoringAttributesToJSON(JSONObject jsonAttributeDef, PropertyDescription propertyDescription, Object defaultValue) {
        ClassDescription classDesc;
        jsonAttributeDef.put("readOnly", propertyDescription.get_IsReadOnly());
        jsonAttributeDef.put("required", propertyDescription.get_IsValueRequired());
        String requiredClassDisplayName = "";
        if (propertyDescription instanceof PropertyDescriptionObject && !propertyDescription.get_IsSystemOwned().booleanValue() && !propertyDescription.get_IsReadOnly().booleanValue() && (classDesc = ((PropertyDescriptionObject)propertyDescription).get_RequiredClass()) != null) {
            requiredClassDisplayName = classDesc.get_DisplayName();
        }
        jsonAttributeDef.put("requiredClass", requiredClassDisplayName);
        int settability = propertyDescription.get_Settability().getValue();
        if (settability == 3) {
            jsonAttributeDef.put("settability", "readOnly");
        } else if (settability == 1) {
            jsonAttributeDef.put("settability", "onlyBeforeCheckin");
        } else if (settability == 2) {
            jsonAttributeDef.put("settability", "onlyOnCreate");
        } else {
            jsonAttributeDef.put("settability", "readWrite");
        }
        jsonAttributeDef.put("fixedValue", new Boolean(false));
        jsonAttributeDef.put("ascending", new Boolean(false));
        if (this.currentValues != null && this.currentValues.containsKey(propertyDescription.get_SymbolicName())) {
            Object value = this.currentValues.get(propertyDescription.get_SymbolicName());
            if (value instanceof String[]) {
                P8AttributesMediator.addStringArrayToJSON(jsonAttributeDef, "value", (String[])value);
            } else {
                jsonAttributeDef.put("value", value);
            }
        } else if (defaultValue instanceof String[]) {
            P8AttributesMediator.addStringArrayToJSON(jsonAttributeDef, "value", (String[])defaultValue);
        } else {
            jsonAttributeDef.put("value", defaultValue);
        }
    }

    public static String getFromJSONString(HttpServletRequest request, String stringJSON, PropertyDescriptionList propertyDescriptionList, MessageResources resources, Locale locale, boolean isAndSearch) throws IOException {
        String methodName = "getFromJSONString";
        Logger.logEntry(P8AttributesMediator.class, methodName, (ServletRequest)request);
        Logger.logDebug(P8AttributesMediator.class, methodName, (ServletRequest)request, "stringJSON = " + stringJSON);
        String sqlString = "";
        try {
            JSONObject jsonObject = JSONObject.parse(stringJSON);
            JSONArray criteriasJsonArray = (JSONArray)jsonObject.get("criterias");
            JSONObject criteria = null;
            Logger.logDebug(P8AttributesMediator.class, methodName, (ServletRequest)request, "criteriasJsonArray.length()" + criteriasJsonArray.size());
            for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
                criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
                String criteriaName = criteria.get("name").toString();
                Logger.logDebug(P8AttributesMediator.class, methodName, (ServletRequest)request, "criteriaName : " + criteriaName);
                PropertyDescription propertyDescription = null;
                for (int i = 0; i < propertyDescriptionList.size() && propertyDescription == null; ++i) {
                    PropertyDescription tpropertyDescription = (PropertyDescription)propertyDescriptionList.get(i);
                    Logger.logDebug(P8AttributesMediator.class, methodName, (ServletRequest)request, "tpropertyDescription.get_Name() = " + tpropertyDescription.get_Name());
                    if (!tpropertyDescription.get_Name().equals(criteriaName)) continue;
                    propertyDescription = tpropertyDescription;
                }
                String displayOperator = criteria.get("operator").toString();
                String queryOperator = P8AttributesMediator.getOperatorFromDisplayValue(displayOperator.trim(), resources, locale);
                Logger.logDebug(P8AttributesMediator.class, methodName, (ServletRequest)request, "displayOperator : " + displayOperator);
                Logger.logDebug(P8AttributesMediator.class, methodName, (ServletRequest)request, "queryOperator : " + queryOperator);
                JSONArray valuesJsonArray = (JSONArray)criteria.get("values");
                String[] tempValuesArray = new String[valuesJsonArray.size()];
                for (int iValuesCounter = 0; iValuesCounter < valuesJsonArray.size(); ++iValuesCounter) {
                    String value = (String)valuesJsonArray.get(iValuesCounter);
                    Logger.logDebug(P8AttributesMediator.class, methodName, (ServletRequest)request, "value : " + value);
                    tempValuesArray[iValuesCounter] = value = P8AttributesMediator.replaceWildCardChars(value, queryOperator);
                    Logger.logDebug(P8AttributesMediator.class, methodName, (ServletRequest)request, "value" + iValuesCounter + " = " + value);
                }
                String queryCriteria = P8AttributesMediator.buildQueryCriteria(request, propertyDescription.get_SymbolicName(), queryOperator, tempValuesArray);
                Logger.logDebug(P8AttributesMediator.class, methodName, (ServletRequest)request, "queryCriteria : " + queryCriteria);
                if (sqlString.trim().length() > 0) {
                    if (queryCriteria.trim().length() <= 0) continue;
                    if (isAndSearch) {
                        sqlString = sqlString + " " + " AND " + " " + queryCriteria;
                        continue;
                    }
                    sqlString = sqlString + " " + " OR " + " " + queryCriteria;
                    continue;
                }
                sqlString = queryCriteria;
            }
            Logger.logDebug(P8AttributesMediator.class, methodName, (ServletRequest)request, "sqlString : " + sqlString);
        }
        catch (NumberFormatException e) {
            Logger.logError(P8AttributesMediator.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit(P8AttributesMediator.class, methodName, (ServletRequest)request);
        return sqlString;
    }

    private static String buildQueryCriteria(HttpServletRequest request, String criteriaName, String queryOperator, String[] valuesArray) {
        String methodName = "buildQueryCriteria";
        Logger.logEntry(P8AttributesMediator.class, methodName, (ServletRequest)request);
        String criteriaStatement = "";
        if (valuesArray.length > 0) {
            Logger.logInfo(P8AttributesMediator.class, methodName, (ServletRequest)request, "criteriaName = " + criteriaName + " queryOperator= " + queryOperator + " valuesArray[0]=" + valuesArray[0]);
        } else {
            Logger.logInfo(P8AttributesMediator.class, methodName, (ServletRequest)request, "criteriaName = " + criteriaName + " queryOperator= " + queryOperator + " valuesArray[0]=");
        }
        if (criteriaName != null && criteriaName.length() > 0) {
            if (valuesArray.length > 0 && valuesArray[0].length() > 0) {
                if (queryOperator.equals("IN") || queryOperator.equals("NOTIN")) {
                    criteriaStatement = criteriaName + " " + queryOperator + " (";
                    String[] valueSet = valuesArray[0].split(",");
                    for (int i = 0; i < valueSet.length; ++i) {
                        criteriaStatement = criteriaStatement + "'" + valueSet[i].trim() + "',";
                    }
                    criteriaStatement = criteriaStatement.subSequence(0, criteriaStatement.length() - 1) + ")";
                } else {
                    criteriaStatement = queryOperator.equals("BETWEEN") || queryOperator.equals("NOTBETWEEN") ? criteriaName + " " + queryOperator + " ('" + valuesArray[0] + "','" + valuesArray[1] + "')" : criteriaName + " " + queryOperator + " " + "'" + valuesArray[0] + "'";
                }
            } else if (queryOperator.equals("NULL") || queryOperator.equals("NOTNULL")) {
                criteriaStatement = criteriaName + " " + queryOperator;
            }
        }
        Logger.logInfo(P8AttributesMediator.class, methodName, (ServletRequest)request, "criteriaStatement = " + criteriaStatement);
        Logger.logExit(P8AttributesMediator.class, methodName, (ServletRequest)request);
        return criteriaStatement;
    }

    private static String replaceWildCardChars(String value, String operator) {
        if (operator.equalsIgnoreCase("LIKE") || operator.equalsIgnoreCase("NOTLIKE")) {
            value = value.replace('*', '%');
            value = value.replace('?', '_');
        }
        return value;
    }

    private static String getOperatorFromDisplayValue(String operator, MessageResources resources, Locale locale) {
        String op = null;
        if (operator.equalsIgnoreCase("EQUAL")) {
            op = "=";
        } else if (operator.equalsIgnoreCase("NOTEQUAL")) {
            op = "!=";
        } else if (operator.equalsIgnoreCase("LIKE")) {
            op = "LIKE";
        } else if (operator.equalsIgnoreCase("NOTLIKE")) {
            op = "NOT LIKE";
        } else if (operator.equalsIgnoreCase("NOTIN")) {
            op = "NOT IN";
        } else if (operator.equalsIgnoreCase("NULL")) {
            op = "IS NULL";
        } else if (operator.equalsIgnoreCase("NOTNULL")) {
            op = "IS NOT NULL";
        } else if (operator.equalsIgnoreCase("CONTAINS")) {
            op = "contains-text-basic";
        } else if (operator.equalsIgnoreCase("IN")) {
            op = "IN";
        } else if (operator.equalsIgnoreCase("LESS")) {
            op = "<";
        } else if (operator.equalsIgnoreCase("LESSOREQUAL")) {
            op = "<=";
        } else if (operator.equalsIgnoreCase("GREATEROREQUAL")) {
            op = ">=";
        } else if (operator.equalsIgnoreCase("GREATER")) {
            op = ">";
        } else if (operator.equalsIgnoreCase("BETWEEN")) {
            op = "BETWEEN";
        } else if (operator.equalsIgnoreCase("NOTBETWEEN")) {
            op = "NOT BETWEEN";
        }
        return op;
    }

    public String[] getOperatorSymbols(PropertyDescription loopCriteria, MessageResources resources, Locale locale) {
        String methodName = "getOperatorSymbols";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        ArrayList<String> arrayListReturn = new ArrayList<String>(15);
        String dataType = P8Util.getDataType(loopCriteria);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "name = " + loopCriteria.get_DisplayName());
        if (dataType.equals("xs:boolean")) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = xs:boolean");
            arrayListReturn.add("EQUAL");
            arrayListReturn.add("NOTEQUAL");
        } else if (dataType.equals("xs:guid")) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = xs:guid");
            arrayListReturn.add("NULL");
            arrayListReturn.add("NOTNULL");
            arrayListReturn.add("EQUAL");
            arrayListReturn.add("NOTEQUAL");
        } else if (dataType.equals("xs:date") || dataType.equals("xs:time") || dataType.equals("xs:timestamp")) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = xs:date");
            arrayListReturn.add("EQUAL");
            arrayListReturn.add("NOTEQUAL");
            arrayListReturn.add("LESS");
            arrayListReturn.add("LESSOREQUAL");
            arrayListReturn.add("GREATER");
            arrayListReturn.add("GREATEROREQUAL");
            arrayListReturn.add("BETWEEN");
            arrayListReturn.add("NOTBETWEEN");
        } else if (dataType.equals("xs:double") || dataType.equals("xs:long")) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = xs:double || xs:long");
            arrayListReturn.add("EQUAL");
            arrayListReturn.add("NOTEQUAL");
            arrayListReturn.add("IN");
            arrayListReturn.add("NOTIN");
            arrayListReturn.add("LESS");
            arrayListReturn.add("LESSOREQUAL");
            arrayListReturn.add("GREATER");
            arrayListReturn.add("GREATEROREQUAL");
            arrayListReturn.add("BETWEEN");
            arrayListReturn.add("NOTBETWEEN");
        } else if (dataType.equals("xs:string")) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = xs:string");
            arrayListReturn.add("EQUAL");
            arrayListReturn.add("NOTEQUAL");
            arrayListReturn.add("LIKE");
            arrayListReturn.add("NOTLIKE");
        }
        return arrayListReturn.toArray(new String[0]);
    }

    public String getFormat(PropertyDescription criteria) {
        String methodName = "getFormat";
        Logger.logEntry(P8AttributesMediator.class, methodName, (ServletRequest)this.request);
        String type = P8Util.getDataType(criteria);
        String returnFormat = null;
        if (!(type.equals("xs:date") || type.equals("xs:timestamp") || type.equals("xs:time"))) {
            if (type.equals("xs:decimal")) {
                returnFormat = "";
            } else if (criteria.get_SymbolicName().equals("ContentSize")) {
                returnFormat = "fileSize";
            }
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "returned Format [" + criteria.get_Name() + "]: " + returnFormat);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return returnFormat;
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }

    public void addClassDescription(ClassDescription classDescription) {
        if (this.classDescList == null) {
            this.classDescList = new ArrayList<ClassDescription>();
        }
        this.classDescList.add(classDescription);
    }

    public void addSecurityPolicy(String className, P8SecurityPolicy secPol) {
        if (this.securityPolicies == null) {
            this.securityPolicies = new HashMap<String, P8SecurityPolicy>();
        }
        this.securityPolicies.put(className, secPol);
    }

    public void addAlternateChoiceList(String propertyName, String choiceListId) {
        if (this.alternateChoiceLists == null) {
            this.alternateChoiceLists = new HashMap<String, String>();
        }
        this.alternateChoiceLists.put(propertyName, choiceListId);
    }

    public boolean hasAlternateChoiceList(String propertyName) {
        if (this.alternateChoiceLists == null) {
            return false;
        }
        return this.alternateChoiceLists.get(propertyName) != null;
    }

    public String getAlternateChoiceList(String propertyName) {
        if (this.alternateChoiceLists == null) {
            return null;
        }
        return this.alternateChoiceLists.get(propertyName);
    }

    private void addClassJSONInfo(JSONObject jsonObject) {
        block4: {
            block3: {
                if (this.classDescList != null && this.classDescList.size() != 0) break block3;
                jsonObject.put("template_name", this.getClassId());
                jsonObject.put("template_label", this.getClassDisplayName());
                jsonObject.put("template_desc", this.getFolderDescription());
                if (this.allowsInstances != null) {
                    jsonObject.put("allowsInstances", this.allowsInstances.toString());
                }
                if (!this.includeAuthoringAttributes) break block4;
                if (this.permissionDescList != null && this.permissionDescList.size() > 0) {
                    jsonObject.put("permissions_desc", this.accesPermissionsToJSONArray(this.permissionDescList));
                }
                if (this.securityPolicy == null) break block4;
                jsonObject.put("parm_securitypolicy", this.securityPolicy.toJSONObject());
                break block4;
            }
            jsonObject.putAll(this.classInfoToJSONMap(this.classDescList.get(0)));
            for (int i = 0; i < this.classDescList.size(); ++i) {
                JSONObject jsonEntity = new JSONObject();
                jsonEntity.putAll(this.classInfoToJSONMap(this.classDescList.get(i)));
                JSONUtils.accumulate(jsonObject, "classes", jsonEntity);
            }
        }
    }

    private Map<String, Object> classInfoToJSONMap(ClassDescription classDesc) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("template_name", classDesc.get_SymbolicName());
        properties.put("template_label", classDesc.get_DisplayName());
        properties.put("template_desc", classDesc.get_DescriptiveText());
        properties.put("allowsInstances", Boolean.toString(P8Util.classAllowsInstances(this.objectStore, classDesc)));
        if (this.includeAuthoringAttributes) {
            P8SecurityPolicy secPol;
            List<AccessPermissionDescription> permDescs = P8Util.getPermissionsDescriptions(classDesc);
            properties.put("permissions_desc", this.accesPermissionsToJSONArray(permDescs));
            if (this.securityPolicies != null && (secPol = this.securityPolicies.get(classDesc.get_SymbolicName())) != null) {
                properties.put("parm_securitypolicy", secPol.toJSONObject());
            }
        }
        return properties;
    }

    private boolean isMultipleClassesMode() {
        return this.classDescList != null && this.classDescList.size() > 1;
    }

    public void addTextSearchableProperty(String propertyName) {
        if (this.textSearchableProps == null) {
            this.textSearchableProps = new HashSet<String>();
        }
        this.textSearchableProps.add(propertyName);
    }

    private boolean isPropertyTextSearchable(PropertyDescription prop) {
        boolean textSearchable = ((PropertyDescriptionString)prop).get_IsCBREnabled();
        if (!textSearchable && this.isMultipleClassesMode() && this.textSearchableProps != null) {
            String propName = prop.get_SymbolicName();
            return this.textSearchableProps.contains(propName);
        }
        return textSearchable;
    }
}

