/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.p8;

import com.filenet.api.core.Document;
import com.filenet.api.util.UserContext;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.p8.P8Annotation;
import com.ibm.ecm.util.p8.P8AnnotationExporter;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.json.java.JSONObject;
import com.ibm.json.xml.XMLToJSONTransformer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;
import org.xml.sax.SAXException;

public class P8AnnotationsMediator
extends BaseMediator {
    private static final long serialVersionUID = 1L;
    private static final String ANNOTATIONS_KEY = "annotations";
    private Document document;
    private P8Connection connection;
    private JSONObject annotationObject = null;

    public P8AnnotationsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = super.toJSONObject();
        if (this.annotationObject != null) {
            jsonObject.put(ANNOTATIONS_KEY, this.annotationObject);
        }
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        if (jsonObject.containsKey(ANNOTATIONS_KEY)) {
            this.annotationObject = (JSONObject)jsonObject.get(ANNOTATIONS_KEY);
        }
    }

    public void setDocument(P8Connection connection, Document document) {
        String methodName = "setDocument";
        this.connection = connection;
        this.document = document;
        try {
            if (this.annotationObject == null && connection != null) {
                byte[] byteData = this.getAnnotationsXml().getBytes("UTF8");
                ByteArrayInputStream bais = new ByteArrayInputStream(byteData);
                String jsonString = XMLToJSONTransformer.transform(bais);
                this.annotationObject = JSONObject.parse(jsonString);
            }
        }
        catch (UnsupportedEncodingException uee) {
            this.addError("error.exception.general", uee.getMessage());
            Logger.logError((Object)this, methodName, "Annotation XML encoding", (Throwable)uee);
        }
        catch (IOException ioe) {
            this.addError("error.exception.general", ioe.getMessage());
            Logger.logError((Object)this, methodName, "Unable to parse JSON", (Throwable)ioe);
        }
        catch (SAXException se) {
            this.addError("error.exception.general", se.getMessage());
            Logger.logError((Object)this, methodName, "Invalid annotation XML", (Throwable)se);
        }
    }

    public JSONObject getAnnotations() {
        return this.annotationObject;
    }

    private String getAnnotationsXml() {
        String annotationsXml = null;
        if (this.connection != null) {
            UserContext uc = UserContext.get();
            uc.pushSubject(this.connection.getSubject());
            List<P8Annotation> p8Annotations = P8Annotation.getDocumentAnnotations(this.request, this.connection, this.document);
            P8AnnotationExporter annotationExporter = new P8AnnotationExporter(p8Annotations);
            annotationsXml = annotationExporter.getAnnotationXml().toString();
            uc.popSubject();
        }
        return annotationsXml;
    }
}

