/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.od;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.edms.od.ODUser;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class ODServerPrinterMediator
extends BaseMediator {
    HashMap printers = null;
    ODUser user = null;

    public ODServerPrinterMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public HashMap getPrinters() {
        if (this.printers == null) {
            this.printers = new HashMap(0);
        }
        return this.printers;
    }

    public void setPrinters(HashMap printers) {
        this.printers = printers;
    }

    public void addPrinter(String printerName, char printerType) {
        this.getPrinters().put(printerName, new Character(printerType));
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        if (this.user != null) {
            String printerName;
            try {
                printerName = this.user.getPrinter();
            }
            catch (Exception e) {
                printerName = "";
            }
            if (printerName == null) {
                printerName = "";
            }
            jsonObject.put("user_printer", printerName);
            jsonObject.put("user_printclass", this.user.getPrintClass());
            jsonObject.put("user_printrouting", this.user.getPrintRouting());
            jsonObject.put("user_printpagedef", this.user.getPrintPageDef());
            jsonObject.put("user_printnode", this.user.getPrintNode());
            jsonObject.put("user_printwriter", this.user.getPrintWriter());
            jsonObject.put("user_printformdef", this.user.getPrintFormDef());
            jsonObject.put("user_printerid", this.user.getPrinterID());
            jsonObject.put("user_printforms", this.user.getPrintForms());
            jsonObject.put("user_printbanner", this.user.getPrintBanner());
            jsonObject.put("faxSenderName", this.user.getFullName());
            jsonObject.put("faxSenderCompany", this.user.getCompany());
            jsonObject.put("faxSenderTelNumber", this.user.getPhone());
            jsonObject.put("faxSenderNumber", this.user.getFax());
            jsonObject.put("faxCoverPage", this.user.getCoverPage());
        }
        JSONObject printerObject = null;
        ArrayList printers = new ArrayList(this.getPrinters().entrySet());
        Collections.sort(printers, new Comparator<Map.Entry>(){

            @Override
            public int compare(Map.Entry e1, Map.Entry e2) {
                return e1.getKey().toString().compareToIgnoreCase(e2.getKey().toString());
            }
        });
        for (Map.Entry entry : printers) {
            printerObject = new JSONObject();
            printerObject.put("printer", entry.getKey().toString());
            printerObject.put("printerType", entry.getValue().toString());
            JSONUtils.accumulate(jsonObject, "printers", printerObject);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, new StringBuffer("Returning JSON:").append(jsonObject.toString()).toString());
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
    }

    public ODUser getUser() {
        return this.user;
    }

    public void setUser(ODUser user) {
        this.user = user;
    }
}

