/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.od;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.json.TableView;
import com.ibm.ecm.mediator.ResultSetMediator;
import com.ibm.ecm.mediator.od.ODHitMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.ColumnUtil;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.ecm.util.od.ODSearchResultsBean;
import com.ibm.ecm.util.od.ODUtil;
import com.ibm.edms.od.ODCriteria;
import com.ibm.edms.od.ODFolder;
import com.ibm.edms.od.ODHit;
import com.ibm.edms.od.ODServer;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class ODSearchResultsMediator
extends ResultSetMediator {
    public ODSearchResultsBean searchResultsBean = null;
    public ODServer server = null;
    public String folderDescription = null;
    private JSONObject sortJsonObject = new JSONObject();
    public ODFolder folder = null;
    public String searchMessage = null;
    public boolean showDocLocation = false;
    public int pageSize = 50;
    private boolean allow_unknown = true;
    public int sortIndex = -1;
    private HashMap columnSizes = new HashMap();
    private HashMap uniqueDates = new HashMap();
    public int sortDirection = 1;
    public boolean showNotesIcon = true;
    private boolean annotationsByDefault = false;
    private HashMap updatedDocIds = null;
    private int timezoneAdjust = 0;

    public boolean isAllow_unknown() {
        return this.allow_unknown;
    }

    public void setAllow_unknown(boolean allow_unknown) {
        this.allow_unknown = allow_unknown;
    }

    public ODSearchResultsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setTimezoneAdjust(int millis) {
        this.timezoneAdjust = millis;
    }

    public ODSearchResultsBean getSearchResultsBean() {
        return this.searchResultsBean;
    }

    public void setSearchResultsBean(ODSearchResultsBean searchResultsBean) {
        this.searchResultsBean = searchResultsBean;
    }

    public ODFolder getFolder() {
        return this.folder;
    }

    public void setFolder(ODFolder folder) {
        this.folder = folder;
    }

    public String getSearchMessage() {
        return this.searchMessage;
    }

    public void setSearchMessage(String searchMessage) {
        this.searchMessage = searchMessage;
    }

    public boolean hasAnnotationsByDefault() {
        return this.annotationsByDefault;
    }

    public void setAnnotationsByDefault(boolean annotationsByDefault) {
        this.annotationsByDefault = annotationsByDefault;
    }

    public void setShowDocLocation(boolean showDocLocation) {
        this.showDocLocation = showDocLocation;
    }

    public boolean getShowDocLocation() {
        return this.showDocLocation;
    }

    public boolean getShowNotesIcon() {
        return this.showNotesIcon;
    }

    public void setShowNotesIcon(boolean showNotesIcon) {
        this.showNotesIcon = showNotesIcon;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        try {
            if (this.getFolder() != null) {
                jsonObject.put("template_name", this.getFolder().getName());
            }
            jsonObject.put("template_label", this.getFolderDescription());
            jsonObject.put("sortformats", this.sortJsonObject);
            int iNumResults = 0;
            if (this.getSearchResultsBean() != null) {
                iNumResults = this.getSearchResultsBean().size();
                JSONUtils.put(jsonObject, "num_results", iNumResults);
                JSONUtils.put(jsonObject, "showLocation", this.getShowDocLocation());
                JSONUtils.put(jsonObject, "showNotesIcon", this.getShowNotesIcon());
                JSONUtils.put(jsonObject, "pageSize", this.getPageSize());
                JSONUtils.put(jsonObject, "sortIndex", this.getSortIndex());
                JSONUtils.put(jsonObject, "sortDirection", this.getSortDirection());
                JSONObject jsonDates = new JSONObject();
                jsonDates.putAll(this.uniqueDates);
                jsonObject.put("dates", jsonDates);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            this.addError("error.exception.general", e.getMessage());
        }
        return jsonObject;
    }

    private void putColumnSize(String index, int size) {
        Integer tempValue = (Integer)this.columnSizes.get(index);
        if (tempValue != null) {
            int value = tempValue;
            if (value < size) {
                this.columnSizes.put(index, new Integer(size));
            }
        } else {
            if (size < 5) {
                size = 5;
            }
            this.columnSizes.put(index, new Integer(size));
        }
    }

    public JSONObject toJSONObject(String origDocid, String newDocid) {
        String methodName = "toJSONObject";
        JSONObject jsonObject = this.toJSONObject();
        if (this.getFolder() != null) {
            jsonObject.put("template_name", this.getFolder().getName());
        }
        jsonObject.put("template_label", this.getFolderDescription());
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, new StringBuffer("search results size: ").append(this.getSearchResultsBean() != null ? String.valueOf(this.getSearchResultsBean().size()) : "0").toString());
        jsonObject.put("origdocid", origDocid);
        jsonObject.put("docid", newDocid);
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
    }

    private String getMimeType(ODHit odHit) {
        String mimeType = odHit.getMimeType();
        int extIndex = mimeType.indexOf("extension-field=");
        if (extIndex != -1) {
            String itemMimeExtension = odHit.getMimeType().substring(extIndex + 16);
            mimeType = MimeTypeUtil.getMimeType(itemMimeExtension);
        }
        return mimeType;
    }

    protected JSONArray buildTableRows() throws Exception {
        String methodName = "buildTableRows";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONArray jsonRows = new JSONArray();
        if (this.getFolder() != null && this.getSearchResultsBean() != null) {
            this.getSearchResultsBean().reset();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Starting to build json rows from hits");
            ODHitMediator hitMediator = new ODHitMediator(this.request, this.messageResources, this.locale);
            hitMediator.setFolder(this.folder);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "isAllow_unknown() = " + this.isAllow_unknown());
            Vector tempHitList = this.getSearchResultsBean().getHits();
            for (int iHitCounter = 0; iHitCounter < tempHitList.size(); ++iHitCounter) {
                String encodedDocId;
                ODHit tempHit = (ODHit)tempHitList.get(iHitCounter);
                hitMediator.setHit(tempHit);
                JSONObject jsonHit = hitMediator.toJSONObject();
                String mimeType = this.getMimeType(tempHit);
                String docId = tempHit.getDocId();
                String[] criteriaDisplayOrdered = this.getFolder().getDisplayOrder();
                try {
                    encodedDocId = this.wrapperText(URLEncoder.encode(docId, "UTF-8"));
                }
                catch (UnsupportedEncodingException e1) {
                    encodedDocId = this.wrapperText(URLEncoder.encode(docId));
                }
                jsonHit.put("hasNote", (Object)(this.hasAnnotationsByDefault() || tempHit.getNoteStatus() == 1 ? 1 : 0));
                if (this.getUpdatedDocIds().containsKey(docId)) {
                    String origdocid = (String)this.getUpdatedDocIds().get(docId);
                    jsonHit.put("origdocid", origdocid);
                }
                jsonHit.put("template", this.getFolder().getName());
                jsonHit.put("mimetype", mimeType.trim());
                jsonHit.put("hasHold", (Object)tempHit.isOnHold());
                jsonRows.add(jsonHit);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonRows;
    }

    protected JSONArray buildMagazineViewColumns() {
        JSONArray columns = new JSONArray();
        JSONObject thumbnail = new JSONObject();
        thumbnail.put("field", "thumbnail");
        thumbnail.put("name", "");
        thumbnail.put("width", "60px");
        thumbnail.put("decorator", "MagazineViewDecorator.thumbnailDecorator");
        columns.add(thumbnail);
        JSONObject content = new JSONObject();
        content.put("field", "content");
        content.put("name", "");
        content.put("decorator", "MagazineViewDecorator.contentCellDecoratorOD");
        columns.add(content);
        return columns;
    }

    protected JSONObject buildTableColumns() throws Exception {
        String methodName = "buildTableColums";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        OdSortRules odSortRules = new OdSortRules();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Starting to build columns from criteria");
        String[] criteriaDisplayOrdered = this.getFolder().getDisplayOrder();
        ODCriteria tempCriteria = null;
        String dateFormat = "%m/%d/%Y";
        String timeFormat = "hh:mm:ss";
        TableView view1 = new TableView();
        TableView.ColumnSet set1 = view1.createColumnSet();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Starting to build columns from criteria");
        if (!this.getShowDocLocation()) {
            set1.addColumnProperty(ColumnUtil.buildStateColumnProperty(this.request, "&nbsp;", "multiStateIcon", true, false, false), true);
            set1.addColumnProperty(ColumnUtil.buildColumnProperty("&nbsp;", "17px", "mimeTypeIcon", null, true), true);
        } else {
            set1.addColumnProperty(ColumnUtil.buildStateColumnProperty(this.request, "&nbsp;", "multiStateIcon", true, false, false), true);
            set1.addColumnProperty(ColumnUtil.buildColumnProperty("&nbsp;", "17px", "mimeTypeIcon", null, true), true);
        }
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriaDisplayOrdered.length; ++iCriteriaCounter) {
            tempCriteria = this.getFolder().getCriteria(criteriaDisplayOrdered[iCriteriaCounter]);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, new StringBuffer("Processing criteria - ").append(criteriaDisplayOrdered[iCriteriaCounter]).toString());
            String criteriaName = criteriaDisplayOrdered[iCriteriaCounter].trim();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "criteria name - " + criteriaName);
            String type = ODUtil.getCriteriaType(tempCriteria, "");
            boolean isDateTime = type.equals("xs:date") || type.equals("xs:time") || type.equals("xs:timestamp");
            boolean isNumeric = type.equals("xs:decimal") || type.equals("xs:double") || type.equals("xs:integer") || type.equals("xs:short") || type.equals("xs:long");
            Integer columnSize = (Integer)this.columnSizes.get(criteriaName.replace('.', '_'));
            String width = ColumnUtil.getColumnWidth(criteriaName.length(), columnSize != null ? columnSize : -1, isDateTime, isNumeric);
            if (type != null && (type.equals("xs:decimal") || type.equals("xs:double") || type.equals("xs:integer") || type.equals("xs:short") || type.equals("xs:long"))) {
                set1.addColumnProperty(new String[][]{{"name", criteriaName}, {"width", width}, {"field", criteriaName.replace('.', '_')}, {"styles", "text-align:right;"}});
            } else {
                set1.addColumnProperty(new String[][]{{"name", criteriaName}, {"width", width}, {"field", criteriaName.replace('.', '_')}});
            }
            if (type.equals("xs:date")) {
                dateFormat = tempCriteria.getDisplayFmt();
                this.sortJsonObject.put(criteriaName.replace('.', '_'), "dateSort");
            } else if (type.equals("xs:time") || type.equals("xs:timestamp")) {
                this.sortJsonObject.put(criteriaName.replace('.', '_'), "timeSort");
                timeFormat = tempCriteria.getDisplayFmt();
            } else if (type != null && (type.equals("xs:decimal") || type.equals("xs:double") || type.equals("xs:integer") || type.equals("xs:short") || type.equals("xs:long"))) {
                this.sortJsonObject.put(criteriaName.replace('.', '_'), "numberSort");
            } else {
                this.sortJsonObject.put(criteriaName.replace('.', '_'), "stringSort");
            }
            if (iCriteriaCounter + 1 == criteriaDisplayOrdered.length) {
                // empty if block
            }
            if (odSortRules.getFirstSortCriteriaName() == null || !tempCriteria.getName().equals(odSortRules.getFirstSortCriteriaName())) continue;
            this.sortIndex = iCriteriaCounter + 2;
            if (odSortRules.isFirstSortCriteriaAscending()) continue;
            this.sortDirection = -1;
        }
        if (this.sortIndex < 0) {
            this.sortDirection = 0;
        }
        this.sortJsonObject.put("dataFormat", dateFormat);
        this.sortJsonObject.put("timeFormat", timeFormat);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "SortCrit Name='" + odSortRules.getFirstSortCriteriaName() + "' [" + this.getSortIndex() + "], Direction=" + this.getSortDirection());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Finished  building columns from criteria");
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return view1.toJson();
    }

    private String getDisplayFormat(ODCriteria criteria) {
        char type = criteria.getType();
        String odFormat = criteria.getDisplayFmt();
        String displayFormat = "";
        switch (type) {
            case 'T': {
                if (!odFormat.equals("%T")) break;
                displayFormat = "hh:mm:ss";
                break;
            }
            default: {
                displayFormat = odFormat;
            }
        }
        return displayFormat;
    }

    public String toCSVString() {
        String methodName = "toCSV";
        String csvDelim = ",";
        StringBuffer csvString = new StringBuffer();
        String newLine = System.getProperty("line.seperator");
        if (newLine == null) {
            newLine = "\n";
        }
        if (this.getFolder() != null && this.getSearchResultsBean() != null) {
            Logger.logDebug((Object)this, "toCSV", (ServletRequest)this.request, "SearchResults size=" + this.getSearchResultsBean().size());
            String[] criteriaDisplayOrdered = this.getFolder().getDisplayOrder();
            for (int iCriteriaCounter = 0; iCriteriaCounter < criteriaDisplayOrdered.length; ++iCriteriaCounter) {
                Logger.logDebug((Object)this, "toCSV", (ServletRequest)this.request, new StringBuffer("Processing criteria - ").append(criteriaDisplayOrdered[iCriteriaCounter]).toString());
                String encodedName = criteriaDisplayOrdered[iCriteriaCounter];
                encodedName = encodedName.replaceAll("\"", "\"\"");
                Logger.logDebug((Object)this, "toCSV", (ServletRequest)this.request, new StringBuffer("Encoded criteria name - ").append(encodedName).toString());
                csvString.append("\"").append(encodedName).append("\"");
                if (iCriteriaCounter + 1 >= criteriaDisplayOrdered.length) continue;
                csvString.append(",");
            }
            csvString.append(newLine);
            this.getSearchResultsBean().reset();
            ODHit tempHit = null;
            while (this.getSearchResultsBean().hasMoreElements()) {
                tempHit = (ODHit)this.getSearchResultsBean().nextElement();
                for (int iCriteriaCounter = 0; iCriteriaCounter < criteriaDisplayOrdered.length; ++iCriteriaCounter) {
                    String value = tempHit.getDisplayValue(criteriaDisplayOrdered[iCriteriaCounter]);
                    value = value.replaceAll("\"", "\"\"");
                    csvString.append("\"").append(value).append("\"");
                    if (iCriteriaCounter + 1 >= criteriaDisplayOrdered.length) continue;
                    csvString.append(",");
                }
                Logger.logDebug((Object)this, "toCSV", (ServletRequest)this.request, " appending new line char " + newLine);
                csvString.append(newLine);
            }
        }
        return csvString.toString();
    }

    private String wrapperText(String text) {
        return text.replaceAll("&", "&amp;");
    }

    public String getFolderDescription() {
        return this.folderDescription;
    }

    public void setFolderDescription(String folderDescription) {
        this.folderDescription = folderDescription;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public ODServer getServer() {
        return this.server;
    }

    public void setServer(ODServer server) {
        this.server = server;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(int sortDirection) {
        this.sortDirection = sortDirection;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public HashMap getUpdatedDocIds() {
        if (this.updatedDocIds == null) {
            this.updatedDocIds = new HashMap(1);
        }
        return this.updatedDocIds;
    }

    public void setUpdatedDocIds(HashMap updatedDocIds) {
        this.updatedDocIds = updatedDocIds;
    }

    public class OdSortRules {
        private String firstSortCriteriaName = null;
        private boolean firstSortCriteriaAscending = true;

        public OdSortRules() {
            ArrayList folderSortCriteria = ODSearchResultsMediator.this.getFolder().getFolderSortOrder();
            ODCriteria firstSortCritera = null;
            if (folderSortCriteria != null && !folderSortCriteria.isEmpty()) {
                for (int count = 0; count < folderSortCriteria.size(); ++count) {
                    if (((ODCriteria)folderSortCriteria.get(count)).getSortOrder() != 1 || (firstSortCritera = (ODCriteria)folderSortCriteria.get(count)) == null) continue;
                    this.setFirstSortCriteriaName(firstSortCritera.getName());
                    this.setFirstSortCriteriaAscending(firstSortCritera.getAscending());
                    break;
                }
            }
        }

        public void setFirstSortCriteriaName(String _firstSortCriteriaName) {
            this.firstSortCriteriaName = _firstSortCriteriaName;
        }

        public boolean isFirstSortCriteriaAscending() {
            return this.firstSortCriteriaAscending;
        }

        public void setFirstSortCriteriaAscending(boolean firstSortCriteriaAscending) {
            this.firstSortCriteriaAscending = firstSortCriteriaAscending;
        }

        public String getFirstSortCriteriaName() {
            return this.firstSortCriteriaName;
        }
    }
}

