/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.od;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.od.ODCriteriaBean;
import com.ibm.ecm.util.od.ODUtil;
import com.ibm.edms.od.ODNamedQueryCriteria;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class ODNamedQueryMediator
extends BaseMediator {
    private static final long serialVersionUID = 1L;
    public String queryName = null;
    public String folderName = null;
    public String version = null;
    public Enumeration criterias = null;
    public boolean publicQuery = false;

    public ODNamedQueryMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected ODNamedQueryMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public Enumeration getCriterias() {
        if (this.criterias == null) {
            this.criterias = new Vector(0).elements();
        }
        return this.criterias;
    }

    public void setCriterias(Enumeration criterias) {
        this.criterias = criterias;
    }

    public void setCriterias(Vector criterias) {
        if (criterias != null) {
            this.criterias = criterias.elements();
        }
    }

    public boolean isPublicQuery() {
        return this.publicQuery;
    }

    public void setPublicQuery(boolean publicQuery) {
        this.publicQuery = publicQuery;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        jsonObject.put("template_name", this.getFolderName());
        jsonObject.put("query_name", this.getQueryName());
        JSONUtils.put(jsonObject, "query_public", this.isPublicQuery());
        jsonObject.put("odwek_version", this.getVersion());
        Enumeration enumNamedQueries = this.getCriterias();
        JSONObject jsonNamedQueryCriteria = null;
        ODNamedQueryCriteria tempCriteria = null;
        while (enumNamedQueries.hasMoreElements()) {
            tempCriteria = (ODNamedQueryCriteria)enumNamedQueries.nextElement();
            jsonNamedQueryCriteria = new JSONObject();
            jsonNamedQueryCriteria.put("name", tempCriteria.getName());
            jsonNamedQueryCriteria.put("operator", ODUtil.getOperand(tempCriteria.getOperator()));
            String[] searchValues = tempCriteria.getSearchValues();
            for (int iSearchValueCounter = 0; iSearchValueCounter < searchValues.length; ++iSearchValueCounter) {
                JSONUtils.accumulate(jsonNamedQueryCriteria, "values", searchValues[iSearchValueCounter]);
            }
            JSONUtils.accumulate(jsonObject, "saved_criterias", jsonNamedQueryCriteria);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        String methodName = "fromJSONObject";
        this.setQueryName(jsonObject.get("query_name").toString());
        this.setFolderName(jsonObject.get("template_name").toString());
        this.setQueryName(jsonObject.get("query_name").toString());
        this.setPublicQuery(new Boolean(jsonObject.get("query_public").toString()));
        Object obj = jsonObject.get("odwek_version");
        String odwekVersion = "";
        if (obj != null) {
            odwekVersion = obj.toString();
        }
        this.setVersion(odwekVersion);
        JSONArray savedCriteriasJsonArray = (JSONArray)jsonObject.get("saved_criterias");
        JSONObject savedCriteria = null;
        ODCriteriaBean criteriaHolder = null;
        Vector<ODCriteriaBean> criterias = new Vector<ODCriteriaBean>(savedCriteriasJsonArray.size());
        for (int iCriteriaCounter = 0; iCriteriaCounter < savedCriteriasJsonArray.size(); ++iCriteriaCounter) {
            savedCriteria = (JSONObject)savedCriteriasJsonArray.get(iCriteriaCounter);
            criteriaHolder = new ODCriteriaBean();
            String criteriaName = savedCriteria.get("name").toString();
            criteriaHolder.setCriteriaName(criteriaName);
            int currentOperator = ODUtil.getOperand(savedCriteria.get("operator").toString());
            criteriaHolder.setOperator(currentOperator);
            JSONArray valuesJsonArray = (JSONArray)savedCriteria.get("values");
            String[] tempValuesArray = new String[valuesJsonArray.size()];
            for (int iValuesCounter = 0; iValuesCounter < valuesJsonArray.size(); ++iValuesCounter) {
                tempValuesArray[iValuesCounter] = (String)valuesJsonArray.get(iValuesCounter);
            }
            criteriaHolder.setValues(tempValuesArray);
            criterias.add(criteriaHolder);
        }
        this.setCriterias(criterias);
        String outputString = jsonObject.toString();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, new StringBuffer("Returning JSON: ").append(outputString).toString());
    }

    public String toXML() {
        String methodName = "toXML";
        String xmlString = "";
        Logger.logDebug((Object)this, "toXML", (ServletRequest)this.request, new StringBuffer("Returning XML: ").append(xmlString).toString());
        return xmlString;
    }
}

