/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.od;

import com.ibm.ecm.mediator.LogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.od.ODRepositoryProfile;
import com.ibm.ecm.util.od.ODUtil;
import com.ibm.edms.od.ODServer;
import com.ibm.json.java.JSONObject;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.util.MessageResources;

public class ODLogonMediator
extends LogonMediator {
    public ODServer server = null;
    private boolean changePassword = false;

    public ODLogonMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public ODServer getServer() {
        return this.server;
    }

    public void setServer(ODServer server) {
        this.server = server;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        if (this.getServer() != null && !this.isChangePassword()) {
            Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Calling the getServer.getUserId   getServer=" + this.getServer() + "   isChangePassword=" + this.isChangePassword());
            jsonObject.put("userid", this.getServer().getUserId());
            boolean privCreateHold = false;
            if (this.server != null && this.server.isInitialized()) {
                privCreateHold = ODUtil.hasHoldPriv(this.request, this.getServer());
            }
            jsonObject.put("privCreateHold", (Object)privCreateHold);
            jsonObject.put("searchTemplateSupported", "true");
        } else {
            Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Skipping the the call for getServer.getUserId   getServer=" + this.getServer() + "   isChangePassword=" + this.isChangePassword());
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, new StringBuffer("Returning JSON: ").append(jsonObject.toString()).toString());
        return jsonObject;
    }

    public Hashtable getJSONRepoProfile() {
        String methodName = "getJSONRepoProfile";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Hashtable<String, Boolean> jsonHashTable = new Hashtable<String, Boolean>();
        StringBuffer sb = new StringBuffer();
        ODRepositoryProfile profile = new ODRepositoryProfile();
        try {
            Class<?> profileClass = profile.getClass();
            Method[] profileMethods = profileClass.getMethods();
            int j = 0;
            for (int i = 0; i < profileMethods.length; ++i) {
                String methodString = profileMethods[i].getName();
                String returnString = profileMethods[i].getReturnType().getName();
                Class<?>[] parameterTypes = profileMethods[i].getParameterTypes();
                if (parameterTypes.length != 0 || !returnString.equalsIgnoreCase("boolean") || !methodString.startsWith("get")) continue;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Passed filter: " + methodString);
                Method profileMethod = profileClass.getMethod(methodString, null);
                Boolean result = (Boolean)profileMethod.invoke((Object)profile, null);
                jsonHashTable.put(StringUtils.uncapitalise((String)methodString.substring(3)), result);
                ++j;
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonHashTable;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
    }

    public void setChangePassword(boolean changePassword) {
        this.changePassword = changePassword;
    }

    public boolean isChangePassword() {
        return this.changePassword;
    }
}

