/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.od;

import com.ibm.ecm.mediator.HitMediator;
import com.ibm.ecm.util.od.ODUtil;
import com.ibm.edms.od.ODCriteria;
import com.ibm.edms.od.ODFolder;
import com.ibm.edms.od.ODHit;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class ODHitMediator
extends HitMediator {
    private ODHit hit;
    private ODFolder folder;

    public ODHitMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setHit(ODHit hit) {
        this.hit = hit;
    }

    public void setFolder(ODFolder folder) {
        this.folder = folder;
    }

    public String getItemId() {
        return this.hit.getDocId();
    }

    public String getItemName() {
        return this.hit.getDocumentName();
    }

    public JSONObject buildAttributes() {
        JSONObject jsonAttributes = new JSONObject();
        String[] criteriaDisplayOrdered = this.folder.getDisplayOrder();
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriaDisplayOrdered.length; ++iCriteriaCounter) {
            ODCriteria tempCriteria = this.folder.getCriteria(criteriaDisplayOrdered[iCriteriaCounter]);
            String encodedName = tempCriteria.getName().replace('.', '_');
            JSONArray jsonAttributeInfo = new JSONArray();
            String dispValue = this.hit.getDisplayValue(criteriaDisplayOrdered[iCriteriaCounter]).trim();
            String type = ODUtil.getCriteriaType(tempCriteria, "");
            if (type != null && (type.equalsIgnoreCase("xs:date") || type.equalsIgnoreCase("xs:time") || type.equalsIgnoreCase("xs:timestamp"))) {
                dispValue = ODUtil.getISODateString(this.request, dispValue, tempCriteria.getDisplayFmt(), tempCriteria.getFieldQualifier() == 'Z');
            }
            jsonAttributeInfo.add(dispValue);
            jsonAttributeInfo.add(type);
            if (type.equalsIgnoreCase("xs:date")) {
                jsonAttributeInfo.add(ODUtil.getSimpleDateFormat(this.getDisplayFormat(tempCriteria)));
            } else if (type.equalsIgnoreCase("xs:time")) {
                jsonAttributeInfo.add(ODUtil.getSimpleDateFormat(this.getDisplayFormat(tempCriteria)));
            } else if (type.equalsIgnoreCase("xs:timestamp")) {
                jsonAttributeInfo.add(ODUtil.getSimpleDateFormat(this.getDisplayFormat(tempCriteria)));
            }
            this.putColumnSize(encodedName, dispValue.length());
            jsonAttributes.put(encodedName, jsonAttributeInfo);
        }
        return jsonAttributes;
    }

    public void putColumnSize(String index, int size) {
    }

    private String getDisplayFormat(ODCriteria criteria) {
        char type = criteria.getType();
        String odFormat = criteria.getDisplayFmt();
        String displayFormat = "";
        switch (type) {
            case 'T': {
                if (!odFormat.equals("%T")) break;
                displayFormat = "hh:mm:ss";
                break;
            }
            default: {
                displayFormat = odFormat;
            }
        }
        return displayFormat;
    }

    public boolean canEditProperties() {
        return this.hit.hasPermToUpdateDoc();
    }

    public boolean canEditDoc() {
        return this.hit.hasPermToUpdateDoc();
    }

    public boolean canViewNotes() {
        return this.hit.hasPermToViewNotes();
    }

    public boolean canAddDoc() {
        return false;
    }

    public boolean canAddItem() {
        return false;
    }

    public boolean canEmailDoc() {
        return this.hit.hasPermToViewDoc() && this.hit.hasPermToCopyFromDoc() && this.hit.getDocType() != 'N';
    }

    public boolean canExport() {
        return this.hit.hasPermToViewDoc() && this.hit.hasPermToCopyFromDoc();
    }

    public boolean canAddToFolder() {
        return false;
    }

    public boolean canRemoveFromFolder() {
        return false;
    }

    public boolean canAddLink() {
        return false;
    }

    public boolean canRemoveLink() {
        return false;
    }

    public boolean canAddNotes() {
        return this.hit.hasPermToAddNotes();
    }

    public boolean canPrintNotes() {
        return this.hit.hasPermToViewNotes();
    }

    public boolean canPrintDoc() {
        return this.hit.hasPermToPrintDoc();
    }

    public boolean canCheckInOutDoc() {
        return false;
    }

    public boolean canCheckInDoc() {
        return false;
    }

    public boolean canCheckOutDoc() {
        return false;
    }

    public boolean canCancelCheckOutDoc() {
        return false;
    }

    public boolean canViewAnnotations() {
        return false;
    }

    public boolean canEditAnnotations() {
        return false;
    }

    public boolean canViewDoc() {
        return this.hit.hasPermToViewDoc() && this.hit.getDocType() != 'N';
    }

    public boolean canDelete() {
        return false;
    }

    public boolean canStartWorkflow() {
        return false;
    }

    public boolean canHold() {
        try {
            return this.hit.canBeAddedToHold();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canMoveToFolder() {
        return false;
    }

    public boolean canChangeClass() {
        return false;
    }

    public boolean canMajorVersion() {
        return false;
    }

    public boolean canMinorVersion() {
        return false;
    }

    public boolean canDeclare() {
        return false;
    }
}

