/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.od;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.DocumentInfoMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.od.ODCriteriaBean;
import com.ibm.ecm.util.od.ODUtil;
import com.ibm.edms.od.ODCriteria;
import com.ibm.edms.od.ODFolder;
import com.ibm.edms.od.ODHit;
import com.ibm.edms.od.ODHitProperties;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class ODDocumentMediator
extends DocumentInfoMediator {
    private WCDateFormat wcDateFormat;
    public ODHit hit;
    public ODFolder folder;
    public String docID;
    public String formType;
    public boolean showFieldHoverHelp;
    protected Enumeration criterias;
    private int timezoneAdjust;

    public ODDocumentMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
        this.wcDateFormat = WCDateFormat.getDefaultDateFormats(this.request);
        this.hit = null;
        this.folder = null;
        this.docID = null;
        this.formType = null;
        this.showFieldHoverHelp = false;
        this.criterias = null;
        this.timezoneAdjust = 0;
        this.formType = "edit";
    }

    public void setTimezoneAdjust(int millis) {
        this.timezoneAdjust = millis;
    }

    protected ODDocumentMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
        this.wcDateFormat = WCDateFormat.getDefaultDateFormats(this.request);
        this.hit = null;
        this.folder = null;
        this.docID = null;
        this.formType = null;
        this.showFieldHoverHelp = false;
        this.criterias = null;
        this.timezoneAdjust = 0;
    }

    public ODHit getHit() {
        return this.hit;
    }

    public String getDocID() {
        return this.docID;
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }

    public ODFolder getFolder() {
        return this.folder;
    }

    public void setFolder(ODFolder folder) {
        this.folder = folder;
    }

    public void setHit(ODHit hit) {
        this.hit = hit;
    }

    public String getFormType() {
        if (this.formType == null) {
            this.formType = "search";
        }
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public Enumeration getCriterias() {
        return this.criterias;
    }

    public void setCriterias(Enumeration criterias) {
        this.criterias = criterias;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        if (this.getHit() != null) {
            jsonObject.put("template_name", this.getHit().getFolderName());
            jsonObject.put("template_label", this.getHit().getFolderName());
            jsonObject.put("template_desc", this.folder.getDescription());
            jsonObject.put("docid", this.getHit().getDocId());
            jsonObject.put("mimetype", this.getHit().getMimeType());
            jsonObject.put("file_ext", this.getHit().getFileExt());
            JSONUtils.put(jsonObject, "showFieldHoverHelp", this.getShowFieldHoverHelp());
            this.addSystemProperties(jsonObject);
            String[] criteriaDisplayOrdered = this.getFolder().getDisplayOrder();
            for (int i = 0; i < criteriaDisplayOrdered.length; ++i) {
                JSONObject jsonCriteria = new JSONObject();
                ODCriteria loopCriteria = this.getFolder().getCriteria(criteriaDisplayOrdered[i]);
                jsonCriteria.put("name", loopCriteria.getName());
                String dataType = ODUtil.getCriteriaType(loopCriteria, "");
                jsonCriteria.put("label", loopCriteria.getName());
                jsonCriteria.put("minValue", loopCriteria.getMinSearchValue() != null ? loopCriteria.getMinSearchValue() : "");
                jsonCriteria.put("maxValue", loopCriteria.getMaxSearchValue() != null ? loopCriteria.getMaxSearchValue() : "");
                JSONUtils.put(jsonCriteria, "maxEntry", loopCriteria.getMaxEntryChars());
                ODDocumentMediator.addStringArrayToJSON(jsonCriteria, "validValues", ODUtil.getValidValues(loopCriteria, this.getMessageResources(), this.locale));
                String values = this.getHit().getDisplayValue(loopCriteria.getName());
                if (dataType.equalsIgnoreCase("xs:time") || dataType.equalsIgnoreCase("xs:date") || dataType.equalsIgnoreCase("xs:timestamp")) {
                    values = ODUtil.getISODateString(this.request, values, loopCriteria.getDisplayFmt(), loopCriteria.getFieldQualifier() == 'Z');
                }
                jsonCriteria.put("values", values);
                JSONUtils.accumulate(jsonObject, "criterias", jsonCriteria);
                loopCriteria = null;
                jsonCriteria = null;
            }
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    void addSystemProperties(JSONObject jsonObject) {
        String methodName = "addSystemProperties";
        JSONObject jsonSystemProperties = null;
        try {
            ODHitProperties prop = this.getHit().getProperties();
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "hitLength");
            jsonSystemProperties.put("values", "" + prop.getLength());
            jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "search.results.header.length"));
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "doc_name");
            jsonSystemProperties.put("values", this.getHit().getDocumentName());
            jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.name.label"));
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "mimetype");
            jsonSystemProperties.put("values", this.getTypeString(this.getHit().getDocType()));
            jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.type.label"));
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "file_ext");
            jsonSystemProperties.put("values", this.getHit().getFileExt());
            jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.ext.label"));
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "doc_location");
            jsonSystemProperties.put("values", this.getLocationString(this.getHit().getDocLocation()));
            jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.location"));
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "application_group");
            jsonSystemProperties.put("values", this.getHit().getApplGrpName());
            jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.app.group"));
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "application");
            jsonSystemProperties.put("values", this.getHit().getApplName());
            jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.app"));
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            String partialLoadID = prop.getAGId() + "-" + prop.getPrimaryNodeId() + "-" + prop.getSecondaryNodeId() + "-" + prop.getLoadName();
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "partial_load_id");
            jsonSystemProperties.put("values", partialLoadID);
            jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.partial.load.id"));
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "file_size");
            try {
                long fileSize = 0L;
                if (this.getHit().getDocumentSize() > 0) {
                    fileSize = this.getHit().getDocumentSize();
                } else if (this.getHit().getDocumentSize() == -1 && !this.getHit().isLargeObject()) {
                    fileSize = this.getHit().getProperties().getLength();
                }
                if (fileSize > 0L) {
                    jsonSystemProperties.put("values", "" + fileSize);
                } else {
                    jsonSystemProperties.put("values", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.not.available"));
                }
            }
            catch (Exception e1) {
                jsonSystemProperties.put("values", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.not.available"));
            }
            jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.file.size"));
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            int numPages = 0;
            try {
                if (this.getHit().getNumPages() > 0) {
                    numPages = this.getHit().getNumPages();
                } else if (this.getHit().isLargeObject()) {
                    numPages = (this.getHit().getNumSegments() - 1) * this.getHit().getNumPagesInSegment() + this.getHit().getNumPagesInLastSegment();
                }
            }
            catch (Exception e) {
                numPages = 1;
            }
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "num_pages");
            if (numPages == 0) {
                jsonSystemProperties.put("values", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.not.available"));
            } else {
                jsonSystemProperties.put("values", "" + numPages);
            }
            jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.num.pages"));
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            jsonSystemProperties = new JSONObject();
            jsonSystemProperties.put("name", "large_object");
            if (this.getHit().isLargeObject()) {
                jsonSystemProperties.put("values", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.yes"));
            } else {
                jsonSystemProperties.put("values", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.no"));
            }
            jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.large.object"));
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            if (this.getHit().isLargeObject()) {
                jsonSystemProperties = new JSONObject();
                jsonSystemProperties.put("name", "segment_num");
                if (this.getHit().getNumSegments() > 0) {
                    try {
                        jsonSystemProperties.put("values", "" + this.getHit().getNumSegments());
                    }
                    catch (Exception e) {
                        jsonSystemProperties.put("values", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.not.available"));
                    }
                } else {
                    jsonSystemProperties.put("values", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.not.available"));
                }
                jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.num.segments"));
                JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
                jsonSystemProperties = new JSONObject();
                jsonSystemProperties.put("name", "pages_segment");
                if (this.getHit().getNumPagesInSegment() > 0) {
                    try {
                        jsonSystemProperties.put("values", "" + this.getHit().getNumPagesInSegment());
                    }
                    catch (Exception e) {
                        jsonSystemProperties.put("values", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.not.available"));
                    }
                } else {
                    jsonSystemProperties.put("values", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.not.available"));
                }
                jsonSystemProperties.put("label", MessageUtil.getMessage(this.getLocale(), "retrieve.doc.num.pages.per.seg"));
                JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
            }
            JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        jsonSystemProperties = new JSONObject();
        jsonSystemProperties.put("name", "idValue");
        jsonSystemProperties.put("values", this.getHit().getDocId());
        String idString = MessageUtil.getMessage(this.getLocale(), "search.results.header.id");
        jsonSystemProperties.put("label", idString);
        JSONUtils.accumulate(jsonObject, "systemProperties", jsonSystemProperties);
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        this.setDocID(jsonObject.get("docid").toString());
        JSONArray criteriasJsonArray = (JSONArray)jsonObject.get("criterias");
        JSONObject criteria = null;
        ODCriteriaBean criteriaHolder = null;
        Vector<ODCriteriaBean> criterias = new Vector<ODCriteriaBean>(criteriasJsonArray.size());
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
            criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
            criteriaHolder = new ODCriteriaBean();
            String criteriaName = criteria.get("name").toString();
            criteriaHolder.setCriteriaName(criteriaName);
            int currentOperator = ODUtil.getOperand(criteria.get("operator").toString());
            criteriaHolder.setOperator(currentOperator);
            JSONArray valuesJsonArray = (JSONArray)criteria.get("values");
            String[] tempValuesArray = new String[valuesJsonArray.size()];
            for (int iValuesCounter = 0; iValuesCounter < valuesJsonArray.size(); ++iValuesCounter) {
                tempValuesArray[iValuesCounter] = (String)valuesJsonArray.get(iValuesCounter);
            }
            criteriaHolder.setValues(tempValuesArray);
            criterias.add(criteriaHolder);
        }
        this.setCriterias(criterias.elements());
    }

    public String getFormat(String type, String odFormat) {
        String methodName = "getFormat";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        String returnFormat = null;
        returnFormat = type.equals("xs:timestamp") ? ((SimpleDateFormat)this.wcDateFormat.getTimestampFormat()).toPattern() : (type.equals("xs:date") ? ((SimpleDateFormat)this.wcDateFormat.getDateFormat()).toPattern() : (type.equals("xs:time") ? ((SimpleDateFormat)this.wcDateFormat.getTimeFormat()).toPattern() : ""));
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "returned Format [" + type + "]: " + returnFormat);
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        return returnFormat;
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }

    private String getTypeString(char odType) {
        if (odType == 'B') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.bitmap.image");
        }
        if (odType == 'G') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.gif.image");
        }
        if (odType == 'Q') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.png.image");
        }
        if (odType == 'A') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.afp.document");
        }
        if (odType == 'E') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.email.document");
        }
        if (odType == 'F') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.jfif.image");
        }
        if (odType == 'L') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.line.data.document");
        }
        if (odType == 'M') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.metacode");
        }
        if (odType == 'N') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.none");
        }
        if (odType == 'X') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.pcx.image");
        }
        if (odType == 'P') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.pdf.document");
        }
        if (odType == 'T') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.tiff.image");
        }
        if (odType == 'U') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.user.defined");
        }
        if (odType == 'C') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.scs.ext.document");
        }
        if (odType == 'D') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.djde.document");
        }
        if (odType == 'S') {
            return MessageUtil.getMessage(this.getLocale(), "file.type.scs.document");
        }
        return MessageUtil.getMessage(this.getLocale(), "file.type.unknown");
    }

    private String getLocationString(int docLocation) {
        if (docLocation == 1) {
            return MessageUtil.getMessage(this.getLocale(), "document.location.cache");
        }
        if (docLocation == 2) {
            return MessageUtil.getMessage(this.getLocale(), "document.location.archive");
        }
        if (docLocation == 3) {
            return MessageUtil.getMessage(this.getLocale(), "document.location.external");
        }
        if (docLocation == 4) {
            return MessageUtil.getMessage(this.getLocale(), "document.location.dasd");
        }
        if (docLocation == 5) {
            return MessageUtil.getMessage(this.getLocale(), "document.location.optical");
        }
        if (docLocation == 6) {
            return MessageUtil.getMessage(this.getLocale(), "document.location.optial.shelf");
        }
        if (docLocation == 7) {
            return MessageUtil.getMessage(this.getLocale(), "document.location.tape");
        }
        if (docLocation == 8) {
            return MessageUtil.getMessage(this.getLocale(), "document.location.tape.shelf");
        }
        return MessageUtil.getMessage(this.getLocale(), "document.location.unknown");
    }
}

