/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.od;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.od.ODCriteriaBean;
import com.ibm.ecm.util.od.ODUtil;
import com.ibm.edms.od.ODCriteria;
import com.ibm.edms.od.ODException;
import com.ibm.edms.od.ODFolder;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class ODCriteriasMediator
extends BaseMediator {
    private WCDateFormat wcDateFormat;
    public transient Enumeration criterias;
    public transient Enumeration displayCriterias;
    public String folderName;
    public String folderDescription;
    public String formType;
    public boolean hasSavedSearches;
    public boolean showFieldHoverHelp;

    public ODCriteriasMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
        this.wcDateFormat = WCDateFormat.getDefaultDateFormats(this.request);
        this.criterias = null;
        this.displayCriterias = null;
        this.folderName = null;
        this.folderDescription = null;
        this.formType = null;
        this.hasSavedSearches = false;
        this.showFieldHoverHelp = false;
    }

    protected ODCriteriasMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
        this.wcDateFormat = WCDateFormat.getDefaultDateFormats(this.request);
        this.criterias = null;
        this.displayCriterias = null;
        this.folderName = null;
        this.folderDescription = null;
        this.formType = null;
        this.hasSavedSearches = false;
        this.showFieldHoverHelp = false;
    }

    public boolean getHasSavedSearches() {
        return this.hasSavedSearches;
    }

    public void setHasSavedSearches(boolean hasSavedSearches) {
        this.hasSavedSearches = hasSavedSearches;
    }

    public Enumeration getCriterias() {
        return this.criterias;
    }

    public void setCriterias(Enumeration criterias) {
        this.criterias = criterias;
    }

    public Enumeration getDisplayCriterias() {
        return this.displayCriterias;
    }

    public void setDisplayCriterias(Enumeration displayCriterias) {
        this.displayCriterias = displayCriterias;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public String getFolderDescription() {
        return this.folderDescription;
    }

    public void setFolderDescription(String folderDescription) {
        this.folderDescription = folderDescription;
    }

    public String getFormType() {
        if (this.formType == null) {
            this.formType = "search";
        }
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    private void criteriaToJSONObject(JSONObject jsonObject, String criteriasKey, Enumeration enumODCriterias, boolean forSearch) {
        String methodName = "criteriaToJSONObject";
        ODCriteria loopCriteria = null;
        JSONObject jsonCriteria = null;
        String dataType = null;
        String criteriaFormat = null;
        while (enumODCriterias != null && enumODCriterias.hasMoreElements()) {
            int i;
            jsonCriteria = new JSONObject();
            loopCriteria = (ODCriteria)enumODCriterias.nextElement();
            jsonCriteria.put("name", loopCriteria.getName());
            criteriaFormat = forSearch ? loopCriteria.getDefaultFmt() : loopCriteria.getDisplayFmt();
            dataType = ODUtil.getCriteriaType(loopCriteria, criteriaFormat);
            jsonCriteria.put("dataType", dataType);
            if (dataType != null && (dataType.equalsIgnoreCase("xs:date") || dataType.equalsIgnoreCase("xs:time") || dataType.equalsIgnoreCase("xs:timestamp"))) {
                criteriaFormat = ODUtil.getSimpleDateFormat(criteriaFormat);
            }
            jsonCriteria.put("format", criteriaFormat);
            boolean readOnly = false;
            if (!forSearch) {
                String[] appGroupNames = loopCriteria.getApplicationGroupNames();
                block3: for (i = 0; i < appGroupNames.length; ++i) {
                    String appGroupName = appGroupNames[i];
                    String[] mappedAppGrpField = loopCriteria.getDBFieldNames(appGroupName);
                    if (mappedAppGrpField != null) {
                        for (int j = 0; j < mappedAppGrpField.length; ++j) {
                            boolean isUpdateable = true;
                            try {
                                isUpdateable = loopCriteria.isUpdateable(appGroupName, mappedAppGrpField[j]);
                                if (isUpdateable) continue;
                                readOnly = true;
                                continue block3;
                            }
                            catch (ODException e) {
                                Logger.logError((Object)this, "criteriaToJSONObject", (ServletRequest)this.request, (Throwable)e);
                            }
                        }
                        continue;
                    }
                    readOnly = true;
                    break;
                }
            }
            JSONUtils.put(jsonCriteria, "readOnly", readOnly);
            JSONUtils.put(jsonCriteria, "required", loopCriteria.isRequired());
            JSONUtils.put(jsonCriteria, "fixedValue", loopCriteria.isDefaultValueFixed());
            JSONUtils.put(jsonCriteria, "ascending", loopCriteria.getAscending());
            jsonCriteria.put("label", loopCriteria.getName());
            jsonCriteria.put("label2", loopCriteria.getName());
            if (loopCriteria.getMaxSearchValue() != null && loopCriteria.getMinSearchValue() != null && loopCriteria.getMaxSearchValue().equalsIgnoreCase(loopCriteria.getMinSearchValue())) {
                jsonCriteria.put("minValue", ODUtil.getJSONValueString(this.request, ODUtil.getMin(loopCriteria), loopCriteria, false));
                jsonCriteria.put("maxValue", ODUtil.getJSONValueString(this.request, ODUtil.getMax(loopCriteria), loopCriteria, false));
            } else {
                jsonCriteria.put("minValue", ODUtil.getJSONValueString(this.request, loopCriteria.getMinSearchValue(), loopCriteria, false));
                jsonCriteria.put("maxValue", ODUtil.getJSONValueString(this.request, loopCriteria.getMaxSearchValue(), loopCriteria, false));
            }
            JSONUtils.put(jsonCriteria, "maxEntry", loopCriteria.getMaxEntryChars());
            String[] values = ODUtil.getValidValues(loopCriteria, this.getMessageResources(), this.locale);
            for (i = 0; i < values.length; ++i) {
                values[i] = ODUtil.getJSONValueString(this.request, values[i], loopCriteria, false);
            }
            ODCriteriasMediator.addStringArrayToJSON(jsonCriteria, "validValues", values);
            jsonCriteria.put("defaultOperator", ODUtil.getSelectedOperator(loopCriteria));
            ODCriteriasMediator.addStringArrayToJSON(jsonCriteria, "availableOperators", ODUtil.getDefinedOperators(loopCriteria, this.getMessageResources(), this.getLocale()));
            values = loopCriteria.getSearchValues();
            if (!(loopCriteria.getOperator() != 64 && loopCriteria.getOperator() != 128 || values.length != 2 || values[0] != null && !values[0].isEmpty() || values[1] != null && !values[1].isEmpty())) {
                values = new String[]{""};
            } else {
                for (i = 0; i < values.length; ++i) {
                    values[i] = ODUtil.getJSONValueString(this.request, values[i], loopCriteria, false);
                }
            }
            if (dataType != null && (dataType.equalsIgnoreCase("xs:date") || dataType.equalsIgnoreCase("xs:timestamp")) && values.length == 2 && values[0].length() > 0 && values[1].length() > 0 && values[0].substring(0, 2).equalsIgnoreCase("19") && values[1].substring(0, 2).equalsIgnoreCase("19") && new Integer(values[0].substring(0, 4)) > new Integer(values[1].substring(0, 4))) {
                values[1] = "20" + values[1].substring(2);
            }
            ODCriteriasMediator.addStringArrayToJSON(jsonCriteria, "values", values);
            JSONUtils.accumulate(jsonObject, criteriasKey, jsonCriteria);
            loopCriteria = null;
            jsonCriteria = null;
        }
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        jsonObject.put("template_name", this.getFolderName());
        jsonObject.put("template_label", this.getFolderName());
        jsonObject.put("template_desc", this.getFolderDescription());
        JSONUtils.put(jsonObject, "query_view", this.getHasSavedSearches());
        JSONUtils.put(jsonObject, "showFieldHoverHelp", this.getShowFieldHoverHelp());
        boolean forSearch = this.formType != null && this.formType.equals("search");
        this.criteriaToJSONObject(jsonObject, "criterias", this.getCriterias(), forSearch);
        if (forSearch) {
            this.criteriaToJSONObject(jsonObject, "displayCriterias", this.getDisplayCriterias(), false);
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject, ODFolder folder, String language) throws Exception {
        super.fromJSONObject(jsonObject);
        this.setFolderName((String)jsonObject.get("template_name"));
        DateFormatSymbols symbols = ODUtil.getDateFormatSymbols(language);
        JSONArray criteriasJsonArray = (JSONArray)jsonObject.get("criterias");
        JSONObject criteria = null;
        ODCriteriaBean criteriaHolder = null;
        Vector<ODCriteriaBean> criterias = new Vector<ODCriteriaBean>(criteriasJsonArray.size());
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
            JSONArray valuesJsonArray;
            criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
            criteriaHolder = new ODCriteriaBean();
            String criteriaName = (String)criteria.get("label");
            if (criteriaName == null) {
                criteriaName = (String)criteria.get("name");
            }
            criteriaHolder.setCriteriaName(criteriaName);
            ODCriteria tempODCriteria = folder.getCriteria(criteriaName);
            String dataType = ODUtil.getCriteriaType(tempODCriteria, tempODCriteria.getDefaultFmt());
            int currentOperator = ODUtil.getOperand((String)criteria.get("operator"));
            criteriaHolder.setOperator(currentOperator);
            if (criteria.get("value") != null) {
                Object value = criteria.get("value");
                valuesJsonArray = new JSONArray();
                valuesJsonArray.add(value);
            } else {
                valuesJsonArray = (JSONArray)criteria.get("values");
            }
            String[] tempValuesArray = new String[valuesJsonArray.size()];
            for (int iValuesCounter = 0; iValuesCounter < valuesJsonArray.size(); ++iValuesCounter) {
                Date date;
                String dataFormat;
                String value = valuesJsonArray.get(iValuesCounter).toString();
                if (dataType.equalsIgnoreCase("xs:date") && value.length() > 0) {
                    dataFormat = tempODCriteria.getDefaultFmt();
                    if (dataFormat == null) {
                        dataFormat = "MM/dd/yy";
                    }
                    date = DateUtil.parseISODate(value, false);
                    tempValuesArray[iValuesCounter] = new SimpleDateFormat(ODUtil.getSimpleDateFormat(dataFormat), symbols).format(date);
                    continue;
                }
                if (dataType.equalsIgnoreCase("xs:time") && value.length() > 0) {
                    dataFormat = tempODCriteria.getDefaultFmt();
                    if (dataFormat == null) {
                        dataFormat = "HH.mm.ss";
                    }
                    date = DateUtil.parseISODate(value, false);
                    tempValuesArray[iValuesCounter] = new SimpleDateFormat(ODUtil.getSimpleDateFormat(dataFormat), symbols).format(date);
                    continue;
                }
                if (dataType.equalsIgnoreCase("xs:timestamp") && value.length() > 0) {
                    dataFormat = tempODCriteria.getDefaultFmt();
                    if (dataFormat == null) {
                        dataFormat = "MM/dd/yy";
                    }
                    date = tempODCriteria.getFieldQualifier() == 'Z' ? DateUtil.parseISODate(value, true) : DateUtil.parseISODate(value, false);
                    tempValuesArray[iValuesCounter] = new SimpleDateFormat(ODUtil.getSimpleDateFormat(dataFormat), symbols).format(date);
                    continue;
                }
                tempValuesArray[iValuesCounter] = value;
            }
            criteriaHolder.setValues(tempValuesArray);
            criterias.add(criteriaHolder);
        }
        this.setCriterias(criterias.elements());
    }

    public void fromSearchTemplateJSONObject(JSONObject jsonObject, ODFolder folder, String language) throws IOException {
        super.fromJSONObject(jsonObject);
        this.setFolderName(jsonObject.get("name").toString());
        DateFormatSymbols symbols = ODUtil.getDateFormatSymbols(language);
        JSONArray criteriasJsonArray = (JSONArray)jsonObject.get("searchCriteria");
        JSONObject criteria = null;
        ODCriteriaBean criteriaHolder = null;
        Vector<ODCriteriaBean> criterias = new Vector<ODCriteriaBean>(criteriasJsonArray.size());
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
            criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
            criteriaHolder = new ODCriteriaBean();
            String criteriaName = (String)criteria.get("label");
            if (criteriaName == null) {
                criteriaName = criteria.get("name").toString();
            }
            criteriaHolder.setCriteriaName(criteriaName);
            ODCriteria tempODCriteria = folder.getCriteria(criteriaName);
            String dataType = criteria.get("dataType").toString();
            int currentOperator = ODUtil.getOperand(criteria.get("selectedOperator").toString());
            criteriaHolder.setOperator(currentOperator);
            JSONArray valuesJsonArray = (JSONArray)criteria.get("values");
            String[] tempValuesArray = new String[valuesJsonArray.size()];
            for (int iValuesCounter = 0; iValuesCounter < valuesJsonArray.size(); ++iValuesCounter) {
                String value = valuesJsonArray.get(iValuesCounter).toString();
                try {
                    Date date;
                    String dataFormat;
                    if (dataType.equalsIgnoreCase("xs:date") && value.length() > 0) {
                        dataFormat = tempODCriteria.getDefaultFmt();
                        if (dataFormat == null) {
                            dataFormat = "MM/dd/yy";
                        }
                        date = DateUtil.parseISODate(value, false);
                        tempValuesArray[iValuesCounter] = new SimpleDateFormat(ODUtil.getSimpleDateFormat(dataFormat), symbols).format(date);
                        continue;
                    }
                    if (dataType.equalsIgnoreCase("xs:time") && value.length() > 0) {
                        dataFormat = tempODCriteria.getDefaultFmt();
                        if (dataFormat == null) {
                            dataFormat = "HH.mm.ss";
                        }
                        date = DateUtil.parseISODate(value, false);
                        tempValuesArray[iValuesCounter] = new SimpleDateFormat(ODUtil.getSimpleDateFormat(dataFormat), symbols).format(date);
                        continue;
                    }
                    if (dataType.equalsIgnoreCase("xs:timestamp") && value.length() > 0) {
                        dataFormat = tempODCriteria.getDefaultFmt();
                        if (dataFormat == null) {
                            dataFormat = "MM/dd/yy";
                        }
                        date = tempODCriteria.getFieldQualifier() == 'Z' ? DateUtil.parseISODate(value, true) : DateUtil.parseISODate(value, false);
                        tempValuesArray[iValuesCounter] = new SimpleDateFormat(ODUtil.getSimpleDateFormat(dataFormat), symbols).format(date);
                        continue;
                    }
                    tempValuesArray[iValuesCounter] = value;
                    continue;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            criteriaHolder.setValues(tempValuesArray);
            criterias.add(criteriaHolder);
        }
        this.setCriterias(criterias.elements());
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }
}

