/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.od;

import com.ibm.ecm.json.JSONItem;
import com.ibm.ecm.json.JSONStore;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.edms.od.ODCabinet;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.text.Collator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class ODCabinetsMediator
extends BaseMediator {
    public HashMap cabinets = null;

    public ODCabinetsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void addCabinet(ODCabinet cabinet) {
        this.getCabinets().put(cabinet.getName(), cabinet.getDescription());
    }

    public void addCabinet(String cabinetName, String cabinetDescription) {
        this.getCabinets().put(cabinetName, cabinetDescription);
    }

    public HashMap getCabinets() {
        if (this.cabinets == null) {
            this.cabinets = new HashMap(0);
        }
        return this.cabinets;
    }

    public void setCabinets(HashMap cabinets) {
        this.cabinets = cabinets;
    }

    protected Map sortCabinets() {
        TreeMap sortedMap = new TreeMap(Collator.getInstance());
        sortedMap.putAll(this.getCabinets());
        return sortedMap;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        JSONUtils.put(jsonObject, "num_cabinets", this.getCabinets().size());
        JSONStore jsonStore = new JSONStore("cabinet_name", "cabinet_name", this.locale);
        Map sortedCabinets = this.sortCabinets();
        boolean currentCabinet = false;
        for (String cabinetName : sortedCabinets.keySet()) {
            String cabinetDescription = (String)sortedCabinets.get(cabinetName);
            JSONItem jsonItem = jsonStore.createDataItem(cabinetName, cabinetName);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("cabinet_desc", cabinetDescription);
            jsonItem.setProperties(properties);
            jsonStore.addItem(jsonItem);
        }
        jsonObject.put("datastore", jsonStore.toJson());
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        TreeMap<String, String> cabinets = new TreeMap<String, String>();
        JSONObject jsonArrayObject = null;
        JSONArray jsonArray = (JSONArray)jsonObject.get("cabinet_name");
        for (int iArrayItemCounter = 0; iArrayItemCounter < jsonArray.size(); ++iArrayItemCounter) {
            jsonArrayObject = (JSONObject)jsonArray.get(iArrayItemCounter);
            for (String cabinetName : jsonArrayObject.keySet()) {
                String cabinetDescription = jsonArrayObject.get(cabinetName).toString();
                cabinets.put(cabinetName, cabinetDescription);
            }
        }
        this.setCabinets(new HashMap(cabinets));
    }
}

