/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.od;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.od.ODAnnotationMediator;
import com.ibm.ecm.mediator.od.ODSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.edms.od.ODNote;
import com.ibm.json.java.JSONObject;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class ODAnnotationsMediator
extends BaseMediator {
    private Vector notes = null;
    private String documentId = null;
    private ODSearchResultsMediator searchResultsMediator = null;
    private String folderName = null;
    private String headerInfo = null;
    private String[] userGroupNames = null;

    public ODAnnotationsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public Vector getNotes() {
        return this.notes;
    }

    public void setNotes(Vector notes) {
        this.notes = notes;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public String[] getUserGroupNames() {
        return this.userGroupNames;
    }

    public void setUserGroupNames(String[] userGroupNames) {
        this.userGroupNames = userGroupNames;
    }

    public ODSearchResultsMediator getSearchResultsMediator() {
        return this.searchResultsMediator;
    }

    public void setSearchResultsMediator(ODSearchResultsMediator searchResultsMediator) {
        this.searchResultsMediator = searchResultsMediator;
    }

    public String toSTREAMString() {
        String methodName = "toSTREAMString";
        StringBuffer noteBytes = new StringBuffer();
        if (this.getNotes() != null) {
            Enumeration enumNotes = this.getNotes().elements();
            ODNote note = null;
            while (enumNotes.hasMoreElements()) {
                note = (ODNote)enumNotes.nextElement();
                noteBytes.append(note.getDateTime());
                noteBytes.append("\n");
                noteBytes.append(note.getUserId());
                noteBytes.append("  Page: ");
                noteBytes.append(note.getPageNum());
                noteBytes.append("  Access: ");
                if (note.isPublic()) {
                    noteBytes.append("Public");
                } else {
                    noteBytes.append("Private");
                    if (note.getGroupName() != null && note.getGroupName().trim().length() > 0) {
                        noteBytes.append(" (").append(note.getGroupName()).append(")");
                    }
                }
                noteBytes.append("\n");
                if (note.isOkToCopy()) {
                    noteBytes.append("Can be copied");
                } else {
                    noteBytes.append("Can not be copied");
                }
                noteBytes.append("\n");
                noteBytes.append(note.getText());
                noteBytes.append("\n\n");
            }
        }
        return noteBytes.toString();
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        jsonObject.put("template_name", this.getFolderName());
        jsonObject.put("docid", this.getDocumentId());
        if (this.getUserGroupNames() != null) {
            String[] userGrpNames = this.getUserGroupNames();
            userGrpNames = BaseUtil.sort(userGrpNames, this.locale);
            int groupsCount = userGrpNames.length;
            JSONUtils.put(jsonObject, "num_groups", groupsCount);
            for (int i = 0; i < groupsCount; ++i) {
                JSONUtils.accumulate(jsonObject, "userGroupNames", userGrpNames[i]);
            }
        }
        if (this.getNotes() != null) {
            JSONUtils.put(jsonObject, "num_notes", this.getNotes().size());
            jsonObject.put("notesHeaderInfo", this.getHeaderInfo());
            Enumeration enumNotes = this.getNotes().elements();
            ODNote tempNote = null;
            ODAnnotationMediator oneAnnotationMediator = null;
            while (enumNotes.hasMoreElements()) {
                tempNote = (ODNote)enumNotes.nextElement();
                oneAnnotationMediator = new ODAnnotationMediator(this.request, this.getMessageResources(), this.getLocale());
                oneAnnotationMediator.setNote(tempNote);
                oneAnnotationMediator.setDocumentId(this.getDocumentId());
                oneAnnotationMediator.setFolderName(this.getFolderName());
                JSONUtils.accumulate(jsonObject, "notes", oneAnnotationMediator.toJSONString());
            }
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, new StringBuffer("Returning JSON: ").append(jsonObject.toString()).toString());
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        this.setFolderName(jsonObject.get("template_name").toString());
    }

    public String getHeaderInfo() {
        return this.headerInfo;
    }

    public void setHeaderInfo(String headerInfo) {
        this.headerInfo = headerInfo;
    }
}

