/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.od;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.od.ODSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.edms.od.ODNote;
import com.ibm.json.java.JSONObject;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class ODAnnotationMediator
extends BaseMediator {
    private ODSearchResultsMediator searchResultsMediator = null;
    public ODNote note = null;
    public String documentId = null;
    public String folderName = null;
    public boolean canAddNotes = false;
    public boolean canPrintNotes = false;

    public ODAnnotationMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public ODNote getNote() {
        return this.note;
    }

    public void setNote(ODNote note) {
        this.note = note;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        jsonObject.put("template_name", this.getFolderName());
        jsonObject.put("docid", this.getDocumentId());
        if (this.getNote() != null) {
            try {
                JSONUtils.put(jsonObject, "color", this.getNote().getColor());
                jsonObject.put("timestamp", this.getNote().getDateTime());
                jsonObject.put("groupName", this.getNote().getGroupName());
                JSONUtils.put(jsonObject, "xOffset", this.getNote().getOffsetX());
                JSONUtils.put(jsonObject, "yOffset", this.getNote().getOffsetY());
                JSONUtils.put(jsonObject, "page", this.getNote().getPageNum());
                jsonObject.put("text", this.getNote().getText());
                jsonObject.put("userID", this.getNote().getUserId());
                JSONUtils.put(jsonObject, "isOKToCopy", this.getNote().isOkToCopy());
                JSONUtils.put(jsonObject, "isPublic", this.getNote().isPublic());
                if (this.getSearchResultsMediator() != null) {
                    jsonObject.put("rows", this.getSearchResultsMediator().buildTableRows());
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            }
        }
        JSONUtils.put(jsonObject, "privAddNotes", this.getCanAddNotes());
        JSONUtils.put(jsonObject, "privPrintNotes", this.getCanPrintNotes());
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, new StringBuffer("Returning JSON: ").append(jsonObject.toString()).toString());
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        this.setFolderName(jsonObject.get("template_name").toString());
    }

    public boolean getCanAddNotes() {
        return this.canAddNotes;
    }

    public void setCanAddNotes(boolean canAddNotes) {
        this.canAddNotes = canAddNotes;
    }

    public boolean getCanPrintNotes() {
        return this.canPrintNotes;
    }

    public void setCanPrintNotes(boolean canPrintNotes) {
        this.canPrintNotes = canPrintNotes;
    }

    public ODSearchResultsMediator getSearchResultsMediator() {
        return this.searchResultsMediator;
    }

    public void setSearchResultsMediator(ODSearchResultsMediator searchResultsMediator) {
        this.searchResultsMediator = searchResultsMediator;
    }
}

