/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cmis;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.json.TableView;
import com.ibm.ecm.mediator.ResultSetMediator;
import com.ibm.ecm.mediator.cmis.CMISHitMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.ColumnUtil;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.cmis.CMISUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertiesBase;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertiesDocument;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISSearchResultsMediator
extends ResultSetMediator {
    private static final long serialVersionUID = 1L;
    private static List<String> DisplayedColumnsForBrowsing = Collections.unmodifiableList(Arrays.asList("cmis:objectTypeId", EnumPropertiesDocument.CMIS_CONTENT_STREAM_LENGTH.value(), EnumPropertiesBase.CMIS_LAST_MODIFIED_BY.value(), EnumPropertiesBase.CMIS_LAST_MODIFICATION_DATE.value(), EnumPropertiesDocument.CMIS_VERSION_LABEL.value()));
    private static List<String> VersionDisplayColumnWidths = Collections.unmodifiableList(Arrays.asList("15%", "20%", "15%", "15%", "15%"));
    private SearchTemplate.ResultsDisplay queryResultsDisplaySettings;
    private List<CmisObject> hits;
    private CMISConnection connection;
    private Collection<TypeDefinition> typeDefinitions;
    private String folderDescription;
    private JSONObject sortJsonObject = new JSONObject();
    private String serverName;
    private String searchMessage;
    private boolean showDocLocation;
    private int pageSize = 50;
    private int sortIndex = -1;
    private Hashtable<String, Integer> columnSizes = new Hashtable();
    private HashMap<?, ?> uniqueDates = new HashMap();
    public int sortDirection = 1;
    private boolean showNotesIcon = true;
    private String parentDocID;
    private boolean annotationsByDefault;
    private HashMap<?, ?> updatedDocIds;
    private boolean maxResultsReached;
    private boolean addColumnSorting = true;
    private String nameColumnWidth = "25em";
    private String versionsNameColumnWidth = "20%";
    private boolean listDocumentVersions;
    private boolean showCheckoutIfReservation;
    private Map<?, ?> containmentNames = null;
    private Map<?, ?> fullpathNames = null;

    public SearchTemplate.ResultsDisplay getQueryResultsDisplaySettings() {
        return this.queryResultsDisplaySettings;
    }

    public void setQueryResultsDisplaySettings(SearchTemplate.ResultsDisplay queryResultsDisplaySettings) {
        this.queryResultsDisplaySettings = queryResultsDisplaySettings;
    }

    public CMISSearchResultsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void setSearchResults(List<CmisObject> hits) {
        this.hits = hits;
    }

    public String getParentDocID() {
        return this.parentDocID;
    }

    public void setParentDocID(String parentDocID) {
        this.parentDocID = parentDocID;
    }

    public void setContainmentNames(Map<?, ?> containmentNames) {
        this.containmentNames = containmentNames;
    }

    public void setFullPathNames(Map<?, ?> fullpathNames) {
        this.fullpathNames = fullpathNames;
    }

    public String getSearchMessage() {
        return this.searchMessage;
    }

    public void setSearchMessage(String searchMessage) {
        this.searchMessage = searchMessage;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setAddColumnSorting(boolean addColumnSorting) {
        this.addColumnSorting = addColumnSorting;
    }

    public void setNameColumnWidth(String width) {
        this.nameColumnWidth = width;
    }

    public boolean hasAnnotationsByDefault() {
        return this.annotationsByDefault;
    }

    public void setAnnotationsByDefault(boolean annotationsByDefault) {
        this.annotationsByDefault = annotationsByDefault;
    }

    public void setShowDocLocation(boolean showDocLocation) {
        this.showDocLocation = showDocLocation;
    }

    public boolean getShowDocLocation() {
        return this.showDocLocation;
    }

    public boolean getShowNotesIcon() {
        return this.showNotesIcon;
    }

    public void setShowNotesIcon(boolean showNotesIcon) {
        this.showNotesIcon = showNotesIcon;
    }

    public void setClassDescriptions(Collection<TypeDefinition> classDescriptions) {
        this.typeDefinitions = classDescriptions;
    }

    public TypeDefinition getTypeDefinition() {
        if (this.typeDefinitions == null || this.typeDefinitions.size() == 0) {
            return null;
        }
        return this.typeDefinitions.iterator().next();
    }

    public void addTypeDefinition(TypeDefinition typeDefinition) {
        if (typeDefinition != null) {
            if (this.typeDefinitions == null) {
                this.typeDefinitions = new Vector<TypeDefinition>();
            }
            this.typeDefinitions.add(typeDefinition);
        }
    }

    protected void toJSONFromVectorForClassDescriptions(JSONObject jsonObject, String category) throws IOException {
        String methodName = "toJSONFromVectorForClassDescriptions";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (this.typeDefinitions != null && jsonObject != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "classDescriptions().size(): " + this.typeDefinitions.size());
            for (TypeDefinition typeDef : this.typeDefinitions) {
                JSONObject jsonCD = new JSONObject();
                jsonCD.put("template_name", typeDef.getId());
                jsonCD.put("template_label", typeDef.getDisplayName());
                jsonCD.put("template_desc", typeDef.getDescription());
                JSONUtils.accumulate(jsonObject, category, jsonCD);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONString";
        JSONObject jsonObject = super.toJSONObject();
        try {
            jsonObject.put("printersConfigured", "false");
            if (this.getTypeDefinition() != null) {
                jsonObject.put("template_name", this.getTypeDefinition().getId());
            }
            jsonObject.put("repositoryId", this.getServerName());
            jsonObject.put("template_label", this.getFolderDescription());
            jsonObject.put("sortformats", this.sortJsonObject);
            this.toJSONFromVectorForClassDescriptions(jsonObject, "templates");
            if (this.getParentDocID() != null) {
                jsonObject.put("docid", this.getParentDocID());
            }
            int iNumResults = 0;
            if (this.hits != null) {
                iNumResults = this.hits.size();
                jsonObject.put("num_results", (Object)iNumResults);
                jsonObject.put("showLocation", "false");
                jsonObject.put("showNotesIcon", "false");
                jsonObject.put("pageSize", (Object)this.pageSize);
                jsonObject.put("sortIndex", (Object)this.getSortIndex());
                jsonObject.put("sortDirection", (Object)this.getSortDirection());
                JSONObject jsonDates = new JSONObject();
                jsonDates.putAll(this.uniqueDates);
                jsonObject.put("dates", jsonDates);
            }
            if (this.maxResultsReached) {
                jsonObject.put("maxResultsReached", "true");
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            this.addError("error.exception.general", e.getLocalizedMessage());
        }
        return jsonObject;
    }

    private void putColumnSize(String index, int size) {
        Integer tempValue = this.columnSizes.get(index);
        if (tempValue != null) {
            int value = tempValue;
            if (value < size) {
                this.columnSizes.put(index, size);
            }
        } else {
            this.columnSizes.put(index, size);
        }
    }

    public JSONObject toJSONObject(String origDocid, String newDocid) throws IOException {
        String methodName = "toJSONObject";
        JSONObject jsonObject = this.toJSONObject();
        if (this.getTypeDefinition() != null) {
            jsonObject.put("template_name", this.getTypeDefinition().getId());
        }
        jsonObject.put("repositoryId", this.getServerName());
        jsonObject.put("template_label", this.getFolderDescription());
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, new StringBuffer("search results size: ").append(String.valueOf(this.hits != null ? this.hits.size() : 0)).toString());
        jsonObject.put("origdocid", origDocid);
        jsonObject.put("docid", newDocid);
        return jsonObject;
    }

    @Override
    public void fromJSONObject(JSONObject jsonObject) {
        throw new RuntimeException("This method is not implemented.");
    }

    private boolean isColumnDisplayed(String symbolicName) {
        if (symbolicName.equals(EnumPropertiesBase.CMIS_NAME.value())) {
            return false;
        }
        if (this.queryResultsDisplaySettings != null) {
            HashSet<String> tempColumns = new HashSet<String>(Arrays.asList(this.queryResultsDisplaySettings.getColumns()));
            return tempColumns.contains(symbolicName);
        }
        return DisplayedColumnsForBrowsing.contains(symbolicName);
    }

    @Override
    protected JSONArray buildTableRows() throws Exception {
        String methodName = "buildTableRows";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONArray jsonRows = new JSONArray();
        if (this.hits != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Starting to build json rows from hits");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "hit size: " + this.hits.size());
            CMISHitMediator hitMediator = new CMISHitMediator(this.request, this.messageResources, this.locale, this.connection, this.getUpdatedDocIds(), this.containmentNames, this.fullpathNames);
            for (CmisObject hit : this.hits) {
                hitMediator.setHit(hit);
                JSONObject jsonHit = hitMediator.toJSONObject();
                jsonRows.add(jsonHit);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonRows;
    }

    @Override
    protected JSONArray buildMagazineViewColumns() {
        JSONArray columns = new JSONArray();
        JSONObject thumbnail = new JSONObject();
        thumbnail.put("field", "thumbnail");
        thumbnail.put("name", "");
        thumbnail.put("width", "60px");
        thumbnail.put("decorator", "MagazineViewDecorator.thumbnailDecorator");
        columns.add(thumbnail);
        JSONObject content = new JSONObject();
        content.put("field", "content");
        content.put("name", "");
        content.put("decorator", "MagazineViewDecorator.contentCellDecoratorCMIS");
        columns.add(content);
        return columns;
    }

    @Override
    protected JSONObject buildTableColumns() throws Exception {
        String methodName = "buildTableColums";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        String dateFormat = "%m/%d/%Y";
        String timeFormat = "hh:mm:ss";
        TableView tableView = new TableView();
        TableView.ColumnSet columnSet = tableView.createColumnSet();
        columnSet.addColumnProperty(ColumnUtil.buildStateColumnProperty(this.request, "&nbsp;", "multiStateIcon", true, false, false), true);
        columnSet.addColumnProperty(ColumnUtil.buildColumnProperty("&nbsp;", "17px", "mimeTypeIcon", null, true), true);
        String nameWidth = null;
        HashMap<String, String> versionColumnWidths = new HashMap<String, String>();
        if (this.listDocumentVersions) {
            nameWidth = this.versionsNameColumnWidth;
            for (int index = 0; index < DisplayedColumnsForBrowsing.size(); ++index) {
                versionColumnWidths.put(DisplayedColumnsForBrowsing.get(index), VersionDisplayColumnWidths.get(index));
            }
        } else {
            nameWidth = this.nameColumnWidth;
        }
        columnSet.addColumnProperty(ColumnUtil.buildColumnProperty(this.messageResources.getMessage(this.getLocale(), "name"), nameWidth, "Name", null, !this.addColumnSorting));
        String[] columnsSortingInfo = DisplayedColumnsForBrowsing.toArray(new String[DisplayedColumnsForBrowsing.size()]);
        if (this.typeDefinitions != null) {
            for (TypeDefinition typeDef : this.typeDefinitions) {
                Map pds_map = typeDef.getPropertyDefinitions();
                if (this.queryResultsDisplaySettings != null) {
                    columnsSortingInfo = this.queryResultsDisplaySettings.getColumns();
                }
                for (String id : columnsSortingInfo) {
                    PropertyDefinition pd = (PropertyDefinition)pds_map.get(id);
                    boolean columnDisplayed = this.isColumnDisplayed(id);
                    if (!columnDisplayed || pd == null) continue;
                    String displayName = pd.getDisplayName();
                    String criteriaName = StringEscapeUtils.escapeHtml((String)displayName).trim();
                    boolean isDateTime = pd.getPropertyType().equals((Object)PropertyType.DATETIME);
                    String width = null;
                    Integer columnSize = this.columnSizes.get(id);
                    if (this.listDocumentVersions) {
                        width = (String)versionColumnWidths.get(id);
                    }
                    if (width == null) {
                        width = ColumnUtil.getColumnWidth(displayName.length(), columnSize != null ? columnSize : -1, isDateTime, CMISUtil.isNumericDataType(pd));
                    }
                    if (CMISUtil.isNumericDataType(pd)) {
                        columnSet.addColumnProperty(ColumnUtil.buildColumnProperty(criteriaName, width, id, "text-align:right;", !this.addColumnSorting));
                        continue;
                    }
                    columnSet.addColumnProperty(ColumnUtil.buildColumnProperty(criteriaName, width, id, null, !this.addColumnSorting));
                }
            }
        }
        this.sortJsonObject.put("dataFormat", dateFormat);
        this.sortJsonObject.put("timeFormat", timeFormat);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return tableView.toJson();
    }

    private String wrapperText(String text) {
        return text.replaceAll("&", "&amp;");
    }

    public String getFolderDescription() {
        return this.folderDescription;
    }

    public void setFolderDescription(String folderDescription) {
        this.folderDescription = folderDescription;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public CMISConnection getServer() {
        return this.connection;
    }

    public void setServer(CMISConnection server) {
        this.connection = server;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(int sortDirection) {
        this.sortDirection = sortDirection;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public HashMap<?, ?> getUpdatedDocIds() {
        if (this.updatedDocIds == null) {
            this.updatedDocIds = new HashMap();
        }
        return this.updatedDocIds;
    }

    public void setUpdatedDocIds(HashMap<?, ?> updatedDocIds) {
        this.updatedDocIds = updatedDocIds;
    }

    public boolean isMaxResultsReached() {
        return this.maxResultsReached;
    }

    public void setMaxResultsReached(boolean maxResultsReached) {
        this.maxResultsReached = maxResultsReached;
    }

    public boolean getListDocumentVersions() {
        return this.listDocumentVersions;
    }

    public void setListDocumentVersions(boolean listDocumentVersions) {
        this.listDocumentVersions = listDocumentVersions;
    }

    public void setShowCheckoutIfReservation(boolean showCheckoutIfReservation) {
        this.showCheckoutIfReservation = showCheckoutIfReservation;
    }

    public boolean getShowCheckoutIfReservation() {
        return this.showCheckoutIfReservation;
    }
}

