/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cmis;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.ChildSearchCriteria;
import com.ibm.ecm.util.SearchCriteria;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class CMISSearchCriteriaMediator
extends BaseMediator {
    private SearchTemplate searchTemplate = null;
    private String languageCode = "ENU";
    private JSONObject savedSearchCriteriaJSON;

    public void setRawSearchCriteriaOverride(JSONObject objSavedSearch) {
        this.savedSearchCriteriaJSON = objSavedSearch;
    }

    public CMISSearchCriteriaMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected CMISSearchCriteriaMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public SearchTemplate getSearchTemplate() {
        return this.searchTemplate;
    }

    public void setSearchTemplate(SearchTemplate searchTemplate) {
        this.searchTemplate = searchTemplate;
    }

    public void getLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject json = super.toJSONObject();
        if (this.savedSearchCriteriaJSON == null) {
            try {
                SearchTemplate.TextSearchCriterion textSearchCriteria;
                List<SearchCriteria> criteria;
                json.put("template_name", this.searchTemplate.getFirstClassName());
                json.put("template_label", this.searchTemplate.getFirstClassDisplayName());
                json.put("objectType", this.searchTemplate.getObjectType().toString());
                json.put("andSearch", (Object)this.searchTemplate.isAndSearch());
                json.put("autoRun", (Object)this.searchTemplate.isAutoRun());
                json.put("showInTree", (Object)this.searchTemplate.isShowInTree());
                List<SearchTemplate.SearchFolder> folders = this.searchTemplate.getFolders();
                if (folders != null) {
                    for (SearchTemplate.SearchFolder folder : folders) {
                        JSONObject folderJSON = new JSONObject();
                        folderJSON.put("id", folder.getId());
                        folderJSON.put("pathName", folder.getPathName());
                        folderJSON.put("searchSubfolders", (Object)folder.isSearchSubfolders());
                        folderJSON.put("view", folder.getView().toString());
                        folderJSON.put("repositoryId", folder.getObjectStoreId());
                        JSONUtils.accumulate(json, "search_folders", folderJSON);
                    }
                }
                if ((criteria = this.searchTemplate.getSearchCriteria()) != null) {
                    for (SearchCriteria criteriaEntry : criteria) {
                        if (criteriaEntry instanceof SearchCriterion) {
                            JSONObject criterionJSON = this.createSearchCriterionJSONObj((SearchCriterion)criteriaEntry);
                            JSONUtils.accumulate(json, "criterias", criterionJSON);
                            continue;
                        }
                        if (!(criteriaEntry instanceof ChildSearchCriteria)) continue;
                        ChildSearchCriteria child = (ChildSearchCriteria)criteriaEntry;
                        JSONObject childJSON = new JSONObject();
                        childJSON.put("template_name", child.getName());
                        List<SearchCriterion> childCriterionList = child.getSearchCriteria();
                        JSONArray childCriteriaJSON = new JSONArray();
                        for (SearchCriterion childCriterion : childCriterionList) {
                            JSONObject criterionJSON = this.createSearchCriterionJSONObj(childCriterion);
                            childCriteriaJSON.add(criterionJSON);
                        }
                        childJSON.put("criterias", childCriteriaJSON);
                        JSONUtils.accumulate(json, "criterias", childJSON);
                    }
                }
                if ((textSearchCriteria = this.searchTemplate.getFirstTextSearchCriterion()) != null) {
                    json.put("textSearchCriteria", textSearchCriteria.toJSON());
                }
                JSONObject optionCriteria = new JSONObject();
                SearchTemplate.VersionOption verOption = this.searchTemplate.getVersionOption();
                if (verOption != null) {
                    optionCriteria.put("versionOption", verOption.toString());
                }
                optionCriteria.put("propertyTextAnded", (Object)this.searchTemplate.isPropertyTextAnded());
                json.put("moreOptions", optionCriteria);
                SearchTemplate.ResultsDisplay resultsDisplay = this.searchTemplate.getResultsDisplay();
                if (resultsDisplay != null) {
                    json.put("resultsDisplay", resultsDisplay.toJSON());
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
                this.addError("error.exception.general", e.getLocalizedMessage());
            }
        }
        json = this.savedSearchCriteriaJSON;
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return json;
    }

    private JSONObject createSearchCriterionJSONObj(SearchCriterion criterion) {
        String name = criterion.getName();
        JSONObject criterionJSON = new JSONObject();
        criterionJSON.put("name", name);
        criterionJSON.put("dataType", criterion.getDataType());
        criterionJSON.put("readOnly", (Object)criterion.isReadOnly());
        criterionJSON.put("hidden", (Object)criterion.isHidden());
        criterionJSON.put("required", (Object)criterion.isRequired());
        criterionJSON.put("defaultOperator", criterion.getOperator());
        CMISSearchCriteriaMediator.addStringArrayToJSON(criterionJSON, "values", criterion.getValues());
        CMISSearchCriteriaMediator.addStringArrayToJSON(criterionJSON, "displayValues", criterion.getDisplayValues());
        return criterionJSON;
    }
}

