/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISPropertyDescsMediator
extends BaseMediator {
    private static final long serialVersionUID = 1L;
    private Map<String, List<PropertyDefinition>> propDescs = new LinkedHashMap<String, List<PropertyDefinition>>();

    public void setPropDescs(String objectType, List<PropertyDefinition> propertyDefinitions) {
        this.propDescs.put(objectType, propertyDefinitions);
    }

    public CMISPropertyDescsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        JSONArray jsonObjectTypes = new JSONArray();
        if (this.propDescs != null) {
            Set<Map.Entry<String, List<PropertyDefinition>>> entries = this.propDescs.entrySet();
            for (Map.Entry<String, List<PropertyDefinition>> entry : entries) {
                JSONArray jsonPropertyDescriptions = new JSONArray();
                List<PropertyDefinition> list = entry.getValue();
                String key = entry.getKey();
                Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, key + " property description size: " + list.size());
                for (PropertyDefinition propDesc : list) {
                    JSONObject json = new JSONObject();
                    json.put("label", propDesc.getDisplayName());
                    json.put("value", propDesc.getQueryName());
                    jsonPropertyDescriptions.add(json);
                }
                JSONObject jsonObjectType = new JSONObject();
                jsonObjectType.put("items", jsonPropertyDescriptions);
                jsonObjectType.put("type", key);
                jsonObjectTypes.add(jsonObjectType);
            }
        }
        jsonObject.put("objectTypes", jsonObjectTypes);
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON:" + jsonObject.toString());
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }
}

