/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cmis;

import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.DocumentInfoMediator;
import com.ibm.ecm.security.AccessControlList;
import com.ibm.ecm.security.AccessControlListData;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.cmis.CMISDefinitionUtil;
import com.ibm.ecm.util.cmis.CMISPropertiesUtils;
import com.ibm.ecm.util.cmis.CMISPropertyDefinition;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISItemMediator
extends DocumentInfoMediator {
    private static final long serialVersionUID = 1L;
    public String serverDisplayName = null;
    public String docID = null;
    CmisObject hit = null;
    private AccessControlList acl = null;
    public String formType = null;
    public boolean showFieldHoverHelp = false;
    private RepositoryConfig repositoryConfig = null;
    protected Enumeration<SearchCriterion> criterias = null;

    public CMISItemMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
        this.formType = "edit";
    }

    protected CMISItemMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public CmisObject getHit() {
        return this.hit;
    }

    public String getDocID() {
        return this.docID;
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }

    public void setHit(CmisObject item) {
        this.hit = item;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public String getFormType() {
        if (this.formType == null) {
            this.formType = "search";
        }
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public Enumeration<SearchCriterion> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(Enumeration<SearchCriterion> criterias) {
        this.criterias = criterias;
    }

    public RepositoryConfig getRepositoryConfig() {
        return this.repositoryConfig;
    }

    public void setRepositoryConfig(RepositoryConfig repositoryConfig) {
        this.repositoryConfig = repositoryConfig;
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        String[] configuredSystemProperties = null;
        HashMap<String, String> configuraedSystemPropertiesMap = new HashMap<String, String>();
        if (this.getHit() != null) {
            jsonObject.put("template_name", this.getHit().getType().getId());
            jsonObject.put("template_label", this.getHit().getType().getDisplayName());
            jsonObject.put("template_desc", this.getHit().getType().getDescription());
            jsonObject.put("template_hidden", (Object)false);
            if (this.getHit() instanceof Document) {
                configuredSystemProperties = this.repositoryConfig.getDocumentSystemProperties();
                if (configuredSystemProperties != null) {
                    for (int i = 0; i < configuredSystemProperties.length; ++i) {
                        Logger.logInfo((Object)this, "toJSONObject", (ServletRequest)this.request, i + 1 + ":" + configuredSystemProperties[i]);
                        configuraedSystemPropertiesMap.put(configuredSystemProperties[i], configuredSystemProperties[i]);
                    }
                }
                Document document = (Document)this.getHit();
                jsonObject.put("docid", document.getId());
                jsonObject.put("mimetype", document.getContentStreamMimeType());
                jsonObject.put("file_ext", document.getContentStreamFileName());
            } else if (this.getHit() instanceof Folder) {
                configuredSystemProperties = this.repositoryConfig.getFolderSystemProperties();
                if (configuredSystemProperties != null) {
                    for (int i = 0; i < configuredSystemProperties.length; ++i) {
                        Logger.logInfo((Object)this, "toJSONObject", (ServletRequest)this.request, i + 1 + ":" + configuredSystemProperties[i]);
                        configuraedSystemPropertiesMap.put(configuredSystemProperties[i], configuredSystemProperties[i]);
                    }
                }
                Folder folder = (Folder)this.getHit();
                jsonObject.put("docid", folder.getId());
                jsonObject.put("mimetype", "Folder");
                jsonObject.put("file_ext", folder.getName());
            }
        }
        jsonObject.put("showFieldHoverHelp", new Boolean(this.getShowFieldHoverHelp()));
        CmisObject item = this.getHit();
        if (item != null) {
            ArrayList<Property> nonSystemProperties = new ArrayList<Property>();
            ArrayList<Property> systemProperties = new ArrayList<Property>();
            for (Property property : item.getProperties()) {
                CMISPropertyDefinition propertyDescription = new CMISPropertyDefinition(property);
                if (propertyDescription.isSystemProperty()) {
                    if (configuraedSystemPropertiesMap.get(propertyDescription.getId()) == null) continue;
                    systemProperties.add(property);
                    continue;
                }
                nonSystemProperties.add(property);
            }
            this.createJSONForProperties(jsonObject, nonSystemProperties, "criterias");
            this.createJSONForProperties(jsonObject, systemProperties, "systemProperties");
        }
        JSONArray jsonAccessControlArray = new JSONArray();
        jsonObject.put("acl", jsonAccessControlArray);
        if (this.acl != null) {
            for (AccessControlListData aclDataEntry : this.acl.getAclData()) {
                jsonAccessControlArray.add(aclDataEntry.toJSON());
            }
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    private void createJSONForProperties(JSONObject jsonObject, List<Property> properties, String jsonKey) {
        String maxEntry = "";
        String minValue = "";
        String maxValue = "";
        for (Property property : properties) {
            CMISPropertyDefinition propertyDefWrapper = new CMISPropertyDefinition(property);
            JSONObject jsonCriteria = new JSONObject();
            maxEntry = propertyDefWrapper.getMaxLength();
            minValue = propertyDefWrapper.getMinValue();
            maxValue = propertyDefWrapper.getMaxValue();
            String[] validValues = propertyDefWrapper.getChoiceListAsArray();
            PropertyDefinition nativePD = property.getDefinition();
            CMISDefinitionUtil.addChoiceList(this.request, nativePD, jsonCriteria);
            jsonCriteria.put("cardinality", propertyDefWrapper.getCardinality());
            jsonCriteria.put("name", propertyDefWrapper.getId());
            jsonCriteria.put("dataType", propertyDefWrapper.getDataType());
            boolean readOnly = this.getFormType().equals("edit") ? !propertyDefWrapper.isUpdatabilityReadWrite() : propertyDefWrapper.isUpdatabilityReadOnly();
            jsonCriteria.put("readOnly", (Object)readOnly);
            jsonCriteria.put("required", (Object)propertyDefWrapper.isRequired());
            jsonCriteria.put("label", propertyDefWrapper.getDisplayName());
            jsonCriteria.put("minValue", minValue);
            jsonCriteria.put("maxValue", maxValue);
            jsonCriteria.put("maxEntry", maxEntry);
            CMISItemMediator.addStringArrayToJSON(jsonCriteria, "validValues", validValues);
            Object values = CMISPropertiesUtils.getValue(property);
            if (values instanceof String[]) {
                CMISItemMediator.addStringArrayToJSON(jsonCriteria, "values", (String[])values);
            } else {
                jsonCriteria.put("values", values);
            }
            JSONUtils.accumulate(jsonObject, jsonKey, jsonCriteria);
            jsonCriteria = null;
        }
    }

    @Override
    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        this.setDocID(jsonObject.get("docid").toString());
        JSONArray criteriasJsonArray = (JSONArray)jsonObject.get("criterias");
        JSONObject criteria = null;
        SearchCriterion criteriaHolder = null;
        Vector<SearchCriterion> criterias = new Vector<SearchCriterion>(criteriasJsonArray.size());
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
            criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
            criteriaHolder = new SearchCriterion();
            String criteriaName = criteria.get("name").toString();
            criteriaHolder.setName(criteriaName);
            String currentOperator = criteria.get("operator").toString();
            criteriaHolder.setOperator(currentOperator);
            JSONArray valuesJsonArray = (JSONArray)criteria.get("values");
            String[] tempValuesArray = new String[valuesJsonArray.size()];
            for (int iValuesCounter = 0; iValuesCounter < valuesJsonArray.size(); ++iValuesCounter) {
                tempValuesArray[iValuesCounter] = (String)valuesJsonArray.get(iValuesCounter);
            }
            criteriaHolder.setValues(tempValuesArray);
            criterias.add(criteriaHolder);
        }
        this.setCriterias(criterias.elements());
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }
}

