/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cmis;

import com.ibm.ecm.mediator.HitMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.cmis.CMISPropertiesUtils;
import com.ibm.ecm.util.cmis.CMISUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertiesBase;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertiesDocument;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISHitMediator
extends HitMediator {
    CMISConnection connection;
    CmisObject hit;
    private HashMap<?, ?> updatedDocIds;
    private Map<?, ?> containmentNames;
    private Map<?, ?> fullPathNames;
    private Set<Action> actions;
    private boolean privViewDoc;
    private boolean privEditDoc;
    private boolean privEditProp;
    private boolean canCreateDocOrFolder;
    private boolean privDelete;
    private boolean privCheckOut;
    private boolean privCheckIn;
    private boolean privCancelCheckOut;
    private boolean isCheckedOut;
    private String checkedOutBy;

    public CMISHitMediator(HttpServletRequest request, MessageResources resources, Locale locale, CMISConnection connection, HashMap<?, ?> updatedDocIds, Map<?, ?> containmentNames, Map<?, ?> fullPathNames) {
        super(request, resources, locale);
        this.connection = connection;
        this.updatedDocIds = updatedDocIds;
        this.containmentNames = containmentNames;
        this.fullPathNames = fullPathNames;
    }

    public void setHit(CmisObject hit) throws UnsupportedEncodingException {
        this.hit = hit;
        AllowableActions aa = hit.getAllowableActions();
        if (aa != null) {
            this.actions = aa.getAllowableActions();
        } else {
            hit.refresh();
            aa = hit.getAllowableActions();
            this.actions = aa != null ? aa.getAllowableActions() : new HashSet<Action>();
        }
        this.privViewDoc = this.actions.contains(Action.CAN_GET_CONTENT_STREAM);
        this.privEditDoc = this.actions.contains(Action.CAN_CHECK_IN);
        this.privEditProp = this.actions.contains(Action.CAN_UPDATE_PROPERTIES);
        this.canCreateDocOrFolder = this.actions.contains(Action.CAN_CREATE_DOCUMENT) || this.actions.contains(Action.CAN_CREATE_FOLDER);
        this.privDelete = this.actions.contains(Action.CAN_DELETE_OBJECT);
        this.privCheckOut = this.actions.contains(Action.CAN_CHECK_OUT);
        this.privCheckIn = this.actions.contains(Action.CAN_CHECK_IN);
        this.privCancelCheckOut = this.actions.contains(Action.CAN_CANCEL_CHECK_OUT);
        String noUser = "";
        if (hit instanceof Document) {
            Document document = (Document)hit;
            DocumentTypeDefinition type = (DocumentTypeDefinition)hit.getType();
            boolean isVersionable = type.isVersionable();
            this.isCheckedOut = isVersionable ? document.isVersionSeriesCheckedOut() : false;
            this.checkedOutBy = this.isCheckedOut ? document.getVersionSeriesCheckedOutBy() : noUser;
        } else {
            this.isCheckedOut = false;
            this.checkedOutBy = noUser;
        }
    }

    @Override
    public JSONObject toJSONObject() {
        String mimeType;
        String hitName;
        boolean rootFolder;
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONObject row = super.toJSONObject();
        this.putColumnSize("icon", 12);
        this.putColumnSize("mimeTypeIcon", 12);
        boolean bl = rootFolder = this.hit instanceof Folder && ((Folder)this.hit).isRootFolder();
        if (rootFolder) {
            hitName = this.messageResources.getMessage(this.getLocale(), "folder.root.name");
            row.put("rootfolder", (Object)true);
        } else {
            hitName = this.hit.getName();
        }
        row.put("name", hitName);
        String docId = CMISUtil.getDocId(this.hit);
        if (this.updatedDocIds.containsKey(docId)) {
            String origdocid = (String)this.updatedDocIds.get(docId);
            row.put("origdocid", origdocid);
        }
        row.put("template", this.hit.getType().getId());
        String DEFAULT_MIME_TYPE = "";
        if (this.hit instanceof Folder) {
            mimeType = "folder";
        } else if (this.hit instanceof Document) {
            Document d = (Document)this.hit;
            mimeType = d.getContentStreamMimeType();
            if (mimeType == null || mimeType.length() == 0) {
                mimeType = DEFAULT_MIME_TYPE;
            }
        } else {
            mimeType = DEFAULT_MIME_TYPE;
        }
        row.put("mimetype", mimeType.trim());
        if (this.hit instanceof Document) {
            Document document = (Document)this.hit;
            String vsId = document.getVersionSeriesId();
            if (vsId != null) {
                row.put("vsId", vsId);
            }
        } else if (this.hit instanceof Folder) {
            if (this.containmentNames != null && this.containmentNames.containsKey(this.hit.getId())) {
                row.put("containmentName", (String)this.containmentNames.get(this.hit.getId()));
            }
            if (this.fullPathNames != null && this.fullPathNames.containsKey(this.hit.getId())) {
                row.put("PathName", (String)this.fullPathNames.get(this.hit.getId()));
            }
        }
        String user = "";
        if (this.connection != null) {
            user = this.connection.getUserId();
        }
        row.put("locked", (Object)this.isCheckedOut);
        row.put("showCheckoutForReservation", (Object)(this.hit instanceof Document));
        row.put("lockedUser", this.checkedOutBy);
        row.put("hasNote", (Object)false);
        row.put("hasHold", (Object)false);
        row.put("modifyPermissions", (Object)false);
        return row;
    }

    public void putColumnSize(String index, int size) {
    }

    @Override
    public String getItemId() throws Exception {
        String docId = CMISUtil.getDocId(this.hit);
        return docId;
    }

    @Override
    public String getItemName() throws Exception {
        return this.hit.getName();
    }

    @Override
    public JSONObject buildAttributes() throws Exception {
        String methodName = "buildAttributes";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONObject jsonAttributes = new JSONObject();
        List properties = this.hit.getProperties();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "properties count: " + properties.size());
        for (Property property : properties) {
            PropertyDefinition pd = CMISUtil.getPropertyDescription(property);
            boolean isHidden = CMISUtil.isPropertyHidden(pd);
            if (pd == null || isHidden) continue;
            JSONArray jsonAttributeInfo = new JSONArray();
            String propDefId = pd.getId();
            Object value = CMISPropertiesUtils.getValue(property);
            if (value instanceof String[]) {
                JSONArray jsonArray = new JSONArray();
                String[] array = (String[])value;
                jsonArray.addAll(Arrays.asList(array));
                jsonAttributeInfo.add(jsonArray);
            } else {
                jsonAttributeInfo.add(value);
            }
            jsonAttributeInfo.add(CMISUtil.getDataType(pd));
            if (property.getId().equals(EnumPropertiesDocument.CMIS_CONTENT_STREAM_LENGTH.value())) {
                jsonAttributeInfo.add("fileSize");
            }
            Logger.logDebug((Object)this, "processProperty", (ServletRequest)this.request, "row.put(" + propDefId + ',' + value + ")");
            jsonAttributes.put(propDefId, jsonAttributeInfo);
            this.putColumnSize(propDefId, value == null ? 0 : value.toString().length());
            if (!propDefId.equals(EnumPropertiesBase.CMIS_NAME.value())) continue;
            String dispValue = "";
            if (value != null) {
                dispValue = value.toString();
            }
            jsonAttributeInfo = new JSONArray();
            jsonAttributeInfo.add(dispValue);
            String nameDisplayName = this.messageResources.getMessage(this.getLocale(), "name");
            jsonAttributes.put(nameDisplayName, jsonAttributeInfo);
            this.putColumnSize(nameDisplayName, dispValue.length());
            jsonAttributeInfo = new JSONArray();
            jsonAttributeInfo.add(dispValue);
            jsonAttributes.put("Name", jsonAttributeInfo);
            this.putColumnSize("Name", dispValue.length());
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonAttributes;
    }

    @Override
    public boolean canEditProperties() throws Exception {
        return this.privEditProp;
    }

    @Override
    public boolean canEditDoc() throws Exception {
        return this.hit instanceof Document ? this.privEditDoc : this.privEditProp;
    }

    @Override
    public boolean canViewNotes() throws Exception {
        return false;
    }

    @Override
    public boolean canAddDoc() throws Exception {
        return false;
    }

    @Override
    public boolean canAddItem() throws Exception {
        return this.hit instanceof Document ? false : this.canCreateDocOrFolder;
    }

    @Override
    public boolean canEmailDoc() throws Exception {
        return this.privViewDoc;
    }

    @Override
    public boolean canExport() throws Exception {
        return this.privViewDoc;
    }

    @Override
    public boolean canAddToFolder() throws Exception {
        return this.hit instanceof Document ? this.actions.contains(Action.CAN_ADD_OBJECT_TO_FOLDER) : this.canCreateDocOrFolder;
    }

    @Override
    public boolean canRemoveFromFolder() throws Exception {
        return this.hit instanceof Document ? this.actions.contains(Action.CAN_REMOVE_OBJECT_FROM_FOLDER) : this.canCreateDocOrFolder;
    }

    @Override
    public boolean canAddLink() throws Exception {
        return this.hit instanceof Document ? false : this.canCreateDocOrFolder;
    }

    @Override
    public boolean canRemoveLink() throws Exception {
        return false;
    }

    @Override
    public boolean canAddNotes() throws Exception {
        return false;
    }

    @Override
    public boolean canPrintNotes() throws Exception {
        return false;
    }

    @Override
    public boolean canPrintDoc() throws Exception {
        return this.privViewDoc;
    }

    @Override
    public boolean canCheckInOutDoc() throws Exception {
        return this.isCheckedOut;
    }

    @Override
    public boolean canCheckInDoc() throws Exception {
        return this.isCheckedOut;
    }

    @Override
    public boolean canCheckOutDoc() throws Exception {
        return this.privCheckOut;
    }

    @Override
    public boolean canCancelCheckOutDoc() throws Exception {
        return this.privCancelCheckOut;
    }

    @Override
    public boolean canViewAnnotations() throws Exception {
        return false;
    }

    @Override
    public boolean canEditAnnotations() throws Exception {
        return false;
    }

    @Override
    public boolean canViewDoc() throws Exception {
        return this.privViewDoc;
    }

    @Override
    public boolean canDelete() throws Exception {
        return this.privDelete;
    }

    @Override
    public boolean canStartWorkflow() throws Exception {
        return false;
    }

    @Override
    public boolean canHold() throws Exception {
        return false;
    }

    @Override
    public boolean canMoveToFolder() throws Exception {
        return this.actions.contains(Action.CAN_MOVE_OBJECT);
    }

    @Override
    public boolean canChangeClass() throws Exception {
        return false;
    }

    @Override
    public boolean canMajorVersion() throws Exception {
        return true;
    }

    @Override
    public boolean canMinorVersion() throws Exception {
        return false;
    }

    @Override
    public boolean canDeclare() throws Exception {
        return false;
    }
}

