/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cmis;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.DocumentInfoMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.cmis.CMISPropertiesUtils;
import com.ibm.ecm.util.cmis.CMISUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.struts.util.MessageResources;

public class CMISDocumentMediator
extends DocumentInfoMediator {
    public String serverDisplayName = null;
    public Document document = null;
    public String docID = null;
    Document hit = null;
    public String formType = null;
    public boolean showFieldHoverHelp = false;
    protected Enumeration criterias = null;

    public CMISDocumentMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
        this.formType = "edit";
    }

    protected CMISDocumentMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public Document getHit() {
        return this.hit;
    }

    public String getDocID() {
        return this.docID;
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }

    public void setHit(Document hit) {
        this.hit = hit;
    }

    public String getFormType() {
        if (this.formType == null) {
            this.formType = "search";
        }
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public Enumeration getCriterias() {
        return this.criterias;
    }

    public void setCriterias(Enumeration criterias) {
        this.criterias = criterias;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        if (this.getHit() != null) {
            jsonObject.put("template_name", this.getHit().getType().getQueryName());
            jsonObject.put("template_label", this.getHit().getType().getQueryName());
            jsonObject.put("template_desc", this.getHit().getType().getDescription());
            jsonObject.put("docid", this.getHit().getId());
            jsonObject.put("mimetype", this.getHit().getContentStreamMimeType());
            jsonObject.put("file_ext", this.getHit().getName());
        }
        jsonObject.put("showFieldHoverHelp", new Boolean(this.getShowFieldHoverHelp()));
        boolean editMode = true;
        Document document = this.getHit();
        List properties = document.getProperties();
        for (Property property : properties) {
            PropertyDefinition propertyDescription = null;
            JSONObject jsonCriteria = new JSONObject();
            jsonCriteria.put("name", propertyDescription.getQueryName());
            jsonCriteria.put("dataType", CMISUtil.getDataType(propertyDescription));
            jsonCriteria.put("dataType", "xs:string");
            jsonCriteria.put("required", propertyDescription.isRequired());
            jsonCriteria.put("label", propertyDescription.getDisplayName());
            CMISDocumentMediator.addStringArrayToJSON(jsonCriteria, "validValues", new String[0]);
            jsonCriteria.put("values", CMISPropertiesUtils.getValue(property));
            JSONUtils.accumulate(jsonObject, "criterias", jsonCriteria);
            jsonCriteria = null;
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        this.setDocID(jsonObject.get("docid").toString());
        JSONArray criteriasJsonArray = (JSONArray)jsonObject.get("criterias");
        JSONObject criteria = null;
        SearchCriterion criteriaHolder = null;
        Vector<SearchCriterion> criterias = new Vector<SearchCriterion>(criteriasJsonArray.size());
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
            criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
            criteriaHolder = new SearchCriterion();
            String criteriaName = criteria.get("name").toString();
            criteriaHolder.setName(criteriaName);
            String currentOperator = criteria.get("operator").toString();
            criteriaHolder.setOperator(currentOperator);
            JSONArray valuesJsonArray = (JSONArray)criteria.get("values");
            String[] tempValuesArray = new String[valuesJsonArray.size()];
            for (int iValuesCounter = 0; iValuesCounter < valuesJsonArray.size(); ++iValuesCounter) {
                tempValuesArray[iValuesCounter] = (String)valuesJsonArray.get(iValuesCounter);
            }
            criteriaHolder.setValues(tempValuesArray);
            criterias.add(criteriaHolder);
        }
        this.setCriterias(criterias.elements());
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }
}

