/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cmis;

import com.ibm.ecm.json.JSONItem;
import com.ibm.ecm.json.JSONStore;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.struts.util.MessageResources;

public class CMISClassesMediator
extends BaseMediator {
    private String serverDisplayName = null;
    private HashMap classes = null;
    private int maxClasses;

    public CMISClassesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public void addClass(ObjectType classDescription, boolean canCreateInstance) {
        String className = classDescription.getId();
        String dispName = classDescription.getDisplayName();
        if (className != null) {
            CMISClassDescription cd = new CMISClassDescription();
            cd.name = className;
            cd.displayName = dispName;
            cd.description = classDescription.getDescription();
            cd.allowsInstances = classDescription.isCreatable();
            this.getClasses().put(className, cd);
        }
    }

    public String getServerDisplayName() {
        return this.serverDisplayName;
    }

    public void setServerDisplayName(String serverDisplayName) {
        this.serverDisplayName = serverDisplayName;
    }

    public HashMap getClasses() {
        if (this.classes == null) {
            this.classes = new HashMap(0);
        }
        return this.classes;
    }

    public void setClasses(HashMap classes) {
        this.classes = classes;
    }

    protected List sortClasses() {
        ArrayList sortedList = new ArrayList(this.getClasses().values());
        Collections.sort(sortedList, new Comparator<CMISClassDescription>(){

            @Override
            public int compare(CMISClassDescription w1, CMISClassDescription w2) {
                return w1.displayName.compareTo(w2.displayName);
            }
        });
        return sortedList;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        jsonObject.put("repositoryId", this.getServerDisplayName());
        jsonObject.put("num_templates", new Integer(this.getClasses().size()));
        JSONStore DataStore = new JSONStore("template_name", "template_label", this.locale);
        List sortedClasses = this.sortClasses();
        Iterator iterator = sortedClasses.iterator();
        for (int currentFolder = 0; iterator.hasNext() && currentFolder < this.getMaxClasses(); ++currentFolder) {
            CMISClassDescription classDescription = (CMISClassDescription)iterator.next();
            String classId = classDescription.name;
            String dispName = classDescription.displayName;
            JSONItem DataItem = DataStore.createDataItem(classId, dispName);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("template_desc", classDescription.description);
            properties.put("allowsInstances", classDescription.allowsInstances.toString());
            DataItem.setProperties(properties);
            DataStore.addItem(DataItem);
        }
        jsonObject.put("datastore", DataStore.toJson());
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
        this.setServerDisplayName(jsonObject.get("repositoryId").toString());
        this.setClasses(new HashMap(CMISClassesMediator.toMapFromJSONForClasses((JSONArray)jsonObject.get("templates"))));
    }

    protected static Map toMapFromJSONForClasses(JSONArray jsonArray) {
        TreeMap<String, String> newHashMap = new TreeMap<String, String>();
        JSONObject jsonObject = null;
        for (int iArrayItemCounter = 0; iArrayItemCounter < jsonArray.size(); ++iArrayItemCounter) {
            jsonObject = (JSONObject)jsonArray.get(iArrayItemCounter);
            for (String keyName : jsonObject.keySet()) {
                String value = jsonObject.get(keyName).toString();
                newHashMap.put(keyName, value);
            }
        }
        return newHashMap;
    }

    public int getMaxClasses() {
        return this.maxClasses;
    }

    public void setMaxClasses(int maxClasses) {
        this.maxClasses = maxClasses;
    }

    private class CMISClassDescription {
        String name;
        String displayName;
        String description;
        Boolean allowsInstances;

        private CMISClassDescription() {
        }
    }
}

