/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cmis;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.cmis.CMISDefinitionUtil;
import com.ibm.ecm.util.cmis.CMISPropertyDefinition;
import com.ibm.ecm.util.cmis.CMISUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISAttributesMediator
extends BaseMediator {
    private Collection<PropertyDefinition<?>> propertyDefinitions = null;
    private Map<String, Object> currentValues = null;
    public String classId = null;
    public String classSymbolicName = null;
    public String classDisplayName = null;
    public String classDescription = null;
    public String serverName = null;
    public boolean showFieldHoverHelp = false;
    public boolean isPseudoClass = false;
    Collection<PropertyDefinition<?>> properDefinitionsIncludingSubclasses = null;

    public Collection<PropertyDefinition<?>> getPropertyDescriptionList() {
        return this.propertyDefinitions;
    }

    public void setPropertyDefinitions(Collection<PropertyDefinition<?>> collection) {
        this.propertyDefinitions = collection;
    }

    public void addCurrentValue(String attributeName, Object value) {
        if (this.currentValues == null) {
            this.currentValues = new Hashtable<String, Object>();
        }
        this.currentValues.put(attributeName, value);
    }

    public CMISAttributesMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected CMISAttributesMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public String getClassId() {
        return this.classId;
    }

    public void setClassId(String classId) {
        this.classId = classId;
    }

    public String getClassSymbolicName() {
        return this.classSymbolicName;
    }

    public void setClassSymbolicName(String name) {
        this.classSymbolicName = name;
    }

    public String getClassDisplayName() {
        return this.classDisplayName;
    }

    public void setClassDisplayName(String name) {
        this.classDisplayName = name;
    }

    public String getFolderDescription() {
        return this.classDescription;
    }

    public void setFolderDescription(String folderDescription) {
        this.classDescription = folderDescription;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public boolean isPseudoClass() {
        return this.isPseudoClass;
    }

    public void setPseudoClass(boolean isPsedoClass) {
        this.isPseudoClass = isPsedoClass;
    }

    public void setproperDefinitionsIncludingSubclasses(Collection<PropertyDefinition<?>> propertyDescriptionNameSet) {
        this.properDefinitionsIncludingSubclasses = propertyDescriptionNameSet;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jsonObject = super.toJSONObject();
        jsonObject.put("template_name", this.getClassId());
        jsonObject.put("template_label", this.getClassDisplayName());
        jsonObject.put("template_desc", this.getFolderDescription());
        jsonObject.put("showFieldHoverHelp", new Boolean(this.getShowFieldHoverHelp()));
        HashSet<String> propsSetOfBase = new HashSet<String>();
        if (this.properDefinitionsIncludingSubclasses == null) {
            this.properDefinitionsIncludingSubclasses = this.propertyDefinitions;
        } else {
            for (PropertyDefinition<?> propertyDefinition : this.propertyDefinitions) {
                String propertyDefinitionId = propertyDefinition.getId();
                propsSetOfBase.add(propertyDefinitionId);
            }
        }
        JSONArray jsonAttributeDefsArray = new JSONArray();
        for (PropertyDefinition<?> propertyDefinition : this.properDefinitionsIncludingSubclasses) {
            String propertyDefinitionId = propertyDefinition.getId();
            CMISPropertyDefinition propDef = new CMISPropertyDefinition(propertyDefinition);
            JSONObject jsonAttributeDef = new JSONObject();
            if (this.properDefinitionsIncludingSubclasses != null && !propsSetOfBase.contains(propertyDefinitionId)) {
                jsonAttributeDef.put("subClassAttribute", new Boolean(true));
            }
            jsonAttributeDef.put("name", propertyDefinitionId);
            jsonAttributeDef.put("readOnly", (Object)propDef.isUpdatabilityReadOnly());
            jsonAttributeDef.put("required", (Object)propDef.isRequired());
            jsonAttributeDef.put("hidden", (Object)propDef.isHidden());
            jsonAttributeDef.put("orderable", propDef.isOrderable());
            jsonAttributeDef.put("open_choice", (Object)propDef.isOpenChoice());
            if (propDef.isUpdatabilityReadOnly()) {
                jsonAttributeDef.put("settability", "readOnly");
            } else if (propDef.isUpdatabilityWhenCheckedOut()) {
                jsonAttributeDef.put("settability", "onlyBeforeCheckin");
            } else if (propDef.isUpdatabilityOnCreate()) {
                jsonAttributeDef.put("settability", "onlyOnCreate");
            } else if (propDef.isUpdatabilityReadWrite()) {
                jsonAttributeDef.put("settability", "readWrite");
            }
            jsonAttributeDef.put("system", (Object)propDef.isSystemProperty());
            jsonAttributeDef.put("dataType", propDef.getDataType());
            jsonAttributeDef.put("label", propDef.getDisplayName());
            jsonAttributeDef.put("description", propDef.getDescription());
            jsonAttributeDef.put("fixedValue", new Boolean(false));
            jsonAttributeDef.put("ascending", new Boolean(false));
            jsonAttributeDef.put("searchable", propertyDefinition.isQueryable());
            String maxEntry = propDef.getMaxLength();
            String minValue = propDef.getMinValue();
            String maxValue = propDef.getMaxValue();
            String[] validValues = propDef.getValidValues();
            jsonAttributeDef.put("cardinality", propDef.getCardinality());
            CMISDefinitionUtil.addChoiceList(this.request, propertyDefinition, jsonAttributeDef);
            jsonAttributeDef.put("minValue", minValue);
            jsonAttributeDef.put("maxValue", maxValue);
            Object defaultValue = propDef.getDefaultValue();
            if (this.currentValues != null && this.currentValues.containsKey(propDef.getId())) {
                defaultValue = this.currentValues.get(propDef.getId());
            }
            if (defaultValue instanceof String[]) {
                CMISAttributesMediator.addStringArrayToJSON(jsonAttributeDef, "value", (String[])defaultValue);
            } else {
                jsonAttributeDef.put("value", defaultValue);
            }
            String criteriaFormat = this.getFormat(propertyDefinition);
            if (criteriaFormat != null) {
                jsonAttributeDef.put("format", criteriaFormat);
            }
            CMISAttributesMediator.addStringArrayToJSON(jsonAttributeDef, "validValues", validValues);
            jsonAttributeDef.put("maxEntry", maxEntry);
            jsonAttributeDef.put("defaultOperator", "EQUAL");
            String[] operators = this.getOperatorSymbols(propertyDefinition, this.getMessageResources(), this.getLocale());
            CMISAttributesMediator.addStringArrayToJSON(jsonAttributeDef, "availableOperators", operators);
            jsonAttributeDefsArray.add(jsonAttributeDef);
        }
        jsonObject.put("criterias", jsonAttributeDefsArray);
        return jsonObject;
    }

    public static String getFromJSONString(HttpServletRequest request, String stringJSON, Collection<PropertyDefinition> propertyDefinitions, MessageResources resources, Locale locale, boolean isAndSearch) throws IOException {
        String methodName = "getFromJSONString";
        Logger.logEntry(CMISAttributesMediator.class, methodName, (ServletRequest)request);
        Logger.logDebug(CMISAttributesMediator.class, methodName, (ServletRequest)request, "stringJSON = " + stringJSON);
        String sqlString = "";
        try {
            JSONObject jsonObject = JSONObject.parse(stringJSON);
            JSONArray criteriasJsonArray = (JSONArray)jsonObject.get("criterias");
            JSONObject criteria = null;
            Logger.logDebug(CMISAttributesMediator.class, methodName, (ServletRequest)request, "criteriasJsonArray.length()" + criteriasJsonArray.size());
            for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
                criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
                String criteriaName = criteria.get("name").toString();
                Logger.logDebug(CMISAttributesMediator.class, methodName, (ServletRequest)request, "criteriaName : " + criteriaName);
                PropertyDefinition propertyDescription = null;
                for (PropertyDefinition tpropertyDescription : propertyDefinitions) {
                    CMISPropertyDefinition propDef = new CMISPropertyDefinition(tpropertyDescription);
                    if (!propDef.getQueryName().equals(criteriaName)) continue;
                    propertyDescription = tpropertyDescription;
                }
                String displayOperator = criteria.get("operator").toString();
                String queryOperator = CMISAttributesMediator.getOperatorFromDisplayValue(displayOperator.trim(), resources, locale);
                Logger.logDebug(CMISAttributesMediator.class, methodName, (ServletRequest)request, "displayOperator : " + displayOperator);
                Logger.logDebug(CMISAttributesMediator.class, methodName, (ServletRequest)request, "queryOperator : " + queryOperator);
                JSONArray valuesJsonArray = (JSONArray)criteria.get("values");
                String[] tempValuesArray = new String[valuesJsonArray.size()];
                for (int iValuesCounter = 0; iValuesCounter < valuesJsonArray.size(); ++iValuesCounter) {
                    String value = (String)valuesJsonArray.get(iValuesCounter);
                    Logger.logDebug(CMISAttributesMediator.class, methodName, (ServletRequest)request, "value : " + value);
                    tempValuesArray[iValuesCounter] = value = CMISAttributesMediator.replaceWildCardChars(value, queryOperator);
                    Logger.logDebug(CMISAttributesMediator.class, methodName, (ServletRequest)request, "value" + iValuesCounter + " = " + value);
                }
                String queryCriteria = CMISAttributesMediator.buildQueryCriteria(request, propertyDescription.getId(), queryOperator, tempValuesArray);
                Logger.logDebug(CMISAttributesMediator.class, methodName, (ServletRequest)request, "queryCriteria : " + queryCriteria);
                if (sqlString.trim().length() > 0) {
                    if (queryCriteria.trim().length() <= 0) continue;
                    if (isAndSearch) {
                        sqlString = sqlString + " " + " AND " + " " + queryCriteria;
                        continue;
                    }
                    sqlString = sqlString + " " + " OR " + " " + queryCriteria;
                    continue;
                }
                sqlString = queryCriteria;
            }
            Logger.logDebug(CMISAttributesMediator.class, methodName, (ServletRequest)request, "sqlString : " + sqlString);
        }
        catch (NumberFormatException e) {
            Logger.logError(CMISAttributesMediator.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit(CMISAttributesMediator.class, methodName, (ServletRequest)request);
        return sqlString;
    }

    private static String buildQueryCriteria(HttpServletRequest request, String criteriaName, String queryOperator, String[] valuesArray) {
        String methodName = "buildQueryCriteria";
        Logger.logEntry(CMISAttributesMediator.class, methodName, (ServletRequest)request);
        String criteriaStatement = "";
        if (valuesArray.length > 0) {
            Logger.logInfo(CMISAttributesMediator.class, methodName, (ServletRequest)request, "criteriaName = " + criteriaName + " queryOperator= " + queryOperator + " valuesArray[0]=" + valuesArray[0]);
        } else {
            Logger.logInfo(CMISAttributesMediator.class, methodName, (ServletRequest)request, "criteriaName = " + criteriaName + " queryOperator= " + queryOperator + " valuesArray[0]=");
        }
        if (criteriaName != null && criteriaName.length() > 0) {
            if (valuesArray.length > 0 && valuesArray[0].length() > 0) {
                if (queryOperator.equals("IN") || queryOperator.equals("NOTIN")) {
                    criteriaStatement = criteriaName + " " + queryOperator + " (";
                    String[] valueSet = valuesArray[0].split(",");
                    for (int i = 0; i < valueSet.length; ++i) {
                        criteriaStatement = criteriaStatement + "'" + valueSet[i].trim() + "',";
                    }
                    criteriaStatement = criteriaStatement.subSequence(0, criteriaStatement.length() - 1) + ")";
                } else {
                    criteriaStatement = queryOperator.equals("BETWEEN") || queryOperator.equals("NOTBETWEEN") ? criteriaName + " " + queryOperator + " ('" + valuesArray[0] + "','" + valuesArray[1] + "')" : criteriaName + " " + queryOperator + " " + "'" + valuesArray[0] + "'";
                }
            } else if (queryOperator.equals("NULL") || queryOperator.equals("NOTNULL")) {
                criteriaStatement = criteriaName + " " + queryOperator;
            }
        }
        Logger.logInfo(CMISAttributesMediator.class, methodName, (ServletRequest)request, "criteriaStatement = " + criteriaStatement);
        Logger.logExit(CMISAttributesMediator.class, methodName, (ServletRequest)request);
        return criteriaStatement;
    }

    private static String replaceWildCardChars(String value, String operator) {
        if (operator.equalsIgnoreCase("LIKE") || operator.equalsIgnoreCase("NOTLIKE")) {
            value = value.replace('*', '%');
            value = value.replace('?', '_');
        }
        return value;
    }

    private static String getOperatorFromDisplayValue(String operator, MessageResources resources, Locale locale) {
        String op = null;
        if (operator.equalsIgnoreCase("EQUAL")) {
            op = "=";
        } else if (operator.equalsIgnoreCase("NOTEQUAL")) {
            op = "!=";
        } else if (operator.equalsIgnoreCase("LIKE")) {
            op = "LIKE";
        } else if (operator.equalsIgnoreCase("NOTLIKE")) {
            op = "NOT LIKE";
        } else if (operator.equalsIgnoreCase("NOTIN")) {
            op = "NOT IN";
        } else if (operator.equalsIgnoreCase("NULL")) {
            op = "IS NULL";
        } else if (operator.equalsIgnoreCase("NOTNULL")) {
            op = "IS NOT NULL";
        } else if (operator.equalsIgnoreCase("CONTAINS")) {
            op = "contains-text-basic";
        } else if (operator.equalsIgnoreCase("IN")) {
            op = "IN";
        } else if (operator.equalsIgnoreCase("LESS")) {
            op = "<";
        } else if (operator.equalsIgnoreCase("LESSOREQUAL")) {
            op = "<=";
        } else if (operator.equalsIgnoreCase("GREATEROREQUAL")) {
            op = ">=";
        } else if (operator.equalsIgnoreCase("GREATER")) {
            op = ">";
        } else if (operator.equalsIgnoreCase("BETWEEN")) {
            op = "BETWEEN";
        } else if (operator.equalsIgnoreCase("NOTBETWEEN")) {
            op = "NOT BETWEEN";
        }
        return op;
    }

    public String[] getOperatorSymbols(PropertyDefinition loopCriteria, MessageResources resources, Locale locale) {
        String methodName = "getOperatorSymbols";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        ArrayList<String> arrayListReturn = new ArrayList<String>(15);
        String dataType = CMISUtil.getDataType(loopCriteria);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "name = " + loopCriteria.getDisplayName());
        if (dataType.equals("xs:boolean")) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = xs:boolean");
            arrayListReturn.add("EQUAL");
            arrayListReturn.add("NOTEQUAL");
        } else if (dataType.equals("xs:guid")) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = xs:guid");
            arrayListReturn.add("NULL");
            arrayListReturn.add("NOTNULL");
            arrayListReturn.add("EQUAL");
            arrayListReturn.add("NOTEQUAL");
        } else if (dataType.equals("xs:date") || dataType.equals("xs:time") || dataType.equals("xs:timestamp")) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = xs:date");
            arrayListReturn.add("EQUAL");
            arrayListReturn.add("NOTEQUAL");
            arrayListReturn.add("LESS");
            arrayListReturn.add("LESSOREQUAL");
            arrayListReturn.add("GREATER");
            arrayListReturn.add("GREATEROREQUAL");
            arrayListReturn.add("BETWEEN");
            arrayListReturn.add("NOTBETWEEN");
        } else if (dataType.equals("xs:double") || dataType.equals("xs:long")) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = xs:double || xs:long");
            arrayListReturn.add("EQUAL");
            arrayListReturn.add("NOTEQUAL");
            arrayListReturn.add("IN");
            arrayListReturn.add("NOTIN");
            arrayListReturn.add("LESS");
            arrayListReturn.add("LESSOREQUAL");
            arrayListReturn.add("GREATER");
            arrayListReturn.add("GREATEROREQUAL");
            arrayListReturn.add("BETWEEN");
            arrayListReturn.add("NOTBETWEEN");
        } else if (dataType.equals("xs:string")) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = xs:string");
            arrayListReturn.add("EQUAL");
            arrayListReturn.add("NOTEQUAL");
            arrayListReturn.add("LIKE");
            arrayListReturn.add("NOTLIKE");
        }
        return arrayListReturn.toArray(new String[0]);
    }

    public String getFormat(PropertyDefinition criteria) {
        String methodName = "getFormat";
        Logger.logEntry(CMISAttributesMediator.class, methodName, (ServletRequest)this.request);
        String type = CMISUtil.getDataType(criteria);
        String returnFormat = null;
        if (!(type.equals("xs:date") || type.equals("xs:timestamp") || type.equals("xs:time"))) {
            if (type.equals("xs:decimal")) {
                returnFormat = "";
            } else if (CMISDefinitionUtil.isContentLengthProperty(criteria)) {
                returnFormat = "fileSize";
            }
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "returned Format [" + criteria.getId() + "]: " + returnFormat);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return returnFormat;
    }

    public boolean getShowFieldHoverHelp() {
        return this.showFieldHoverHelp;
    }

    public void setShowFieldHoverHelp(boolean showFieldHoverHelp) {
        this.showFieldHoverHelp = showFieldHoverHelp;
    }
}

