/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm.workflow;

import com.ibm.ecm.json.JSONItem;
import com.ibm.ecm.json.JSONStore;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKDocRoutingServiceICM;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class CMWorkListMediator
extends BaseMediator {
    private Vector worklistsVec;
    int maxWorklists;
    DKDocRoutingServiceICM dkDocRoutingServiceICM = null;

    public CMWorkListMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        JSONObject jsonObject = super.toJSONObject();
        JSONStore DataStore = new JSONStore("worklist_name", "worklist_desc", this.locale);
        int currentWorklist = 0;
        Iterator iterator = this.worklistsVec.iterator();
        while (iterator.hasNext() && currentWorklist++ < this.getMaxWorklists()) {
            String worklistName = (String)iterator.next();
            try {
                String worklistLabel = worklistName;
                JSONItem DataItem = DataStore.createDataItem(worklistName, worklistLabel);
                DataStore.addItem(DataItem);
            }
            catch (Exception e) {
                Logger.logWarning((Object)this, "toJSONObject", (ServletRequest)this.request, e.getMessage());
            }
        }
        jsonObject.put("datastore", DataStore.toJson());
        JSONUtils.put(jsonObject, "num_worklists", this.worklistsVec.size());
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + jsonObject.toString());
        return jsonObject;
    }

    protected JSONObject toJSONFromVectorForWorklists(JSONObject jsonObject, String category) throws IOException {
        if (jsonObject == null) {
            jsonObject = new JSONObject();
        }
        int numOfWorklists = this.getWorklistsVec().size();
        String worklistName = null;
        for (int i = 0; i < this.getMaxWorklists(); ++i) {
            worklistName = (String)this.getWorklistsVec().get(i);
            JSONObject tempObject = new JSONObject();
            tempObject.put("worklist_name", worklistName);
            tempObject.put("worklist_desc", worklistName);
            JSONUtils.accumulate(jsonObject, category, tempObject.toString());
        }
        JSONUtils.put(jsonObject, "num_worklists", numOfWorklists);
        return jsonObject;
    }

    public Vector getWorklistsVec() {
        if (this.worklistsVec == null) {
            this.worklistsVec = new Vector();
        }
        return this.worklistsVec;
    }

    public void setWorklistsVec(Vector worklistsVec) {
        this.worklistsVec = worklistsVec;
    }

    public int getMaxWorklists() {
        return this.maxWorklists;
    }

    public void setMaxWorklists(int maxWorklists) {
        this.maxWorklists = maxWorklists;
    }

    public DKDocRoutingServiceICM getDkDocRoutingServiceICM() {
        return this.dkDocRoutingServiceICM;
    }

    public void setDkDocRoutingServiceICM(DKDocRoutingServiceICM dkDocRoutingServiceICM) {
        this.dkDocRoutingServiceICM = dkDocRoutingServiceICM;
    }
}

