/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm.workflow;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKProcessICM;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkIterator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class CMProcessUserMediator
extends BaseMediator {
    public HashMap processes = null;
    public dkCollection processColl = null;
    public String[] users = null;
    public String processName = null;
    public String priority = null;
    public String owner = null;

    public CMProcessUserMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    public HashMap getProcesses() {
        if (this.processes == null) {
            this.processes = new HashMap(0);
        }
        return this.processes;
    }

    public void setProcesses(HashMap processes) {
        this.processes = processes;
    }

    private void addProcessesToHashMap() {
        String methodName = "addProcessesToHashMap";
        dkIterator iter = this.getProcessColl().createIterator();
        while (iter.more()) {
            try {
                DKProcessICM process = (DKProcessICM)iter.next();
                String processName = process.getName();
                String processDesc = process.getDescription();
                this.getProcesses().put(processName, processDesc);
            }
            catch (DKUsageError e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
    }

    protected Map sortProcesses() {
        TreeMap sortedMap = new TreeMap(this.getProcesses());
        return sortedMap;
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = super.toJSONObject();
        this.toJSONFromMapForProcesses(jsonObject, "processes", this.sortProcesses());
        this.toJSONFromUserArray(jsonObject, "users");
        this.toJSONFromDefaultProcessInfo(jsonObject);
        return jsonObject;
    }

    protected JSONObject toJSONFromDefaultProcessInfo(JSONObject jsonObject) {
        jsonObject.put("process_name", this.getProcessName());
        jsonObject.put("process_priority", this.getPriority());
        jsonObject.put("process_owner", this.getOwner());
        return jsonObject;
    }

    protected JSONObject toJSONFromUserArray(JSONObject jsonObject, String category) {
        JSONObject tempObject = null;
        if (this.getUsers() != null) {
            for (int i = 0; i < this.getUsers().length; ++i) {
                tempObject = new JSONObject();
                tempObject.put("process_owner", this.users[i]);
                JSONUtils.accumulate(jsonObject, category, tempObject.toString());
            }
        }
        return jsonObject;
    }

    protected JSONObject toJSONFromMapForProcesses(JSONObject jsonObject, String category, Map hashMap) {
        if (jsonObject == null) {
            jsonObject = new JSONObject();
        }
        JSONObject tempObject = null;
        String tempString2 = null;
        for (String tempString2 : hashMap.keySet()) {
            tempObject = new JSONObject();
            tempObject.put("process_name", tempString2);
            tempObject.put("process_desc", hashMap.get(tempString2));
            JSONUtils.accumulate(jsonObject, category, tempObject.toString());
        }
        return jsonObject;
    }

    protected static Map toMapFromJSONForProcesses(String jsonStringArray) throws IOException {
        TreeMap<String, String> newHashMap = new TreeMap<String, String>();
        String myString = new String();
        JSONArray jsonArray = JSONArray.parse(jsonStringArray);
        JSONObject jsonObject = null;
        for (int iArrayItemCounter = 0; iArrayItemCounter < jsonArray.size(); ++iArrayItemCounter) {
            jsonObject = (JSONObject)jsonArray.get(iArrayItemCounter);
            for (String keyName : jsonObject.keySet()) {
                String value = jsonObject.get(keyName).toString();
                newHashMap.put(keyName, value);
            }
        }
        return newHashMap;
    }

    public dkCollection getProcessColl() {
        return this.processColl;
    }

    public void setProcessColl(dkCollection processColl) {
        this.processColl = processColl;
        this.addProcessesToHashMap();
    }

    public String[] getUsers() {
        return this.users;
    }

    public void setUsers(String[] users) {
        this.users = users;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }
}

