/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.json.TableView;
import com.ibm.ecm.mediator.ResultSetMediator;
import com.ibm.ecm.mediator.cm.CMHitMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.ColumnUtil;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.ecm.util.cm.CMSearchConstants;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKCommonPrivilege;
import com.ibm.mm.sdk.common.DKComponentTypeAttrGroupDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastoreExt;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.server.DKDatastoreExtICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.IOException;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMSearchResultsMediator
extends ResultSetMediator {
    public static final int SORT_NATURAL = 0;
    public static final int SORT_AFTER_QUERY_BY_PROPERTY = 1;
    public static final int SORT_BY_LAST_MODIFIED = 2;
    public static final String TRUE = "1";
    private int searchSortType = 0;
    private boolean sortAscending = true;
    private boolean foldersFirst = true;
    boolean workflowMode = false;
    private int attributeCount = 0;
    private dkCollection childComponents;
    private dkCollection referenceAttributes = null;
    private String[] processAttrConstants;
    private dkCollection workItems;
    private String worklistName;
    private Hashtable processAttrs;
    public HashMap folderWorkItems;
    private HashMap updatedDocIds;
    boolean privContinueWF;
    boolean privEditWF;
    boolean privRemoveWF;
    boolean privSuspendWF;
    boolean privResumeWF;
    boolean privViewWFVariables;
    boolean privViewWF;
    boolean privRefreshWorkflow;
    private JSONObject sortJsonObject = new JSONObject();
    private HashMap uniqueDates = new HashMap();
    private DKComponentTypeDefICM itemType;
    private CMConnection connection;
    private CMSearchResults searchResults;
    private boolean showVersions = false;
    private boolean showFolderVersions = false;
    private Integer currentVersionHit = null;
    private boolean allItemtypesView;
    private dkCollection resultAttributes;
    public int sortIndex = -1;
    public int sortDirection = 1;
    private Hashtable columnSizes = new Hashtable();
    public String searchMessage;
    public WCDateFormat wcDateFormats;
    public Collection<DKComponentTypeDefICM> entities;
    public String parentDocID;
    private boolean maxResultsReached;
    private boolean allowNonSystemAttributeSorting = true;
    public Hashtable attrNameValuePairs = null;
    dkDatastoreExt dsExt = null;
    private String[] displayColumns = null;
    private String[] displayColumnWidths = null;
    private String nameProperty = null;
    private dkCollection attrColl;
    private String nameColumnWidth = "25em";
    private String sortByProperty = null;
    private String sortAfterQueryProperty = null;
    private JSONObject aclJSON = null;
    private String docNameProperty = null;
    private String folderNameProperty = null;
    private Collator nlsCollator;

    public CMSearchResultsMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
        this.nlsCollator = Collator.getInstance(locale);
    }

    public Hashtable getAttrNameValuePairs() {
        return this.attrNameValuePairs;
    }

    public void setAttrNameValuePairs(Hashtable attrNameValuePairs) {
        this.attrNameValuePairs = attrNameValuePairs;
    }

    public void setSortType(int searchSortType, boolean sortAscending, String property, boolean foldersFirst) {
        this.searchSortType = searchSortType;
        this.sortAscending = sortAscending;
        this.foldersFirst = foldersFirst;
        if (this.searchSortType == 1) {
            this.sortAfterQueryProperty = property;
        }
    }

    public void setAllItemtypesView(boolean allItemtypesView) {
        this.allItemtypesView = allItemtypesView;
    }

    public CMSearchResults getSearchResults() {
        return this.searchResults;
    }

    public void setSearchResults(CMSearchResults searchResults) {
        this.searchResults = searchResults;
    }

    public String getSearchMessage() {
        return this.searchMessage;
    }

    public void setSearchMessage(String searchMessage) {
        this.searchMessage = searchMessage;
    }

    public void setNameColumnWidth(String width) {
        this.nameColumnWidth = width;
    }

    public void setACLJson(JSONObject aclJSON) {
        this.aclJSON = aclJSON;
    }

    protected void toJSONFromVectorForEntities(JSONObject jsonObject, String category) throws IOException {
        String methodName = "toJSONFromVectorForEntities";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (this.entities != null && jsonObject != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "entities.size(): " + this.entities.size());
            String entityDescription = null;
            for (DKComponentTypeDefICM entity : this.entities) {
                entityDescription = entity.getDescription();
                JSONObject tempObject = new JSONObject();
                tempObject.put("template_name", entity.getName());
                tempObject.put("template_label", entityDescription);
                tempObject.put("template_desc", entityDescription);
                JSONUtils.accumulate(jsonObject, category, tempObject);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    @Override
    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject jsonObject = super.toJSONObject();
        try {
            if (this.workflowMode) {
                jsonObject.put("worklist_name", this.getWorklistName());
                jsonObject.put("grid_type", "workflow");
            } else {
                jsonObject.put("grid_type", "search");
            }
            if (this.getItemType() != null) {
                String entityDescription = this.getItemType().getDescription();
                jsonObject.put("template_label", entityDescription);
                jsonObject.put("template_name", this.getItemType().getName());
            }
            this.setAttributeCount();
            this.toJSONFromVectorForEntities(jsonObject, "templates");
            if (this.getParentDocID() != null) {
                jsonObject.put("docid", this.getParentDocID());
            }
            int iNumResults = 0;
            if (this.getSearchResults() != null) {
                iNumResults = this.getSearchResults().getCount();
                Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "result count: " + iNumResults);
                jsonObject.put("sortformats", this.sortJsonObject);
                if (this.attributeCount > 0) {
                    JSONUtils.put(jsonObject, "num_results", iNumResults);
                } else {
                    JSONUtils.put(jsonObject, "num_results", 0);
                }
                JSONUtils.put(jsonObject, "sortIndex", this.getSortIndex());
                JSONUtils.put(jsonObject, "sortDirection", this.getSortDirection());
                if (this.connection != null) {
                    jsonObject.put("repositoryRecordType", this.connection.getDataStoreRecordType());
                }
                JSONObject tempObject = new JSONObject();
                tempObject.putAll(this.uniqueDates);
                jsonObject.put("dates", tempObject);
            }
            if (this.maxResultsReached) {
                jsonObject.put("maxResultsReached", (Object)true);
            }
            if (this.aclJSON != null) {
                jsonObject.put("modifyPermissions", this.aclJSON.get("user_permissions"));
                jsonObject.put("acl", this.aclJSON.get("acl"));
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            this.addError("error.exception.general", e.getMessage());
        }
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return jsonObject;
    }

    private void putColumnSize(String index, int size) {
        Integer tempValue = (Integer)this.columnSizes.get(index);
        if (tempValue != null) {
            int value = tempValue;
            if (value < size) {
                this.columnSizes.put(index, new Integer(size));
            }
        } else {
            this.columnSizes.put(index, new Integer(size));
        }
    }

    @Override
    public void fromJSONObject(JSONObject jsonObject) {
        super.fromJSONObject(jsonObject);
    }

    private void setNameInfo(JSONObject itemAttributes, JSONObject propTypes, Hashtable itemProperties, CMItem cmItem, String nameProp, String name, String nameType) {
        String methodName = "setNameInfo";
        try {
            if (name == null) {
                name = cmItem.getName();
                short cmNameType = cmItem.getNameType();
                nameType = CMUtil.getCriteriaType(cmNameType);
                if (name == null) {
                    name = "";
                    nameType = "xs:string";
                }
            }
            if (name.equals("ICMROOTFOLDER")) {
                name = this.messageResources.getMessage(this.getLocale(), "folder.root.name");
            } else if (name.equals("ICMSYSDEFAULTFOLDER")) {
                name = this.messageResources.getMessage(this.getLocale(), "folder.sysdefault.name");
            }
            itemAttributes.put("{NAME}", name);
            if (nameType != null) {
                propTypes.put("{NAME}", nameType);
            }
            itemProperties.put("name", name);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    @Override
    protected JSONArray buildTableRows() throws Exception {
        String methodName = "buildTableRows";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONArray jsonRows = new JSONArray();
        if (this.getSearchResults() != null && this.getSearchResults().getCount() > 0) {
            CMItem[] tempHitList = this.getSearchResults().getItems();
            CMHitMediator hitMediator = new CMHitMediator(this.request, this.messageResources, this.locale);
            DKDatastoreICM dsICM = this.connection.getDatastore();
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
            dkCollection attrColl = this.getResultAttributes();
            if (attrColl.cardinality() == 0) {
                DKAttrDefICM attr = (DKAttrDefICM)dsDefICM.retrieveAttr("ICM$NAME");
                attrColl.addElement((Object)attr);
            }
            if (this.displayColumns != null) {
                HashSet<String> requiredAttributes = new HashSet<String>();
                for (int i = 0; i < this.displayColumns.length; ++i) {
                    requiredAttributes.add(this.displayColumns[i]);
                }
                if (this.workflowMode) {
                    String[] attributeNames = this.getProcessAttrNames();
                    for (int i = 0; i < attributeNames.length; ++i) {
                        requiredAttributes.add(attributeNames[i]);
                    }
                }
                hitMediator.setRequiredAttributes(requiredAttributes);
            }
            DKSequentialCollection ddoColl = new DKSequentialCollection();
            for (int iHitCounter = 0; iHitCounter < tempHitList.length; ++iHitCounter) {
                ddoColl.addElement((Object)tempHitList[iHitCounter].getDDO());
            }
            HashMap privilegeMap = ((DKDatastoreExtICM)dsICM.getExtension("DATASTORE_EXTENSION")).getCommonItemPrivilege((dkCollection)ddoColl);
            for (int iHitCounter = 0; iHitCounter < tempHitList.length; ++iHitCounter) {
                Object origDocIdObject;
                String namePropValue;
                boolean hasContent;
                CMItem tempHit = tempHitList[iHitCounter];
                hitMediator.setHit(tempHit, this.workflowMode, this.isShowVersions(), true);
                hitMediator.setDKCommonPrivilege((DKCommonPrivilege)privilegeMap.get(tempHit.getDDO()));
                JSONObject jsonHit = hitMediator.toJSONObject();
                String itemTypeName = tempHit.getEntityName();
                CMEntity itemTypeHelper = this.connection.getEntity(itemTypeName);
                tempHit.setDateFormats(this.getDateFormats());
                String nameProp = null;
                nameProp = tempHit.getItemType() == 2 ? this.getFolderNameProperty() : this.getDocNameProperty();
                JSONObject propTypes = new JSONObject();
                this.setPrivileges((DKCommonPrivilege)privilegeMap.get(tempHit.getDDO()));
                boolean isCheckedOut = tempHit.isCheckedOut();
                String checkedOutBy = tempHit.getCheckedOutUserid();
                String mimeType = tempHit.getMimeType();
                if (mimeType.equalsIgnoreCase("item") && !itemTypeName.equals("ICMSearch")) {
                    boolean MIMEtypesIncluded = this.searchResults.areMIMETypesIncluded();
                    if (MIMEtypesIncluded) {
                        hasContent = false;
                    } else if (itemTypeHelper.getItemTypeClassification() == 2) {
                        hasContent = true;
                        mimeType = "unknown/unknown";
                    } else {
                        hasContent = false;
                    }
                } else {
                    hasContent = true;
                }
                if (this.isShowVersions() && (this.getCurrentVersionHit() == null || this.getCurrentVersionHit() == -1 || this.getCurrentVersionHit() != iHitCounter)) {
                    this.privContinueWF = false;
                }
                if (this.workflowMode) {
                    boolean isSuspended = tempHit.getWorkPackage().getSuspendState() == 1;
                    jsonHit.put("privContinueWF", (Object)this.privContinueWF);
                    jsonHit.put("privEditWF", (Object)this.privEditWF);
                    jsonHit.put("privRemoveWF", (Object)this.privRemoveWF);
                    jsonHit.put("privSuspendWF", (Object)this.privSuspendWF);
                    jsonHit.put("privResumeWF", (Object)this.privResumeWF);
                    jsonHit.put("privViewWFVariables", (Object)this.privViewWFVariables);
                    jsonHit.put("privViewWF", (Object)this.privViewWF);
                    jsonHit.put("privRefreshInbasket", (Object)this.privRefreshWorkflow);
                    jsonHit.put("workItemId", tempHit.getWorkPackage().getPidString());
                    jsonHit.put("isSuspended", (Object)isSuspended);
                    jsonHit.put("docid", tempHit.getPidString());
                }
                if ((namePropValue = null) == null) {
                    namePropValue = tempHit.getName();
                }
                boolean rootFolder = false;
                if (namePropValue.equals("ICMROOTFOLDER") || namePropValue.equals("ICMSYSDEFAULTFOLDER")) {
                    rootFolder = true;
                }
                jsonHit.put("rootfolder", (Object)rootFolder);
                jsonHit.put("hasNote", (Object)false);
                jsonHit.put("locked", (Object)isCheckedOut);
                jsonHit.put("lockedUser", checkedOutBy);
                if (tempHit.getPidString() != null && this.updatedDocIds != null && (origDocIdObject = this.updatedDocIds.get(tempHit.getPidString())) != null) {
                    jsonHit.put("origdocid", origDocIdObject.toString());
                }
                jsonHit.put("template", StringEscapeUtils.escapeXml((String)tempHit.getEntityName()));
                jsonHit.put("isVersionControlByApp", (Object)tempHit.getVersionControlByApp());
                jsonHit.put("isFirstPartVersionControlByApp", (Object)tempHit.getFirstPartVersionControlByApp());
                jsonHit.put("hasBookmarks", (Object)tempHit.hasBookmarks());
                jsonHit.put("mimetype", mimeType);
                jsonHit.put("versionControl", (Object)(tempHit.getVersionControl() != 0 ? 1 : 0));
                if (this.aclJSON != null) {
                    jsonHit.put("modifyPermissions", this.aclJSON.get("modifyPermissions"));
                }
                String declarePropertyValue = null;
                DKDDO ddo = tempHit.getDDO();
                short dataId = ddo.propertyId("SYSROOTATTRS.ICMMANAGEDRECORD");
                if (dataId != 0) {
                    declarePropertyValue = ddo.getPropertyByName("SYSROOTATTRS.ICMMANAGEDRECORD").toString();
                }
                boolean isDeclaredAsRecord = declarePropertyValue != null && declarePropertyValue.equals(TRUE);
                jsonHit.put("declaredAsRecord", (Object)isDeclaredAsRecord);
                if (this.getParentDocID() != null) {
                    jsonHit.put("parentDocid", new Boolean(this.getParentDocID()).toString());
                }
                jsonHit.put("isHierarchicalItemType", (Object)itemTypeHelper.getIsHierarchical());
                if (this.getCurrentVersionHit() != null) {
                    jsonHit.put("currentVersion", (Object)(this.getCurrentVersionHit() != -1 && this.getCurrentVersionHit() == iHitCounter ? 1 : 0));
                }
                jsonRows.add(jsonHit);
            }
        }
        if (this.searchSortType == 1) {
            this.sortSearchResultsByProperty(jsonRows, this.sortAfterQueryProperty, this.sortAscending, this.foldersFirst);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonRows;
    }

    public void sortSearchResultsByProperty(JSONArray jsonRows, final String property, final boolean ascending, final boolean foldersFirst) {
        Collections.sort(jsonRows, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject item1, JSONObject item2) {
                String value2;
                String value1;
                if (foldersFirst) {
                    String type1 = (String)item1.get("mimetype");
                    String type2 = (String)item2.get("mimetype");
                    if (type1.equals("folder") && !type2.equals("folder")) {
                        return ascending ? -1 : 1;
                    }
                    if (!type1.equals("folder") && type2.equals("folder")) {
                        return ascending ? 1 : -1;
                    }
                }
                if (property.equals("name") || property.equals("{NAME}")) {
                    value1 = (String)item1.get("name");
                    value2 = (String)item2.get("name");
                } else {
                    JSONObject item1Attributes = (JSONObject)item1.get("attributes");
                    JSONObject item2Attributes = (JSONObject)item2.get("attributes");
                    Object ob = item1Attributes.get(property);
                    value1 = ob instanceof JSONArray ? (String)((JSONArray)ob).get(0) : (String)item1Attributes.get(property);
                    ob = item2Attributes.get(property);
                    value2 = ob instanceof JSONArray ? (String)((JSONArray)ob).get(0) : (String)item2Attributes.get(property);
                }
                if (value1 != null && value2 != null) {
                    if (ascending) {
                        return CMSearchResultsMediator.this.nlsCollator.compare(value1, value2);
                    }
                    return CMSearchResultsMediator.this.nlsCollator.compare(value2, value1);
                }
                return 0;
            }
        });
    }

    public dkCollection getResultAttributes() {
        String methodName = "getResultAttributes";
        if (this.resultAttributes == null && (this.itemType != null || this.entities != null)) {
            try {
                if (!this.allItemtypesView || this.entities == null) {
                    this.resultAttributes = (DKSequentialCollection)this.itemType.listAllAttributes();
                } else {
                    this.resultAttributes = new DKSequentialCollection();
                    for (DKComponentTypeDefICM entity : this.entities) {
                        DKSequentialCollection tempAttributes = (DKSequentialCollection)entity.listAllAttributes();
                        dkIterator iterator = tempAttributes.createIterator();
                        while (iterator.more()) {
                            DKAttrDefICM attribute = (DKAttrDefICM)iterator.next();
                            boolean found = false;
                            dkIterator itr = this.resultAttributes.createIterator();
                            while (itr.more() && !found) {
                                DKAttrDefICM attr = (DKAttrDefICM)itr.next();
                                if (!attribute.getQualifiedName().equals(attr.getQualifiedName())) continue;
                                found = true;
                            }
                            if (found) continue;
                            this.resultAttributes.addElement((Object)attribute);
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        return this.resultAttributes;
    }

    public void setResultAttributes(dkCollection resultAttributes) {
        this.resultAttributes = resultAttributes;
    }

    private void setAttributeCount() {
        String methodName = "setAttributeCount";
        try {
            this.attributeCount = 0;
            if (this.allItemtypesView || this.itemType != null) {
                dkCollection attrColl = this.getResultAttributes();
                dkIterator iter = attrColl.createIterator();
                while (iter.more()) {
                    DKAttrDefICM attr = (DKAttrDefICM)iter.next();
                    if (attr.getType() != 4 && attr.getType() != 3 && attr.getType() != 10 && attr.getType() != 5 && attr.getType() != 6 && attr.getType() != 7 && attr.getType() != 9 && attr.getType() != 8 && attr.getType() != 2 && attr.getType() != 1) continue;
                    ++this.attributeCount;
                }
            }
        }
        catch (DKException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
    }

    @Override
    protected JSONArray buildMagazineViewColumns() {
        JSONArray columns = new JSONArray();
        JSONObject thumbnail = new JSONObject();
        thumbnail.put("field", "thumbnail");
        thumbnail.put("name", "");
        thumbnail.put("width", "60px");
        thumbnail.put("decorator", "MagazineViewDecorator.thumbnailDecorator");
        columns.add(thumbnail);
        JSONObject content = new JSONObject();
        content.put("field", "content");
        content.put("name", "");
        content.put("decorator", "MagazineViewDecorator.contentCellDecoratorCM8");
        columns.add(content);
        return columns;
    }

    @Override
    protected JSONObject buildTableColumns() throws Exception {
        TableView view1;
        String methodName;
        block38: {
            methodName = "buildTableColums";
            Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
            view1 = new TableView();
            TableView.ColumnSet set1 = view1.createColumnSet();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Starting to build columns from criteria");
            boolean isRecordsManagerEnabled = false;
            if (this.connection != null) {
                isRecordsManagerEnabled = this.connection.isRecordsManagerEnabled();
            }
            if (!this.showFolderVersions) {
                set1.addColumnProperty(ColumnUtil.buildStateColumnProperty(this.request, "&zwj;", "multiStateIcon", true, this.workflowMode, isRecordsManagerEnabled), true);
            }
            set1.addColumnProperty(ColumnUtil.buildColumnProperty("&zwj;", "17px", "mimeTypeIcon", null, true), true);
            if (this.getItemType() != null || this.getEntities() != null) {
                try {
                    dkIterator refIter;
                    dkIterator iter;
                    if (this.attrColl != null) {
                        iter = this.attrColl.createIterator();
                    } else {
                        dkCollection attrColl = this.getResultAttributes();
                        iter = attrColl.createIterator();
                    }
                    if (this.displayColumns != null && this.displayColumns.length > 0) {
                        dkIterator refIter2;
                        ColumnDefinition colDefinition;
                        HashMap<String, ColumnDefinition> columnMap = new HashMap<String, ColumnDefinition>();
                        while (iter.more()) {
                            DKAttrDefICM attr = (DKAttrDefICM)iter.next();
                            colDefinition = this.buildAttributeColumn(attr);
                            if (colDefinition == null) continue;
                            columnMap.put(colDefinition.fieldName, colDefinition);
                        }
                        if (this.getReferenceAttributes() != null && (refIter2 = this.referenceAttributes.createIterator()) != null) {
                            while (refIter2.more()) {
                                colDefinition = this.buildReferenceColumn(refIter2);
                                columnMap.put(colDefinition.fieldName, colDefinition);
                            }
                        }
                        if (this.getChildComponents() != null) {
                            dkIterator childCompIter = this.getChildComponents().createIterator();
                            while (childCompIter.more()) {
                                colDefinition = this.buildChildComponentColumn(childCompIter);
                                columnMap.put(colDefinition.fieldName, colDefinition);
                            }
                        }
                        for (int i = 0; i < this.displayColumns.length; ++i) {
                            String displayColumnWidth;
                            if (this.displayColumns[i].equals("{NAME}")) {
                                displayColumnWidth = this.displayColumnWidths != null && this.displayColumnWidths[i] != null && !this.displayColumnWidths[i].isEmpty() ? this.displayColumnWidths[i] : this.nameColumnWidth;
                                boolean noSort = this.getContinuationData() != null && this.getItemType() == null;
                                set1.addColumnProperty(this.buildColumnPropertyForSearchCriteria(MessageUtil.getMessage(this.getLocale(), "name"), this.displayColumns[i], displayColumnWidth, noSort, false, false, false));
                                continue;
                            }
                            colDefinition = (ColumnDefinition)columnMap.get(this.displayColumns[i]);
                            if (colDefinition != null) {
                                set1.addColumnProperty(colDefinition.definition);
                                if (colDefinition.sortType != null) {
                                    this.sortJsonObject.put(colDefinition.fieldName, colDefinition.sortType);
                                }
                            } else {
                                try {
                                    CMSearchConstants.SystemAttribute sa = CMSearchConstants.SystemAttribute.valueOf(this.displayColumns[i]);
                                    String displayLabel = MessageUtil.getMessage(this.getLocale(), sa.getMessageKey());
                                    String customLabel = BaseUtil.getCustomLabelValue(this.request, "sys_" + sa.toString());
                                    if (customLabel != null) {
                                        displayLabel = customLabel;
                                    }
                                    displayColumnWidth = this.displayColumnWidths != null && this.displayColumnWidths[i] != null && !this.displayColumnWidths[i].isEmpty() ? this.displayColumnWidths[i] : sa.getSize() + "em";
                                    set1.addColumnProperty(this.buildColumnPropertyForSearchCriteria(displayLabel, sa.toString(), displayColumnWidth, false, false, false, sa.isNumeric()));
                                    this.sortJsonObject.put(sa.toString(), sa.getSortType());
                                }
                                catch (Exception e) {
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Not a valid VersionInfo enum.");
                                }
                            }
                            if (this.sortByProperty == null || !this.sortByProperty.equals(this.displayColumns[i])) continue;
                            this.setSortIndex(i + 3);
                        }
                        if (this.workflowMode) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Starting to build columns from process attributes");
                            String[] attributeNames = this.getProcessAttrNames();
                            Hashtable processAttrs = this.getProcessAttrs();
                            for (int i = 0; i < attributeNames.length; ++i) {
                                double columnWidth;
                                String attributeName = attributeNames[i];
                                String attributeDisplayName = (String)processAttrs.get(attributeName);
                                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, new StringBuffer("Processing attribute - ").append(attributeName).toString());
                                String fieldQualifier = "STRING";
                                if (attributeName.equals("process_priority")) {
                                    fieldQualifier = "NUMBER";
                                    columnWidth = 6.0;
                                } else if (attributeName.equalsIgnoreCase("processResumeDate") || attributeName.equalsIgnoreCase("processLastMovedDate") || attributeName.equalsIgnoreCase("processNotifyDate")) {
                                    fieldQualifier = "TIMESTAMP";
                                    columnWidth = 14.0;
                                } else {
                                    columnWidth = 8.0;
                                }
                                set1.addColumnProperty(new String[][]{{"name", attributeDisplayName}, {"width", columnWidth + "em"}, {"field", attributeName}});
                                if (fieldQualifier.equalsIgnoreCase("NUMBER")) {
                                    this.sortJsonObject.put(attributeName, "numberSort");
                                    continue;
                                }
                                if (fieldQualifier.equalsIgnoreCase("TIMESTAMP")) {
                                    this.sortJsonObject.put(attributeName, "timeSort");
                                    continue;
                                }
                                this.sortJsonObject.put(attributeName, "stringSort");
                            }
                        }
                        break block38;
                    }
                    if (this.isShowVersions()) {
                        for (CMSearchConstants.SystemAttribute sa : Arrays.asList(CMSearchConstants.SystemAttribute.version, CMSearchConstants.SystemAttribute.modifiedBy, CMSearchConstants.SystemAttribute.modifiedTimestamp)) {
                            String displayLabel = MessageUtil.getMessage(this.getLocale(), sa.getMessageKey());
                            String customLabel = BaseUtil.getCustomLabelValue(this.request, "sys_" + sa.toString());
                            if (customLabel != null) {
                                displayLabel = customLabel;
                            }
                            set1.addColumnProperty(this.buildColumnPropertyForSearchCriteria(displayLabel, sa.toString(), sa.getSize() + "em", false, false, false, sa.isNumeric()));
                            this.sortJsonObject.put(sa.toString(), sa.getSortType());
                        }
                    }
                    ColumnDefinition colDefinition = null;
                    while (iter.more()) {
                        DKAttrDefICM attr = (DKAttrDefICM)iter.next();
                        colDefinition = this.buildAttributeColumn(attr);
                        if (colDefinition == null) continue;
                        set1.addColumnProperty(colDefinition.definition);
                        if (colDefinition.sortType == null) continue;
                        this.sortJsonObject.put(colDefinition.fieldName, colDefinition.sortType);
                    }
                    if (this.getReferenceAttributes() != null && (refIter = this.referenceAttributes.createIterator()) != null) {
                        while (refIter.more()) {
                            colDefinition = this.buildReferenceColumn(refIter);
                            set1.addColumnProperty(colDefinition.definition);
                        }
                    }
                    if (this.getChildComponents() != null) {
                        dkIterator childCompIter = this.getChildComponents().createIterator();
                        while (childCompIter.more()) {
                            colDefinition = this.buildChildComponentColumn(childCompIter);
                            set1.addColumnProperty(colDefinition.definition);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
            }
        }
        if (this.getDateFormats() != null) {
            this.sortJsonObject.put("dataFormat", ((SimpleDateFormat)this.getDateFormats().getTimeFormat()).toPattern());
            this.sortJsonObject.put("timeFormat", ((SimpleDateFormat)this.getDateFormats().getTimestampFormat()).toPattern());
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Finished  building columns from criteria");
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return view1.toJson();
    }

    private ColumnDefinition buildAttributeColumn(DKAttrDefICM attr) {
        String methodName = "buildAttributeColumn";
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Processing criteria - " + attr.getName());
        ColumnDefinition column = null;
        String criteriaName = attr.getDescription();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "criteria name - " + criteriaName);
        String fieldQualifier = "xs:string";
        if (attr != null) {
            fieldQualifier = CMUtil.getCriteriaType(attr);
        }
        if (attr.getType() == 4 || attr.getType() == 3 || attr.getType() == 10 || attr.getType() == 5 || attr.getType() == 6 || attr.getType() == 7 || attr.getType() == 9 || attr.getType() == 8 || attr.getType() == 2 || attr.getType() == 1) {
            Map columnDefinition;
            String fieldName = attr.getName();
            if (this.nameProperty != null && this.nameProperty.equals(fieldName)) {
                columnDefinition = this.buildColumnPropertyForSearchCriteria(MessageUtil.getMessage(this.getLocale(), "name"), fieldName, this.nameColumnWidth, false, false, false, false);
            } else {
                boolean isDateTime = attr.getType() == 7 || attr.getType() == 9 || attr.getType() == 8;
                columnDefinition = this.buildColumnPropertyForSearchCriteria(criteriaName, fieldName, !this.allowNonSystemAttributeSorting, false, false, isDateTime, CMUtil.isNumericCriteriaType(attr));
            }
            String sortType = null;
            if (fieldQualifier.equalsIgnoreCase("xs:integer") || fieldQualifier.equalsIgnoreCase("xs:double") || fieldQualifier.equalsIgnoreCase("xs:decimal")) {
                sortType = "numberSort";
            } else if (fieldQualifier.equalsIgnoreCase("xs:date")) {
                sortType = "dateSort";
            } else if (fieldQualifier.equalsIgnoreCase("xs:time")) {
                sortType = "timeSort";
            } else if (fieldQualifier.equalsIgnoreCase("xs:timestamp")) {
                sortType = "timeSort";
            } else if (fieldQualifier.startsWith("xs:string")) {
                sortType = "stringSort";
            }
            column = new ColumnDefinition(fieldName, columnDefinition, sortType);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return column;
    }

    private ColumnDefinition buildChildComponentColumn(dkIterator childCompIter) throws DKUsageError, DKException, Exception {
        String methodName = "buildChildComponentColumn";
        DKComponentTypeDefICM compType = (DKComponentTypeDefICM)childCompIter.next();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "     - " + compType.getName() + ":  " + compType.getDescription());
        DKSequentialCollection childCompAttrColl = (DKSequentialCollection)compType.listAllAttributes();
        String criteriaName = compType.getDescription();
        String fieldName = compType.getName();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "criteria name - " + criteriaName);
        Map columnDefinition = this.buildColumnPropertyForSearchCriteria(criteriaName, fieldName, true, false, true, false, false);
        ColumnDefinition column = new ColumnDefinition(fieldName, columnDefinition, null);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return column;
    }

    private ColumnDefinition buildReferenceColumn(dkIterator refIter) throws DKUsageError {
        String methodName = "buildReferenceColumn";
        DKComponentTypeAttrGroupDefICM attrGroup = (DKComponentTypeAttrGroupDefICM)refIter.next();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attrName: " + attrGroup.getName());
        Map columnDefinition = this.buildColumnPropertyForSearchCriteria(attrGroup.getName(), attrGroup.getName(), true, true, false, false, false);
        ColumnDefinition column = new ColumnDefinition(attrGroup.getName(), columnDefinition, null);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return column;
    }

    private double getSize(String criteriaName, String fieldName) {
        double size = 7.0;
        double paddedCriteriaNameLength = (double)criteriaName.length() * 1.5;
        if (this.columnSizes.get(fieldName) != null) {
            size = ((Integer)this.columnSizes.get(fieldName)).intValue();
        }
        if (Math.max(paddedCriteriaNameLength, size) < 5.0) {
            size = 5.0;
        }
        size = Math.max(paddedCriteriaNameLength, size) * 0.6;
        return size;
    }

    private Map buildColumnPropertyForSearchCriteria(String criteriaName, String fieldName, boolean nosort, boolean referenceAttribute, boolean childComponent, boolean isDateTime, boolean isNumeric) {
        Integer columnSize = (Integer)this.columnSizes.get(fieldName);
        String width = ColumnUtil.getColumnWidth(criteriaName.length(), columnSize != null ? columnSize : -1, isDateTime, isNumeric);
        return this.buildColumnPropertyForSearchCriteria(criteriaName, fieldName, width, nosort, referenceAttribute, childComponent, isNumeric);
    }

    private Map buildColumnPropertyForSearchCriteria(String criteriaName, String fieldName, String size, boolean nosort, boolean referenceAttribute, boolean childComponent, boolean isNumeric) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("name", criteriaName);
        propertyMap.put("width", size);
        propertyMap.put("field", fieldName);
        if (referenceAttribute) {
            propertyMap.put("referenceAttribute", "true");
            propertyMap.put("decorator", "DetailsViewDecorator.referenceAttributeDecorator");
        } else if (childComponent) {
            propertyMap.put("childComponent", "true");
            propertyMap.put("decorator", "DetailsViewDecorator.childComponentDecorator");
        }
        if (isNumeric) {
            propertyMap.put("styles", "text-align:right;");
        }
        if (nosort) {
            propertyMap.put("nosort", nosort);
        }
        propertyMap.put("sortable", !nosort);
        return propertyMap;
    }

    private DKCommonPrivilege getCommonPrivilege(DKDDO privDDO) throws Exception {
        String methodName = "getCommonPrivilege";
        DKCommonPrivilege commonPrivilege = null;
        if (this.dsExt == null) {
            this.dsExt = (dkDatastoreExt)this.connection.getDatastore().getExtension("DATASTORE_EXTENSION");
        }
        if (privDDO != null) {
            try {
                commonPrivilege = this.dsExt.getCommonItemPrivilege((dkDataObject)privDDO);
            }
            catch (RuntimeException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        return commonPrivilege;
    }

    private void setPrivileges(DKCommonPrivilege dkCommonPrivilege) throws Exception {
        if (dkCommonPrivilege == null) {
            return;
        }
        if (this.workflowMode) {
            this.privContinueWF = CMBaseUtil.checkAuthorization(dkCommonPrivilege, 34);
            this.privEditWF = CMBaseUtil.checkAuthorization(dkCommonPrivilege, 71);
            this.privRemoveWF = CMBaseUtil.checkAuthorization(dkCommonPrivilege, 35);
            this.privSuspendWF = CMBaseUtil.checkAuthorization(dkCommonPrivilege, 71);
            this.privResumeWF = CMBaseUtil.checkAuthorization(dkCommonPrivilege, 71);
            this.privViewWFVariables = CMBaseUtil.checkAuthorization(dkCommonPrivilege, 44);
            this.privViewWF = CMBaseUtil.checkAuthorization(dkCommonPrivilege, 44);
            this.privRefreshWorkflow = CMBaseUtil.checkAuthorization(dkCommonPrivilege, 44);
        }
    }

    private String wrapperText(String text) {
        return text.replaceAll("&", "&amp;");
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(int sortDirection) {
        this.sortDirection = sortDirection;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public DKComponentTypeDefICM getItemType() {
        return this.itemType;
    }

    public void setItemType(DKComponentTypeDefICM itemType) {
        this.itemType = itemType;
    }

    public Integer getCurrentVersionHit() {
        return this.currentVersionHit;
    }

    public void setCurrentVersionHit(int currentVersionHit) {
        this.currentVersionHit = currentVersionHit;
    }

    public boolean isShowVersions() {
        return this.showVersions;
    }

    public void setShowVersions(boolean showVersions) {
        this.showVersions = showVersions;
    }

    public void setShowFolderVersions(boolean showFolderVersions) {
        this.showFolderVersions = showFolderVersions;
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    public void setConnection(CMConnection connection) {
        this.connection = connection;
    }

    public Collection<DKComponentTypeDefICM> getEntities() {
        return this.entities;
    }

    public void setEntities(Collection<DKComponentTypeDefICM> entities) {
        this.entities = entities;
    }

    public void addEntity(DKComponentTypeDefICM entity) {
        if (this.entities == null) {
            this.entities = new HashSet<DKComponentTypeDefICM>();
        }
        this.entities.add(entity);
    }

    public String getParentDocID() {
        return this.parentDocID;
    }

    public void setParentDocID(String parentDocID) {
        this.parentDocID = parentDocID;
    }

    public HashMap getUpdatedDocIds() {
        if (this.updatedDocIds == null) {
            this.updatedDocIds = new HashMap(0);
        }
        return this.updatedDocIds;
    }

    public void setUpdatedDocIds(HashMap updatedDocIds) {
        this.updatedDocIds = updatedDocIds;
    }

    public void setProcessAttrs(Hashtable processAttrs) {
        this.processAttrs = processAttrs;
    }

    public String[] getProcessAttrNames() {
        if (this.processAttrConstants == null) {
            this.processAttrConstants = new String[9];
            this.processAttrConstants[0] = "process_name";
            this.processAttrConstants[1] = "processStep";
            this.processAttrConstants[2] = "process_priority";
            this.processAttrConstants[3] = "processSuspendState";
            this.processAttrConstants[4] = "processNotifyDate";
            this.processAttrConstants[5] = "process_owner";
            this.processAttrConstants[6] = "processLastMovedBy";
            this.processAttrConstants[7] = "processLastMovedDate";
            this.processAttrConstants[8] = "processResumeDate";
        }
        return this.processAttrConstants;
    }

    public void setProcessAttrNames(String[] processAttrConstants) {
        this.processAttrConstants = processAttrConstants;
    }

    public HashMap getFolderWorkItems() {
        if (this.folderWorkItems == null) {
            this.folderWorkItems = new HashMap(0);
        }
        return this.folderWorkItems;
    }

    public void setFolderWorkItems(HashMap folderWorkItems) {
        this.folderWorkItems = folderWorkItems;
    }

    protected Map sortFolderWorkItems() {
        TreeMap sortedMap = new TreeMap(this.getFolderWorkItems());
        return sortedMap;
    }

    protected String toJSONFromMapForFolderWorkItems(String jsonString, String category, Map hashMap) throws IOException {
        String myString = new String();
        JSONObject jsonObject = null;
        jsonObject = jsonString != null ? JSONObject.parse(jsonString) : new JSONObject();
        String workPackageID2 = null;
        for (String workPackageID2 : hashMap.keySet()) {
            JSONObject tempObject = new JSONObject();
            tempObject.put("folder_workitem_id", workPackageID2);
            tempObject.put("folder_workitem_name", hashMap.get(workPackageID2)).toString();
            JSONUtils.accumulate(jsonObject, category, tempObject);
        }
        myString = jsonObject.toString();
        return myString;
    }

    public dkCollection getWorkItems() {
        return this.workItems;
    }

    public Hashtable getProcessAttrs() {
        if (this.processAttrs == null) {
            this.processAttrs = new Hashtable();
            String workflowString = MessageUtil.getMessage(this.getLocale(), "desktop.workList.view.workflow");
            String stepString = MessageUtil.getMessage(this.getLocale(), "desktop.workList.view.step");
            String priorityString = MessageUtil.getMessage(this.getLocale(), "desktop.workList.view.priority");
            String statusString = MessageUtil.getMessage(this.getLocale(), "desktop.workList.view.status");
            String notifyDateString = MessageUtil.getMessage(this.getLocale(), "desktop.workList.view.notified");
            String createdByString = MessageUtil.getMessage(this.getLocale(), "desktop.workList.view.owner");
            String lastModifiedByString = MessageUtil.getMessage(this.getLocale(), "desktop.workList.view.lastmovedby");
            String lastModifiedDateString = MessageUtil.getMessage(this.getLocale(), "desktop.workList.view.lastmoveddate");
            String resumeDateString = MessageUtil.getMessage(this.getLocale(), "desktop.workList.view.resume");
            this.processAttrs.put("process_name", workflowString);
            this.processAttrs.put("processStep", stepString);
            this.processAttrs.put("process_priority", priorityString);
            this.processAttrs.put("processSuspendState", statusString);
            this.processAttrs.put("processNotifyDate", notifyDateString);
            this.processAttrs.put("process_owner", createdByString);
            this.processAttrs.put("processLastMovedBy", lastModifiedByString);
            this.processAttrs.put("processLastMovedDate", lastModifiedDateString);
            this.processAttrs.put("processResumeDate", resumeDateString);
        }
        return this.processAttrs;
    }

    private String changeTimeZone(String oldTimeValue) {
        String TIMESTAMP_FORMAT = "yyyy-MM-dd-HH.mm.ss.SSSSSS";
        String newTimeValue = null;
        TimeZone tz = TimeZone.getTimeZone("GMT");
        TimeZone tz1 = Calendar.getInstance().getTimeZone();
        if (oldTimeValue != null) {
            newTimeValue = CMUtil.changeTimeZone(oldTimeValue, TIMESTAMP_FORMAT, tz, tz1);
        }
        return newTimeValue;
    }

    public boolean isWorkflowMode() {
        return this.workflowMode;
    }

    public void setWorkflowMode(boolean workflowMode) {
        this.workflowMode = workflowMode;
    }

    public void setWorkItems(dkCollection workItems) {
        this.workItems = workItems;
    }

    public String getWorklistName() {
        return this.worklistName;
    }

    public void setWorklistName(String worklistName) {
        this.worklistName = worklistName;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public void setAttributeCount(int attributeCount) {
        this.attributeCount = attributeCount;
    }

    public dkCollection getChildComponents() {
        return this.childComponents;
    }

    public dkCollection getReferenceAttributes() {
        return this.referenceAttributes;
    }

    public void setReferenceAttributes(dkCollection referenceAttributes) {
        String methodName = "setReferenceAttributes";
        if (!this.allItemtypesView || this.entities == null) {
            this.referenceAttributes = referenceAttributes;
        } else {
            this.referenceAttributes = new DKSequentialCollection();
            try {
                for (DKComponentTypeDefICM entity : this.entities) {
                    DKSequentialCollection refAttrs = (DKSequentialCollection)entity.listAttrGroups(99);
                    dkIterator iterator = refAttrs.createIterator();
                    while (iterator.more()) {
                        DKComponentTypeAttrGroupDefICM attrGroup = (DKComponentTypeAttrGroupDefICM)iterator.next();
                        boolean found = false;
                        dkIterator itr = this.referenceAttributes.createIterator();
                        while (itr.more() && !found) {
                            DKComponentTypeAttrGroupDefICM ra = (DKComponentTypeAttrGroupDefICM)itr.next();
                            if (!attrGroup.getName().equals(ra.getName())) continue;
                            found = true;
                        }
                        if (found) continue;
                        this.referenceAttributes.addElement((Object)attrGroup);
                    }
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
    }

    public void setChildComponents(dkCollection childComponents) {
        String methodName = "setChildComponents";
        if (!this.allItemtypesView || this.entities == null) {
            this.childComponents = childComponents;
        } else {
            this.childComponents = new DKSequentialCollection();
            try {
                for (DKComponentTypeDefICM entity : this.entities) {
                    DKSequentialCollection childComps = (DKSequentialCollection)entity.listSubEntities();
                    dkIterator iterator = childComps.createIterator();
                    while (iterator.more()) {
                        DKComponentTypeDefICM childComp = (DKComponentTypeDefICM)iterator.next();
                        boolean found = false;
                        dkIterator itr = this.childComponents.createIterator();
                        while (itr.more() && !found) {
                            DKComponentTypeDefICM cc = (DKComponentTypeDefICM)itr.next();
                            if (!childComp.getName().equals(cc.getName())) continue;
                            found = true;
                        }
                        if (found) continue;
                        this.childComponents.addElement((Object)childComp);
                    }
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
    }

    public boolean isMaxResultsReached() {
        return this.maxResultsReached;
    }

    public void setMaxResultsReached(boolean maxResultsReached) {
        this.maxResultsReached = maxResultsReached;
    }

    public void setDisplayColumns(String[] displayColumns) {
        this.displayColumns = displayColumns;
    }

    public void setDisplayColumnWidths(String[] displayColumnWidths) {
        this.displayColumnWidths = displayColumnWidths;
    }

    public String[] getDisplayColumns() {
        return this.displayColumns;
    }

    public void setNameProperty(String nameProperty) {
        this.nameProperty = nameProperty;
    }

    public void setAllowNonSystemAttributeSorting(boolean yes) {
        this.allowNonSystemAttributeSorting = yes;
    }

    public boolean getAllowNonSystemAttributeSorting() {
        return this.allowNonSystemAttributeSorting;
    }

    public void setSortByProperty(String sortByProperty) {
        this.sortByProperty = sortByProperty;
    }

    public String getSortByProperty() {
        return this.sortByProperty;
    }

    public int getSearchSortType() {
        return this.searchSortType;
    }

    public String getSortAfterQueryProperty() {
        return this.sortAfterQueryProperty;
    }

    public boolean getSortAscending() {
        return this.sortAscending;
    }

    public boolean getFoldersFirst() {
        return this.foldersFirst;
    }

    public dkCollection getAttrColl() {
        return this.attrColl;
    }

    public void setAttrColl(dkCollection attrColl) {
        this.attrColl = attrColl;
    }

    public String getDocNameProperty() {
        return this.docNameProperty;
    }

    public void setDocNameProperty(String docNameProperty) {
        this.docNameProperty = docNameProperty;
    }

    public String getFolderNameProperty() {
        return this.folderNameProperty;
    }

    public void setFolderNameProperty(String folderNameProperty) {
        this.folderNameProperty = folderNameProperty;
    }

    private class ColumnDefinition {
        String fieldName;
        Map definition;
        String sortType;

        public ColumnDefinition(String fieldName, Map definition, String sortType) {
            this.fieldName = fieldName;
            this.definition = definition;
            this.sortType = sortType;
        }
    }
}

