/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.mediator.cm;

import com.ibm.ecm.json.JSONUtils;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.ChildSearchCriteria;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.SearchCriteria;
import com.ibm.ecm.util.SearchCriterion;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.cm.CMSearchConstants;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkIterator;
import java.text.Collator;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;

public class CMSearchCriteriaMediator
extends BaseMediator {
    private SearchTemplate searchTemplate = null;
    private dkCollection attributes = null;
    private dkCollection childComponents = null;
    private dkCollection foreignKeys = null;

    public CMSearchCriteriaMediator(HttpServletRequest request, MessageResources resources, Locale locale) {
        super(request, resources, locale);
    }

    protected CMSearchCriteriaMediator(HttpServletRequest request, BaseMediator baseMediator) {
        super(request, baseMediator);
    }

    public SearchTemplate getSearchTemplate() {
        return this.searchTemplate;
    }

    public void setSearchTemplate(SearchTemplate searchTemplate) {
        this.searchTemplate = searchTemplate;
    }

    public dkCollection getAttributes() {
        return this.attributes;
    }

    public void setAttributes(dkCollection attributes) {
        this.attributes = attributes;
    }

    public dkCollection getChildComponents() {
        return this.childComponents;
    }

    public void setChildComponents(dkCollection childComponents) {
        this.childComponents = childComponents;
    }

    public dkCollection getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(dkCollection foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public JSONObject toJSONObject() {
        String methodName = "toJSONObject";
        Logger.logEntry((Object)this, "toJSONObject", (ServletRequest)this.request);
        JSONObject json = super.toJSONObject();
        try {
            SearchTemplate.TextSearchCriterion textSearchCriteria;
            List<SearchCriteria> criteria;
            List<SearchTemplate.SearchFolder> folders;
            json.put("template_name", this.searchTemplate.getFirstClassName());
            json.put("template_label", this.searchTemplate.getFirstClassDisplayName());
            json.put("objectType", this.searchTemplate.getObjectType().toString());
            json.put("andSearch", (Object)this.searchTemplate.isAndSearch());
            json.put("autoRun", (Object)this.searchTemplate.isAutoRun());
            json.put("showInTree", (Object)this.searchTemplate.isShowInTree());
            List<SearchTemplate.SearchClass> classes = this.searchTemplate.getClasses();
            if (classes != null) {
                for (SearchTemplate.SearchClass searchClass : classes) {
                    JSONObject classJSON = new JSONObject();
                    classJSON.put("name", searchClass.getName());
                    classJSON.put("displayName", searchClass.getDisplayName());
                    JSONUtils.accumulate(json, "search_classes", classJSON);
                }
            }
            if ((folders = this.searchTemplate.getFolders()) != null) {
                for (SearchTemplate.SearchFolder folder : folders) {
                    JSONObject folderJSON = new JSONObject();
                    folderJSON.put("id", folder.getId());
                    folderJSON.put("pathName", folder.getPathName());
                    folderJSON.put("searchSubfolders", (Object)folder.isSearchSubfolders());
                    folderJSON.put("view", folder.getView().toString());
                    folderJSON.put("repositoryId", folder.getObjectStoreId());
                    JSONUtils.accumulate(json, "search_folders", folderJSON);
                }
            }
            if ((criteria = this.searchTemplate.getSearchCriteria()) != null) {
                for (SearchCriteria criteriaEntry : criteria) {
                    if (criteriaEntry instanceof SearchCriterion) {
                        JSONObject criterionJSON = this.createSearchCriterionJSONObj((SearchCriterion)criteriaEntry, false);
                        JSONUtils.accumulate(json, "criterias", criterionJSON);
                        continue;
                    }
                    if (!(criteriaEntry instanceof ChildSearchCriteria)) continue;
                    ChildSearchCriteria child = (ChildSearchCriteria)criteriaEntry;
                    JSONObject childJSON = new JSONObject();
                    childJSON.put("template_name", child.getName());
                    childJSON.put("template_label", this.getChildComponentDisplayName(child.getName()));
                    List<SearchCriterion> childCriterionList = child.getSearchCriteria();
                    JSONArray childCriteriaJSON = new JSONArray();
                    for (SearchCriterion childCriterion : childCriterionList) {
                        JSONObject criterionJSON = this.createSearchCriterionJSONObj(childCriterion, true);
                        childCriteriaJSON.add(criterionJSON);
                    }
                    childJSON.put("criterias", childCriteriaJSON);
                    JSONUtils.accumulate(json, "criterias", childJSON);
                }
            }
            if ((textSearchCriteria = this.searchTemplate.getFirstTextSearchCriterion()) != null) {
                json.put("textSearchCriteria", textSearchCriteria.toJSON());
            }
            JSONObject optionCriteria = new JSONObject();
            SearchTemplate.VersionOption verOption = this.searchTemplate.getVersionOption();
            if (verOption != null) {
                optionCriteria.put("versionOption", verOption.toString());
            }
            optionCriteria.put("propertyTextAnded", (Object)this.searchTemplate.isPropertyTextAnded());
            SearchTemplate.Macros macros = this.searchTemplate.getMacros();
            if (macros != null) {
                optionCriteria.put("macros", macros.toJSON());
            }
            json.put("moreOptions", optionCriteria);
            SearchTemplate.ResultsDisplay resultsDisplay = this.searchTemplate.getResultsDisplay();
            if (resultsDisplay != null) {
                json.put("resultsDisplay", resultsDisplay.toJSON());
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, "toJSONObject", (ServletRequest)this.request, (Throwable)e);
            this.addError("error.exception.general", e.getLocalizedMessage());
        }
        Logger.logDebug((Object)this, "toJSONObject", (ServletRequest)this.request, "Returning JSON: " + json.toString());
        Logger.logExit((Object)this, "toJSONObject", (ServletRequest)this.request);
        return json;
    }

    private JSONObject createSearchCriterionJSONObj(SearchCriterion criterion, boolean isChild) {
        String name = criterion.getName();
        DKAttrDefICM attrib = this.getAttribute(name);
        JSONObject criterionJSON = new JSONObject();
        criterionJSON.put("name", name);
        criterionJSON.put("label", this.getAttributeDisplayName(name));
        criterionJSON.put("dataType", criterion.getDataType());
        criterionJSON.put("readOnly", (Object)criterion.isReadOnly());
        criterionJSON.put("hidden", (Object)criterion.isHidden());
        criterionJSON.put("required", (Object)criterion.isRequired());
        if (attrib != null) {
            int size = attrib.getSize();
            if (attrib.getType() == 6) {
                size += 2;
            }
            if (size != 0) {
                criterionJSON.put("maxEntry", (Object)size);
            }
            criterionJSON.put("minValue", CMUtil.getMin(attrib));
            criterionJSON.put("maxValue", CMUtil.getMax(attrib));
            criterionJSON.put("nullable", (Object)attrib.isNullable());
            criterionJSON.put("textSearchable", (Object)attrib.isTextSearchable());
            String[] validValues = !isChild && this.foreignKeys != null ? CMUtil.getValidValues(this.request, attrib, this.getForeignKeys(), null) : new String[]{};
            Arrays.sort(validValues, Collator.getInstance(this.request.getLocale()));
            CMSearchCriteriaMediator.addStringArrayToJSON(criterionJSON, "validValues", validValues);
            criterionJSON.put("hasForeignKeys", (Object)(this.foreignKeys != null ? 1 : 0));
        }
        criterionJSON.put("defaultOperator", criterion.getOperator());
        CMSearchCriteriaMediator.addStringArrayToJSON(criterionJSON, "values", criterion.getValues());
        CMSearchCriteriaMediator.addStringArrayToJSON(criterionJSON, "displayValues", criterion.getDisplayValues());
        return criterionJSON;
    }

    private DKAttrDefICM getAttribute(String name) {
        if (this.attributes != null) {
            dkIterator i = this.attributes.createIterator();
            while (i.more()) {
                DKAttrDefICM attrib;
                try {
                    attrib = (DKAttrDefICM)i.next();
                }
                catch (DKUsageError e) {
                    continue;
                }
                if (!attrib.getName().equals(name)) continue;
                return attrib;
            }
        }
        return null;
    }

    private String getAttributeDisplayName(String name) {
        String displayName;
        if (name.equals(CMSearchConstants.SystemAttribute.itemID.toString())) {
            displayName = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.itemID.toString());
            if (displayName == null) {
                displayName = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.itemID.getMessageKey());
            }
        } else if (name.equals(CMSearchConstants.SystemAttribute.version.toString())) {
            displayName = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.version.toString());
            if (displayName == null) {
                displayName = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.version.getMessageKey());
            }
        } else if (name.equals(CMSearchConstants.SystemAttribute.createdBy.toString())) {
            displayName = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.createdBy.toString());
            if (displayName == null) {
                displayName = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.createdBy.getMessageKey());
            }
        } else if (name.equals(CMSearchConstants.SystemAttribute.createdTimestamp.toString())) {
            displayName = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.createdTimestamp.toString());
            if (displayName == null) {
                displayName = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.createdTimestamp.getMessageKey());
            }
        } else if (name.equals(CMSearchConstants.SystemAttribute.modifiedBy.toString())) {
            displayName = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.modifiedBy.toString());
            if (displayName == null) {
                displayName = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.modifiedBy.getMessageKey());
            }
        } else if (name.equals(CMSearchConstants.SystemAttribute.modifiedTimestamp.toString())) {
            displayName = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.modifiedTimestamp.toString());
            if (displayName == null) {
                displayName = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.modifiedTimestamp.getMessageKey());
            }
        } else if (name.equals(CMSearchConstants.SystemAttribute.aclCode.toString())) {
            displayName = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.aclCode.toString());
            if (displayName == null) {
                displayName = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.aclCode.getMessageKey());
            }
        } else if (name.equals(CMSearchConstants.SystemAttribute.semanticType.toString())) {
            displayName = BaseUtil.getCustomLabelValue(this.request, "sys_" + CMSearchConstants.SystemAttribute.semanticType.toString());
            if (displayName == null) {
                displayName = MessageUtil.getMessage(this.getLocale(), CMSearchConstants.SystemAttribute.semanticType.getMessageKey());
            }
        } else {
            DKAttrDefICM attrib = this.getAttribute(name);
            displayName = attrib != null ? attrib.getDescription() : name;
        }
        return displayName;
    }

    private String getChildComponentDisplayName(String name) {
        String displayName = name;
        if (this.childComponents != null) {
            dkIterator i = this.childComponents.createIterator();
            while (i.more()) {
                DKComponentTypeDefICM componentType;
                try {
                    componentType = (DKComponentTypeDefICM)i.next();
                }
                catch (DKUsageError e) {
                    continue;
                }
                if (!componentType.getName().equals(name)) continue;
                displayName = componentType.getDescription();
                break;
            }
        }
        return displayName;
    }
}

